/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.internal.filetype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.filetype.ICFileType;
import org.eclipse.cdt.core.filetype.ICFileTypeAssociation;
import org.eclipse.cdt.core.filetype.ICFileTypeResolver;
import org.eclipse.cdt.core.filetype.ICLanguage;
import org.eclipse.cdt.core.filetype.IResolverChangeListener;
import org.eclipse.cdt.core.filetype.IResolverModel;
import org.eclipse.cdt.core.filetype.ResolverChangeEvent;
import org.eclipse.cdt.core.filetype.ResolverDelta;
import org.eclipse.cdt.core.internal.filetype.CFileType;
import org.eclipse.cdt.core.internal.filetype.CFileTypeAssociation;
import org.eclipse.cdt.core.internal.filetype.CLanguage;
import org.eclipse.cdt.core.internal.filetype.CustomResolver;
import org.eclipse.cdt.core.internal.filetype.WorkspaceResolver;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;

public class ResolverModel
implements IResolverModel {
    public static final String NAME_UNKNOWN = "Unknown";
    public static final ICLanguage DEFAULT_LANG_TYPE = new CLanguage("org.eclipse.cdt.core.language.unknown", "Unknown");
    public static final ICFileType DEFAULT_FILE_TYPE = new CFileType("org.eclipse.cdt.core.fileType.unknown", DEFAULT_LANG_TYPE, "Unknown", 0);
    private Map fLangMap = new HashMap();
    private Map fTypeMap = new HashMap();
    private ICFileTypeResolver fWorkspaceResolver = null;
    private static final String EXTENSION_LANG = "CLanguage";
    private static final String EXTENSION_TYPE = "CFileType";
    private static final String EXTENSION_ASSOC = "CFileTypeAssociation";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_ID = "id";
    private static final String ATTR_LANGUAGE = "language";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VAL_SOURCE = "source";
    private static final String ATTR_VAL_HEADER = "header";
    public static boolean VERBOSE = false;
    private static ResolverModel fInstance = null;
    private static final String QN_RESOLVER_MODEL_ID = "org.eclipse.cdt.core.resolver";
    private static final QualifiedName QN_CUSTOM_RESOLVER = new QualifiedName("org.eclipse.cdt.core.resolver", "custom");
    private List fListeners = new Vector();
    private static final String WKSP_STATE_FILE = "resolver.properties";

    private ResolverModel() {
        try {
            this.loadDeclaredLanguages();
            this.loadDeclaredTypes();
            this.fWorkspaceResolver = this.loadWorkspaceResolver();
            this.convertFrom20();
            this.initRegistryChangeListener();
            this.initPreferenceChangeListener();
        }
        catch (Exception e) {
            CCorePlugin.log(e);
        }
    }

    public static synchronized ResolverModel getDefault() {
        if (fInstance == null) {
            fInstance = new ResolverModel();
        }
        return fInstance;
    }

    public ICLanguage[] getLanguages() {
        Collection values = this.fLangMap.values();
        return values.toArray(new ICLanguage[values.size()]);
    }

    public ICFileType[] getFileTypes() {
        Collection values = this.fTypeMap.values();
        return values.toArray(new ICFileType[values.size()]);
    }

    public ICLanguage getLanguageById(String languageId) {
        ICLanguage lang = (ICLanguage)this.fLangMap.get(languageId);
        return lang != null ? lang : DEFAULT_LANG_TYPE;
    }

    public ICFileType getFileTypeById(String typeId) {
        ICFileType type = (ICFileType)this.fTypeMap.get(typeId);
        return type != null ? type : DEFAULT_FILE_TYPE;
    }

    public boolean addLanguages(ICLanguage[] langs) {
        ResolverChangeEvent event = new ResolverChangeEvent(this, this.getResolver());
        boolean result = this.addLanguages(langs, event);
        if (result) {
            this.fireEvent(event);
        }
        return result;
    }

    public boolean addFileTypes(ICFileType[] types) {
        ResolverChangeEvent event = new ResolverChangeEvent(this, this.getResolver());
        boolean result = this.addFileTypes(types, event);
        if (result) {
            this.fireEvent(event);
        }
        return result;
    }

    public boolean removeLanguages(ICLanguage[] langs) {
        ResolverChangeEvent event = new ResolverChangeEvent(this, this.getResolver());
        boolean result = this.removeLanguages(langs, event);
        if (result) {
            this.fireEvent(event);
        }
        return result;
    }

    public boolean removeFileTypes(ICFileType[] types) {
        ResolverChangeEvent event = new ResolverChangeEvent(this, this.getResolver());
        boolean result = this.removeFileTypes(types, event);
        if (result) {
            this.fireEvent(event);
        }
        return result;
    }

    public ICFileTypeResolver getResolver() {
        return this.fWorkspaceResolver;
    }

    public boolean hasCustomResolver(IProject project) {
        return CustomResolver.hasCustomResolver(project);
    }

    public ICFileTypeResolver createCustomResolver(IProject project, ICFileTypeResolver copy) {
        ICFileTypeAssociation[] oldAssocs = null;
        ICFileTypeAssociation[] newAssocs = null;
        ICFileTypeResolver oldResolver = this.getResolver(project);
        oldAssocs = oldResolver.getFileTypeAssociations();
        if (this.hasCustomResolver(project)) {
            CustomResolver.removeCustomResover(project);
        }
        CustomResolver newResolver = new CustomResolver(this, project);
        if (copy != null) {
            newAssocs = copy.getFileTypeAssociations();
            newResolver.addAssociations(newAssocs);
        }
        try {
            project.setSessionProperty(QN_CUSTOM_RESOLVER, (Object)newResolver);
        }
        catch (CoreException coreException) {}
        ResolverChangeEvent event = new ResolverChangeEvent(this, newResolver, oldResolver);
        this.fireResolverChangeEvent(event, newAssocs, oldAssocs);
        return newResolver;
    }

    public void removeCustomResolver(IProject project) {
        if (this.hasCustomResolver(project)) {
            ICFileTypeAssociation[] oldAssocs = null;
            ICFileTypeAssociation[] newAssocs = null;
            ICFileTypeResolver oldResolver = this.getResolver(project);
            oldAssocs = oldResolver.getFileTypeAssociations();
            ICFileTypeResolver newResolver = this.getResolver();
            newAssocs = newResolver.getFileTypeAssociations();
            try {
                project.setSessionProperty(QN_CUSTOM_RESOLVER, null);
            }
            catch (CoreException coreException) {}
            CustomResolver.removeCustomResover(project);
            ResolverChangeEvent event = new ResolverChangeEvent(this, newResolver, oldResolver);
            this.fireResolverChangeEvent(event, newAssocs, oldAssocs);
        }
    }

    public ICFileTypeResolver getResolver(IProject project) {
        ICFileTypeResolver resolver = null;
        if (project != null) {
            try {
                Object obj = project.getSessionProperty(QN_CUSTOM_RESOLVER);
                if (obj instanceof ICFileTypeResolver) {
                    resolver = (ICFileTypeResolver)obj;
                }
            }
            catch (CoreException coreException) {}
            if (resolver == null && this.hasCustomResolver(project)) {
                resolver = new CustomResolver(this, project);
                try {
                    project.setSessionProperty(QN_CUSTOM_RESOLVER, (Object)resolver);
                }
                catch (CoreException coreException) {}
            }
        }
        if (resolver == null) {
            resolver = this.getResolver();
        }
        return resolver;
    }

    public ICFileTypeAssociation createAssocation(String pattern, ICFileType type) {
        return new CFileTypeAssociation(pattern, type);
    }

    public void addResolverChangeListener(IResolverChangeListener listener) {
        this.fListeners.add(listener);
    }

    public void removeResolverChangeListener(IResolverChangeListener listener) {
        this.fListeners.remove(listener);
    }

    private IExtensionPoint getExtensionPoint(String extensionPointId) {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", extensionPointId);
    }

    private static boolean isDebugging() {
        return VERBOSE;
    }

    private static void debugLog(String message) {
        System.out.println("CDT Resolver: " + message);
    }

    public void fireEvent(final ResolverChangeEvent event) {
        if (event == null) {
            return;
        }
        if (ResolverModel.isDebugging()) {
            ResolverModel.debugLog(event.toString());
        }
        if (this.fListeners.isEmpty()) {
            return;
        }
        final IResolverChangeListener[] listeners = this.fListeners.toArray(new IResolverChangeListener[this.fListeners.size()]);
        int i = 0;
        while (i < listeners.length) {
            final int index = i++;
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    Status status = new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString("ResolverModel.exception.listenerError"), exception);
                    CCorePlugin.log((IStatus)status);
                }

                public void run() throws Exception {
                    listeners[index].resolverChanged(event);
                }
            });
        }
    }

    private void fireResolverChangeEvent(ResolverChangeEvent event, ICFileTypeAssociation[] newAssocs, ICFileTypeAssociation[] oldAssocs) {
        if (oldAssocs != null && newAssocs != null) {
            int i = 0;
            while (i < oldAssocs.length) {
                if (Arrays.binarySearch(newAssocs, oldAssocs[i], ICFileTypeAssociation.Comparator) < 0) {
                    event.addDelta(new ResolverDelta(oldAssocs[i], 32));
                }
                ++i;
            }
            i = 0;
            while (i < newAssocs.length) {
                if (Arrays.binarySearch(oldAssocs, newAssocs[i], ICFileTypeAssociation.Comparator) < 0) {
                    event.addDelta(new ResolverDelta(newAssocs[i], 16));
                }
                ++i;
            }
        }
        this.fireEvent(event);
    }

    private void initRegistryChangeListener() {
        Platform.getExtensionRegistry().addRegistryChangeListener(new IRegistryChangeListener(){

            public void registryChanged(IRegistryChangeEvent event) {
                ResolverModel.this.handleRegistryChanged(event);
            }
        }, "org.eclipse.cdt.core");
    }

    private void initPreferenceChangeListener() {
        Preferences prefs = CCorePlugin.getDefault().getPluginPreferences();
        prefs.addPropertyChangeListener(new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent event) {
                ResolverModel.this.handlePropertyChanged(event);
            }
        });
    }

    protected void handlePropertyChanged(Preferences.PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property != null && ("org.eclipse.cdt.core.associationExclusion".equals(property) || "org.eclipse.cdt.core.associationInclusion".equals(property))) {
            this.fWorkspaceResolver = this.loadWorkspaceResolver();
        }
    }

    protected void handleRegistryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = null;
        ResolverChangeEvent modelEvent = new ResolverChangeEvent(this, this.getResolver());
        deltas = event.getExtensionDeltas("org.eclipse.cdt.core", EXTENSION_LANG);
        int i = 0;
        while (i < deltas.length) {
            this.processLanguageExtension(modelEvent, deltas[i].getExtension(), 1 == deltas[i].getKind());
            ++i;
        }
        deltas = event.getExtensionDeltas("org.eclipse.cdt.core", EXTENSION_TYPE);
        i = 0;
        while (i < deltas.length) {
            this.processTypeExtension(modelEvent, deltas[i].getExtension(), 1 == deltas[i].getKind());
            ++i;
        }
        deltas = event.getExtensionDeltas("org.eclipse.cdt.core", EXTENSION_ASSOC);
        if (deltas.length != 0) {
            this.fWorkspaceResolver = this.loadWorkspaceResolver();
        }
        this.fireEvent(modelEvent);
    }

    private boolean addLanguages(ICLanguage[] langs, ResolverChangeEvent event) {
        boolean added = false;
        int i = 0;
        while (i < langs.length) {
            ICLanguage lang = langs[i];
            if (!this.fLangMap.containsValue(lang)) {
                this.fLangMap.put(lang.getId(), lang);
                if (event != null) {
                    event.addDelta(new ResolverDelta(lang, 16));
                }
                added = true;
            }
            ++i;
        }
        return added;
    }

    private boolean addFileTypes(ICFileType[] types, ResolverChangeEvent event) {
        boolean added = false;
        int i = 0;
        while (i < types.length) {
            ICFileType type = types[i];
            if (!this.fTypeMap.containsValue(type)) {
                this.fTypeMap.put(type.getId(), type);
                event.addDelta(new ResolverDelta(type, 16));
                added = true;
            }
            ++i;
        }
        return added;
    }

    private boolean removeLanguages(ICLanguage[] langs, ResolverChangeEvent event) {
        boolean del = false;
        ArrayList<ICFileType> removeTypeList = new ArrayList<ICFileType>(langs.length);
        int i = 0;
        while (i < langs.length) {
            boolean removed;
            ICLanguage lang = langs[i];
            boolean bl = removed = this.fLangMap.remove(lang.getId()) != null;
            if (removed) {
                event.addDelta(new ResolverDelta(lang, 32));
                del = true;
                Iterator iter = this.fTypeMap.values().iterator();
                while (iter.hasNext()) {
                    ICFileType type = (ICFileType)iter.next();
                    if (!lang.equals(type.getLanguage())) continue;
                    removeTypeList.add(type);
                }
            }
            ++i;
        }
        if (!removeTypeList.isEmpty()) {
            ICFileType[] types = removeTypeList.toArray(new ICFileType[removeTypeList.size()]);
            this.removeFileTypes(types, event);
        }
        return del;
    }

    private boolean removeFileTypes(ICFileType[] types, ResolverChangeEvent event) {
        boolean changed = false;
        int i = 0;
        while (i < types.length) {
            boolean removed;
            ICFileType type = types[i];
            boolean bl = removed = this.fTypeMap.remove(type.getId()) != null;
            if (removed) {
                changed = true;
                if (event != null) {
                    event.addDelta(new ResolverDelta(type, 32));
                }
            }
            ++i;
        }
        return changed;
    }

    private void loadDeclaredLanguages() {
        IExtensionPoint point = this.getExtensionPoint(EXTENSION_LANG);
        IExtension[] extensions = point.getExtensions();
        ResolverChangeEvent event = new ResolverChangeEvent(this, this.getResolver());
        int i = 0;
        while (i < extensions.length) {
            this.processLanguageExtension(event, extensions[i], true);
            ++i;
        }
        this.fireEvent(event);
    }

    private void loadDeclaredTypes() {
        IExtensionPoint point = this.getExtensionPoint(EXTENSION_TYPE);
        IExtension[] extensions = point.getExtensions();
        ResolverChangeEvent event = new ResolverChangeEvent(this, this.getResolver());
        int i = 0;
        while (i < extensions.length) {
            this.processTypeExtension(event, extensions[i], true);
            ++i;
        }
        this.fireEvent(event);
    }

    private void processLanguageExtension(ResolverChangeEvent event, IExtension extension, boolean add) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        ArrayList<CLanguage> list = new ArrayList<CLanguage>(elements.length);
        int i = 0;
        while (i < elements.length) {
            String id = elements[i].getAttribute(ATTR_ID);
            String name = elements[i].getAttribute(ATTR_NAME);
            try {
                CLanguage element = new CLanguage(id, name);
                list.add(element);
            }
            catch (IllegalArgumentException e) {
                CCorePlugin.log(e);
            }
            ++i;
        }
        ICLanguage[] langs = list.toArray(new ICLanguage[list.size()]);
        if (add) {
            this.addLanguages(langs, event);
        } else {
            this.removeLanguages(langs, event);
        }
    }

    private void processTypeExtension(ResolverChangeEvent event, IExtension extension, boolean add) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        ArrayList<CFileType> list = new ArrayList<CFileType>(elements.length);
        int i = 0;
        while (i < elements.length) {
            String id = elements[i].getAttribute(ATTR_ID);
            String lang = elements[i].getAttribute(ATTR_LANGUAGE);
            String name = elements[i].getAttribute(ATTR_NAME);
            String type = elements[i].getAttribute(ATTR_TYPE);
            try {
                CFileType element = new CFileType(id, this.getLanguageById(lang), name, this.parseType(type));
                list.add(element);
            }
            catch (IllegalArgumentException e) {
                CCorePlugin.log(e);
            }
            ++i;
        }
        ICFileType[] types = list.toArray(new ICFileType[list.size()]);
        if (add) {
            this.addFileTypes(types, event);
        } else {
            this.removeFileTypes(types, event);
        }
    }

    private int parseType(String typeString) {
        int type = 0;
        if (typeString.equals(ATTR_VAL_SOURCE)) {
            type = 1;
        } else if (typeString.equals(ATTR_VAL_HEADER)) {
            type = 2;
        }
        return type;
    }

    private ICFileTypeResolver loadWorkspaceResolver() {
        return new WorkspaceResolver(this);
    }

    private void convertFrom20() {
        if (this.customWorkspaceResolverExists()) {
            ICFileTypeAssociation[] assocs = this.loadOldWorkspaceResolver();
            if (assocs != null && assocs.length > 0) {
                this.getResolver().addAssociations(assocs);
            }
            try {
                this.getWorkspaceResolverStateFilePath().toFile().delete();
            }
            catch (Exception exception) {}
        }
    }

    private boolean customWorkspaceResolverExists() {
        return this.getWorkspaceResolverStateFilePath().toFile().exists();
    }

    private IPath getWorkspaceResolverStateFilePath() {
        return CCorePlugin.getDefault().getStateLocation().append(WKSP_STATE_FILE);
    }

    /*
     * Exception decompiling
     */
    private ICFileTypeAssociation[] loadOldWorkspaceResolver() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 176->179)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

