/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.typehierarchy;

import org.eclipse.cdt.core.browser.TypeUtil;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IMember;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.internal.ui.actions.OpenActionUtil;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.TypeHierarchyViewPart;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;

public class OpenTypeHierarchyUtil {
    private OpenTypeHierarchyUtil() {
    }

    public static TypeHierarchyViewPart open(ICElement element, IWorkbenchWindow window) {
        ICElement[] candidates = OpenTypeHierarchyUtil.getCandidates(element);
        if (candidates != null) {
            return OpenTypeHierarchyUtil.open(candidates, window);
        }
        return null;
    }

    public static TypeHierarchyViewPart open(ICElement[] candidates, IWorkbenchWindow window) {
        Assert.isTrue((candidates != null && candidates.length != 0 ? 1 : 0) != 0);
        ICElement input = null;
        if (candidates.length > 1) {
            String title = CUIMessages.getString("OpenTypeHierarchyUtil.selectionDialog.title");
            String message = CUIMessages.getString("OpenTypeHierarchyUtil.selectionDialog.message");
            input = OpenActionUtil.selectCElement(candidates, window.getShell(), title, message);
        } else {
            input = candidates[0];
        }
        if (input == null) {
            return null;
        }
        try {
            if ("perspective".equals(PreferenceConstants.getPreferenceStore().getString("org.eclipse.cdt.ui.openTypeHierarchy"))) {
                return OpenTypeHierarchyUtil.openInPerspective(window, input);
            }
            return OpenTypeHierarchyUtil.openInViewPart(window, input);
        }
        catch (WorkbenchException e) {
            ExceptionHandler.handle((CoreException)((Object)e), window.getShell(), CUIMessages.getString("OpenTypeHierarchyUtil.error.open_perspective"), e.getMessage());
        }
        catch (CModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), window.getShell(), CUIMessages.getString("OpenTypeHierarchyUtil.error.open_editor"), e.getMessage());
        }
        return null;
    }

    private static TypeHierarchyViewPart openInViewPart(IWorkbenchWindow window, ICElement input) {
        IWorkbenchPage page = window.getActivePage();
        try {
            TypeHierarchyViewPart result = (TypeHierarchyViewPart)page.findView("org.eclipse.cdt.ui.TypeHierarchyView");
            if (result != null) {
                result.clearNeededRefresh();
            }
            result = (TypeHierarchyViewPart)page.showView("org.eclipse.cdt.ui.TypeHierarchyView");
            result.setInputElement(input);
            if (input instanceof IMember) {
                result.selectMember(input);
            }
            return result;
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, window.getShell(), CUIMessages.getString("OpenTypeHierarchyUtil.error.open_view"), e.getMessage());
            return null;
        }
    }

    private static TypeHierarchyViewPart openInPerspective(IWorkbenchWindow window, ICElement input) throws WorkbenchException, CModelException {
        IWorkbenchPage page;
        TypeHierarchyViewPart part;
        IWorkbench workbench = CUIPlugin.getDefault().getWorkbench();
        ICElement perspectiveInput = input;
        if (input instanceof IMember) {
            perspectiveInput = TypeUtil.isClassOrStruct((ICElement)input) ? TypeUtil.getDeclaringClass((ICElement)input) : input;
        }
        if ((part = (TypeHierarchyViewPart)(page = workbench.showPerspective("org.eclipse.cdt.ui.CHierarchyPerspective", window, (IAdaptable)perspectiveInput)).findView("org.eclipse.cdt.ui.TypeHierarchyView")) != null) {
            part.clearNeededRefresh();
        }
        part = (TypeHierarchyViewPart)page.showView("org.eclipse.cdt.ui.TypeHierarchyView");
        part.setInputElement(perspectiveInput);
        if (input instanceof IMember) {
            part.selectMember(input);
            if (page.getEditorReferences().length == 0) {
                OpenTypeHierarchyUtil.openEditor(input, false);
            }
        }
        return part;
    }

    private static void openEditor(Object input, boolean activate) throws PartInitException, CModelException {
        IEditorPart part = EditorUtility.openInEditor(input, activate);
        if (input instanceof ICElement) {
            EditorUtility.revealInEditor(part, (ICElement)input);
        }
    }

    public static ICElement[] getCandidates(Object input) {
        if (!(input instanceof ICElement)) {
            return null;
        }
        try {
            ICElement elem = (ICElement)input;
            switch (elem.getElementType()) {
                case 63: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 78: {
                    return new ICElement[]{TypeUtil.getDeclaringClass((ICElement)elem)};
                }
                case 64: 
                case 65: {
                    return new ICElement[]{elem};
                }
                case 61: {
                    return TypeUtil.getTypes((ICElement)elem);
                }
                case 60: {
                    ITranslationUnit cu = (ITranslationUnit)elem.getAncestor(60);
                    if (cu != null) {
                        return TypeUtil.getTypes((ITranslationUnit)cu);
                    }
                    break;
                }
            }
        }
        catch (CModelException e) {
            CUIPlugin.getDefault().log(e);
        }
        return null;
    }
}

