/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.preferences.TodoTaskInputDialog;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class TodoTaskConfigurationBlock
extends OptionsConfigurationBlock {
    private static final String PREF_TRANSLATION_TASK_TAGS = "org.eclipse.cdt.core.translation.taskTags";
    private static final String PREF_TRANSLATION_TASK_PRIORITIES = "org.eclipse.cdt.core.translation.taskPriorities";
    private static final String PRIORITY_HIGH = "HIGH";
    private static final String PRIORITY_NORMAL = "NORMAL";
    private static final String PRIORITY_LOW = "LOW";
    private PixelConverter fPixelConverter;
    private IStatus fTaskTagsStatus;
    private ListDialogField fTodoTasksList;

    public TodoTaskConfigurationBlock(IStatusChangeListener context, ICProject project) {
        super(context, project);
        TaskTagAdapter adapter = new TaskTagAdapter();
        String[] stringArray = new String[4];
        stringArray[0] = PreferencesMessages.getString("TodoTaskConfigurationBlock.markers.tasks.add.button");
        stringArray[1] = PreferencesMessages.getString("TodoTaskConfigurationBlock.markers.tasks.remove.button");
        stringArray[3] = PreferencesMessages.getString("TodoTaskConfigurationBlock.markers.tasks.edit.button");
        String[] buttons = stringArray;
        this.fTodoTasksList = new ListDialogField(adapter, buttons, (IBaseLabelProvider)new TodoTaskLabelProvider());
        this.fTodoTasksList.setDialogFieldListener(adapter);
        this.fTodoTasksList.setLabelText(PreferencesMessages.getString("TodoTaskConfigurationBlock.markers.tasks.label"));
        this.fTodoTasksList.setRemoveButtonIndex(1);
        String[] columnsHeaders = new String[]{PreferencesMessages.getString("TodoTaskConfigurationBlock.markers.tasks.name.column"), PreferencesMessages.getString("TodoTaskConfigurationBlock.markers.tasks.priority.column")};
        this.fTodoTasksList.setTableColumns(new ListDialogField.ColumnsDescription(columnsHeaders, true));
        this.unpackTodoTasks();
        if (this.fTodoTasksList.getSize() > 0) {
            this.fTodoTasksList.selectFirstElement();
        } else {
            this.fTodoTasksList.enableButton(3, false);
        }
        this.fTaskTagsStatus = new StatusInfo();
    }

    protected final String[] getAllKeys() {
        return new String[]{PREF_TRANSLATION_TASK_TAGS, PREF_TRANSLATION_TASK_PRIORITIES};
    }

    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite markersComposite = this.createMarkersTabContent(parent);
        this.validateSettings(null, null);
        return markersComposite;
    }

    private Composite createMarkersTabContent(Composite folder) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        Composite markersComposite = new Composite(folder, 0);
        markersComposite.setLayout((Layout)layout);
        this.fTodoTasksList.doFillIntoGrid(markersComposite, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fTodoTasksList.getLabelControl(null), 2);
        Table table = this.fTodoTasksList.getTableViewer().getTable();
        GridData data = (GridData)this.fTodoTasksList.getListControl(null).getLayoutData();
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 0;
        data.heightHint = SWTUtil.getTableHeightHint(table, 6);
        return markersComposite;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateSettings(String changedKey, String newValue) {
        if (changedKey != null) {
            if (!PREF_TRANSLATION_TASK_TAGS.equals(changedKey)) return;
            this.fTaskTagsStatus = this.validateTaskTags();
        } else {
            this.fTaskTagsStatus = this.validateTaskTags();
        }
        IStatus status = this.fTaskTagsStatus;
        this.fContext.statusChanged(status);
    }

    private IStatus validateTaskTags() {
        return new StatusInfo();
    }

    public boolean performOk(boolean enabled) {
        this.packTodoTasks();
        return super.performOk(enabled);
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = PreferencesMessages.getString("TodoTaskConfigurationBlock.needsbuild.title");
        String message = this.fProject == null ? PreferencesMessages.getString("TodoTaskConfigurationBlock.needsfullbuild.message") : PreferencesMessages.getString("TodoTaskConfigurationBlock.needsprojectbuild.message");
        return new String[]{title, message};
    }

    protected String[] getFullReParseDialogStrings(boolean workspaceSettings) {
        String title = PreferencesMessages.getString("TodoTaskConfigurationBlock.needsparse.title");
        String message = this.fProject == null ? PreferencesMessages.getString("TodoTaskConfigurationBlock.needsfullparse.message") : PreferencesMessages.getString("TodoTaskConfigurationBlock.needsprojectparse.message");
        return new String[]{title, message};
    }

    protected void updateControls() {
        this.unpackTodoTasks();
    }

    private void unpackTodoTasks() {
        String currTags = (String)this.fWorkingValues.get(PREF_TRANSLATION_TASK_TAGS);
        String currPrios = (String)this.fWorkingValues.get(PREF_TRANSLATION_TASK_PRIORITIES);
        String[] tags = this.getTokens(currTags, ",");
        String[] prios = this.getTokens(currPrios, ",");
        ArrayList<TodoTask> elements = new ArrayList<TodoTask>(tags.length);
        int i = 0;
        while (i < tags.length) {
            TodoTask task = new TodoTask();
            task.name = tags[i].trim();
            task.priority = i < prios.length ? prios[i] : PRIORITY_NORMAL;
            elements.add(task);
            ++i;
        }
        this.fTodoTasksList.setElements(elements);
    }

    private void packTodoTasks() {
        StringBuffer tags = new StringBuffer();
        StringBuffer prios = new StringBuffer();
        List list = this.fTodoTasksList.getElements();
        int i = 0;
        while (i < list.size()) {
            if (i > 0) {
                tags.append(',');
                prios.append(',');
            }
            TodoTask elem = (TodoTask)list.get(i);
            tags.append(elem.name);
            prios.append(elem.priority);
            ++i;
        }
        this.fWorkingValues.put(PREF_TRANSLATION_TASK_TAGS, tags.toString());
        this.fWorkingValues.put(PREF_TRANSLATION_TASK_PRIORITIES, prios.toString());
    }

    void doTodoButtonPressed(int index) {
        TodoTaskInputDialog dialog;
        TodoTask edited = null;
        if (index != 0) {
            edited = (TodoTask)this.fTodoTasksList.getSelectedElements().get(0);
        }
        if ((dialog = new TodoTaskInputDialog(this.getShell(), edited, this.fTodoTasksList.getElements())).open() == 0) {
            if (edited != null) {
                this.fTodoTasksList.replaceElement(edited, dialog.getResult());
            } else {
                this.fTodoTasksList.addElement(dialog.getResult());
            }
        }
    }

    public static class TodoTask {
        public String name;
        public String priority;
    }

    private static class TodoTaskLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TodoTaskLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            TodoTask task = (TodoTask)element;
            if (columnIndex == 0) {
                return task.name;
            }
            if (TodoTaskConfigurationBlock.PRIORITY_HIGH.equals(task.priority)) {
                return PreferencesMessages.getString("TodoTaskConfigurationBlock.markers.tasks.high.priority");
            }
            if (TodoTaskConfigurationBlock.PRIORITY_NORMAL.equals(task.priority)) {
                return PreferencesMessages.getString("TodoTaskConfigurationBlock.markers.tasks.normal.priority");
            }
            if (TodoTaskConfigurationBlock.PRIORITY_LOW.equals(task.priority)) {
                return PreferencesMessages.getString("TodoTaskConfigurationBlock.markers.tasks.low.priority");
            }
            return "";
        }
    }

    public class TaskTagAdapter
    implements IListAdapter,
    IDialogFieldListener {
        private boolean canEdit(ListDialogField field) {
            return field.getSelectedElements().size() == 1;
        }

        public void customButtonPressed(ListDialogField field, int index) {
            TodoTaskConfigurationBlock.this.doTodoButtonPressed(index);
        }

        public void selectionChanged(ListDialogField field) {
            field.enableButton(3, this.canEdit(field));
        }

        public void doubleClicked(ListDialogField field) {
            if (this.canEdit(field)) {
                TodoTaskConfigurationBlock.this.doTodoButtonPressed(3);
            }
        }

        public void dialogFieldChanged(DialogField field) {
            TodoTaskConfigurationBlock.this.validateSettings(TodoTaskConfigurationBlock.PREF_TRANSLATION_TASK_TAGS, null);
        }
    }
}

