/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import java.io.IOException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class SelectionParseAction
extends Action {
    protected IWorkbenchSite fSite;
    protected CEditor fEditor;

    public SelectionParseAction() {
    }

    public SelectionParseAction(CEditor editor) {
        this.fEditor = editor;
        this.fSite = editor.getSite();
    }

    public SelectionParseAction(IWorkbenchSite site) {
        this.fSite = site;
    }

    protected IParser setupParser(IFile resourceFile) {
        IWorkingCopy[] workingCopies;
        IScannerInfo buildScanInfo;
        IProject currentProject = resourceFile.getProject();
        ScannerInfo scanInfo = new ScannerInfo();
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(currentProject);
        if (provider != null && (buildScanInfo = provider.getScannerInformation((IResource)resourceFile)) != null) {
            scanInfo = new ScannerInfo(buildScanInfo.getDefinedSymbols(), buildScanInfo.getIncludePaths());
        }
        ParserLanguage language = CoreModel.hasCCNature((IProject)currentProject) ? ParserLanguage.CPP : ParserLanguage.C;
        IWorkingCopy workingCopy = null;
        if (this.fEditor.isDirty() && (workingCopies = CUIPlugin.getSharedWorkingCopies()) != null) {
            int i = 0;
            while (i < workingCopies.length) {
                if (workingCopies[i].getUnderlyingResource().equals((Object)resourceFile)) {
                    workingCopy = workingCopies[i];
                    break;
                }
                ++i;
            }
        }
        IParser parser = null;
        CodeReader reader = null;
        try {
            reader = workingCopy == null ? new CodeReader(resourceFile.getLocation().toOSString(), resourceFile.getCharset()) : new CodeReader(resourceFile.getLocation().toOSString(), workingCopy.getContents());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        try {
            parser = ParserFactory.createParser((IScanner)ParserFactory.createScanner((CodeReader)reader, (IScannerInfo)scanInfo, (ParserMode)ParserMode.SELECTION_PARSE, (ParserLanguage)language, (ISourceElementRequestor)new NullSourceElementRequestor(), (IParserLogService)ParserUtil.getScannerLogService(), null), (ISourceElementRequestor)new NullSourceElementRequestor(), (ParserMode)ParserMode.SELECTION_PARSE, (ParserLanguage)language, (IParserLogService)ParserUtil.getParserLogService());
        }
        catch (ParserFactoryError parserFactoryError) {}
        return parser;
    }

    protected void operationNotAvailable() {
        IStatusLineManager statusManager = null;
        if (this.fSite instanceof IViewSite) {
            statusManager = ((IViewSite)this.fSite).getActionBars().getStatusLineManager();
        } else if (this.fSite instanceof IEditorSite) {
            statusManager = ((IEditorSite)this.fSite).getActionBars().getStatusLineManager();
        }
        if (statusManager != null) {
            statusManager.setErrorMessage(CSearchMessages.getString("CSearchOperation.operationUnavailable.message"));
        }
    }

    protected void clearStatusLine() {
        IStatusLineManager statusManager = null;
        if (this.fSite instanceof IViewSite) {
            statusManager = ((IViewSite)this.fSite).getActionBars().getStatusLineManager();
        } else if (this.fSite instanceof IEditorSite) {
            statusManager = ((IEditorSite)this.fSite).getActionBars().getStatusLineManager();
        }
        if (statusManager != null) {
            statusManager.setErrorMessage("");
        }
    }

    public SelSearchNode getSelection(int fPos) {
        IDocument doc;
        IDocumentProvider prov = this.fEditor != null ? this.fEditor.getDocumentProvider() : null;
        IDocument iDocument = doc = prov != null ? prov.getDocument((Object)this.fEditor.getEditorInput()) : null;
        if (doc == null) {
            return null;
        }
        int pos = fPos;
        int fStartPos = 0;
        int fEndPos = 0;
        String selectedWord = null;
        try {
            char c;
            while (pos >= 0) {
                c = doc.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                --pos;
            }
            fStartPos = pos + 1;
            pos = fPos;
            int length = doc.getLength();
            while (pos < length) {
                c = doc.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++pos;
            }
            fEndPos = pos;
            selectedWord = doc.get(fStartPos, fEndPos - fStartPos);
        }
        catch (BadLocationException badLocationException) {}
        SelSearchNode sel = new SelSearchNode();
        sel.selText = selectedWord;
        sel.selStart = fStartPos;
        sel.selEnd = fEndPos;
        return sel;
    }

    protected SelSearchNode getSelection(ITextSelection textSelection) {
        if (textSelection == null) {
            return null;
        }
        String seltext = textSelection.getText();
        SelSearchNode sel = null;
        if (seltext == null || seltext.length() == 0) {
            int selStart = textSelection.getOffset();
            sel = this.getSelection(selStart);
        } else {
            sel = new SelSearchNode();
            sel.selText = seltext;
            sel.selStart = textSelection.getOffset();
            sel.selEnd = textSelection.getOffset() + textSelection.getLength();
        }
        return sel;
    }

    protected ISelection getSelection() {
        ISelection sel = null;
        if (this.fSite != null && this.fSite.getSelectionProvider() != null) {
            sel = this.fSite.getSelectionProvider().getSelection();
        }
        return sel;
    }

    class SelSearchNode {
        protected String selText;
        protected int selStart;
        protected int selEnd;

        SelSearchNode() {
        }
    }
}

