/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.gnu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParserUtility;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class GCCScannerInfoConsoleParser
implements IScannerInfoConsoleParser {
    private static final String SINGLE_QUOTE_STRING = "'";
    private static final String DOUBLE_QUOTE_STRING = "\"";
    private static final char[] matchingChars = new char[]{'`', '\'', '\"'};
    private IProject fProject = null;
    private IScannerInfoConsoleParserUtility fUtil = null;
    private IScannerInfoCollector fCollector = null;
    private boolean bMultiline = false;
    private String sMultiline = "";

    public void startup(IProject project, IScannerInfoConsoleParserUtility util, IScannerInfoCollector collector) {
        this.fProject = project;
        this.fUtil = util;
        this.fCollector = collector;
    }

    public boolean processLine(String line) {
        List allTokens;
        boolean rc = false;
        if (line.endsWith("\\")) {
            this.sMultiline = String.valueOf(this.sMultiline) + line.substring(0, line.length() - 1);
            this.bMultiline = true;
            return rc;
        }
        if (this.bMultiline) {
            line = String.valueOf(this.sMultiline) + line;
            this.bMultiline = false;
            this.sMultiline = "";
        }
        TraceUtil.outputTrace("GCCScannerInfoConsoleParser parsing line:", TraceUtil.EOL, line);
        int firstColon = line.indexOf(58);
        String make = line.substring(0, firstColon + 1);
        if (firstColon != -1 && make.indexOf("make") != -1) {
            boolean enter = false;
            String msg = line.substring(firstColon + 1).trim();
            enter = msg.startsWith("Entering directory");
            if (enter || msg.startsWith("Leaving directory")) {
                int s = msg.indexOf(96);
                int e = msg.indexOf(39);
                if (s != -1 && e != -1) {
                    String dir = msg.substring(s + 1, e);
                    if (this.fUtil != null) {
                        this.fUtil.changeMakeDirectory(dir, this.getDirectoryLevel(line), enter);
                    }
                    return rc;
                }
            }
        }
        if ((allTokens = this.tokenize(line)).size() <= 1) {
            return false;
        }
        Iterator I = allTokens.iterator();
        String token = ((String)I.next()).toLowerCase();
        if (token.indexOf("gcc") != -1 || token.indexOf("g++") != -1) {
            ArrayList includes = new ArrayList();
            ArrayList symbols = new ArrayList();
            ArrayList<String> targetSpecificOptions = new ArrayList<String>();
            rc = true;
            String fileName = null;
            this.parseLineForIncludePaths(line, includes);
            this.parseLineForSymbolDefinitions(line, symbols);
            while (I.hasNext()) {
                token = (String)I.next();
                if (token.equals("-mwin32") || token.equals("-mno-win32") || token.equals("-mno-cygwin") || token.equals("-ansi") || token.equals("-nostdinc") || token.equals("-posix") || token.equals("-pthread")) {
                    if (targetSpecificOptions.contains(token)) continue;
                    targetSpecificOptions.add(token);
                    continue;
                }
                if (fileName != null) continue;
                String possibleFileName = token.toLowerCase();
                if (possibleFileName.startsWith(DOUBLE_QUOTE_STRING) && possibleFileName.endsWith(DOUBLE_QUOTE_STRING) || possibleFileName.startsWith(SINGLE_QUOTE_STRING) && possibleFileName.endsWith(SINGLE_QUOTE_STRING)) {
                    possibleFileName = possibleFileName.substring(1, possibleFileName.length() - 1).trim();
                }
                if (!possibleFileName.endsWith(".c") && !possibleFileName.endsWith(".cpp") && !possibleFileName.endsWith(".cc") && !possibleFileName.endsWith(".cxx") && !possibleFileName.endsWith(".C") && !possibleFileName.endsWith(".CPP") && !possibleFileName.endsWith(".CC") && !possibleFileName.endsWith(".CXX") && !possibleFileName.endsWith(".c++")) continue;
                fileName = token;
            }
            IProject project = this.fProject;
            IFile file = null;
            List translatedIncludes = includes;
            if (includes.size() > 0) {
                if (fileName != null) {
                    if (this.fUtil != null && (file = this.fUtil.findFile(fileName)) != null) {
                        project = file.getProject();
                        translatedIncludes = this.fUtil.translateRelativePaths(file, fileName, includes);
                    }
                } else {
                    String error = MakeMessages.getString("ConsoleParser.Filename_Missing_Error_Message");
                    TraceUtil.outputError(error, line);
                    if (this.fUtil != null) {
                        this.fUtil.generateMarker((IResource)this.fProject, -1, String.valueOf(error) + line, 1, null);
                    }
                }
                if (file == null && this.fUtil != null) {
                    translatedIncludes.clear();
                }
            }
            if (translatedIncludes.size() > 0 || symbols.size() > 0) {
                HashMap<Integer, ArrayList<String>> extraInfo = new HashMap<Integer, ArrayList<String>>();
                extraInfo.put(IScannerInfoCollector.TARGET_SPECIFIC_OPTION, targetSpecificOptions);
                this.fCollector.contributeToScannerConfig((IResource)project, translatedIncludes, symbols, extraInfo);
                TraceUtil.outputTrace("Discovered scanner info for file '" + fileName + '\'', "Include paths", includes, translatedIncludes, "Defined symbols", symbols);
            }
        }
        return rc;
    }

    private List tokenize(String line) {
        ArrayList<String> rv = new ArrayList<String>(2);
        int prevFmc = line.length();
        int emc = -1;
        char matchingChar = '\u0000';
        int i = 0;
        while (i < matchingChars.length) {
            char ch = matchingChars[i];
            int fmc = line.indexOf(ch);
            if (fmc > -1 && fmc < prevFmc && (emc = line.indexOf(ch, fmc + 1)) > fmc) {
                matchingChar = ch;
                prevFmc = fmc;
            }
            ++i;
        }
        if (matchingChar != '\u0000') {
            String prefix = line.substring(0, prevFmc).trim();
            rv.addAll(Arrays.asList(prefix.split("\\s+")));
            rv.add(line.substring(prevFmc, emc + 1));
            rv.addAll(this.tokenize(line.substring(emc + 1).trim()));
        } else {
            rv.addAll(Arrays.asList(line.split("\\s+")));
        }
        return rv;
    }

    private void parseLineForIncludePaths(String line, List includes) {
        int prevIndex = 0;
        int index = line.indexOf("-I", prevIndex);
        while (index != -1) {
            String postfix;
            String delimiter = "\\s+";
            if (line.charAt(index - 1) == '\'' || line.charAt(index - 1) == '\"') {
                delimiter = String.valueOf(line.charAt(index - 1));
            }
            if ((postfix = line.substring(index + 2).trim()).charAt(0) != '-') {
                String iPath;
                String[] tokens;
                if (postfix.startsWith(SINGLE_QUOTE_STRING) || postfix.startsWith(DOUBLE_QUOTE_STRING)) {
                    delimiter = postfix.substring(0, 1);
                }
                int tokIndex = (tokens = postfix.split(delimiter)).length > 1 && tokens[0].length() == 0 ? 1 : 0;
                String temp = iPath = tokens[tokIndex];
                ++tokIndex;
                while (temp.endsWith("\\") && tokIndex < tokens.length && tokens[tokIndex].length() > 0 && !tokens[tokIndex].startsWith("-")) {
                    int beg = postfix.indexOf(temp) + temp.length();
                    int end = postfix.indexOf(tokens[tokIndex]) + tokens[tokIndex].length();
                    iPath = String.valueOf(iPath.substring(0, iPath.length() - 1)) + postfix.substring(beg, end);
                    temp = String.valueOf(temp) + postfix.substring(beg, end);
                    ++tokIndex;
                }
                String nPath = iPath;
                if (this.fUtil != null) {
                    nPath = this.fUtil.normalizePath(iPath);
                }
                if (!includes.contains(nPath)) {
                    includes.add(nPath);
                }
            }
            prevIndex = index + 2;
            index = line.indexOf("-I", prevIndex);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseLineForSymbolDefinitions(String line, List symbols) {
        prevIndex = 0;
        delimiter = null;
        splitRegex = "\\s+";
        index = line.indexOf("-D", prevIndex);
        while (index != -1) {
            block12: {
                block13: {
                    nDelimiterSymbols = 2;
                    postfix = line.substring(index + 2).trim();
                    if (postfix.charAt(0) == '-') break block12;
                    if (line.charAt(index - 1) != '\'' && line.charAt(index - 1) != '\"') break block13;
                    delimiter = String.valueOf(line.charAt(index - 1));
                    nDelimiterSymbols = 1;
                    ** GOTO lbl24
                }
                tokens = postfix.split(splitRegex, 2);
                if (tokens.length <= 0 || tokens[0].length() <= 0) break block12;
                sQuoteIndex = tokens[0].indexOf("'");
                dQuoteIndex = tokens[0].indexOf("\"");
                if (sQuoteIndex == -1 && dQuoteIndex == -1) {
                    if (!symbols.contains(tokens[0])) {
                        symbols.add(tokens[0]);
                    }
                } else {
                    delimiter = sQuoteIndex != -1 && (dQuoteIndex == -1 || sQuoteIndex < dQuoteIndex) ? "'" : "\"";
lbl24:
                    // 2 sources

                    nextDelimiterIndex = -1;
                    prevDelimiterIndex = -1;
                    do {
                        if ((nextDelimiterIndex = postfix.indexOf(delimiter, nextDelimiterIndex + 1)) != 0 && (nextDelimiterIndex <= 0 || postfix.charAt(nextDelimiterIndex - 1) == '\\') || --nDelimiterSymbols <= 0) continue;
                        prevDelimiterIndex = nextDelimiterIndex;
                    } while (nDelimiterSymbols > 0 && nextDelimiterIndex != -1);
                    if (nDelimiterSymbols <= 0) {
                        bStartsWithDelimiter = postfix.startsWith(delimiter);
                        symbol = postfix.substring(bStartsWithDelimiter != false ? 1 : 0, nextDelimiterIndex);
                        if (!bStartsWithDelimiter && prevDelimiterIndex != -1) {
                            symbol = String.valueOf(symbol.substring(0, prevDelimiterIndex)) + symbol.substring(prevDelimiterIndex + 1);
                        }
                        if (delimiter.equals("\"")) {
                            symbol = symbol.replaceAll("\\\\\"", "\"");
                        }
                        if (!symbols.contains(symbol)) {
                            symbols.add(symbol);
                        }
                    }
                }
            }
            prevIndex = index + 2;
            index = line.indexOf("-D", prevIndex);
        }
    }

    public void shutdown() {
        if (this.fUtil != null) {
            this.fUtil.reportProblems();
        }
    }

    private int getDirectoryLevel(String line) {
        int s = line.indexOf(91);
        int num = 0;
        if (s != -1) {
            int e = line.indexOf(93);
            String number = line.substring(s + 1, e).trim();
            try {
                num = Integer.parseInt(number);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return num;
    }
}

