/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParserUtility;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ScannerInfoConsoleParserUtility
implements IScannerInfoConsoleParserUtility {
    private IProject fProject;
    private IPath fBaseDirectory;
    private IMarkerGenerator fMarkerGenerator;
    private ArrayList fErrors;
    private Map fFilesInProject;
    private List fCollectedFiles;
    private List fNameConflicts;
    private Vector fDirectoryStack;

    public ScannerInfoConsoleParserUtility(IProject project, IPath workingDirectory, IMarkerGenerator markerGenerator) {
        this.fProject = project;
        this.fMarkerGenerator = markerGenerator;
        this.fBaseDirectory = this.fProject.getLocation();
        this.fErrors = new ArrayList();
        this.fFilesInProject = new HashMap();
        this.fCollectedFiles = new ArrayList();
        this.fNameConflicts = new ArrayList();
        this.fDirectoryStack = new Vector();
        this.collectFiles((IContainer)this.fProject, this.fCollectedFiles);
        int i = 0;
        while (i < this.fCollectedFiles.size()) {
            IFile curr = (IFile)this.fCollectedFiles.get(i);
            IFile existing = this.fFilesInProject.put(curr.getName(), curr);
            if (existing != null) {
                this.fNameConflicts.add(curr.getName());
            }
            ++i;
        }
        if (workingDirectory != null) {
            this.pushDirectory(workingDirectory);
        }
    }

    public boolean reportProblems() {
        boolean reset = false;
        Iterator iter = this.fErrors.iterator();
        while (iter.hasNext()) {
            Problem problem = (Problem)iter.next();
            if (problem.severity == 3) {
                reset = true;
            }
            if (problem.file == null) {
                this.fMarkerGenerator.addMarker((IResource)this.fProject, problem.lineNumber, problem.description, problem.severity, problem.variableName);
                continue;
            }
            this.fMarkerGenerator.addMarker(problem.file, problem.lineNumber, problem.description, problem.severity, problem.variableName);
        }
        this.fErrors.clear();
        return reset;
    }

    public void generateMarker(IResource file, int lineNumber, String desc, int severity, String varName) {
        if (this.fMarkerGenerator != null) {
            Problem problem = new Problem(file, lineNumber, desc, severity, varName);
            this.fErrors.add(problem);
        }
    }

    public IFile findFile(String fileName) {
        IFile file = this.findFilePath(fileName);
        if (file == null && (file = this.findFileName(fileName)) != null && this.isConflictingName(fileName)) {
            file = null;
            String error = MakeMessages.getString("ConsoleParser.Ambiguous_Filepath_Error_Message");
            TraceUtil.outputError(error, fileName);
            this.generateMarker((IResource)this.fProject, -1, String.valueOf(error) + fileName, 1, null);
        }
        return file;
    }

    protected IFile findFilePath(String filePath) {
        IPath path = null;
        Path fp = new Path(filePath);
        if (fp.isAbsolute()) {
            if (this.fBaseDirectory.isPrefixOf((IPath)fp)) {
                int segments = this.fBaseDirectory.matchingFirstSegments((IPath)fp);
                path = fp.removeFirstSegments(segments);
            } else {
                path = fp;
            }
        } else {
            path = this.getWorkingDirectory().append(filePath);
        }
        IFile file = null;
        try {
            file = this.findFileInWorkspace(path);
        }
        catch (Exception exception) {}
        if (file == null || !file.exists()) {
            File f = path.toFile();
            try {
                String canon = f.getCanonicalPath();
                path = new Path(canon);
                file = this.findFileInWorkspace(path);
            }
            catch (IOException iOException) {}
        }
        return file != null && file.exists() ? file : null;
    }

    protected IFile findFileName(String fileName) {
        Path path = new Path(fileName);
        return (IFile)this.fFilesInProject.get(path.lastSegment());
    }

    protected IFile findFileInWorkspace(IPath path) {
        IFile file = null;
        if (path.isAbsolute()) {
            IWorkspaceRoot root = this.fProject.getWorkspace().getRoot();
            file = root.getFileForLocation(path);
            if (file == null) {
                IFile[] files = root.findFilesForLocation(path);
                int i = 0;
                while (i < files.length) {
                    if (files[i].getProject().equals((Object)this.fProject)) {
                        file = files[i];
                        break;
                    }
                    ++i;
                }
            }
        } else {
            file = this.fProject.getFile(path);
        }
        return file;
    }

    protected void collectFiles(IContainer parent, List result) {
        try {
            IResource[] resources = parent.members();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (resource instanceof IFile) {
                    result.add(resource);
                } else if (resource instanceof IContainer) {
                    this.collectFiles((IContainer)resource, result);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            MakeCorePlugin.log(e.getStatus());
        }
    }

    protected boolean isConflictingName(String fileName) {
        Path path = new Path(fileName);
        return this.fNameConflicts.contains(path.lastSegment());
    }

    protected IPath getWorkingDirectory() {
        if (this.fDirectoryStack.size() != 0) {
            return (IPath)this.fDirectoryStack.lastElement();
        }
        return this.fBaseDirectory;
    }

    protected void pushDirectory(IPath dir) {
        if (dir != null) {
            IPath pwd = null;
            if (this.fBaseDirectory.isPrefixOf(dir)) {
                pwd = dir.removeFirstSegments(this.fBaseDirectory.segmentCount());
            } else if (dir.toString().startsWith("/cygdrive/")) {
                char driveLetter = dir.toString().charAt(10);
                driveLetter = Character.isLowerCase(driveLetter) ? Character.toUpperCase(driveLetter) : driveLetter;
                StringBuffer buf = new StringBuffer();
                buf.append(driveLetter);
                buf.append(':');
                String drive = buf.toString();
                pwd = dir.removeFirstSegments(2);
                pwd = pwd.setDevice(drive);
                pwd = pwd.makeAbsolute();
            } else {
                pwd = dir;
            }
            this.fDirectoryStack.addElement(pwd);
        }
    }

    protected IPath popDirectory() {
        int i = this.getDirectoryLevel();
        if (i != 0) {
            IPath dir = (IPath)this.fDirectoryStack.lastElement();
            this.fDirectoryStack.removeElementAt(i - 1);
            return dir;
        }
        return new Path("");
    }

    protected int getDirectoryLevel() {
        return this.fDirectoryStack.size();
    }

    public void changeMakeDirectory(String dir, int dirLevel, boolean enterDir) {
        if (enterDir) {
            int parseLevel = this.getDirectoryLevel();
            while (dirLevel < parseLevel) {
                this.popDirectory();
                parseLevel = this.getDirectoryLevel();
            }
            this.pushDirectory((IPath)new Path(dir));
        } else {
            this.popDirectory();
        }
    }

    public List translateRelativePaths(IFile file, String fileName, List includes) {
        ArrayList<String> translatedIncludes = new ArrayList<String>(includes.size());
        Iterator i = includes.iterator();
        while (i.hasNext()) {
            String include = (String)i.next();
            Path includePath = new Path(include);
            if (!includePath.isAbsolute() && !includePath.isUNC()) {
                Path filePath;
                IPath cwd = this.getWorkingDirectory();
                if (!cwd.isAbsolute()) {
                    cwd = this.fProject.getLocation().append(cwd);
                }
                if (!(filePath = new Path(fileName)).isAbsolute()) {
                    filePath = cwd.append(fileName);
                }
                if (!filePath.toString().equalsIgnoreCase(file.getLocation().toString())) {
                    IPath lastFileSegment;
                    if (fileName.startsWith("..")) {
                        String error = MakeMessages.getString("ConsoleParser.Working_Directory_Error_Message");
                        TraceUtil.outputError(error, fileName);
                        this.generateMarker((IResource)file, -1, error, 1, fileName);
                        break;
                    }
                    Path tPath = new Path(fileName);
                    if (fileName.startsWith(".")) {
                        tPath = tPath.removeFirstSegments(1);
                    }
                    if ((lastFileSegment = (filePath = file.getLocation()).removeFirstSegments(filePath.segmentCount() - tPath.segmentCount())).matchingFirstSegments((IPath)tPath) == tPath.segmentCount()) {
                        cwd = filePath.removeLastSegments(tPath.segmentCount());
                    }
                }
                IPath candidatePath = cwd.append((IPath)includePath);
                File dir = candidatePath.toFile();
                include = candidatePath.toString();
                if (!dir.exists()) {
                    String error = MakeMessages.getString("ConsoleParser.Nonexistent_Include_Path_Error_Message");
                    TraceUtil.outputError(error, include);
                }
            }
            translatedIncludes.add(include);
        }
        return translatedIncludes;
    }

    public String normalizePath(String path) {
        int sdot;
        char driveLetter;
        int column = path.indexOf(58);
        if (column > 0 && Character.isLowerCase(driveLetter = path.charAt(column - 1))) {
            StringBuffer sb = new StringBuffer();
            if (column - 1 > 0) {
                sb.append(path.substring(0, column - 1));
            }
            sb.append(Character.toUpperCase(driveLetter));
            sb.append(path.substring(column));
            path = sb.toString();
        }
        if (path.indexOf(46) == -1 || path.equals(".")) {
            return new Path(path).toString();
        }
        StringBuffer buf = new StringBuffer(path);
        int len = buf.length();
        StringBuffer newBuf = new StringBuffer(buf.length());
        int scp = 0;
        int ssp = 0;
        while (ssp < len && (sdot = buf.indexOf(".", ssp)) != -1) {
            boolean validPrefix = false;
            int ddot = buf.indexOf("..", ssp);
            if (sdot < ddot || ddot == -1) {
                newBuf.append(buf.substring(scp, sdot));
                scp = sdot;
                ssp = sdot + 1;
                if (ssp >= len) continue;
                if (sdot == 0 || buf.charAt(sdot - 1) == '/' || buf.charAt(sdot - 1) == '\\') {
                    validPrefix = true;
                }
                char nextChar = buf.charAt(ssp);
                if (validPrefix && nextChar == '/') {
                    scp = ++ssp;
                    continue;
                }
                if (validPrefix && nextChar == '\\') {
                    if (++ssp < len - 1 && buf.charAt(ssp) == '\\') {
                        ++ssp;
                    }
                    scp = ssp;
                    continue;
                }
                scp = ssp - 1;
                continue;
            }
            if (sdot != ddot) continue;
            ssp = sdot + 2;
        }
        newBuf.append(buf.substring(scp, len));
        Path orgPath = new Path(newBuf.toString());
        return orgPath.toString();
    }

    protected class Problem {
        protected IResource file;
        protected int lineNumber;
        protected String description;
        protected int severity;
        protected String variableName;

        public Problem(IResource file, int lineNumber, String desciption, int severity, String variableName) {
            this.file = file;
            this.lineNumber = lineNumber;
            this.description = desciption;
            this.severity = severity;
            this.variableName = variableName;
        }
    }
}

