/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.drag;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.cdt.internal.ui.drag.TransferDragSourceListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Control;

public class DelegatingDragAdapter
implements DragSourceListener {
    private final ISelectionProvider provider;
    private final TransferDragSourceListener[] listeners;
    private final boolean[] actives;
    private TransferDragSourceListener selected;
    static /* synthetic */ Class class$0;

    public DelegatingDragAdapter(ISelectionProvider provider, TransferDragSourceListener[] listeners) {
        Assert.isNotNull((Object)provider);
        Assert.isNotNull((Object)listeners);
        this.provider = provider;
        this.listeners = listeners;
        this.actives = new boolean[listeners.length];
        this.selected = null;
    }

    public void dragStart(DragSourceEvent event) {
        this.selected = null;
        IStructuredSelection selection = (IStructuredSelection)this.provider.getSelection();
        if (selection.isEmpty()) {
            event.doit = false;
            return;
        }
        Iterator i = selection.iterator();
        while (i.hasNext()) {
            Object next = i.next();
            IResource res = null;
            if (next instanceof IResource) {
                res = (IResource)next;
            } else if (next instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)next;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                res = (IResource)iAdaptable.getAdapter((Class)clazz);
            }
            if (res instanceof IFile || res instanceof IFolder) continue;
            event.doit = false;
            return;
        }
        DragSource dragSource = (DragSource)event.widget;
        Control control = dragSource.getControl();
        if (control != control.getDisplay().getFocusControl()) {
            event.doit = false;
            return;
        }
        Object saveData = event.data;
        boolean saveDoit = event.doit;
        int listenerCount = this.listeners.length;
        int transferCount = 0;
        int i2 = 0;
        while (i2 < listenerCount) {
            TransferDragSourceListener listener = this.listeners[i2];
            event.data = saveData;
            event.doit = saveDoit;
            listener.dragStart(event);
            this.actives[i2] = event.doit;
            if (this.actives[i2]) {
                ++transferCount;
            }
            ++i2;
        }
        event.data = saveData;
        event.doit = transferCount != 0;
        if (event.doit) {
            Transfer[] transferArray = new Transfer[transferCount];
            int i3 = listenerCount;
            while (--i3 >= 0) {
                if (!this.actives[i3]) continue;
                transferArray[--transferCount] = this.listeners[i3].getTransfer();
            }
            dragSource.setTransfer(transferArray);
        }
    }

    public void dragSetData(DragSourceEvent event) {
        this.selected = this.getListener(event.dataType);
        if (this.selected != null) {
            this.selected.dragSetData(event);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dragFinished(DragSourceEvent event) {
        try {
            if (this.selected == null) {
                this.selected = this.getListener(event.dataType);
            }
            if (this.selected != null) {
                this.selected.dragFinished(event);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            Arrays.fill(this.actives, false);
            this.selected = null;
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        Arrays.fill(this.actives, false);
        this.selected = null;
    }

    private TransferDragSourceListener getListener(TransferData type) {
        if (type != null) {
            int i = 0;
            while (i < this.actives.length) {
                TransferDragSourceListener listener;
                if (this.actives[i] && (listener = this.listeners[i]).getTransfer().isSupportedType(type)) {
                    return listener;
                }
                ++i;
            }
        }
        return null;
    }
}

