/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IMacro;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ParseError;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.ASTUtil;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCodeScope;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTCompletionNode;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.internal.ui.text.contentassist.ContentAssistElementRequestor;
import org.eclipse.cdt.internal.ui.text.contentassist.ICompletionRequestor;
import org.eclipse.cdt.internal.ui.text.contentassist.Problem;
import org.eclipse.cdt.internal.ui.text.contentassist.RelevanceConstants;
import org.eclipse.cdt.internal.ui.util.IDebugLogConstants;
import org.eclipse.cdt.internal.ui.util.Util;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;

public class CompletionEngine
implements RelevanceConstants {
    ICompletionRequestor requestor;
    int completionStart = 0;
    int completionLength = 0;
    int completionOrigin = 0;
    IPreferenceStore store = CUIPlugin.getDefault().getPreferenceStore();
    private CharArrayObjectMap macroMap = null;
    private ContentAssistElementRequestor elementRequestor = null;
    private static final String exceptionKeyword = "...";

    public CompletionEngine(ICompletionRequestor completionRequestor) {
        this.requestor = completionRequestor;
        this.elementRequestor = new ContentAssistElementRequestor();
    }

    private int computeCaseMatchingRelevance(String prefix, String proposalName) {
        if (CharOperation.prefixEquals((char[])prefix.toCharArray(), (char[])proposalName.toCharArray(), (boolean)true)) {
            if (CharOperation.equals((char[])prefix.toCharArray(), (char[])proposalName.toCharArray(), (boolean)true)) {
                return 200;
            }
            return 160;
        }
        return 0;
    }

    private int computeTypeRelevance(int type) {
        switch (type) {
            case 76: {
                return 140;
            }
            case 69: {
                return 130;
            }
            case 74: 
            case 75: {
                return 120;
            }
            case 67: 
            case 68: {
                return 110;
            }
            case 70: 
            case 71: {
                return 100;
            }
            case 64: {
                return 90;
            }
            case 65: {
                return 80;
            }
            case 66: {
                return 70;
            }
            case 78: {
                return 60;
            }
            case 61: {
                return 50;
            }
            case 77: {
                return 20;
            }
            case 63: {
                return 30;
            }
            case 79: {
                return 40;
            }
        }
        return 0;
    }

    public int computeRelevance(int elementType, String prefix, String proposalName) {
        int relevance = this.computeTypeRelevance(elementType);
        return relevance += this.computeCaseMatchingRelevance(prefix, proposalName);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IASTCompletionNode parse(IWorkingCopy sourceUnit, int completionOffset) {
        IScannerInfo buildScanInfo;
        IResource currentResource = sourceUnit.getResource();
        IPath realPath = currentResource.getLocation();
        IProject project = currentResource.getProject();
        CodeReader reader = new CodeReader(realPath.toOSString(), sourceUnit.getContents());
        ScannerInfo scanInfo = new ScannerInfo();
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(project);
        if (provider != null && (buildScanInfo = provider.getScannerInformation(currentResource)) != null) {
            scanInfo = new ScannerInfo(buildScanInfo.getDefinedSymbols(), buildScanInfo.getIncludePaths());
        }
        ParserLanguage language = CoreModel.hasCCNature((IProject)project) ? ParserLanguage.CPP : ParserLanguage.C;
        IParser parser = null;
        IScanner scanner = null;
        try {
            scanner = ParserFactory.createScanner((CodeReader)reader, (IScannerInfo)scanInfo, (ParserMode)ParserMode.COMPLETION_PARSE, (ParserLanguage)language, (ISourceElementRequestor)this.elementRequestor, (IParserLogService)ParserUtil.getScannerLogService(), Arrays.asList(CUIPlugin.getSharedWorkingCopies()));
            parser = ParserFactory.createParser((IScanner)scanner, (ISourceElementRequestor)this.elementRequestor, (ParserMode)ParserMode.COMPLETION_PARSE, (ParserLanguage)language, (IParserLogService)ParserUtil.getParserLogService());
            this.elementRequestor.setParser(parser);
        }
        catch (ParserFactoryError parserFactoryError) {
            return null;
        }
        if (parser == null) {
            return null;
        }
        IASTCompletionNode result = null;
        try {
            try {
                IPreferenceStore prefStore = CUIPlugin.getDefault().getPreferenceStore();
                int timeout = prefStore.getInt("content_assist_timeout_delay");
                if (timeout > 0) {
                    this.elementRequestor.setTimeout(timeout);
                }
                this.elementRequestor.startTimer();
                long parserTime = System.currentTimeMillis();
                this.macroMap = null;
                result = parser.parse(completionOffset);
                this.log("Time spent in Parser = " + (System.currentTimeMillis() - parserTime) + " ms");
                this.macroMap = scanner.getRealDefinitions();
            }
            catch (ParseError e) {
                if (e.getErrorKind() == ParseError.ParseErrorKind.TIMEOUT_OR_CANCELLED) {
                    this.log("Timeout received !!!!!! ");
                    this.requestor.acceptError(new Problem(CUIMessages.getString("CEditor.contentassist.timeout")));
                }
            }
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            this.elementRequestor.stopTimer();
            throw throwable;
        }
        {
            Object var17_19 = null;
            this.elementRequestor.stopTimer();
            return result;
        }
    }

    private void addNodeToCompletions(IASTNode node, String prefix, int totalNumberOfResults, boolean addStaticMethodsOnly, boolean addStaticFieldsOnly, int parameterIndex) {
        if (node instanceof IASTField) {
            IASTField field = (IASTField)node;
            if (addStaticFieldsOnly && !field.isStatic()) {
                return;
            }
            int relevance = this.computeRelevance(69, prefix, field.getName());
            this.requestor.acceptField(field.getName(), ASTUtil.getType((IASTAbstractDeclaration)field.getAbstractDeclaration()), field.getVisiblity(), this.completionStart, this.completionLength, relevance);
        } else if (node instanceof IASTParameterDeclaration) {
            IASTParameterDeclaration param = (IASTParameterDeclaration)node;
            int relevance = this.computeRelevance(76, prefix, param.getName());
            this.requestor.acceptLocalVariable(param.getName(), ASTUtil.getType((IASTAbstractDeclaration)param), this.completionStart, this.completionLength, relevance);
        } else if (node instanceof IASTVariable) {
            IASTVariable variable = (IASTVariable)node;
            IASTScope container = variable.getOwnerScope();
            if (container instanceof IASTCodeScope) {
                int relevance = this.computeRelevance(76, prefix, variable.getName());
                this.requestor.acceptLocalVariable(variable.getName(), ASTUtil.getType((IASTAbstractDeclaration)variable.getAbstractDeclaration()), this.completionStart, this.completionLength, relevance);
            } else {
                if (addStaticFieldsOnly && !variable.isStatic()) {
                    return;
                }
                int relevance = this.computeRelevance(74, prefix, variable.getName());
                this.requestor.acceptVariable(variable.getName(), ASTUtil.getType((IASTAbstractDeclaration)variable.getAbstractDeclaration()), this.completionStart, this.completionLength, relevance);
            }
        } else if (node instanceof IASTMethod) {
            IASTMethod method = (IASTMethod)node;
            if (addStaticMethodsOnly && !method.isStatic()) {
                return;
            }
            int relevance = this.computeRelevance(67, prefix, method.getName());
            String parameterString = ASTUtil.getParametersString((String[])ASTUtil.getFunctionParameterTypes((IASTFunction)method));
            int contextInfoOffset = this.completionOrigin;
            if (parameterIndex > -1 && parameterString.length() > 0) {
                int idx = 0;
                int i = 0;
                while (i < parameterIndex) {
                    idx = parameterString.indexOf(44, idx);
                    ++i;
                }
                contextInfoOffset -= idx;
            }
            this.requestor.acceptMethod(method.getName(), parameterString, ASTUtil.getType((IASTAbstractDeclaration)method.getReturnType()), method.getVisiblity(), this.completionStart, this.completionLength, relevance, parameterIndex == -1, contextInfoOffset);
        } else if (node instanceof IASTFunction) {
            IASTFunction function = (IASTFunction)node;
            if (addStaticMethodsOnly && !function.isStatic()) {
                return;
            }
            int relevance = this.computeRelevance(71, prefix, function.getName());
            String parameterString = ASTUtil.getParametersString((String[])ASTUtil.getFunctionParameterTypes((IASTFunction)function));
            int contextInfoOffset = this.completionOrigin;
            if (parameterIndex > -1 && parameterString.length() > 0) {
                int idx = 0;
                int i = 0;
                while (i < parameterIndex) {
                    idx = parameterString.indexOf(44, idx);
                    ++i;
                }
                contextInfoOffset -= idx;
            }
            this.requestor.acceptFunction(function.getName(), parameterString, ASTUtil.getType((IASTAbstractDeclaration)function.getReturnType()), this.completionStart, this.completionLength, relevance, parameterIndex == -1, contextInfoOffset);
        } else if (node instanceof IASTClassSpecifier) {
            int relevance;
            IASTClassSpecifier classSpecifier = (IASTClassSpecifier)node;
            ASTClassKind classkind = classSpecifier.getClassKind();
            if (classkind == ASTClassKind.CLASS) {
                relevance = this.computeRelevance(64, prefix, classSpecifier.getName());
                this.requestor.acceptClass(classSpecifier.getName(), this.completionStart, this.completionLength, relevance);
            }
            if (classkind == ASTClassKind.STRUCT && classSpecifier.getName().length() > 0) {
                relevance = this.computeRelevance(65, prefix, classSpecifier.getName());
                this.requestor.acceptStruct(classSpecifier.getName(), this.completionStart, this.completionLength, relevance);
            }
            if (classkind == ASTClassKind.UNION && classSpecifier.getName().length() > 0) {
                relevance = this.computeRelevance(66, prefix, classSpecifier.getName());
                this.requestor.acceptUnion(classSpecifier.getName(), this.completionStart, this.completionLength, relevance);
            }
        } else if (node instanceof IASTNamespaceDefinition) {
            IASTNamespaceDefinition namespace = (IASTNamespaceDefinition)node;
            int relevance = this.computeRelevance(61, prefix, namespace.getName());
            this.requestor.acceptNamespace(namespace.getName(), this.completionStart, this.completionLength, relevance);
        } else if (node instanceof IASTEnumerationSpecifier) {
            IASTEnumerationSpecifier enumeration = (IASTEnumerationSpecifier)node;
            if (enumeration.getName().length() > 0) {
                int relevance = this.computeRelevance(63, prefix, enumeration.getName());
                this.requestor.acceptEnumeration(enumeration.getName(), this.completionStart, this.completionLength, relevance);
            }
        } else if (node instanceof IASTEnumerator) {
            IASTEnumerator enumerator = (IASTEnumerator)node;
            int relevance = this.computeRelevance(79, prefix, enumerator.getName());
            this.requestor.acceptEnumerator(enumerator.getName(), this.completionStart, this.completionLength, relevance);
        } else if (node instanceof IASTTypedefDeclaration) {
            IASTTypedefDeclaration typedef = (IASTTypedefDeclaration)node;
            int relevance = this.computeRelevance(78, prefix, typedef.getName());
            this.requestor.acceptTypedef(typedef.getName(), this.completionStart, this.completionLength, relevance);
        } else if (node instanceof IASTElaboratedTypeSpecifier) {
            IASTElaboratedTypeSpecifier elaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)node;
            ASTClassKind classkind = elaboratedTypeSpecifier.getClassKind();
            if (classkind == ASTClassKind.CLASS) {
                int relevance = this.computeRelevance(64, prefix, elaboratedTypeSpecifier.getName());
                this.requestor.acceptClass(elaboratedTypeSpecifier.getName(), this.completionStart, this.completionLength, relevance);
            } else if (classkind == ASTClassKind.STRUCT) {
                int relevance = this.computeRelevance(65, prefix, elaboratedTypeSpecifier.getName());
                this.requestor.acceptStruct(elaboratedTypeSpecifier.getName(), this.completionStart, this.completionLength, relevance);
            } else if (classkind == ASTClassKind.UNION) {
                int relevance = this.computeRelevance(66, prefix, elaboratedTypeSpecifier.getName());
                this.requestor.acceptUnion(elaboratedTypeSpecifier.getName(), this.completionStart, this.completionLength, relevance);
            } else if (classkind == ASTClassKind.ENUM) {
                int relevance = this.computeRelevance(63, prefix, elaboratedTypeSpecifier.getName());
                this.requestor.acceptEnumeration(elaboratedTypeSpecifier.getName(), this.completionStart, this.completionLength, relevance);
            }
        }
    }

    private void addKeywordToCompletions(String keyword) {
        int relevance = 10;
        this.requestor.acceptKeyword(keyword, this.completionStart, this.completionLength, relevance);
    }

    private void addKeywordsToCompletions(Iterator keywords) {
        int numOfKeywords = 0;
        while (keywords.hasNext()) {
            String keyword = (String)keywords.next();
            this.addKeywordToCompletions(keyword);
            ++numOfKeywords;
        }
        this.log("No of Keywords       = " + numOfKeywords);
    }

    private void addMacroToCompletions(String prefix, String macroName) {
        int relevance = this.computeRelevance(77, prefix, macroName);
        this.requestor.acceptMacro(macroName, this.completionStart, this.completionLength, relevance, this.completionOrigin);
    }

    private void addMacrosToCompletions(String prefix, Iterator macros) {
        int numOfMacros = 0;
        while (macros.hasNext()) {
            String macro = (String)macros.next();
            this.addMacroToCompletions(prefix, macro);
            ++numOfMacros;
        }
        this.log("No of Macros         = " + numOfMacros);
    }

    private void addToCompletions(IASTNode.ILookupResult result) {
        this.addToCompletions(result, false, false, -1);
    }

    private void addToCompletions(IASTNode.ILookupResult result, boolean addStaticMethodsOnly, boolean addStaticFieldsOnly, int paramIndex) {
        if (result == null) {
            this.log("Lookup Results       = null ................. !!! No Lookup Results found !!! ");
            return;
        }
        Iterator nodes = result.getNodes();
        int numberOfElements = result.getResultsSize();
        this.log("No of Lookup Results = " + numberOfElements);
        while (nodes.hasNext()) {
            IASTNode node = (IASTNode)nodes.next();
            this.addNodeToCompletions(node, result.getPrefix(), numberOfElements, addStaticMethodsOnly, addStaticFieldsOnly, paramIndex);
        }
    }

    private IASTNode.ILookupResult lookup(IASTScope searchNode, String prefix, IASTNode.LookupKind[] kinds, IASTNode context, IASTExpression expression) {
        try {
            this.logLookups(kinds);
            IASTNode.ILookupResult result = searchNode.lookup(prefix, kinds, context, expression);
            return result;
        }
        catch (IASTNode.LookupError ilk) {
            ilk.printStackTrace();
            return null;
        }
        catch (ASTNotImplementedException e) {
            e.printStackTrace();
            return null;
        }
    }

    private List lookupMacros(String prefix) {
        char[] prefixArray = prefix.toCharArray();
        int length = prefix.length();
        ArrayList<String> resultSet = new ArrayList<String>();
        int i = 0;
        while (i < this.macroMap.size()) {
            char[] key = this.macroMap.keyAt(i);
            if (key.length >= length && CharArrayUtils.equals((char[])key, (int)0, (int)length, (char[])prefixArray, (boolean)true)) {
                IMacro macro = (IMacro)this.macroMap.getAt(i);
                resultSet.add(String.valueOf(macro.getSignature()));
            }
            ++i;
        }
        return resultSet;
    }

    private void completionOnMemberReference(IASTCompletionNode completionNode) {
        IASTScope searchNode = completionNode.getCompletionScope();
        IASTNode.ILookupResult result = null;
        IASTNode.LookupKind[] kinds = new IASTNode.LookupKind[]{IASTNode.LookupKind.FIELDS, IASTNode.LookupKind.METHODS, IASTNode.LookupKind.ENUMERATORS};
        result = this.lookup(searchNode, completionNode.getCompletionPrefix(), kinds, completionNode.getCompletionContext(), null);
        this.addToCompletions(result);
    }

    private void completionOnScopedReference(IASTCompletionNode completionNode) {
        IASTScope searchNode = completionNode.getCompletionScope();
        IASTNode.LookupKind[] kinds = new IASTNode.LookupKind[]{IASTNode.LookupKind.ALL};
        IASTNode.ILookupResult result = this.lookup(searchNode, completionNode.getCompletionPrefix(), kinds, completionNode.getCompletionContext(), null);
        if (completionNode.getCompletionContext() != null && completionNode.getCompletionContext() instanceof IASTClassSpecifier && ((IASTClassSpecifier)completionNode.getCompletionContext()).getClassKind() != ASTClassKind.ENUM) {
            if (completionNode.getCompletionScope() instanceof IASTCodeScope) {
                this.addToCompletions(result, true, true, -1);
            } else {
                this.addToCompletions(result, false, true, -1);
            }
        } else {
            this.addToCompletions(result);
        }
    }

    private void completionOnTypeReference(IASTCompletionNode completionNode) {
        IASTScope searchNode = completionNode.getCompletionScope();
        if (completionNode.getCompletionPrefix().length() > 0 || completionNode.getCompletionContext() != null) {
            IASTNode.LookupKind[] kinds = new IASTNode.LookupKind[]{IASTNode.LookupKind.STRUCTURES, IASTNode.LookupKind.ENUMERATIONS, IASTNode.LookupKind.NAMESPACES, IASTNode.LookupKind.TYPEDEFS};
            IASTNode.ILookupResult result = this.lookup(searchNode, completionNode.getCompletionPrefix(), kinds, completionNode.getCompletionContext(), null);
            this.addToCompletions(result);
        }
    }

    private void completionOnFieldType(IASTCompletionNode completionNode) {
        IASTClassSpecifier classSpec;
        this.completionOnTypeReference(completionNode);
        IASTScope searchNode = completionNode.getCompletionScope();
        if (completionNode.getCompletionPrefix().length() == 0 && searchNode instanceof IASTClassSpecifier && (classSpec = (IASTClassSpecifier)searchNode).getClassKind() == ASTClassKind.CLASS) {
            IASTNode.ILookupResult result = null;
            IASTNode.LookupKind[] kinds = new IASTNode.LookupKind[]{IASTNode.LookupKind.STRUCTURES};
            result = this.lookup(searchNode, classSpec.getName(), kinds, completionNode.getCompletionContext(), null);
            this.addToCompletions(result);
        }
    }

    private void completionOnVariableType(IASTCompletionNode completionNode) {
        IASTNode.LookupKind[] kinds = new IASTNode.LookupKind[]{IASTNode.LookupKind.STRUCTURES, IASTNode.LookupKind.ENUMERATIONS, IASTNode.LookupKind.NAMESPACES, IASTNode.LookupKind.TYPEDEFS, IASTNode.LookupKind.CONSTRUCTORS};
        IASTNode.ILookupResult result = this.lookup(completionNode.getCompletionScope(), completionNode.getCompletionPrefix(), kinds, completionNode.getCompletionContext(), null);
        this.addToCompletions(result);
    }

    private void completionOnSingleNameReference(IASTCompletionNode completionNode) {
        IASTNode.LookupKind[] kinds;
        IASTScope searchNode = completionNode.getCompletionScope();
        String prefix = completionNode.getCompletionPrefix();
        IASTNode.ILookupResult result = null;
        if (completionNode.getCompletionPrefix().length() > 0) {
            kinds = new IASTNode.LookupKind[]{IASTNode.LookupKind.ALL};
            result = this.lookup(searchNode, prefix, kinds, completionNode.getCompletionContext(), null);
            this.addToCompletions(result);
        } else if (searchNode instanceof IASTCodeScope) {
            if (((IASTCodeScope)searchNode).getContainingFunction() instanceof IASTMethod) {
                kinds = new IASTNode.LookupKind[]{IASTNode.LookupKind.THIS};
                result = this.lookup(searchNode, completionNode.getCompletionPrefix(), kinds, completionNode.getCompletionContext(), null);
                this.addToCompletions(result);
                kinds = new IASTNode.LookupKind[]{IASTNode.LookupKind.LOCAL_VARIABLES};
                result = this.lookup(searchNode, completionNode.getCompletionPrefix(), kinds, completionNode.getCompletionContext(), null);
                this.addToCompletions(result);
            } else {
                kinds = new IASTNode.LookupKind[]{IASTNode.LookupKind.LOCAL_VARIABLES};
                result = this.lookup(searchNode, completionNode.getCompletionPrefix(), kinds, completionNode.getCompletionContext(), null);
                this.addToCompletions(result);
            }
        } else {
            kinds = new IASTNode.LookupKind[]{IASTNode.LookupKind.ALL};
            result = this.lookup(searchNode, completionNode.getCompletionPrefix(), kinds, completionNode.getCompletionContext(), null);
            this.addToCompletions(result);
        }
        List macros = this.lookupMacros(completionNode.getCompletionPrefix());
        this.addMacrosToCompletions(prefix, macros.iterator());
    }

    private void completionOnClassReference(IASTCompletionNode completionNode) {
        IASTScope searchNode = completionNode.getCompletionScope();
        IASTNode.LookupKind[] kinds = new IASTNode.LookupKind[]{IASTNode.LookupKind.CLASSES};
        IASTNode.ILookupResult result = this.lookup(searchNode, completionNode.getCompletionPrefix(), kinds, completionNode.getCompletionContext(), null);
        this.addToCompletions(result);
    }

    private void completionOnStructReference(IASTCompletionNode completionNode) {
        IASTScope searchNode = completionNode.getCompletionScope();
        IASTNode.LookupKind[] kinds = new IASTNode.LookupKind[]{IASTNode.LookupKind.STRUCTS};
        IASTNode.ILookupResult result = this.lookup(searchNode, completionNode.getCompletionPrefix(), kinds, completionNode.getCompletionContext(), null);
        this.addToCompletions(result);
    }

    private void completionOnUnionReference(IASTCompletionNode completionNode) {
        IASTScope searchNode = completionNode.getCompletionScope();
        IASTNode.LookupKind[] kinds = new IASTNode.LookupKind[]{IASTNode.LookupKind.UNIONS};
        IASTNode.ILookupResult result = this.lookup(searchNode, completionNode.getCompletionPrefix(), kinds, completionNode.getCompletionContext(), null);
        this.addToCompletions(result);
    }

    private void completionOnEnumReference(IASTCompletionNode completionNode) {
        IASTScope searchNode = completionNode.getCompletionScope();
        IASTNode.LookupKind[] kinds = new IASTNode.LookupKind[]{IASTNode.LookupKind.ENUMERATIONS};
        IASTNode.ILookupResult result = this.lookup(searchNode, completionNode.getCompletionPrefix(), kinds, completionNode.getCompletionContext(), null);
        this.addToCompletions(result);
    }

    private void completionOnNamespaceReference(IASTCompletionNode completionNode) {
        IASTScope searchNode = completionNode.getCompletionScope();
        IASTNode.LookupKind[] kinds = new IASTNode.LookupKind[]{IASTNode.LookupKind.NAMESPACES};
        IASTNode.ILookupResult result = this.lookup(searchNode, completionNode.getCompletionPrefix(), kinds, completionNode.getCompletionContext(), null);
        this.addToCompletions(result);
    }

    private void completionOnExceptionReference(IASTCompletionNode completionNode) {
        this.completionOnTypeReference(completionNode);
        if (completionNode.getCompletionPrefix().length() == 0) {
            this.addKeywordToCompletions(exceptionKeyword);
        }
    }

    private void completionOnMacroReference(IASTCompletionNode completionNode) {
        List result = this.lookupMacros(completionNode.getCompletionPrefix());
        this.addMacrosToCompletions(completionNode.getCompletionPrefix(), result.iterator());
    }

    private void completionOnNewTypeReference(IASTCompletionNode completionNode) {
        this.completionOnTypeReference(completionNode);
    }

    private void completionOnFunctionReference(IASTCompletionNode completionNode, IASTCompletionNode.CompletionKind kind) {
        IASTNode.ILookupResult result;
        IASTNode context = completionNode.getCompletionContext();
        IASTScope scope = completionNode.getCompletionScope();
        String prefix = completionNode.getCompletionPrefix();
        boolean functionsOnly = false;
        IASTNode.LookupKind[] kinds = null;
        boolean statics = false;
        if (prefix.length() == 0 && !(context instanceof IASTClassSpecifier) && !(context instanceof IASTNamespaceDefinition)) {
            if (kind == IASTCompletionNode.CompletionKind.CONSTRUCTOR_REFERENCE) {
                kinds = new IASTNode.LookupKind[]{IASTNode.LookupKind.STRUCTURES};
                result = this.lookup(scope, completionNode.getFunctionName(), kinds, null, null);
                if (result != null && result.getResultsSize() == 1) {
                    scope = (IASTScope)result.getNodes().next();
                }
                kinds[0] = IASTNode.LookupKind.CONSTRUCTORS;
            } else {
                kinds = new IASTNode.LookupKind[]{IASTNode.LookupKind.CONSTRUCTORS, IASTNode.LookupKind.FUNCTIONS, IASTNode.LookupKind.METHODS};
            }
            prefix = completionNode.getFunctionName();
            functionsOnly = true;
        } else if (context != null) {
            kinds = new IASTNode.LookupKind[]{IASTNode.LookupKind.STRUCTURES, IASTNode.LookupKind.NAMESPACES, IASTNode.LookupKind.ENUMERATORS, IASTNode.LookupKind.MEMBERS};
            statics = true;
        } else {
            kinds = new IASTNode.LookupKind[]{IASTNode.LookupKind.STRUCTURES, IASTNode.LookupKind.NAMESPACES, IASTNode.LookupKind.ENUMERATORS, IASTNode.LookupKind.VARIABLES, IASTNode.LookupKind.LOCAL_VARIABLES, IASTNode.LookupKind.MEMBERS, IASTNode.LookupKind.FUNCTIONS};
        }
        result = this.lookup(scope, prefix, kinds, context, completionNode.getFunctionParameters());
        if (result != null) {
            this.addToCompletions(result, statics, statics, functionsOnly ? result.getIndexOfNextParameter() : -1);
        }
        if (!functionsOnly && context == null) {
            List macros = this.lookupMacros(completionNode.getCompletionPrefix());
            this.addMacrosToCompletions(prefix, macros.iterator());
        }
    }

    public IASTCompletionNode complete(IWorkingCopy sourceUnit, int completionOffset) {
        this.log("");
        long startTime = System.currentTimeMillis();
        IASTCompletionNode completionNode = this.parse(sourceUnit, completionOffset);
        if (completionNode == null) {
            this.log("Null Completion Node Error");
            return null;
        }
        this.log("Offset  = " + completionOffset);
        this.logNode("Scope   = ", (IASTNode)completionNode.getCompletionScope());
        this.logNode("Context = ", completionNode.getCompletionContext());
        this.logKind("Kind    = ", completionNode.getCompletionKind());
        this.log("Prefix  = " + completionNode.getCompletionPrefix());
        if (completionNode.getCompletionScope() == null) {
            this.log("Null Completion Scope Error");
            return null;
        }
        if (completionNode.getCompletionKind() == IASTCompletionNode.CompletionKind.NO_SUCH_KIND) {
            this.log("Invalid Completion Kind Error");
            return null;
        }
        this.completionOrigin = completionOffset;
        this.completionStart = completionOffset - completionNode.getCompletionPrefix().length();
        this.completionLength = completionNode.getCompletionPrefix().length();
        IASTCompletionNode.CompletionKind kind = completionNode.getCompletionKind();
        if (kind == IASTCompletionNode.CompletionKind.MEMBER_REFERENCE) {
            this.completionOnMemberReference(completionNode);
        } else if (kind == IASTCompletionNode.CompletionKind.FIELD_TYPE) {
            if (completionNode.getCompletionContext() == null) {
                this.completionOnFieldType(completionNode);
            } else {
                this.completionOnScopedReference(completionNode);
            }
        } else if (kind == IASTCompletionNode.CompletionKind.VARIABLE_TYPE) {
            if (completionNode.getCompletionContext() != null) {
                this.completionOnVariableType(completionNode);
            } else {
                this.completionOnTypeReference(completionNode);
            }
        } else if (kind == IASTCompletionNode.CompletionKind.ARGUMENT_TYPE) {
            this.completionOnTypeReference(completionNode);
        } else if (kind == IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE) {
            if (completionNode.getCompletionContext() == null) {
                this.completionOnSingleNameReference(completionNode);
            } else {
                this.completionOnScopedReference(completionNode);
            }
        } else if (kind == IASTCompletionNode.CompletionKind.TYPE_REFERENCE) {
            this.completionOnTypeReference(completionNode);
        } else if (kind == IASTCompletionNode.CompletionKind.CLASS_REFERENCE) {
            this.completionOnClassReference(completionNode);
        } else if (kind == IASTCompletionNode.CompletionKind.NAMESPACE_REFERENCE) {
            this.completionOnNamespaceReference(completionNode);
        } else if (kind == IASTCompletionNode.CompletionKind.EXCEPTION_REFERENCE) {
            this.completionOnExceptionReference(completionNode);
        } else if (kind == IASTCompletionNode.CompletionKind.MACRO_REFERENCE) {
            this.completionOnMacroReference(completionNode);
        } else if (kind == IASTCompletionNode.CompletionKind.NEW_TYPE_REFERENCE) {
            this.completionOnNewTypeReference(completionNode);
        } else if (kind == IASTCompletionNode.CompletionKind.FUNCTION_REFERENCE || kind == IASTCompletionNode.CompletionKind.CONSTRUCTOR_REFERENCE) {
            this.completionOnFunctionReference(completionNode, kind);
        } else if (kind == IASTCompletionNode.CompletionKind.STRUCT_REFERENCE) {
            this.completionOnStructReference(completionNode);
        } else if (kind == IASTCompletionNode.CompletionKind.UNION_REFERENCE) {
            this.completionOnUnionReference(completionNode);
        } else if (kind == IASTCompletionNode.CompletionKind.ENUM_REFERENCE) {
            this.completionOnEnumReference(completionNode);
        }
        if (kind != IASTCompletionNode.CompletionKind.MEMBER_REFERENCE) {
            this.addKeywordsToCompletions(completionNode.getKeywords());
        }
        this.log("Time spent in Completion Engine = " + (System.currentTimeMillis() - startTime) + " ms");
        return completionNode;
    }

    private void logKind(String message, IASTCompletionNode.CompletionKind kind) {
        if (!CUIPlugin.getDefault().isDebugging() && Util.isActive(IDebugLogConstants.CONTENTASSIST)) {
            return;
        }
        String kindStr = "";
        if (kind == IASTCompletionNode.CompletionKind.MEMBER_REFERENCE) {
            kindStr = "MEMBER_REFERENCE";
        } else if (kind == IASTCompletionNode.CompletionKind.FIELD_TYPE) {
            kindStr = "FIELD_TYPE Class Scope";
        } else if (kind == IASTCompletionNode.CompletionKind.VARIABLE_TYPE) {
            kindStr = "VARIABLE_TYPE Global Scope";
        } else if (kind == IASTCompletionNode.CompletionKind.ARGUMENT_TYPE) {
            kindStr = "ARGUMENT_TYPE";
        } else if (kind == IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE) {
            kindStr = "SINGLE_NAME_REFERENCE";
        } else if (kind == IASTCompletionNode.CompletionKind.TYPE_REFERENCE) {
            kindStr = "TYPE_REFERENCE";
        } else if (kind == IASTCompletionNode.CompletionKind.CLASS_REFERENCE) {
            kindStr = "CLASS_REFERENCE";
        } else if (kind == IASTCompletionNode.CompletionKind.NAMESPACE_REFERENCE) {
            kindStr = "NAMESPACE_REFERENCE";
        } else if (kind == IASTCompletionNode.CompletionKind.EXCEPTION_REFERENCE) {
            kindStr = "EXCEPTION_REFERENCE";
        } else if (kind == IASTCompletionNode.CompletionKind.MACRO_REFERENCE) {
            kindStr = "MACRO_REFERENCE";
        } else if (kind == IASTCompletionNode.CompletionKind.CONSTRUCTOR_REFERENCE) {
            kindStr = "CONSTRUCTOR_REFERENCE";
        } else if (kind == IASTCompletionNode.CompletionKind.NEW_TYPE_REFERENCE) {
            kindStr = "NEW_TYPE_REFERENCE";
        } else if (kind == IASTCompletionNode.CompletionKind.PREPROCESSOR_DIRECTIVE) {
            kindStr = "PREPROCESSOR_DIRECTIVE";
        } else if (kind == IASTCompletionNode.CompletionKind.STRUCT_REFERENCE) {
            kindStr = "STRUCT_REFERENCE";
        } else if (kind == IASTCompletionNode.CompletionKind.UNION_REFERENCE) {
            kindStr = "UNION_REFERENCE";
        } else if (kind == IASTCompletionNode.CompletionKind.ENUM_REFERENCE) {
            kindStr = "ENUM_REFERENCE";
        } else if (kind == IASTCompletionNode.CompletionKind.NO_SUCH_KIND) {
            kindStr = "NO_SUCH_KIND";
        }
        this.log(String.valueOf(message) + kindStr);
    }

    private void logNode(String message, IASTNode node) {
        if (!CUIPlugin.getDefault().isDebugging() && Util.isActive(IDebugLogConstants.CONTENTASSIST)) {
            return;
        }
        if (node == null) {
            this.log(String.valueOf(message) + "null");
            return;
        }
        if (node instanceof IASTMethod) {
            String name = "Method: ";
            name = String.valueOf(name) + ((IASTMethod)node).getName();
            this.log(String.valueOf(message) + name);
            return;
        }
        if (node instanceof IASTFunction) {
            String name = "Function: ";
            name = String.valueOf(name) + ((IASTFunction)node).getName();
            this.log(String.valueOf(message) + name);
            return;
        }
        if (node instanceof IASTClassSpecifier) {
            String name = "Class: ";
            name = String.valueOf(name) + ((IASTClassSpecifier)node).getName();
            this.log(String.valueOf(message) + name);
            return;
        }
        if (node instanceof IASTCompilationUnit) {
            String name = "Global";
            this.log(String.valueOf(message) + name);
            return;
        }
        if (node instanceof IASTCodeScope) {
            String name = "Code Scope";
            this.log(String.valueOf(message) + name);
            return;
        }
        if (node instanceof IASTNamespaceDefinition) {
            String name = "Namespace ";
            this.log(String.valueOf(message) + name);
            return;
        }
        this.log(String.valueOf(message) + node.toString());
    }

    private void logLookups(IASTNode.LookupKind[] kinds) {
        if (!CUIPlugin.getDefault().isDebugging() && Util.isActive(IDebugLogConstants.CONTENTASSIST)) {
            return;
        }
        StringBuffer kindName = new StringBuffer("Looking For ");
        int i = 0;
        while (i < kinds.length) {
            IASTNode.LookupKind kind = kinds[i];
            if (kind == IASTNode.LookupKind.ALL) {
                kindName.append("ALL");
            } else if (kind == IASTNode.LookupKind.STRUCTURES) {
                kindName.append("STRUCTURES");
            } else if (kind == IASTNode.LookupKind.STRUCTS) {
                kindName.append("STRUCTS");
            } else if (kind == IASTNode.LookupKind.UNIONS) {
                kindName.append("UNIONS");
            } else if (kind == IASTNode.LookupKind.CLASSES) {
                kindName.append("CLASSES");
            } else if (kind == IASTNode.LookupKind.FUNCTIONS) {
                kindName.append("FUNCTIONS");
            } else if (kind == IASTNode.LookupKind.VARIABLES) {
                kindName.append("VARIABLES");
            } else if (kind == IASTNode.LookupKind.LOCAL_VARIABLES) {
                kindName.append("LOCAL_VARIABLES");
            } else if (kind == IASTNode.LookupKind.MEMBERS) {
                kindName.append("MEMBERS");
            } else if (kind == IASTNode.LookupKind.METHODS) {
                kindName.append("METHODS");
            } else if (kind == IASTNode.LookupKind.FIELDS) {
                kindName.append("FIELDS");
            } else if (kind == IASTNode.LookupKind.CONSTRUCTORS) {
                kindName.append("CONSTRUCTORS");
            } else if (kind == IASTNode.LookupKind.NAMESPACES) {
                kindName.append("NAMESPACES");
            } else if (kind == IASTNode.LookupKind.ENUMERATIONS) {
                kindName.append("ENUMERATIONS");
            } else if (kind == IASTNode.LookupKind.ENUMERATORS) {
                kindName.append("ENUMERATORS");
            } else if (kind == IASTNode.LookupKind.THIS) {
                kindName.append("THIS");
            } else if (kind == IASTNode.LookupKind.TYPEDEFS) {
                kindName.append("TYPEDEFS");
            }
            kindName.append(", ");
            ++i;
        }
        this.log(kindName.toString());
    }

    private void log(String message) {
        if (!CUIPlugin.getDefault().isDebugging() && Util.isActive(IDebugLogConstants.CONTENTASSIST)) {
            return;
        }
        Util.debugLog(message, IDebugLogConstants.CONTENTASSIST);
    }
}

