/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildSettingsPage;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildToolsSettingsStore;
import org.eclipse.cdt.managedbuilder.ui.properties.MultiLineTextFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.graphics.Point;

public class BuildToolSettingsPage
extends BuildSettingsPage {
    private static final String ALL_OPTIONS = ManagedBuilderUIMessages.getResourceString("BuildToolSettingsPage.alloptions");
    private static final String COMMAND = "FieldEditors.tool.command";
    private static final String DEFAULT_SEPERATOR = ";";
    private static final String WHITESPACE = " ";
    private MultiLineTextFieldEditor allOptionFieldEditor;
    private String allOptionsId = "";
    private Vector defaultOptionNames;
    private HashMap stringOptionsMap;
    private ITool tool;
    private HashMap userObjsMap;
    private boolean isItResourceConfigPage;

    public BuildToolSettingsPage(IConfiguration configuration, ITool tool) {
        super(configuration);
        this.tool = tool;
        this.allOptionsId = String.valueOf(tool.getId()) + ".allOptions";
        this.stringOptionsMap = new HashMap();
        this.userObjsMap = new HashMap();
        this.isItResourceConfigPage = false;
    }

    public BuildToolSettingsPage(IResourceConfiguration resConfig, ITool tool) {
        super(resConfig);
        this.tool = tool;
        this.allOptionsId = String.valueOf(tool.getId()) + ".allOptions";
        this.stringOptionsMap = new HashMap();
        this.userObjsMap = new HashMap();
        this.isItResourceConfigPage = true;
    }

    public Point computeSize() {
        return super.computeSize();
    }

    protected void createFieldEditors() {
        super.createFieldEditors();
        StringFieldEditor stringField = new StringFieldEditor(this.tool.getId(), ManagedBuilderUIMessages.getResourceString(COMMAND), this.getFieldEditorParent());
        stringField.setEmptyStringAllowed(false);
        this.addField((FieldEditor)stringField);
        this.allOptionFieldEditor = new MultiLineTextFieldEditor(this.allOptionsId, ALL_OPTIONS, this.getFieldEditorParent());
        this.allOptionFieldEditor.getTextControl().setEditable(false);
        this.getToolSettingsPreferenceStore().setValue(this.allOptionsId, "");
        this.addField(this.allOptionFieldEditor);
    }

    private String createList(String[] items) {
        StringBuffer path = new StringBuffer("");
        int i = 0;
        while (i < items.length) {
            path.append(items[i]);
            if (i < items.length - 1) {
                path.append(DEFAULT_SEPERATOR);
            }
            ++i;
        }
        return path.toString();
    }

    private Vector getDefaultOptionNames() {
        if (this.defaultOptionNames == null) {
            this.defaultOptionNames = new Vector();
            this.defaultOptionNames.add("Other flags");
            this.defaultOptionNames.add("Linker flags");
            this.defaultOptionNames.add("Archiver flags");
            this.defaultOptionNames.add("Assembler flags");
        }
        return this.defaultOptionNames;
    }

    private Vector getOptionVector(String rawOptionString) {
        Vector<String> tokens = new Vector<String>(Arrays.asList(rawOptionString.split("\\s")));
        Vector<String> output = new Vector<String>(tokens.size());
        Iterator<String> iter = tokens.iterator();
        while (iter.hasNext()) {
            String token = iter.next();
            int firstIndex = token.indexOf("\"");
            int lastIndex = token.lastIndexOf("\"");
            if (firstIndex != -1 && firstIndex == lastIndex) {
                while (iter.hasNext()) {
                    String nextToken = iter.next();
                    token = String.valueOf(token) + WHITESPACE + nextToken;
                    if (nextToken.indexOf("\"") != -1) break;
                }
            }
            output.add(token);
        }
        return output;
    }

    private String evaluateCommand(String command, String values) {
        if (command == null) {
            return values.trim();
        }
        if (command.indexOf("${") >= 0) {
            return command.replaceAll("\\$\\{[vV][aA][lL][uU][eE]\\}", values.trim()).trim();
        }
        return new String(String.valueOf(command) + values).trim();
    }

    private String getToolFlags() throws BuildException {
        StringBuffer buf = new StringBuffer();
        ArrayList<String> flags = new ArrayList<String>();
        IOption[] options = this.tool.getOptions();
        String listStr = "";
        String[] listVal = null;
        int k = 0;
        while (k < options.length) {
            IOption option = options[k];
            buf.setLength(0);
            switch (option.getValueType()) {
                case 0: {
                    String boolCmd = this.getToolSettingsPreferenceStore().getBoolean(option.getId()) ? option.getCommand() : option.getCommandFalse();
                    if (boolCmd == null || boolCmd.length() <= 0) break;
                    buf.append(boolCmd);
                    break;
                }
                case 1: {
                    String string;
                    String enumCommand = this.getToolSettingsPreferenceStore().getString(option.getId());
                    if (enumCommand.indexOf(DEFAULT_SEPERATOR) != -1) {
                        enumCommand = option.getSelectedEnum();
                    }
                    if ((string = option.getEnumCommand(enumCommand)).length() <= 0) break;
                    buf.append(string);
                    break;
                }
                case 2: {
                    String strCmd = option.getCommand();
                    String val = this.getToolSettingsPreferenceStore().getString(option.getId());
                    this.stringOptionsMap.put(option, val);
                    if (val.length() <= 0) break;
                    buf.append(this.evaluateCommand(strCmd, val));
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    String cmd = option.getCommand();
                    listStr = this.getToolSettingsPreferenceStore().getString(option.getId());
                    if (cmd == null) {
                        this.userObjsMap.put(option, listStr);
                    }
                    listVal = BuildToolsSettingsStore.parseString(listStr);
                    int j = 0;
                    while (j < listVal.length) {
                        String temp = listVal[j];
                        buf.append(String.valueOf(this.evaluateCommand(cmd, temp)) + WHITESPACE);
                        ++j;
                    }
                    break;
                }
            }
            if (buf.toString().trim().length() > 0) {
                flags.add(buf.toString().trim());
            }
            ++k;
        }
        String outputName = "temp";
        if (this.tool.getInputExtensions().get(0) != null) {
            outputName = String.valueOf(outputName) + this.tool.getInputExtensions().get(0);
        }
        String[] f = new String[flags.size()];
        IManagedCommandLineGenerator gen = this.tool.getCommandLineGenerator();
        IManagedCommandLineInfo info = gen.generateCommandLineInfo(this.tool, this.tool.getToolCommand(), flags.toArray(f), this.tool.getOutputFlag(), this.tool.getOutputPrefix(), outputName, new String[0], this.tool.getCommandLinePattern());
        return info.getFlags();
    }

    public boolean isForTool(ITool tool) {
        if (tool != null) {
            return tool.equals(this.tool);
        }
        return false;
    }

    public void parseAllOptions() {
        IOption opt;
        String alloptions = this.getToolSettingsPreferenceStore().getString(this.allOptionsId);
        ArrayList<String> optionsList = new ArrayList<String>();
        StringBuffer addnOptions = new StringBuffer();
        Vector optionsArr = this.getOptionVector(alloptions);
        Iterator optIter = optionsArr.iterator();
        while (optIter.hasNext()) {
            String optionValue = (String)optIter.next();
            boolean optionValueExist = false;
            IOption[] options = this.tool.getOptions();
            int k = 0;
            while (k < options.length) {
                opt = options[k];
                opt.getId();
                Iterator stringOptsIter = this.stringOptionsMap.values().iterator();
                while (stringOptsIter.hasNext()) {
                    if (((String)stringOptsIter.next()).indexOf(optionValue) == -1) continue;
                    optionValueExist = true;
                }
                Iterator userObjsIter = this.userObjsMap.values().iterator();
                while (userObjsIter.hasNext()) {
                    if (((String)userObjsIter.next()).indexOf(optionValue) == -1) continue;
                    optionValueExist = true;
                }
                if (!optionValueExist) {
                    try {
                        switch (opt.getValueType()) {
                            case 0: {
                                String boolCommand = opt.getCommand();
                                if (boolCommand != null && boolCommand.equals(optionValue)) {
                                    this.getToolSettingsPreferenceStore().setValue(opt.getId(), true);
                                    optionValueExist = true;
                                }
                                if ((boolCommand = opt.getCommandFalse()) != null && boolCommand.equals(optionValue)) {
                                    this.getToolSettingsPreferenceStore().setValue(opt.getId(), false);
                                    optionValueExist = true;
                                }
                                break;
                            }
                            case 1: {
                                String string = "";
                                String[] enumValues = opt.getApplicableValues();
                                int i = 0;
                                while (i < enumValues.length) {
                                    if (opt.getEnumCommand(enumValues[i]).equals(optionValue)) {
                                        string = enumValues[i];
                                        optionValueExist = true;
                                    }
                                    ++i;
                                }
                                if (!string.equals("")) {
                                    this.getToolSettingsPreferenceStore().setValue(opt.getId(), string);
                                }
                                break;
                            }
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: {
                                if (opt.getCommand() != null && optionValue.startsWith(opt.getCommand())) {
                                    optionsList.add(optionValue);
                                    optionValueExist = true;
                                }
                                break;
                            }
                        }
                    }
                    catch (BuildException buildException) {}
                }
                ++k;
            }
            if (optionValueExist) continue;
            addnOptions.append(String.valueOf(optionValue) + WHITESPACE);
        }
        Set set = this.stringOptionsMap.keySet();
        int s = 0;
        while (s < set.size()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                String val = (String)this.stringOptionsMap.get(key);
                if (alloptions.indexOf(val) != -1) continue;
                StringBuffer buf = new StringBuffer();
                String[] vals = val.split(WHITESPACE);
                int t = 0;
                while (t < vals.length) {
                    if (alloptions.indexOf(vals[t]) != -1) {
                        buf.append(String.valueOf(vals[t]) + WHITESPACE);
                    }
                    ++t;
                }
                this.getToolSettingsPreferenceStore().setValue(((IOption)key).getId(), buf.toString().trim());
            }
            ++s;
        }
        Set objSet = this.userObjsMap.keySet();
        int s2 = 0;
        while (s2 < objSet.size()) {
            Iterator iterator = objSet.iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                String val = (String)this.userObjsMap.get(key);
                ArrayList<String> list = new ArrayList<String>();
                String[] vals = BuildToolsSettingsStore.parseString(val);
                int t = 0;
                while (t < vals.length) {
                    if (alloptions.indexOf(vals[t]) != -1) {
                        list.add(vals[t]);
                    }
                    ++t;
                }
                String[] listArr = new String[list.size()];
                list.toArray(listArr);
                String liststr = BuildToolsSettingsStore.createList(listArr);
                this.getToolSettingsPreferenceStore().setValue(((IOption)key).getId(), liststr);
            }
            ++s2;
        }
        IOption[] options = this.tool.getOptions();
        int k = 0;
        while (k < options.length) {
            opt = options[k];
            opt.getId();
            try {
                switch (opt.getValueType()) {
                    case 0: {
                        ArrayList optsList = new ArrayList(optionsArr);
                        if (opt.getCommand() != null && opt.getCommand().length() > 0 && !optsList.contains(opt.getCommand())) {
                            this.getToolSettingsPreferenceStore().setValue(opt.getId(), false);
                        }
                        if (opt.getCommandFalse() != null && opt.getCommandFalse().length() > 0 && !optsList.contains(opt.getCommandFalse())) {
                            this.getToolSettingsPreferenceStore().setValue(opt.getId(), true);
                        }
                        break;
                    }
                    case 2: {
                        if (this.getDefaultOptionNames().contains(opt.getName())) {
                            String newOptions = this.getToolSettingsPreferenceStore().getString(opt.getId());
                            if (addnOptions.length() > 0) {
                                newOptions = String.valueOf(newOptions) + WHITESPACE + addnOptions.toString().trim();
                            }
                            this.getToolSettingsPreferenceStore().setValue(opt.getId(), newOptions);
                        }
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        ArrayList<String> newList = new ArrayList<String>();
                        int i = 0;
                        while (i < optionsList.size()) {
                            if (opt.getCommand() != null && ((String)optionsList.get(i)).startsWith(opt.getCommand())) {
                                newList.add(((String)optionsList.get(i)).substring(opt.getCommand().length()));
                            }
                            ++i;
                        }
                        String[] strlist = new String[newList.size()];
                        newList.toArray(strlist);
                        newList.clear();
                        this.getToolSettingsPreferenceStore().setValue(opt.getId(), BuildToolsSettingsStore.createList(strlist));
                        break;
                    }
                }
            }
            catch (BuildException buildException) {}
            ++k;
        }
    }

    public boolean performOk() {
        boolean result = super.performOk();
        IOptionCategory category = (IOptionCategory)this.tool;
        Object[][] options = this.isItResourceConfigPage ? category.getOptions(this.resConfig) : category.getOptions(this.configuration);
        if (options == null) {
            return true;
        }
        int i = 0;
        while (i < options.length) {
            ITool tool = (ITool)options[i][0];
            if (tool == null) break;
            IOption option = (IOption)options[i][1];
            try {
                switch (option.getValueType()) {
                    case 0: {
                        boolean boolVal = this.getToolSettingsPreferenceStore().getBoolean(option.getId());
                        IOption setOption = ManagedBuildManager.setOption((IConfiguration)this.configuration, (ITool)tool, (IOption)option, (boolean)boolVal);
                        if (setOption != option) {
                            this.getToolSettingsPreferenceStore().setValue(setOption.getId(), boolVal);
                        }
                        break;
                    }
                    case 1: {
                        String enumVal = this.getToolSettingsPreferenceStore().getString(option.getId());
                        String enumId = option.getEnumeratedId(enumVal);
                        IOption setOption = ManagedBuildManager.setOption((IConfiguration)this.configuration, (ITool)tool, (IOption)option, (String)(enumId != null && enumId.length() > 0 ? enumId : enumVal));
                        if (setOption != option) {
                            this.getToolSettingsPreferenceStore().setValue(setOption.getId(), enumVal);
                        }
                        break;
                    }
                    case 2: {
                        String strVal = this.getToolSettingsPreferenceStore().getString(option.getId());
                        IOption setOption = ManagedBuildManager.setOption((IConfiguration)this.configuration, (ITool)tool, (IOption)option, (String)strVal);
                        if (setOption != option) {
                            this.getToolSettingsPreferenceStore().setValue(setOption.getId(), strVal);
                        }
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        String listStr = this.getToolSettingsPreferenceStore().getString(option.getId());
                        String[] listVal = BuildToolsSettingsStore.parseString(listStr);
                        IOption setOption = ManagedBuildManager.setOption((IConfiguration)this.configuration, (ITool)tool, (IOption)option, (String[])listVal);
                        if (setOption != option) {
                            this.getToolSettingsPreferenceStore().setValue(setOption.getId(), listStr);
                        }
                        break;
                    }
                }
            }
            catch (BuildException buildException) {}
            ++i;
        }
        String command = this.getToolSettingsPreferenceStore().getString(this.tool.getId());
        if (command.length() > 0 && !command.equals(this.tool.getToolCommand())) {
            if (this.isItResourceConfigPage) {
                ManagedBuildManager.setToolCommand((IResourceConfiguration)this.resConfig, (ITool)this.tool, (String)command);
            } else {
                ManagedBuildManager.setToolCommand((IConfiguration)this.configuration, (ITool)this.tool, (String)command);
            }
        }
        return result;
    }

    public void storeSettings() {
        super.performOk();
    }

    public void updateAllOptionField() {
        try {
            if (this.getToolFlags() != null) {
                this.getToolSettingsPreferenceStore().setValue(this.allOptionsId, this.getToolFlags());
                this.allOptionFieldEditor.load();
            }
        }
        catch (BuildException buildException) {}
    }
}

