/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.model.IRunToAddress;
import org.eclipse.cdt.debug.core.model.IRunToLine;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyEditorInput;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyView;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class RunToLineAdapter
implements IRunToLineTarget {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) throws CoreException {
        String errorMessage = null;
        if (part instanceof ITextEditor) {
            IRunToLine runToLine;
            ITextEditor textEditor = (ITextEditor)part;
            IEditorInput input = textEditor.getEditorInput();
            if (input == null) {
                errorMessage = ActionMessages.getString("RunToLineAdapter.Empty_editor_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            }
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
            if (document == null) {
                errorMessage = ActionMessages.getString("RunToLineAdapter.Missing_document_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            }
            final String fileName = this.getFileName(input);
            ITextSelection textSelection = (ITextSelection)selection;
            final int lineNumber = textSelection.getStartLine() + 1;
            if (!(target instanceof IAdaptable)) return;
            IAdaptable iAdaptable = (IAdaptable)target;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IRunToLine");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((runToLine = (IRunToLine)iAdaptable.getAdapter((Class)clazz)) == null || !runToLine.canRunToLine(fileName, lineNumber)) return;
            Runnable r = new Runnable(){

                public void run() {
                    try {
                        runToLine.runToLine(fileName, lineNumber, DebugUIPlugin.getDefault().getPluginPreferences().getBoolean(IDebugUIConstants.PREF_SKIP_BREAKPOINTS_DURING_RUN_TO_LINE));
                    }
                    catch (DebugException e) {
                        RunToLineAdapter.this.failed(e);
                    }
                }
            };
            this.runInBackground(r);
            return;
        }
        if (part instanceof DisassemblyView) {
            IRunToAddress runToAddress;
            IEditorInput input = ((DisassemblyView)part).getInput();
            if (!(input instanceof DisassemblyEditorInput)) {
                errorMessage = ActionMessages.getString("RunToLineAdapter.Empty_editor_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            }
            ITextSelection textSelection = (ITextSelection)selection;
            int lineNumber = textSelection.getStartLine() + 1;
            final IAddress address = ((DisassemblyEditorInput)input).getAddress(lineNumber);
            if (!(target instanceof IAdaptable)) return;
            IAdaptable iAdaptable = (IAdaptable)target;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.debug.core.model.IRunToAddress");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((runToAddress = (IRunToAddress)iAdaptable.getAdapter((Class)clazz)) == null || !runToAddress.canRunToAddress(address)) return;
            Runnable r = new Runnable(){

                public void run() {
                    try {
                        runToAddress.runToAddress(address, DebugUIPlugin.getDefault().getPluginPreferences().getBoolean(IDebugUIConstants.PREF_SKIP_BREAKPOINTS_DURING_RUN_TO_LINE));
                    }
                    catch (DebugException e) {
                        RunToLineAdapter.this.failed(e);
                    }
                }
            };
            this.runInBackground(r);
            return;
        }
        errorMessage = ActionMessages.getString("RunToLineAdapter.Operation_is_not_supported_1");
        throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
    }

    public boolean canRunToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) {
        if (part instanceof DisassemblyView || part instanceof ITextEditor) {
            return target instanceof IDebugElement && ((IDebugElement)target).getModelIdentifier().equals(CDIDebugModel.getPluginIdentifier());
        }
        return false;
    }

    private String getFileName(IEditorInput input) throws CoreException {
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile().getName();
        }
        if (input instanceof IStorageEditorInput) {
            return ((IStorageEditorInput)input).getStorage().getName();
        }
        return null;
    }

    private void runInBackground(Runnable r) {
        DebugPlugin.getDefault().asyncExec(r);
    }

    protected void failed(Throwable e) {
        MultiStatus ms = new MultiStatus(CDIDebugModel.getPluginIdentifier(), 10002, ActionMessages.getString("RunToLineAdapter.0"), null);
        ms.add((IStatus)new Status(4, CDIDebugModel.getPluginIdentifier(), 10002, e.getMessage(), e));
        CDebugUtils.error((IStatus)ms, (Object)this);
    }
}

