/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.BinaryObjectAdapter;
import org.eclipse.core.runtime.IPath;

public class Symbol
implements IBinaryParser.ISymbol,
Comparable {
    protected final BinaryObjectAdapter binary;
    private final String name;
    private final IAddress addr;
    private final int type;
    private final long size;
    private final int startLine;
    private final int endLine;
    private final IPath sourceFile;

    public Symbol(BinaryObjectAdapter binary, String name, int type, IAddress addr, long size, IPath sourceFile, int startLine, int endLine) {
        this.binary = binary;
        this.name = name;
        this.type = type;
        this.addr = addr;
        this.size = size;
        this.startLine = startLine;
        this.endLine = endLine;
        this.sourceFile = sourceFile;
    }

    public Symbol(BinaryObjectAdapter binary, String name, int type, IAddress addr, long size) {
        this.binary = binary;
        this.name = name;
        this.type = type;
        this.addr = addr;
        this.size = size;
        this.startLine = -1;
        this.endLine = -1;
        this.sourceFile = null;
    }

    public IBinaryParser.IBinaryObject getBinaryObject() {
        return this.binary;
    }

    public IPath getFilename() {
        return this.sourceFile;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public IAddress getAddress() {
        return this.addr;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getLineNumber(long offset) {
        return -1;
    }

    public long getSize() {
        return this.size;
    }

    public int compareTo(Object obj) {
        IAddress thisVal = this.addr;
        IAddress anotherVal = null;
        if (obj instanceof Symbol) {
            anotherVal = ((Symbol)obj).addr;
        } else if (obj instanceof IAddress) {
            anotherVal = (IAddress)obj;
        }
        return thisVal.compareTo(anotherVal);
    }
}

