/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core;

import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExpression;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMemoryBlock;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.model.IFormattedMemoryBlock;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CFormattedMemoryBlock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;

public class CDebugModel {
    public static String getPluginIdentifier() {
        return CDebugCorePlugin.getUniqueIdentifier();
    }

    public static IDebugTarget newDebugTarget(ILaunch launch, ICDITarget cdiTarget, String name, IProcess debuggeeProcess, IProcess debuggerProcess, IFile file, boolean allowTerminate, boolean allowDisconnect, boolean stopInMain) throws CoreException {
        return CDIDebugModel.newDebugTarget(launch, cdiTarget, name, debuggeeProcess, debuggerProcess, file, allowTerminate, allowDisconnect, stopInMain);
    }

    public static IDebugTarget newAttachDebugTarget(ILaunch launch, ICDITarget cdiTarget, String name, IProcess debuggerProcess, IFile file) throws CoreException {
        return CDIDebugModel.newAttachDebugTarget(launch, cdiTarget, name, debuggerProcess, file);
    }

    public static IDebugTarget newCoreFileDebugTarget(ILaunch launch, ICDITarget cdiTarget, String name, IProcess debuggerProcess, IFile file) throws CoreException {
        return CDIDebugModel.newCoreFileDebugTarget(launch, cdiTarget, name, debuggerProcess, file);
    }

    public static IFormattedMemoryBlock createFormattedMemoryBlock(IDebugTarget target, String addressExpression, int format, int wordSize, int numberOfRows, int numberOfColumns, char paddingChar) throws DebugException {
        if (target != null && target instanceof CDebugTarget) {
            try {
                ICDIExpression expression = ((CDebugTarget)target).getCDITarget().createExpression(addressExpression);
                ICDIMemoryBlock cdiMemoryBlock = ((CDebugTarget)target).getCDITarget().createMemoryBlock(expression.getExpressionText(), wordSize * numberOfRows * numberOfColumns);
                return new CFormattedMemoryBlock((CDebugTarget)target, cdiMemoryBlock, expression, format, wordSize, numberOfRows, numberOfColumns, paddingChar);
            }
            catch (CDIException e) {
                throw new DebugException((IStatus)new Status(4, CDebugModel.getPluginIdentifier(), 5010, e.getDetailMessage(), null));
            }
        }
        return null;
    }

    public static IFormattedMemoryBlock createFormattedMemoryBlock(IDebugTarget target, String addressExpression, int format, int wordSize, int numberOfRows, int numberOfColumns) throws DebugException {
        if (target != null && target instanceof CDebugTarget) {
            try {
                ICDIExpression expression = ((CDebugTarget)target).getCDITarget().createExpression(addressExpression);
                ICDIMemoryBlock cdiMemoryBlock = ((CDebugTarget)target).getCDITarget().createMemoryBlock(expression.getExpressionText(), wordSize * numberOfRows * numberOfColumns);
                return new CFormattedMemoryBlock((CDebugTarget)target, cdiMemoryBlock, expression, format, wordSize, numberOfRows, numberOfColumns);
            }
            catch (CDIException e) {
                throw new DebugException((IStatus)new Status(4, CDebugModel.getPluginIdentifier(), 5010, e.getDetailMessage(), null));
            }
        }
        return null;
    }
}

