/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.cdt.core.parser.util.ObjectTable;

public class ObjectMap
extends ObjectTable {
    public static final ObjectMap EMPTY_MAP = new ObjectMap(0){

        public Object clone() {
            return this;
        }

        public List toList() {
            return Collections.EMPTY_LIST;
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }
    };
    private Object[] valueTable = new Object[this.capacity()];

    public ObjectMap(int initialSize) {
        super(initialSize);
    }

    public Object clone() {
        ObjectMap newMap = (ObjectMap)super.clone();
        newMap.valueTable = new Object[this.capacity()];
        System.arraycopy(this.valueTable, 0, newMap.valueTable, 0, this.valueTable.length);
        return newMap;
    }

    public final void clear() {
        super.clear();
        int i = 0;
        while (i < this.valueTable.length) {
            this.valueTable[i] = null;
            ++i;
        }
    }

    protected void resize(int size) {
        Object[] oldValueTable = this.valueTable;
        this.valueTable = new Object[size];
        System.arraycopy(oldValueTable, 0, this.valueTable, 0, oldValueTable.length);
        super.resize(size);
    }

    public Object put(Object key, Object value) {
        int i = this.add(key);
        Object oldvalue = this.valueTable[i];
        this.valueTable[i] = value;
        return oldvalue;
    }

    public final Object get(Object key) {
        int i = this.lookup(key);
        if (i >= 0) {
            return this.valueTable[i];
        }
        return null;
    }

    public final Object getAt(int i) {
        if (i < 0 || i > this.currEntry) {
            return null;
        }
        return this.valueTable[i];
    }

    public final Object remove(Object key) {
        if (key == null) {
            return null;
        }
        int i = this.lookup(key);
        if (i < 0) {
            return null;
        }
        Object value = this.valueTable[i];
        this.removeEntry(i);
        return value;
    }

    protected final void removeEntry(int i) {
        if (i < this.currEntry) {
            System.arraycopy(this.valueTable, i + 1, this.valueTable, i, this.currEntry - i);
        }
        this.valueTable[this.currEntry] = null;
        super.removeEntry(i);
    }

    protected int partition(Comparator c, int p, int r) {
        Object x = this.keyTable[p];
        Object temp = null;
        int i = p;
        int j = r;
        while (true) {
            if (c.compare(this.keyTable[j], x) > 0) {
                --j;
                continue;
            }
            if (i < j) {
                while (c.compare(this.keyTable[i], x) < 0) {
                    ++i;
                }
            }
            if (i >= j) break;
            temp = this.keyTable[j];
            this.keyTable[j] = this.keyTable[i];
            this.keyTable[i] = temp;
            temp = this.valueTable[j];
            this.valueTable[j] = this.valueTable[i];
            this.valueTable[i] = temp;
        }
        return j;
    }
}

