/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner2;

import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.parser.scanner2.FunctionStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.ObjectStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.ScannerCallbackManager;
import org.eclipse.cdt.internal.core.parser.scanner2.ScannerProblemFactory;

public class ExpressionEvaluator {
    private static char[] emptyCharArray = new char[0];
    private static final int bufferInitialSize = 8;
    private int bufferStackPos = -1;
    private char[][] bufferStack = new char[8][];
    private Object[] bufferData = new Object[8];
    private int[] bufferPos = new int[8];
    private int[] bufferLimit = new int[8];
    private ScannerCallbackManager callbackManager = null;
    private ScannerProblemFactory spf = null;
    private int lineNumber = 1;
    private char[] fileName = null;
    private int pos = 0;
    CharArrayObjectMap definitions;
    int tokenType = 0;
    long tokenValue;
    private static char[] _defined = "defined".toCharArray();
    private static final int tNULL = 0;
    private static final int tEOF = 1;
    private static final int tNUMBER = 2;
    private static final int tLPAREN = 3;
    private static final int tRPAREN = 4;
    private static final int tNOT = 5;
    private static final int tCOMPL = 6;
    private static final int tMULT = 7;
    private static final int tDIV = 8;
    private static final int tMOD = 9;
    private static final int tPLUS = 10;
    private static final int tMINUS = 11;
    private static final int tSHIFTL = 12;
    private static final int tSHIFTR = 13;
    private static final int tLT = 14;
    private static final int tGT = 15;
    private static final int tLTEQUAL = 16;
    private static final int tGTEQUAL = 17;
    private static final int tEQUAL = 18;
    private static final int tNOTEQUAL = 19;
    private static final int tBITAND = 20;
    private static final int tBITXOR = 21;
    private static final int tBITOR = 22;
    private static final int tAND = 23;
    private static final int tOR = 24;
    private static final int tQUESTION = 25;
    private static final int tCOLON = 26;
    private static final int t_defined = 27;

    public ExpressionEvaluator() {
    }

    public ExpressionEvaluator(ScannerCallbackManager manager, ScannerProblemFactory spf) {
        this.callbackManager = manager;
        this.spf = spf;
    }

    public long evaluate(char[] buffer, int p, int length, CharArrayObjectMap defs) {
        return this.evaluate(buffer, p, length, defs, 0, "".toCharArray());
    }

    public long evaluate(char[] buffer, int p, int length, CharArrayObjectMap defs, int ln, char[] fn) {
        this.lineNumber = ln;
        this.fileName = fn;
        this.bufferStack[++this.bufferStackPos] = buffer;
        this.bufferPos[this.bufferStackPos] = p - 1;
        this.bufferLimit[this.bufferStackPos] = p + length;
        this.definitions = defs;
        this.tokenType = 0;
        long r = 0L;
        try {
            r = this.expression();
        }
        catch (EvalException evalException) {}
        while (this.bufferStackPos >= 0) {
            this.popContext();
        }
        return r;
    }

    private long expression() throws EvalException {
        return this.conditionalExpression();
    }

    private long conditionalExpression() throws EvalException {
        long r1 = this.logicalOrExpression();
        if (this.LA() == 25) {
            this.consume();
            long r2 = this.expression();
            if (this.LA() != 26) {
                this.handleProblem(0x100000E, this.pos);
                throw new EvalException("bad conditional expression");
            }
            this.consume();
            long r3 = this.conditionalExpression();
            return r1 != 0L ? r2 : r3;
        }
        return r1;
    }

    private long logicalOrExpression() throws EvalException {
        long r1 = this.logicalAndExpression();
        while (this.LA() == 24) {
            this.consume();
            long r2 = this.logicalAndExpression();
            r1 = r1 != 0L || r2 != 0L ? 1 : 0;
        }
        return r1;
    }

    private long logicalAndExpression() throws EvalException {
        long r1 = this.inclusiveOrExpression();
        while (this.LA() == 23) {
            this.consume();
            long r2 = this.inclusiveOrExpression();
            r1 = r1 != 0L && r2 != 0L ? 1 : 0;
        }
        return r1;
    }

    private long inclusiveOrExpression() throws EvalException {
        long r1 = this.exclusiveOrExpression();
        while (this.LA() == 22) {
            this.consume();
            long r2 = this.exclusiveOrExpression();
            r1 |= r2;
        }
        return r1;
    }

    private long exclusiveOrExpression() throws EvalException {
        long r1 = this.andExpression();
        while (this.LA() == 21) {
            this.consume();
            long r2 = this.andExpression();
            r1 ^= r2;
        }
        return r1;
    }

    private long andExpression() throws EvalException {
        long r1 = this.equalityExpression();
        while (this.LA() == 20) {
            this.consume();
            long r2 = this.equalityExpression();
            r1 &= r2;
        }
        return r1;
    }

    private long equalityExpression() throws EvalException {
        long r1 = this.relationalExpression();
        int t = this.LA();
        while (t == 18 || t == 19) {
            this.consume();
            long r2 = this.relationalExpression();
            r1 = t == 18 ? (long)(r1 == r2 ? 1 : 0) : (long)(r1 != r2 ? 1 : 0);
            t = this.LA();
        }
        return r1;
    }

    private long relationalExpression() throws EvalException {
        long r1 = this.shiftExpression();
        int t = this.LA();
        while (t == 14 || t == 16 || t == 15 || t == 17) {
            this.consume();
            long r2 = this.shiftExpression();
            switch (t) {
                case 14: {
                    r1 = r1 < r2 ? 1 : 0;
                    break;
                }
                case 16: {
                    r1 = r1 <= r2 ? 1 : 0;
                    break;
                }
                case 15: {
                    r1 = r1 > r2 ? 1 : 0;
                    break;
                }
                case 17: {
                    r1 = r1 >= r2 ? 1 : 0;
                }
            }
            t = this.LA();
        }
        return r1;
    }

    private long shiftExpression() throws EvalException {
        long r1 = this.additiveExpression();
        int t = this.LA();
        while (t == 12 || t == 13) {
            this.consume();
            long r2 = this.additiveExpression();
            r1 = t == 12 ? (r1 <<= (int)r2) : (r1 >>= (int)r2);
            t = this.LA();
        }
        return r1;
    }

    private long additiveExpression() throws EvalException {
        long r1 = this.multiplicativeExpression();
        int t = this.LA();
        while (t == 10 || t == 11) {
            this.consume();
            long r2 = this.multiplicativeExpression();
            r1 = t == 10 ? (r1 += r2) : (r1 -= r2);
            t = this.LA();
        }
        return r1;
    }

    private long multiplicativeExpression() throws EvalException {
        long r1 = this.unaryExpression();
        int t = this.LA();
        while (t == 7 || t == 8) {
            int position = this.pos;
            this.consume();
            long r2 = this.unaryExpression();
            if (t == 7) {
                r1 *= r2;
            } else if (r2 != 0L) {
                r1 /= r2;
            } else {
                this.handleProblem(0x100000A, position);
                throw new EvalException("Divide by 0 encountered");
            }
            t = this.LA();
        }
        return r1;
    }

    private long unaryExpression() throws EvalException {
        switch (this.LA()) {
            case 10: {
                this.consume();
                return this.unaryExpression();
            }
            case 11: {
                this.consume();
                return -this.unaryExpression();
            }
            case 5: {
                this.consume();
                return this.unaryExpression() == 0L ? 1 : 0;
            }
            case 6: {
                this.consume();
                return this.unaryExpression() ^ 0xFFFFFFFFFFFFFFFFL;
            }
            case 2: {
                return this.consume();
            }
            case 27: {
                return this.handleDefined();
            }
            case 3: {
                this.consume();
                long r1 = this.expression();
                if (this.LA() == 4) {
                    this.consume();
                    return r1;
                }
                this.handleProblem(0x100000B, this.pos);
                throw new EvalException("missing )");
            }
        }
        this.handleProblem(0x100000C, this.pos);
        throw new EvalException("expression syntax error");
    }

    /*
     * Unable to fully structure code
     */
    private long handleDefined() throws EvalException {
        this.skipWhiteSpace();
        buffer = this.bufferStack[this.bufferStackPos];
        limit = this.bufferLimit[this.bufferStackPos];
        v0 = this.bufferStackPos;
        this.bufferPos[v0] = this.bufferPos[v0] + 1;
        if (this.bufferPos[v0] >= limit) {
            return 0L;
        }
        c = buffer[this.bufferPos[this.bufferStackPos]];
        inParens = false;
        if (c == '(') {
            inParens = true;
            this.skipWhiteSpace();
            v1 = this.bufferStackPos;
            this.bufferPos[v1] = this.bufferPos[v1] + 1;
            if (this.bufferPos[v1] >= limit) {
                return 0L;
            }
            c = buffer[this.bufferPos[this.bufferStackPos]];
        }
        if (!(c >= 'A' && c <= 'Z' || c == '_' || c >= 'a' && c <= 'z')) {
            this.handleProblem(0x100000D, this.pos);
            throw new EvalException("illegal identifier in defined()");
        }
        idstart = this.bufferPos[this.bufferStackPos];
        idlen = 1;
        ** GOTO lbl26
        while ((c = buffer[this.bufferPos[this.bufferStackPos]]) >= 'A' && c <= 'Z' || c == '_' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
            ++idlen;
lbl26:
            // 2 sources

            v2 = this.bufferStackPos;
            this.bufferPos[v2] = this.bufferPos[v2] + 1;
            if (this.bufferPos[v2] < limit) continue;
        }
        v3 = this.bufferStackPos;
        this.bufferPos[v3] = this.bufferPos[v3] - 1;
        if (inParens) {
            this.skipWhiteSpace();
            v4 = this.bufferStackPos;
            this.bufferPos[v4] = this.bufferPos[v4] + 1;
            if (this.bufferPos[v4] <= limit && buffer[this.bufferPos[this.bufferStackPos]] != ')') {
                this.handleProblem(0x100000B, this.pos);
                throw new EvalException("missing ) on defined");
            }
        }
        this.nextToken();
        return this.definitions.get(buffer, idstart, idlen) != null ? 1 : 0;
    }

    private int LA() throws EvalException {
        if (this.tokenType == 0) {
            this.nextToken();
        }
        return this.tokenType;
    }

    private long consume() throws EvalException {
        long value = this.tokenValue;
        if (this.tokenType != 1) {
            this.nextToken();
        }
        return value;
    }

    /*
     * Unable to fully structure code
     */
    private void nextToken() throws EvalException {
        isHex = false;
        isOctal = false;
        isDecimal = false;
        block21: while (this.bufferStackPos >= 0) {
            this.skipWhiteSpace();
            v0 = this.bufferStackPos;
            this.bufferPos[v0] = this.bufferPos[v0] + 1;
            if (this.bufferPos[v0] >= this.bufferLimit[this.bufferStackPos]) {
                this.popContext();
                continue;
            }
            buffer = this.bufferStack[this.bufferStackPos];
            limit = this.bufferLimit[this.bufferStackPos];
            this.pos = this.bufferPos[this.bufferStackPos];
            if (buffer[this.pos] >= '1' && buffer[this.pos] <= '9') {
                isDecimal = true;
            } else if (buffer[this.pos] == '0' && this.pos + 1 < limit) {
                if (buffer[this.pos + 1] == 'x' || buffer[this.pos + 1] == 'X') {
                    isHex = true;
                    v1 = this.bufferStackPos;
                    this.bufferPos[v1] = this.bufferPos[v1] + 1;
                    if (!(this.pos + 2 >= limit || buffer[this.pos + 2] >= '0' && buffer[this.pos + 2] <= '9' || buffer[this.pos + 2] >= 'a' && buffer[this.pos + 2] <= 'f' || buffer[this.pos + 2] >= 'A' && buffer[this.pos + 2] <= 'F')) {
                        this.handleProblem(0x1000005, this.pos);
                    }
                } else {
                    isOctal = true;
                }
            }
            switch (buffer[this.pos]) {
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    start = this.bufferPos[this.bufferStackPos];
                    len = 1;
                    ** GOTO lbl33
                    while ((c = buffer[this.bufferPos[this.bufferStackPos]]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9') {
                        ++len;
lbl33:
                        // 2 sources

                        v2 = this.bufferStackPos;
                        this.bufferPos[v2] = this.bufferPos[v2] + 1;
                        if (this.bufferPos[v2] < limit) continue;
                    }
                    v3 = this.bufferStackPos;
                    this.bufferPos[v3] = this.bufferPos[v3] - 1;
                    this.pos = this.bufferPos[this.bufferStackPos];
                    if (CharArrayUtils.equals(buffer, start, len, ExpressionEvaluator._defined)) {
                        this.tokenType = 27;
                        return;
                    }
                    expObject = null;
                    if (this.bufferData[this.bufferStackPos] instanceof FunctionStyleMacro.Expansion) {
                        expObject = ((FunctionStyleMacro.Expansion)this.bufferData[this.bufferStackPos]).definitions.get(buffer, start, len);
                    }
                    if (expObject == null) {
                        expObject = this.definitions.get(buffer, start, len);
                    }
                    if (expObject != null) {
                        if (expObject instanceof FunctionStyleMacro) {
                            this.handleFunctionStyleMacro((FunctionStyleMacro)expObject);
                            break;
                        }
                        if (expObject instanceof ObjectStyleMacro) {
                            expMacro = (ObjectStyleMacro)expObject;
                            expText = expMacro.expansion;
                            if (expText.length <= 0) break;
                            this.pushContext(expText, expMacro);
                            break;
                        }
                        if (!(expObject instanceof char[]) || (expText = (char[])expObject).length <= 0) continue block21;
                        this.pushContext(expText, null);
                        break;
                    }
                    this.tokenValue = 0L;
                    this.tokenType = 2;
                    return;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.tokenValue = buffer[this.pos] - 48;
                    this.tokenType = 2;
                    if (true) ** GOTO lbl104
                    do {
                        c = buffer[this.bufferPos[this.bufferStackPos]];
                        if (!isHex) ** GOTO lbl85
                        if (c < '0' || c > '9') ** GOTO lbl74
                        this.tokenValue *= 16L;
                        this.tokenValue += (long)(c - 48);
                        ** GOTO lbl104
lbl74:
                        // 1 sources

                        if (c < 'a' || c > 'f') ** GOTO lbl78
                        this.tokenValue = this.tokenValue == 0L ? 10L : this.tokenValue * 16L + 10L;
                        this.tokenValue += (long)(c - 97);
                        ** GOTO lbl104
lbl78:
                        // 1 sources

                        if (c < 'A' || c > 'F') ** GOTO lbl82
                        this.tokenValue = this.tokenValue == 0L ? 10L : this.tokenValue * 16L + 10L;
                        this.tokenValue += (long)(c - 65);
                        ** GOTO lbl104
lbl82:
                        // 1 sources

                        if (this.bufferPos[this.bufferStackPos] + 1 < limit && !this.isValidTokenSeparator(c, buffer[this.bufferPos[this.bufferStackPos] + 1])) {
                            this.handleProblem(0x1000005, this.pos);
                        }
                        ** GOTO lbl100
lbl85:
                        // 1 sources

                        if (!isOctal) ** GOTO lbl93
                        if (c < '0' || c > '7') ** GOTO lbl90
                        this.tokenValue *= 8L;
                        this.tokenValue += (long)(c - 48);
                        ** GOTO lbl104
lbl90:
                        // 1 sources

                        if (this.bufferPos[this.bufferStackPos] + 1 < limit && !this.isValidTokenSeparator(c, buffer[this.bufferPos[this.bufferStackPos] + 1])) {
                            this.handleProblem(0x1000007, this.pos);
                        }
                        ** GOTO lbl100
lbl93:
                        // 1 sources

                        if (!isDecimal) ** GOTO lbl100
                        if (c >= '0' && c <= '9') {
                            this.tokenValue *= 10L;
                            this.tokenValue += (long)(c - 48);
                        } else {
                            if (this.bufferPos[this.bufferStackPos] + 1 < limit && c != 'L' && c != 'l' && c != 'U' && c != 'u' && !this.isValidTokenSeparator(c, buffer[this.bufferPos[this.bufferStackPos] + 1])) {
                                this.handleProblem(0x1000008, this.pos);
                            }
lbl100:
                            // 6 sources

                            if (c != 'L' && c != 'l' && c != 'U' && c != 'u') break;
                            v4 = this.bufferStackPos;
                            this.bufferPos[v4] = this.bufferPos[v4] + 1;
                            break;
                        }
lbl104:
                        // 6 sources

                        v5 = this.bufferStackPos;
                    } while ((this.bufferPos[v5] = this.bufferPos[v5] + 1) < limit);
                    v6 = this.bufferStackPos;
                    this.bufferPos[v6] = this.bufferPos[v6] - 1;
                    return;
                }
                case '(': {
                    this.tokenType = 3;
                    return;
                }
                case ')': {
                    this.tokenType = 4;
                    return;
                }
                case ':': {
                    this.tokenType = 26;
                    return;
                }
                case '?': {
                    this.tokenType = 25;
                    return;
                }
                case '+': {
                    this.tokenType = 10;
                    return;
                }
                case '-': {
                    this.tokenType = 11;
                    return;
                }
                case '*': {
                    this.tokenType = 7;
                    return;
                }
                case '/': {
                    this.tokenType = 8;
                    return;
                }
                case '%': {
                    this.tokenType = 9;
                    return;
                }
                case '^': {
                    this.tokenType = 21;
                    return;
                }
                case '&': {
                    if (this.pos + 1 < limit && buffer[this.pos + 1] == '&') {
                        v7 = this.bufferStackPos;
                        this.bufferPos[v7] = this.bufferPos[v7] + 1;
                        this.tokenType = 23;
                        return;
                    }
                    this.tokenType = 20;
                    return;
                }
                case '|': {
                    if (this.pos + 1 < limit && buffer[this.pos + 1] == '|') {
                        v8 = this.bufferStackPos;
                        this.bufferPos[v8] = this.bufferPos[v8] + 1;
                        this.tokenType = 24;
                        return;
                    }
                    this.tokenType = 22;
                    return;
                }
                case '~': {
                    this.tokenType = 6;
                    return;
                }
                case '!': {
                    if (this.pos + 1 < limit && buffer[this.pos + 1] == '=') {
                        v9 = this.bufferStackPos;
                        this.bufferPos[v9] = this.bufferPos[v9] + 1;
                        this.tokenType = 19;
                        return;
                    }
                    this.tokenType = 5;
                    return;
                }
                case '=': {
                    if (this.pos + 1 < limit && buffer[this.pos + 1] == '=') {
                        v10 = this.bufferStackPos;
                        this.bufferPos[v10] = this.bufferPos[v10] + 1;
                        this.tokenType = 18;
                        return;
                    }
                    this.handleProblem(0x1000009, this.pos);
                    throw new EvalException("assignment not allowed");
                }
                case '<': {
                    if (this.pos + 1 < limit) {
                        if (buffer[this.pos + 1] == '=') {
                            v11 = this.bufferStackPos;
                            this.bufferPos[v11] = this.bufferPos[v11] + 1;
                            this.tokenType = 16;
                            return;
                        }
                        if (buffer[this.pos + 1] == '<') {
                            v12 = this.bufferStackPos;
                            this.bufferPos[v12] = this.bufferPos[v12] + 1;
                            this.tokenType = 12;
                            return;
                        }
                    }
                    this.tokenType = 14;
                    return;
                }
                case '>': {
                    if (this.pos + 1 < limit) {
                        if (buffer[this.pos + 1] == '=') {
                            v13 = this.bufferStackPos;
                            this.bufferPos[v13] = this.bufferPos[v13] + 1;
                            this.tokenType = 17;
                            return;
                        }
                        if (buffer[this.pos + 1] == '>') {
                            v14 = this.bufferStackPos;
                            this.bufferPos[v14] = this.bufferPos[v14] + 1;
                            this.tokenType = 13;
                            return;
                        }
                    }
                    this.tokenType = 15;
                    return;
                }
            }
        }
        this.tokenType = 1;
    }

    private void handleFunctionStyleMacro(FunctionStyleMacro macro) {
        char[] expText;
        char[] buffer = this.bufferStack[this.bufferStackPos];
        int limit = this.bufferLimit[this.bufferStackPos];
        this.skipWhiteSpace();
        int n = this.bufferStackPos;
        this.bufferPos[n] = this.bufferPos[n] + 1;
        if (this.bufferPos[n] >= limit || buffer[this.bufferPos[this.bufferStackPos]] != '(') {
            return;
        }
        FunctionStyleMacro.Expansion exp = new FunctionStyleMacro.Expansion(macro);
        char[][] arglist = macro.arglist;
        int currarg = -1;
        int parens = 0;
        while (this.bufferPos[this.bufferStackPos] < limit) {
            if (++currarg >= arglist.length || arglist[currarg] == null) break;
            this.skipWhiteSpace();
            int n2 = this.bufferStackPos;
            int n3 = this.bufferPos[n2] + 1;
            this.bufferPos[n2] = n3;
            int p = n3;
            char c = buffer[p];
            if (c == ')') {
                if (parens == 0) break;
                --parens;
                continue;
            }
            if (c == ',') {
                exp.definitions.put(arglist[currarg], emptyCharArray);
                continue;
            }
            if (c == '(') {
                ++parens;
                continue;
            }
            int argstart = p;
            int argend = argstart - 1;
            while (this.bufferPos[this.bufferStackPos] < limit) {
                this.skipOverMacroArg();
                argend = this.bufferPos[this.bufferStackPos];
                this.skipWhiteSpace();
                int n4 = this.bufferStackPos;
                this.bufferPos[n4] = this.bufferPos[n4] + 1;
                if (this.bufferPos[n4] >= limit || (c = buffer[this.bufferPos[this.bufferStackPos]]) == ',' || c == ')') break;
            }
            char[] arg = emptyCharArray;
            int arglen = argend - argstart + 1;
            if (arglen > 0) {
                arg = new char[arglen];
                System.arraycopy(buffer, argstart, arg, 0, arglen);
            }
            exp.definitions.put(arglist[currarg], arg);
            if (c == ')') break;
        }
        if ((expText = macro.expansion).length > 0) {
            this.pushContext(expText, exp);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private void skipOverMacroArg() {
        block14: {
            int n;
            int limit;
            char[] buffer;
            block13: {
                buffer = this.bufferStack[this.bufferStackPos];
                limit = this.bufferLimit[this.bufferStackPos];
                if (!true) break block13;
                n = this.bufferStackPos;
                if ((this.bufferPos[n] = this.bufferPos[n] + 1) >= limit) break block14;
            }
            do {
                block0 : switch (buffer[this.bufferPos[this.bufferStackPos]]) {
                    case '\t': 
                    case '\r': 
                    case ' ': 
                    case ')': 
                    case ',': {
                        int n2 = this.bufferStackPos;
                        this.bufferPos[n2] = this.bufferPos[n2] - 1;
                        return;
                    }
                    case '\n': {
                        ++this.lineNumber;
                        int n3 = this.bufferStackPos;
                        this.bufferPos[n3] = this.bufferPos[n3] - 1;
                        return;
                    }
                    case '\\': {
                        int p = this.bufferPos[this.bufferStackPos];
                        if (p + 1 >= limit || buffer[p + 1] != '\n') break;
                        ++this.lineNumber;
                        int n4 = this.bufferStackPos;
                        this.bufferPos[n4] = this.bufferPos[n4] - 1;
                        return;
                    }
                    case '\"': {
                        boolean escaped = false;
                        while (true) {
                            int n5 = this.bufferStackPos;
                            this.bufferPos[n5] = this.bufferPos[n5] + 1;
                            if (this.bufferPos[n5] >= this.bufferLimit[this.bufferStackPos]) break block0;
                            switch (buffer[this.bufferPos[this.bufferStackPos]]) {
                                case '\\': {
                                    escaped = !escaped;
                                    break;
                                }
                                case '\"': {
                                    if (!escaped) break block0;
                                    escaped = false;
                                    break;
                                }
                                default: {
                                    escaped = false;
                                    break;
                                }
                            }
                        }
                    }
                }
                n = this.bufferStackPos;
            } while ((this.bufferPos[n] = this.bufferPos[n] + 1) < limit);
        }
        int n = this.bufferStackPos;
        this.bufferPos[n] = this.bufferPos[n] - 1;
    }

    /*
     * Unable to fully structure code
     */
    private void skipWhiteSpace() {
        buffer = this.bufferStack[this.bufferStackPos];
        limit = this.bufferLimit[this.bufferStackPos];
        if (true) ** GOTO lbl53
        do {
            p = this.bufferPos[this.bufferStackPos];
            block0 : switch (buffer[p]) {
                case '\t': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '/': {
                    if (p + 1 >= limit) ** GOTO lbl49
                    if (buffer[p + 1] == '/') {
                        v0 = this.bufferStackPos;
                        this.bufferPos[v0] = this.bufferPos[v0] + 2;
                        while (this.bufferPos[this.bufferStackPos] < limit) {
                            p = this.bufferPos[this.bufferStackPos];
                            if (buffer[p] == '\\' && p + 1 < limit && buffer[p + 1] == '\n') {
                                v1 = this.bufferStackPos;
                                this.bufferPos[v1] = this.bufferPos[v1] + 2;
                            } else if (buffer[p] == '\\' && p + 1 < limit && buffer[p + 1] == '\r' && p + 2 < limit && buffer[p + 2] == '\n') {
                                v2 = this.bufferStackPos;
                                this.bufferPos[v2] = this.bufferPos[v2] + 3;
                            } else if (buffer[p] == '\n') break block0;
                            v3 = this.bufferStackPos;
                            this.bufferPos[v3] = this.bufferPos[v3] + 1;
                        }
                        break;
                    }
                    if (buffer[p + 1] == '*') {
                        v4 = this.bufferStackPos;
                        this.bufferPos[v4] = this.bufferPos[v4] + 2;
                        while (this.bufferPos[this.bufferStackPos] < limit) {
                            p = this.bufferPos[this.bufferStackPos];
                            if (buffer[p] == '*' && p + 1 < limit && buffer[p + 1] == '/') {
                                v5 = this.bufferStackPos;
                                this.bufferPos[v5] = this.bufferPos[v5] + 1;
                                break block0;
                            }
                            v6 = this.bufferStackPos;
                            this.bufferPos[v6] = this.bufferPos[v6] + 1;
                        }
                        break;
                    }
                    ** GOTO lbl49
                }
                case '\\': {
                    if (p + 1 < limit && buffer[p + 1] == '\n') {
                        ++this.lineNumber;
                        v7 = this.bufferStackPos;
                        this.bufferPos[v7] = this.bufferPos[v7] + 1;
                        break;
                    }
                }
lbl49:
                // 5 sources

                default: {
                    v8 = this.bufferStackPos;
                    this.bufferPos[v8] = this.bufferPos[v8] - 1;
                    return;
                }
            }
lbl53:
            // 7 sources

            v9 = this.bufferStackPos;
        } while ((this.bufferPos[v9] = this.bufferPos[v9] + 1) < limit);
        v10 = this.bufferStackPos;
        this.bufferPos[v10] = this.bufferPos[v10] - 1;
    }

    private void pushContext(char[] buffer, Object data) {
        if (++this.bufferStackPos == this.bufferStack.length) {
            int size = this.bufferStack.length * 2;
            char[][] oldBufferStack = this.bufferStack;
            this.bufferStack = new char[size][];
            System.arraycopy(oldBufferStack, 0, this.bufferStack, 0, oldBufferStack.length);
            Object[] oldBufferData = this.bufferData;
            this.bufferData = new Object[size];
            System.arraycopy(oldBufferData, 0, this.bufferData, 0, oldBufferData.length);
            int[] oldBufferPos = this.bufferPos;
            this.bufferPos = new int[size];
            System.arraycopy(oldBufferPos, 0, this.bufferPos, 0, oldBufferPos.length);
            int[] oldBufferLimit = this.bufferLimit;
            this.bufferLimit = new int[size];
            System.arraycopy(oldBufferLimit, 0, this.bufferLimit, 0, oldBufferLimit.length);
        }
        this.bufferStack[this.bufferStackPos] = buffer;
        this.bufferPos[this.bufferStackPos] = -1;
        this.bufferLimit[this.bufferStackPos] = buffer.length;
        this.bufferData[this.bufferStackPos] = data;
    }

    private void popContext() {
        this.bufferStack[this.bufferStackPos] = null;
        this.bufferData[this.bufferStackPos] = null;
        --this.bufferStackPos;
    }

    private void handleProblem(int id, int startOffset) {
        if (this.callbackManager != null && this.spf != null) {
            this.callbackManager.pushCallback(this.spf.createProblem(id, startOffset, this.bufferPos[this.bufferStackPos == -1 ? 0 : this.bufferStackPos], this.lineNumber, this.fileName == null ? "".toCharArray() : this.fileName, emptyCharArray, false, true));
        }
    }

    private boolean isValidTokenSeparator(char c, char c2) throws EvalException {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': 
            case '!': 
            case '%': 
            case '&': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '/': 
            case ':': 
            case '<': 
            case '>': 
            case '?': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
            case '=': {
                return c2 == '=';
            }
        }
        return false;
    }

    private static class EvalException
    extends Exception {
        public EvalException(String msg) {
            super(msg);
        }
    }
}

