/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.scannerconfig;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IExternalScannerInfoProvider;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.scannerconfig.IManagedScannerInfoCollector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;

public class ManagedBuildCPathEntryContainer
implements IPathEntryContainer {
    private static final String BUILDER_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".ScannerConfigBuilder";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String ERROR_HEADER = "PathEntryContainer error [";
    private static final String TRACE_FOOTER = "]: ";
    private static final String TRACE_HEADER = "PathEntryContainer trace [";
    private ITarget defaultTarget;
    private Vector entries;
    private IProject project;
    private ManagedBuildInfo info;
    public static boolean VERBOSE = false;

    public static void outputTrace(String resourceName, String message) {
        if (VERBOSE) {
            System.out.println(TRACE_HEADER + resourceName + TRACE_FOOTER + message + NEWLINE);
        }
    }

    public static void outputError(String resourceName, String message) {
        if (VERBOSE) {
            System.err.println(ERROR_HEADER + resourceName + TRACE_FOOTER + message + NEWLINE);
        }
    }

    public ManagedBuildCPathEntryContainer(IProject project) {
        this.project = project;
        this.entries = new Vector();
    }

    protected void addDefinedSymbols(Map definedSymbols) {
        Iterator keyIter = definedSymbols.keySet().iterator();
        while (keyIter.hasNext()) {
            boolean add = true;
            String macro = (String)keyIter.next();
            String value = (String)definedSymbols.get(macro);
            ListIterator entryIter = this.entries.listIterator();
            while (entryIter.hasNext()) {
                IPathEntry entry = (IPathEntry)entryIter.next();
                if (entry.getEntryKind() != 6 || !((IMacroEntry)entry).getMacroName().equals(macro) || !((IMacroEntry)entry).getMacroValue().equals(value)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            this.entries.add(CoreModel.newMacroEntry((IPath)Path.EMPTY, (String)macro, (String)value));
        }
    }

    protected void addIncludePaths(List paths) {
        ListIterator pathIter = paths.listIterator();
        while (pathIter.hasNext()) {
            String path = (String)pathIter.next();
            IIncludeEntry entry = CoreModel.newIncludeEntry((IPath)Path.EMPTY, (IPath)Path.EMPTY, (IPath)new Path(path), (boolean)true);
            if (this.entries.contains(entry)) continue;
            this.entries.add(entry);
        }
    }

    protected void calculateBuiltIns(ITarget defaultTarget, IConfiguration config) {
        ITool[] tools = config.getFilteredTools();
        int toolIndex = 0;
        while (toolIndex < tools.length) {
            ITool tool = tools[toolIndex];
            IOption[] options = tool.getOptions();
            int optIndex = 0;
            while (optIndex < options.length) {
                IOption option = options[optIndex];
                try {
                    String[] values;
                    if (option.getValueType() == 5) {
                        String[] builtIns = option.getBuiltIns();
                        HashMap<String, String> macroMap = new HashMap<String, String>();
                        int biIndex = 0;
                        while (biIndex < builtIns.length) {
                            String symbol = builtIns[biIndex];
                            String[] tokens = symbol.split("=");
                            String macro = tokens[0].trim();
                            String value = tokens.length > 1 ? tokens[1] : new String();
                            macroMap.put(macro, value);
                            ++biIndex;
                        }
                        this.addDefinedSymbols(macroMap);
                    } else if (option.getValueType() == 4 && (values = option.getBuiltIns()).length > 0) {
                        this.addIncludePaths(Arrays.asList(values));
                    }
                }
                catch (BuildException buildException) {}
                ++optIndex;
            }
            ++toolIndex;
        }
    }

    protected void calculateEntriesDynamically(final IProject project, final IScannerInfoCollector collector) {
        final IScannerConfigBuilderInfo buildInfo = MakeCorePlugin.createScannerConfigBuildInfo((Preferences)MakeCorePlugin.getDefault().getPluginPreferences(), (String)BUILDER_ID, (boolean)false);
        final IExternalScannerInfoProvider esiProvider = MakeCorePlugin.getDefault().getExternalScannerInfoProvider(MakeCorePlugin.DEFAULT_EXTERNAL_SI_PROVIDER_ID);
        Vector compilerArgs = new Vector();
        buildInfo.getESIProviderArguments();
        buildInfo.getESIProviderCommand();
        final Vector buildArgs = compilerArgs;
        ISafeRunnable runnable = new ISafeRunnable(){

            public void run() {
                NullProgressMonitor monitor = new NullProgressMonitor();
                esiProvider.invokeProvider((IProgressMonitor)monitor, project, buildInfo, (List)buildArgs, collector);
            }

            public void handleException(Throwable exception) {
                if (exception instanceof OperationCanceledException) {
                    throw (OperationCanceledException)exception;
                }
            }
        };
        Platform.run((ISafeRunnable)runnable);
    }

    public IPathEntry[] getPathEntries() {
        this.info = (ManagedBuildInfo)ManagedBuildManager.getBuildInfo((IResource)this.project);
        if (this.info == null) {
            ManagedBuildCPathEntryContainer.outputError(this.project.getName(), "Build information is null");
            return this.entries.toArray(new IPathEntry[this.entries.size()]);
        }
        IConfiguration defaultConfig = this.info.getDefaultConfiguration();
        if (defaultConfig == null) {
            ManagedBuildCPathEntryContainer.outputError(this.project.getName(), "Build information has not been loaded yet");
            return this.entries.toArray(new IPathEntry[this.entries.size()]);
        }
        IManagedScannerInfoCollector collector = ManagedBuildManager.getScannerInfoCollector(defaultConfig);
        ManagedBuildCPathEntryContainer managedBuildCPathEntryContainer = this;
        synchronized (managedBuildCPathEntryContainer) {
            if (collector != null) {
                ManagedBuildCPathEntryContainer.outputTrace(this.project.getName(), "Path entries collected dynamically");
                collector.setProject(this.info.getOwner().getProject());
                this.calculateEntriesDynamically((IProject)this.info.getOwner(), collector);
                this.addIncludePaths(collector.getIncludePaths());
                this.addDefinedSymbols(collector.getDefinedSymbols());
            } else if (defaultConfig != null) {
                this.calculateBuiltIns(this.defaultTarget, defaultConfig);
                ManagedBuildCPathEntryContainer.outputTrace(this.project.getName(), "Path entries set using built-in definitions from " + defaultConfig.getName());
            } else {
                ManagedBuildCPathEntryContainer.outputError(this.project.getName(), "Configuration is null");
                return this.entries.toArray(new IPathEntry[this.entries.size()]);
            }
            return this.entries.toArray(new IPathEntry[this.entries.size()]);
        }
    }

    public String getDescription() {
        return "CDT Managed Build Project";
    }

    public IPath getPath() {
        return new Path("org.eclipse.cdt.managedbuilder.MANAGED_CONTAINER");
    }
}

