/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.browser.typehierarchy;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.typehierarchy.ITypeHierarchy;
import org.eclipse.cdt.core.browser.typehierarchy.TypeHierarchy;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.core.browser.cache.TypeCacheManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.core.runtime.IProgressMonitor;

public class TypeHierarchyBuilder {
    public ITypeHierarchy createTypeHierarchy(ITypeInfo info, boolean enableIndexing, IProgressMonitor monitor) throws CModelException {
        TypeHierarchy typeHierarchy = new TypeHierarchy(info);
        HashSet processedTypes = new HashSet();
        this.addSuperClasses(typeHierarchy, info, processedTypes, enableIndexing, monitor);
        typeHierarchy.addRootType(info);
        processedTypes.clear();
        this.addSubClasses(typeHierarchy, info, processedTypes, enableIndexing, monitor);
        return typeHierarchy;
    }

    private void addSuperClasses(TypeHierarchy typeHierarchy, ITypeInfo type, Set processedTypes, boolean enableIndexing, IProgressMonitor monitor) throws CModelException {
        if (type.hasSuperTypes()) {
            ITypeInfo[] superTypes = TypeCacheManager.getInstance().locateSuperTypesAndWait(type, enableIndexing, 20, monitor);
            if (superTypes == null) {
                throw new CModelException(new CModelStatus(969));
            }
            int i = 0;
            while (i < superTypes.length) {
                ITypeInfo superType = superTypes[i];
                if (!processedTypes.contains(superType)) {
                    processedTypes.add(superType);
                    this.addSuperClasses(typeHierarchy, superType, processedTypes, enableIndexing, monitor);
                }
                ASTAccessVisibility access = type.getSuperTypeAccess(superType);
                typeHierarchy.addSuperType(type, superType, access);
                ++i;
            }
        } else {
            typeHierarchy.addRootType(type);
        }
    }

    private void addSubClasses(TypeHierarchy typeHierarchy, ITypeInfo type, Set processedTypes, boolean enableIndexing, IProgressMonitor monitor) throws CModelException {
        if (type.hasSubTypes()) {
            ITypeInfo[] subTypes = TypeCacheManager.getInstance().locateSubTypesAndWait(type, enableIndexing, 20, monitor);
            if (subTypes == null) {
                throw new CModelException(new CModelStatus(969));
            }
            int i = 0;
            while (i < subTypes.length) {
                ITypeInfo subType = subTypes[i];
                if (!processedTypes.contains(subType)) {
                    processedTypes.add(subType);
                    this.addSubClasses(typeHierarchy, subType, processedTypes, enableIndexing, monitor);
                }
                typeHierarchy.addSubType(type, subType);
                ++i;
            }
        }
    }
}

