/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.cdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;

public class NamespaceDeclarationPattern
extends CSearchPattern {
    private char[][] decodedContainingTypes;
    private char[] decodedSimpleName;
    private char[][] qualifications;
    private char[] simpleName;

    public NamespaceDeclarationPattern(char[] name, char[][] quals, int matchMode, ICSearchConstants.LimitTo limitTo, boolean caseSensitive) {
        super(matchMode, caseSensitive, limitTo);
        this.simpleName = name;
        this.qualifications = quals;
    }

    public int matchLevel(ISourceElementCallbackDelegate node, ICSearchConstants.LimitTo limit) {
        if (!(node instanceof IASTNamespaceDefinition) || !this.canAccept(limit)) {
            return 0;
        }
        IASTNamespaceDefinition namespace = (IASTNamespaceDefinition)node;
        if (this.simpleName != null && !this.matchesName(this.simpleName, namespace.getNameCharArray())) {
            return 0;
        }
        char[][] qualName = namespace.getFullyQualifiedNameCharArrays();
        if (!this.matchQualifications(this.qualifications, qualName, true)) {
            return 0;
        }
        return 2;
    }

    public void feedIndexRequestor(IIndexSearchRequestor requestor, int detailLevel, int[] references, int[] indexFlags, IndexInput input, ICSearchScope scope) throws IOException {
        int i = 0;
        int max = references.length;
        while (i < max) {
            String path;
            IndexedFile file = input.getIndexedFile(references[i]);
            if (file != null && scope.encloses(path = file.getPath())) {
                requestor.acceptNamespaceDeclaration(path, this.decodedSimpleName, this.decodedContainingTypes);
            }
            ++i;
        }
    }

    protected void resetIndexInfo() {
        this.decodedSimpleName = null;
        this.decodedContainingTypes = null;
    }

    protected void decodeIndexEntry(IEntryResult entryResult) {
        char[] word = entryResult.getWord();
        int size = word.length;
        int firstSlash = CharOperation.indexOf('/', word, 0);
        int slash = CharOperation.indexOf('/', word, firstSlash + 1);
        this.decodedSimpleName = CharOperation.subarray(word, firstSlash + 1, slash);
        if (slash != -1 && slash + 1 < size) {
            char[][] temp = CharOperation.splitOn('/', CharOperation.subarray(word, slash + 1, size));
            this.decodedContainingTypes = new char[temp.length][];
            int i = 0;
            while (i < temp.length) {
                this.decodedContainingTypes[i] = temp[temp.length - i - 1];
                ++i;
            }
        }
    }

    public char[] indexEntryPrefix() {
        return AbstractIndexer.bestNamespacePrefix(this._limitTo, this.simpleName, this.qualifications, this._matchMode, this._caseSensitive);
    }

    protected boolean matchIndexEntry() {
        if (this.simpleName != null && !this.matchesName(this.simpleName, this.decodedSimpleName)) {
            return false;
        }
        return this.matchQualifications(this.qualifications, this.decodedContainingTypes);
    }
}

