/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDICharValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIDoubleValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIFloatValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIIntValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDILongLongValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDILongValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIPointerValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIReferenceValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIShortValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIWCharValue;
import org.eclipse.cdt.debug.core.model.CVariableFormat;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.ICType;
import org.eclipse.cdt.debug.internal.core.model.AbstractCValue;
import org.eclipse.cdt.debug.internal.core.model.AbstractCVariable;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CType;
import org.eclipse.cdt.debug.internal.core.model.CVariable;
import org.eclipse.cdt.debug.internal.core.model.CVariableFactory;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;

public class CValue
extends AbstractCValue {
    private String fValueString = null;
    private ICDIValue fCDIValue;
    private List fVariables = Collections.EMPTY_LIST;
    private CType fType;

    protected CValue(CVariable parent, ICDIValue cdiValue) {
        super(parent);
        this.fCDIValue = cdiValue;
    }

    protected CValue(CVariable parent, String message) {
        super(parent);
        this.setStatus(2, message);
    }

    public String getReferenceTypeName() throws DebugException {
        return this.getParentVariable() != null ? this.getParentVariable().getReferenceTypeName() : null;
    }

    public String getValueString() throws DebugException {
        if (this.fValueString == null && this.getUnderlyingValue() != null) {
            boolean isSuspended;
            this.resetStatus();
            ICStackFrame cframe = this.getParentVariable().getStackFrame();
            boolean bl = isSuspended = cframe == null ? this.getCDITarget().isSuspended() : cframe.isSuspended();
            if (isSuspended) {
                try {
                    this.fValueString = this.processUnderlyingValue(this.getUnderlyingValue());
                }
                catch (CDIException e) {
                    this.setStatus(2, e.getMessage());
                }
            }
        }
        return this.fValueString;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        List list = this.getVariables0();
        return list.toArray(new IVariable[list.size()]);
    }

    protected synchronized List getVariables0() throws DebugException {
        if (!this.isAllocated() || !this.hasVariables()) {
            return Collections.EMPTY_LIST;
        }
        if (this.fVariables.size() == 0) {
            try {
                List vars = this.getCDIVariables();
                this.fVariables = new ArrayList(vars.size());
                Iterator it = vars.iterator();
                while (it.hasNext()) {
                    this.fVariables.add(CVariableFactory.createVariable(this, (ICDIVariable)it.next()));
                }
                this.resetStatus();
            }
            catch (DebugException e) {
                this.setStatus(2, e.getMessage());
            }
        }
        return this.fVariables;
    }

    public boolean hasVariables() throws DebugException {
        try {
            ICDIValue value = this.getUnderlyingValue();
            if (value != null) {
                return value.getChildrenNumber() > 0;
            }
        }
        catch (CDIException e) {
            CDebugElement.targetRequestFailed(e.getMessage(), null);
        }
        return false;
    }

    public ICDIValue getUnderlyingValue() {
        return this.fCDIValue;
    }

    protected List getCDIVariables() throws DebugException {
        ICDIVariable[] vars = null;
        try {
            ICDIValue value = this.getUnderlyingValue();
            if (value != null && (vars = value.getVariables()) == null) {
                vars = new ICDIVariable[]{};
            }
        }
        catch (CDIException e) {
            CDebugElement.requestFailed(e.getMessage(), e);
        }
        return Arrays.asList(vars);
    }

    protected synchronized void setChanged(boolean changed) {
        if (changed) {
            this.fValueString = null;
            this.resetStatus();
        }
        Iterator it = this.fVariables.iterator();
        while (it.hasNext()) {
            ((AbstractCVariable)it.next()).setChanged(changed);
        }
    }

    public void dispose() {
        Iterator it = this.fVariables.iterator();
        while (it.hasNext()) {
            ((AbstractCVariable)it.next()).dispose();
        }
    }

    private String processUnderlyingValue(ICDIValue cdiValue) throws CDIException {
        if (cdiValue != null) {
            if (cdiValue instanceof ICDICharValue) {
                return this.getCharValueString((ICDICharValue)cdiValue);
            }
            if (cdiValue instanceof ICDIShortValue) {
                return this.getShortValueString((ICDIShortValue)cdiValue);
            }
            if (cdiValue instanceof ICDIIntValue) {
                return this.getIntValueString((ICDIIntValue)cdiValue);
            }
            if (cdiValue instanceof ICDILongValue) {
                return this.getLongValueString((ICDILongValue)cdiValue);
            }
            if (cdiValue instanceof ICDILongLongValue) {
                return this.getLongLongValueString((ICDILongLongValue)cdiValue);
            }
            if (cdiValue instanceof ICDIFloatValue) {
                return this.getFloatValueString((ICDIFloatValue)cdiValue);
            }
            if (cdiValue instanceof ICDIDoubleValue) {
                return this.getDoubleValueString((ICDIDoubleValue)cdiValue);
            }
            if (cdiValue instanceof ICDIPointerValue) {
                return this.getPointerValueString((ICDIPointerValue)cdiValue);
            }
            if (cdiValue instanceof ICDIReferenceValue) {
                return this.getReferenceValueString((ICDIReferenceValue)cdiValue);
            }
            if (cdiValue instanceof ICDIWCharValue) {
                return this.getWCharValueString((ICDIWCharValue)cdiValue);
            }
            return cdiValue.getValueString();
        }
        return null;
    }

    private String getCharValueString(ICDICharValue value) throws CDIException {
        CVariableFormat format = this.getParentVariable().getFormat();
        if (CVariableFormat.NATURAL.equals(format)) {
            byte byteValue = (byte)value.byteValue();
            return Character.isISOControl((char)byteValue) && byteValue != 8 && byteValue != 9 && byteValue != 10 && byteValue != 12 && byteValue != 13 || byteValue < 0 ? "" : new String(new byte[]{39, byteValue, 39});
        }
        if (CVariableFormat.DECIMAL.equals(format)) {
            return this.isUnsigned() ? Integer.toString(value.shortValue()) : Integer.toString((byte)value.byteValue());
        }
        if (CVariableFormat.HEXADECIMAL.equals(format)) {
            StringBuffer sb = new StringBuffer("0x");
            String stringValue = this.isUnsigned() ? Integer.toHexString(value.shortValue()) : Integer.toHexString((byte)value.byteValue());
            sb.append(stringValue.length() > 2 ? stringValue.substring(stringValue.length() - 2) : stringValue);
            return sb.toString();
        }
        return null;
    }

    private String getShortValueString(ICDIShortValue value) throws CDIException {
        CVariableFormat format = this.getParentVariable().getFormat();
        if (CVariableFormat.NATURAL.equals(format) || CVariableFormat.DECIMAL.equals(format)) {
            return this.isUnsigned() ? Integer.toString(value.intValue()) : Short.toString(value.shortValue());
        }
        if (CVariableFormat.HEXADECIMAL.equals(format)) {
            StringBuffer sb = new StringBuffer("0x");
            String stringValue = Integer.toHexString(this.isUnsigned() ? value.intValue() : (int)value.shortValue());
            sb.append(stringValue.length() > 4 ? stringValue.substring(stringValue.length() - 4) : stringValue);
            return sb.toString();
        }
        return null;
    }

    private String getIntValueString(ICDIIntValue value) throws CDIException {
        CVariableFormat format = this.getParentVariable().getFormat();
        if (CVariableFormat.NATURAL.equals(format) || CVariableFormat.DECIMAL.equals(format)) {
            return this.isUnsigned() ? Long.toString(value.longValue()) : Integer.toString(value.intValue());
        }
        if (CVariableFormat.HEXADECIMAL.equals(format)) {
            StringBuffer sb = new StringBuffer("0x");
            String stringValue = this.isUnsigned() ? Long.toHexString(value.longValue()) : Integer.toHexString(value.intValue());
            sb.append(stringValue.length() > 8 ? stringValue.substring(stringValue.length() - 8) : stringValue);
            return sb.toString();
        }
        return null;
    }

    private String getLongValueString(ICDILongValue value) throws CDIException {
        try {
            CVariableFormat format = this.getParentVariable().getFormat();
            if (CVariableFormat.NATURAL.equals(format) || CVariableFormat.DECIMAL.equals(format)) {
                if (this.isUnsigned()) {
                    BigInteger bigValue = new BigInteger(value.getValueString());
                    return bigValue.toString();
                }
                return Long.toString(value.longValue());
            }
            if (CVariableFormat.HEXADECIMAL.equals(format)) {
                StringBuffer sb = new StringBuffer("0x");
                if (this.isUnsigned()) {
                    BigInteger bigValue = new BigInteger(value.getValueString());
                    sb.append(bigValue.toString(16));
                } else {
                    sb.append(Long.toHexString(value.longValue()));
                }
                return sb.toString();
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return null;
    }

    private String getLongLongValueString(ICDILongLongValue value) throws CDIException {
        try {
            CVariableFormat format = this.getParentVariable().getFormat();
            if (CVariableFormat.NATURAL.equals(format) || CVariableFormat.DECIMAL.equals(format)) {
                if (this.isUnsigned()) {
                    BigInteger bigValue = new BigInteger(value.getValueString());
                    return bigValue.toString();
                }
                return Long.toString(value.longValue());
            }
            if (CVariableFormat.HEXADECIMAL.equals(format)) {
                StringBuffer sb = new StringBuffer("0x");
                if (this.isUnsigned()) {
                    BigInteger bigValue = new BigInteger(value.getValueString());
                    sb.append(bigValue.toString(16));
                } else {
                    sb.append(Long.toHexString(value.longValue()));
                }
                return sb.toString();
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return null;
    }

    private String getFloatValueString(ICDIFloatValue value) throws CDIException {
        float floatValue = value.floatValue();
        Float flt = new Float(floatValue);
        if (flt.isNaN() || flt.isInfinite()) {
            return "";
        }
        long longValue = flt.longValue();
        CVariableFormat format = this.getParentVariable().getFormat();
        if (CVariableFormat.NATURAL.equals(format)) {
            return Float.toString(floatValue);
        }
        if (CVariableFormat.DECIMAL.equals(format)) {
            return Long.toString(longValue);
        }
        if (CVariableFormat.HEXADECIMAL.equals(format)) {
            StringBuffer sb = new StringBuffer("0x");
            String stringValue = Long.toHexString(longValue);
            sb.append(stringValue.length() > 8 ? stringValue.substring(stringValue.length() - 8) : stringValue);
            return sb.toString();
        }
        return null;
    }

    private String getDoubleValueString(ICDIDoubleValue value) throws CDIException {
        double doubleValue = value.doubleValue();
        Double dbl = new Double(doubleValue);
        if (dbl.isNaN() || dbl.isInfinite()) {
            return "";
        }
        long longValue = dbl.longValue();
        CVariableFormat format = this.getParentVariable().getFormat();
        if (CVariableFormat.NATURAL.equals(format)) {
            return dbl.toString();
        }
        if (CVariableFormat.DECIMAL.equals(format)) {
            return Long.toString(longValue);
        }
        if (CVariableFormat.HEXADECIMAL.equals(format)) {
            StringBuffer sb = new StringBuffer("0x");
            String stringValue = Long.toHexString(longValue);
            sb.append(stringValue.length() > 16 ? stringValue.substring(stringValue.length() - 16) : stringValue);
            return sb.toString();
        }
        return null;
    }

    private String getPointerValueString(ICDIPointerValue value) throws CDIException {
        IAddressFactory factory = ((CDebugTarget)this.getDebugTarget()).getAddressFactory();
        BigInteger pv = value.pointerValue();
        if (pv == null) {
            return "";
        }
        IAddress address = factory.createAddress(pv);
        if (address == null) {
            return "";
        }
        CVariableFormat format = this.getParentVariable().getFormat();
        if (CVariableFormat.NATURAL.equals(format) || CVariableFormat.HEXADECIMAL.equals(format)) {
            return address.toHexAddressString();
        }
        if (CVariableFormat.DECIMAL.equals(format)) {
            return address.toString();
        }
        return null;
    }

    private String getReferenceValueString(ICDIReferenceValue value) throws CDIException {
        IAddressFactory factory = ((CDebugTarget)this.getDebugTarget()).getAddressFactory();
        BigInteger refValue = value.referenceValue();
        if (refValue == null) {
            return "";
        }
        IAddress address = factory.createAddress(refValue);
        if (address == null) {
            return "";
        }
        CVariableFormat format = this.getParentVariable().getFormat();
        if (CVariableFormat.NATURAL.equals(format) || CVariableFormat.HEXADECIMAL.equals(format)) {
            return address.toHexAddressString();
        }
        if (CVariableFormat.DECIMAL.equals(format)) {
            return address.toString();
        }
        return null;
    }

    private String getWCharValueString(ICDIWCharValue value) throws CDIException {
        if (this.getParentVariable() instanceof CVariable) {
            CVariableFormat format;
            int size = ((CVariable)this.getParentVariable()).sizeof();
            if (size == 2) {
                format = this.getParentVariable().getFormat();
                if (CVariableFormat.NATURAL.equals(format) || CVariableFormat.DECIMAL.equals(format)) {
                    return this.isUnsigned() ? Integer.toString(value.intValue()) : Short.toString(value.shortValue());
                }
                if (CVariableFormat.HEXADECIMAL.equals(format)) {
                    StringBuffer sb = new StringBuffer("0x");
                    String stringValue = Integer.toHexString(this.isUnsigned() ? value.intValue() : (int)value.shortValue());
                    sb.append(stringValue.length() > 4 ? stringValue.substring(stringValue.length() - 4) : stringValue);
                    return sb.toString();
                }
            }
            if (size == 4) {
                format = this.getParentVariable().getFormat();
                if (CVariableFormat.NATURAL.equals(format) || CVariableFormat.DECIMAL.equals(format)) {
                    return this.isUnsigned() ? Long.toString(value.longValue()) : Integer.toString(value.intValue());
                }
                if (CVariableFormat.HEXADECIMAL.equals(format)) {
                    StringBuffer sb = new StringBuffer("0x");
                    String stringValue = this.isUnsigned() ? Long.toHexString(value.longValue()) : Integer.toHexString(value.intValue());
                    sb.append(stringValue.length() > 8 ? stringValue.substring(stringValue.length() - 8) : stringValue);
                    return sb.toString();
                }
            }
        }
        return value.getValueString();
    }

    private boolean isUnsigned() {
        boolean result = false;
        try {
            ICType type = this.getParentVariable().getType();
            if (type != null) {
                result = type.isUnsigned();
            }
        }
        catch (DebugException debugException) {}
        return result;
    }

    protected void reset() {
        this.resetStatus();
        this.fValueString = null;
        Iterator it = this.fVariables.iterator();
        while (it.hasNext()) {
            ((AbstractCVariable)it.next()).resetValue();
        }
    }

    public ICType getType() throws DebugException {
        ICDIValue cdiValue = this.getUnderlyingValue();
        if (this.fType == null && cdiValue != null) {
            CValue cValue = this;
            synchronized (cValue) {
                if (this.fType == null) {
                    try {
                        this.fType = new CType(cdiValue.getType());
                    }
                    catch (CDIException e) {
                        CDebugElement.requestFailed(e.getMessage(), null);
                    }
                }
            }
        }
        return this.fType;
    }

    protected void preserve() {
        this.setChanged(false);
        this.resetStatus();
        Iterator it = this.fVariables.iterator();
        while (it.hasNext()) {
            ((AbstractCVariable)it.next()).preserve();
        }
    }
}

