/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.classwizard;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.CConventions;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.AllTypesCache;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.PathUtil;
import org.eclipse.cdt.core.browser.QualifiedTypeName;
import org.eclipse.cdt.core.browser.TypeSearchScope;
import org.eclipse.cdt.core.browser.TypeUtil;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.corext.util.CModelUtil;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.internal.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.cdt.internal.ui.wizards.NewElementWizardPage;
import org.eclipse.cdt.internal.ui.wizards.SourceFolderSelectionDialog;
import org.eclipse.cdt.internal.ui.wizards.classwizard.BaseClassInfo;
import org.eclipse.cdt.internal.ui.wizards.classwizard.BaseClassesListDialogField;
import org.eclipse.cdt.internal.ui.wizards.classwizard.ConstructorMethodStub;
import org.eclipse.cdt.internal.ui.wizards.classwizard.DestructorMethodStub;
import org.eclipse.cdt.internal.ui.wizards.classwizard.EnclosingClassSelectionDialog;
import org.eclipse.cdt.internal.ui.wizards.classwizard.IBaseClassInfo;
import org.eclipse.cdt.internal.ui.wizards.classwizard.IMethodStub;
import org.eclipse.cdt.internal.ui.wizards.classwizard.MethodStubsListDialogField;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NamespaceSelectionDialog;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewBaseClassSelectionDialog;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewClassCodeGenerator;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewClassWizardMessages;
import org.eclipse.cdt.internal.ui.wizards.classwizard.SourceFileSelectionDialog;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.Separator;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.cdt.internal.ui.wizards.filewizard.NewSourceFileGenerator;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;

public class NewClassCreationWizardPage
extends NewElementWizardPage {
    private static final String PAGE_NAME = "NewClassWizardPage";
    private static final int MAX_FIELD_CHARS = 50;
    private IWorkspaceRoot fWorkspaceRoot;
    private static final int SOURCE_FOLDER_ID = 1;
    private static final int ENCLOSING_TYPE_ID = 2;
    private static final int CLASS_NAME_ID = 4;
    private static final int BASE_CLASSES_ID = 8;
    private static final int METHOD_STUBS_ID = 16;
    private static final int HEADER_FILE_ID = 32;
    private static final int SOURCE_FILE_ID = 64;
    private static final int ALL_FIELDS = 127;
    protected int fLastFocusedField = 0;
    private StringButtonDialogField fSourceFolderDialogField;
    SelectionButtonDialogField fEnclosingTypeSelection;
    StringButtonDialogField fEnclosingTypeDialogField;
    StringDialogField fClassNameDialogField;
    BaseClassesListDialogField fBaseClassesDialogField;
    MethodStubsListDialogField fMethodStubsDialogField;
    SelectionButtonDialogField fUseDefaultSelection;
    StringButtonDialogField fHeaderFileDialogField;
    StringButtonDialogField fSourceFileDialogField;
    protected IStatus fSourceFolderStatus;
    protected IStatus fEnclosingTypeStatus;
    protected IStatus fClassNameStatus;
    protected IStatus fBaseClassesStatus;
    protected IStatus fMethodStubsStatus;
    protected IStatus fHeaderFileStatus;
    protected IStatus fSourceFileStatus;
    protected final IStatus STATUS_OK = new StatusInfo();
    private NewClassCodeGenerator fCodeGenerator = null;
    private boolean fErrorIfBaseClassNotInPath = true;
    private static final int MAX_UNIQUE_CLASSNAME = 99;
    private final int[] ENCLOSING_CLASS_TYPES = new int[]{64};
    private final int[] CLASS_TYPES = new int[]{64, 65};
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public NewClassCreationWizardPage() {
        super(PAGE_NAME);
        this.setDescription(NewClassWizardMessages.getString("NewClassCreationWizardPage.description"));
        this.fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.fCodeGenerator = null;
        SourceFolderFieldAdapter sourceFolderAdapter = new SourceFolderFieldAdapter();
        this.fSourceFolderDialogField = new StringButtonDialogField(sourceFolderAdapter);
        this.fSourceFolderDialogField.setDialogFieldListener(sourceFolderAdapter);
        this.fSourceFolderDialogField.setLabelText(NewClassWizardMessages.getString("NewClassCreationWizardPage.sourceFolder.label"));
        this.fSourceFolderDialogField.setButtonLabel(NewClassWizardMessages.getString("NewClassCreationWizardPage.sourceFolder.button"));
        EnclosingTypeFieldAdapter enclosingTypeAdapter = new EnclosingTypeFieldAdapter();
        this.fEnclosingTypeSelection = new SelectionButtonDialogField(32);
        this.fEnclosingTypeSelection.setDialogFieldListener(enclosingTypeAdapter);
        this.fEnclosingTypeSelection.setLabelText(NewClassWizardMessages.getString("NewClassCreationWizardPage.enclosingType.label"));
        this.fEnclosingTypeDialogField = new StringButtonDialogField(enclosingTypeAdapter);
        this.fEnclosingTypeDialogField.setDialogFieldListener(enclosingTypeAdapter);
        this.fEnclosingTypeDialogField.setButtonLabel(NewClassWizardMessages.getString("NewClassCreationWizardPage.enclosingType.button"));
        ClassNameFieldAdapter classAdapter = new ClassNameFieldAdapter();
        this.fClassNameDialogField = new StringDialogField();
        this.fClassNameDialogField.setDialogFieldListener(classAdapter);
        this.fClassNameDialogField.setLabelText(NewClassWizardMessages.getString("NewClassCreationWizardPage.className.label"));
        BaseClassesFieldAdapter baseClassesAdapter = new BaseClassesFieldAdapter();
        this.fBaseClassesDialogField = new BaseClassesListDialogField(NewClassWizardMessages.getString("NewClassCreationWizardPage.baseClasses.label"), baseClassesAdapter);
        MethodStubsFieldAdapter methodStubsAdapter = new MethodStubsFieldAdapter();
        this.fMethodStubsDialogField = new MethodStubsListDialogField(NewClassWizardMessages.getString("NewClassCreationWizardPage.methodStubs.label"), methodStubsAdapter);
        FileGroupFieldAdapter fileGroupAdapter = new FileGroupFieldAdapter();
        this.fUseDefaultSelection = new SelectionButtonDialogField(32);
        this.fUseDefaultSelection.setDialogFieldListener(fileGroupAdapter);
        this.fUseDefaultSelection.setLabelText(NewClassWizardMessages.getString("NewClassCreationWizardPage.useDefaultLocation.label"));
        this.fHeaderFileDialogField = new StringButtonDialogField(fileGroupAdapter);
        this.fHeaderFileDialogField.setDialogFieldListener(fileGroupAdapter);
        this.fHeaderFileDialogField.setLabelText(NewClassWizardMessages.getString("NewClassCreationWizardPage.headerFile.label"));
        this.fHeaderFileDialogField.setButtonLabel(NewClassWizardMessages.getString("NewClassCreationWizardPage.headerFile.button"));
        this.fSourceFileDialogField = new StringButtonDialogField(fileGroupAdapter);
        this.fSourceFileDialogField.setDialogFieldListener(fileGroupAdapter);
        this.fSourceFileDialogField.setLabelText(NewClassWizardMessages.getString("NewClassCreationWizardPage.sourceFile.label"));
        this.fSourceFileDialogField.setButtonLabel(NewClassWizardMessages.getString("NewClassCreationWizardPage.sourceFile.button"));
        this.fSourceFolderStatus = this.STATUS_OK;
        this.fEnclosingTypeStatus = this.STATUS_OK;
        this.fClassNameStatus = this.STATUS_OK;
        this.fBaseClassesStatus = this.STATUS_OK;
        this.fMethodStubsStatus = this.STATUS_OK;
        this.fHeaderFileStatus = this.STATUS_OK;
        this.fSourceFileStatus = this.STATUS_OK;
        this.fLastFocusedField = 0;
        this.updateEnclosingTypeEnableState();
        this.updateFileGroupEnableState();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.createSourceFolderControls(composite, nColumns);
        this.createEnclosingTypeControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createClassNameControls(composite, nColumns);
        this.createBaseClassesControls(composite, nColumns);
        this.createMethodStubsControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createFileControls(composite, nColumns);
        composite.layout();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    protected void createSeparator(Composite composite, int nColumns) {
        new Separator(258).doFillIntoGrid(composite, nColumns, this.convertHeightInCharsToPixels(1));
    }

    protected void createSourceFolderControls(Composite parent, int nColumns) {
        this.fSourceFolderDialogField.doFillIntoGrid(parent, nColumns);
        Text textControl = this.fSourceFolderDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)textControl, this.getMaxFieldWidth());
        textControl.addFocusListener((FocusListener)new StatusFocusListener(1));
    }

    protected void createEnclosingTypeControls(Composite composite, int nColumns) {
        Composite tabGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tabGroup.setLayout((Layout)layout);
        this.fEnclosingTypeSelection.doFillIntoGrid(tabGroup, 1);
        Text textControl = this.fEnclosingTypeDialogField.getTextControl(composite);
        GridData gd = new GridData(768);
        gd.widthHint = this.getMaxFieldWidth();
        gd.horizontalSpan = 2;
        textControl.setLayoutData((Object)gd);
        textControl.addFocusListener((FocusListener)new StatusFocusListener(2));
        Button button = this.fEnclosingTypeDialogField.getChangeControl(composite);
        gd = new GridData(256);
        gd.heightHint = SWTUtil.getButtonHeigthHint(button);
        gd.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gd);
    }

    protected void createClassNameControls(Composite composite, int nColumns) {
        this.fClassNameDialogField.doFillIntoGrid(composite, nColumns - 1);
        DialogField.createEmptySpace(composite);
        Text textControl = this.fClassNameDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)textControl, this.getMaxFieldWidth());
        textControl.addFocusListener((FocusListener)new StatusFocusListener(4));
    }

    protected void createBaseClassesControls(Composite composite, int nColumns) {
        this.fBaseClassesDialogField.doFillIntoGrid(composite, nColumns);
        Control listControl = this.fBaseClassesDialogField.getListControl(null);
        GridData gd = (GridData)listControl.getLayoutData();
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        gd.grabExcessVerticalSpace = false;
        gd.widthHint = this.getMaxFieldWidth();
        listControl.addFocusListener((FocusListener)new StatusFocusListener(8));
    }

    protected void createMethodStubsControls(Composite composite, int nColumns) {
        this.fMethodStubsDialogField.doFillIntoGrid(composite, nColumns);
        Control listControl = this.fMethodStubsDialogField.getListControl(null);
        GridData gd = (GridData)listControl.getLayoutData();
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        gd.grabExcessVerticalSpace = false;
        gd.widthHint = this.getMaxFieldWidth();
        listControl.addFocusListener((FocusListener)new StatusFocusListener(16));
    }

    protected void createFileControls(Composite composite, int nColumns) {
        Composite tabGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tabGroup.setLayout((Layout)layout);
        this.fUseDefaultSelection.doFillIntoGrid(tabGroup, 1);
        LayoutUtil.setHorizontalSpan((Control)this.fHeaderFileDialogField.getLabelControl(composite), 1);
        Text textControl = this.fHeaderFileDialogField.getTextControl(composite);
        GridData gd = new GridData(768);
        gd.widthHint = this.getMaxFieldWidth();
        gd.horizontalSpan = 1;
        textControl.setLayoutData((Object)gd);
        textControl.addFocusListener((FocusListener)new StatusFocusListener(32));
        Button button = this.fHeaderFileDialogField.getChangeControl(composite);
        gd = new GridData(256);
        gd.heightHint = SWTUtil.getButtonHeigthHint(button);
        gd.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gd);
        DialogField.createEmptySpace(composite, 1);
        LayoutUtil.setHorizontalSpan((Control)this.fSourceFileDialogField.getLabelControl(composite), 1);
        textControl = this.fSourceFileDialogField.getTextControl(composite);
        gd = new GridData(768);
        gd.widthHint = this.getMaxFieldWidth();
        gd.horizontalSpan = 1;
        textControl.setLayoutData((Object)gd);
        textControl.addFocusListener((FocusListener)new StatusFocusListener(64));
        button = this.fSourceFileDialogField.getChangeControl(composite);
        gd = new GridData(256);
        gd.heightHint = SWTUtil.getButtonHeigthHint(button);
        gd.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gd);
    }

    public void init(IStructuredSelection selection) {
        ICElement celem = this.getInitialCElement(selection);
        this.initFields(celem);
        this.doStatusUpdate();
    }

    protected ICElement getInitialCElement(IStructuredSelection selection) {
        Object selectedElement;
        ICProject celem = null;
        if (selection != null && !selection.isEmpty() && (selectedElement = selection.getFirstElement()) instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)selectedElement;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.ICElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((celem = (ICElement)adaptable.getAdapter((Class)clazz)) == null) {
                IResource resource;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resource = (IResource)adaptable.getAdapter((Class)clazz2)) != null && resource.getType() != 8) {
                    while (celem == null && resource.getType() != 4) {
                        resource = resource.getParent();
                        Class<?> clazz3 = class$0;
                        if (clazz3 == null) {
                            try {
                                clazz3 = Class.forName("org.eclipse.cdt.core.model.ICElement");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        celem = (ICElement)resource.getAdapter((Class)clazz3);
                    }
                    if (celem == null) {
                        celem = CoreModel.getDefault().create(resource);
                    }
                }
            }
        }
        if (celem == null) {
            IEditorInput input;
            Object elem;
            IWorkbenchPart part = CUIPlugin.getActivePage().getActivePart();
            if (part instanceof ContentOutline) {
                part = CUIPlugin.getActivePage().getActiveEditor();
            }
            if (part instanceof IViewPartInputProvider && (elem = ((IViewPartInputProvider)part).getViewPartInput()) instanceof ICElement) {
                celem = (ICElement)elem;
            }
            if (celem == null && part instanceof CEditor && (input = ((IEditorPart)part).getEditorInput()) != null) {
                IResource res;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((res = (IResource)input.getAdapter((Class)clazz)) != null && res instanceof IFile) {
                    celem = CoreModel.getDefault().create((IFile)res);
                }
            }
        }
        if (celem == null || celem.getElementType() == 10) {
            try {
                ICProject[] projects = CoreModel.create((IWorkspaceRoot)this.getWorkspaceRoot()).getCProjects();
                if (projects.length == 1) {
                    celem = projects[0];
                }
            }
            catch (CModelException e) {
                CUIPlugin.getDefault().log(e);
            }
        }
        return celem;
    }

    protected void initFields(ICElement elem) {
        String text;
        ICElement enclosingElem = this.initEnclosingType(elem);
        this.initSourceFolder(enclosingElem != null ? enclosingElem : elem);
        QualifiedTypeName className = null;
        ITextSelection selection = this.getCurrentTextSelection();
        if (selection != null && (text = selection.getText()) != null && text.length() > 0 && CConventions.validateClassName((String)text).isOK()) {
            className = new QualifiedTypeName(text);
        }
        this.setClassTypeName((IQualifiedTypeName)className, false);
        this.addMethodStub(new ConstructorMethodStub(), true);
        this.addMethodStub(new DestructorMethodStub(), true);
        this.setFileGroupSelection(true, true);
        this.handleFieldChanged(127);
    }

    protected void initSourceFolder(ICElement elem) {
        ICProject cproject;
        ICContainer folder = null;
        if (elem != null && (folder = CModelUtil.getSourceFolder(elem)) == null && (cproject = elem.getCProject()) != null) {
            try {
                ISourceRoot[] roots;
                if (cproject.exists() && (roots = cproject.getSourceRoots()) != null && roots.length > 0) {
                    folder = roots[0];
                }
            }
            catch (CModelException e) {
                CUIPlugin.getDefault().log(e);
            }
            if (folder == null) {
                folder = cproject.findSourceRoot(cproject.getResource());
            }
        }
        this.setSourceFolderFullPath(folder != null ? folder.getResource().getFullPath() : null, false);
    }

    protected ICElement initEnclosingType(ICElement elem) {
        ICElement enclosingElem = null;
        while (elem != null) {
            if (elem.getElementType() == 61 || elem.getElementType() == 64) {
                enclosingElem = elem;
                break;
            }
            elem = elem.getParent();
        }
        IQualifiedTypeName enclosingTypeName = null;
        boolean isNamespace = true;
        if (enclosingElem != null) {
            enclosingTypeName = TypeUtil.getFullyQualifiedName((ICElement)enclosingElem);
            isNamespace = TypeUtil.isNamespace((ICElement)enclosingElem);
        }
        this.setEnclosingTypeName(enclosingTypeName, isNamespace, false);
        this.setEnclosingTypeSelection(enclosingElem != null, true);
        return enclosingElem;
    }

    protected int getMaxFieldWidth() {
        return this.convertWidthInCharsToPixels(50);
    }

    protected ITextSelection getCurrentTextSelection() {
        ISelection selection;
        ISelectionProvider selectionProvider;
        IWorkbenchPart part = CUIPlugin.getActivePage().getActivePart();
        if (part instanceof IEditorPart && (selectionProvider = part.getSite().getSelectionProvider()) != null && (selection = selectionProvider.getSelection()) instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return null;
    }

    protected void setFocusOnSourceFolder() {
        this.fSourceFolderDialogField.setFocus();
    }

    private String findUniqueName(String className) {
        IPath folderPath = this.getSourceFolderFullPath();
        if (folderPath == null) {
            return className;
        }
        String currName = className;
        int count = 0;
        String separator = "";
        if (Character.isDigit(className.charAt(className.length() - 1))) {
            separator = "_";
        }
        while (count < 99) {
            String headerfileName = NewSourceFileGenerator.generateHeaderFileNameFromClass(currName);
            String sourcefileName = NewSourceFileGenerator.generateSourceFileNameFromClass(currName);
            IPath path = folderPath.append(headerfileName);
            if (!path.toFile().exists() && !(path = folderPath.append(sourcefileName)).toFile().exists()) {
                return currName;
            }
            currName = String.valueOf(className) + separator + ++count;
        }
        return null;
    }

    private void updateFilesFromClassName(String className) {
        String headerName = "";
        String sourceName = "";
        if (className.length() > 0 && (className = this.findUniqueName(className)) != null) {
            headerName = NewSourceFileGenerator.generateHeaderFileNameFromClass(className);
            sourceName = NewSourceFileGenerator.generateSourceFileNameFromClass(className);
        }
        this.fHeaderFileDialogField.setTextWithoutUpdate(headerName);
        this.fSourceFileDialogField.setTextWithoutUpdate(sourceName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IStatus sourceFolderChanged() {
        StatusInfo status = new StatusInfo();
        IPath folderPath = this.getSourceFolderFullPath();
        if (folderPath == null) {
            status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.EnterSourceFolderName"));
            return status;
        }
        IResource res = this.fWorkspaceRoot.findMember(folderPath);
        if (res != null && res.exists()) {
            int resType = res.getType();
            if (resType == 4 || resType == 2) {
                ICElement e;
                IProject proj = res.getProject();
                if (!proj.isOpen()) {
                    status.setError(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.error.NotAFolder", folderPath));
                    return status;
                }
                if (!CoreModel.hasCCNature((IProject)proj) && !CoreModel.hasCNature((IProject)proj)) {
                    if (resType == 4) {
                        status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.warning.NotACProject"));
                        return status;
                    }
                    status.setWarning(NewClassWizardMessages.getString("NewClassCreationWizardPage.warning.NotInACProject"));
                }
                if (CModelUtil.getSourceFolder(e = CoreModel.getDefault().create(res.getFullPath())) != null) return status;
                status.setError(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.error.NotASourceFolder", folderPath));
                return status;
            }
            status.setError(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.error.NotAFolder", folderPath));
            return status;
        }
        status.setError(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.error.FolderDoesNotExist", folderPath));
        return status;
    }

    protected IStatus enclosingTypeChanged() {
        StatusInfo status = new StatusInfo();
        if (!this.isEnclosingTypeSelected()) {
            return status;
        }
        return this.namespaceChanged();
    }

    private IStatus namespaceChanged() {
        IProject project;
        StatusInfo status = new StatusInfo();
        IQualifiedTypeName typeName = this.getEnclosingTypeName();
        if (typeName == null) {
            status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.EnterNamespace"));
            return status;
        }
        IStatus val = CConventions.validateNamespaceName((String)typeName.toString());
        if (val.getSeverity() == 4) {
            status.setError(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.error.InvalidNamespace", val.getMessage()));
            return status;
        }
        if (val.getSeverity() == 2) {
            status.setWarning(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.warning.NamespaceDiscouraged", val.getMessage()));
        }
        if ((project = this.getCurrentProject()) != null) {
            ITypeInfo parentNamespace;
            this.prepareTypeCache();
            if (typeName.isQualified() && (parentNamespace = AllTypesCache.getType((IProject)project, (int)61, (IQualifiedTypeName)typeName.getEnclosingTypeName())) == null) {
                status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.EnclosingNamespaceNotExists"));
                return status;
            }
            ITypeInfo[] types = AllTypesCache.getTypes((IProject)project, (IQualifiedTypeName)typeName, (boolean)false, (boolean)true);
            if (types.length > 0) {
                ITypeInfo currType;
                boolean foundNamespace = false;
                boolean exactMatch = false;
                int i = 0;
                while (i < types.length) {
                    currType = types[i];
                    if (currType.getCElementType() == 61) {
                        foundNamespace = true;
                        exactMatch = currType.getQualifiedTypeName().equals(typeName);
                        if (exactMatch) break;
                    }
                    ++i;
                }
                if (foundNamespace) {
                    if (exactMatch) {
                        status.setOK();
                    } else {
                        status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.NamespaceExistsDifferentCase"));
                    }
                    return status;
                }
                exactMatch = false;
                i = 0;
                while (i < types.length) {
                    currType = types[i];
                    if (currType.getCElementType() != 61 && (exactMatch = currType.getQualifiedTypeName().equals(typeName))) break;
                    ++i;
                }
                if (exactMatch) {
                    status.setWarning(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.TypeMatchingNamespaceExists"));
                } else {
                    status.setWarning(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.TypeMatchingNamespaceExistsDifferentCase"));
                }
            } else {
                status.setWarning(NewClassWizardMessages.getString("NewClassCreationWizardPage.warning.NamespaceNotExists"));
            }
        }
        if ((val = CConventions.validateNamespaceName((String)typeName.lastSegment())).getSeverity() == 4) {
            status.setError(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.error.InvalidNamespace", val.getMessage()));
            return status;
        }
        return status;
    }

    protected IStatus classNameChanged() {
        IProject project;
        StatusInfo status = new StatusInfo();
        IQualifiedTypeName className = this.getClassTypeName();
        if (className == null) {
            status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.EnterClassName"));
            return status;
        }
        if (className.isQualified()) {
            status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.QualifiedClassName"));
            return status;
        }
        IStatus val = CConventions.validateClassName((String)className.toString());
        if (val.getSeverity() == 4) {
            status.setError(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.error.InvalidClassName", val.getMessage()));
            return status;
        }
        if (val.getSeverity() == 2) {
            status.setWarning(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.warning.ClassNameDiscouraged", val.getMessage()));
        }
        if ((project = this.getCurrentProject()) != null) {
            ITypeInfo[] types;
            IQualifiedTypeName enclosing;
            this.prepareTypeCache();
            IQualifiedTypeName fullyQualifiedName = className;
            if (this.isEnclosingTypeSelected() && (enclosing = this.getEnclosingTypeName()) != null) {
                fullyQualifiedName = enclosing.append(className);
            }
            if ((types = AllTypesCache.getTypes((IProject)project, (IQualifiedTypeName)fullyQualifiedName, (boolean)false, (boolean)true)).length > 0) {
                ITypeInfo currType;
                boolean foundClass = false;
                boolean exactMatch = false;
                int i = 0;
                while (i < types.length) {
                    currType = types[i];
                    if (currType.getCElementType() == 64 || currType.getCElementType() == 65) {
                        foundClass = true;
                        exactMatch = currType.getQualifiedTypeName().equals(fullyQualifiedName);
                        if (exactMatch) break;
                    }
                    ++i;
                }
                if (foundClass) {
                    if (exactMatch) {
                        status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.ClassNameExists"));
                    } else {
                        status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.ClassNameExistsDifferentCase"));
                    }
                    return status;
                }
                exactMatch = false;
                i = 0;
                while (i < types.length) {
                    currType = types[i];
                    if (currType.getCElementType() != 64 && currType.getCElementType() != 65 && (exactMatch = currType.getQualifiedTypeName().equals(fullyQualifiedName))) break;
                    ++i;
                }
                if (exactMatch) {
                    status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.TypeMatchingClassExists"));
                } else {
                    status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.TypeMatchingClassExistsDifferentCase"));
                }
                return status;
            }
        }
        return status;
    }

    protected IStatus baseClassesChanged() {
        IBaseClassInfo[] baseClasses;
        IPath folderPath;
        StatusInfo status = new StatusInfo();
        if (this.fErrorIfBaseClassNotInPath && (folderPath = this.getSourceFolderFullPath()) != null && (baseClasses = this.getBaseClasses()) != null && baseClasses.length > 0) {
            IScannerInfo info;
            IProject project = PathUtil.getEnclosingProject((IPath)folderPath);
            IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(project);
            if (provider != null && (info = provider.getScannerInformation((IResource)project)) != null) {
                String[] includePaths = info.getIncludePaths();
                int i = 0;
                while (i < baseClasses.length) {
                    ITypeInfo baseType = baseClasses[i].getType();
                    if (!this.isTypeReachable(baseType, project, includePaths)) {
                        status.setError(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.error.BaseClassNotExistsInProject", baseType.getQualifiedTypeName().toString()));
                        return status;
                    }
                    ++i;
                }
            }
        }
        return status;
    }

    private boolean isTypeReachable(ITypeInfo type, IProject project, String[] includePaths) {
        IProject baseProject = type.getEnclosingProject();
        if (baseProject != null) {
            if (baseProject.equals((Object)project)) {
                return true;
            }
            ITypeReference ref = type.getResolvedReference();
            int i = 0;
            while (i < includePaths.length) {
                Path includePath = new Path(includePaths[i]);
                if (ref != null ? includePath.isPrefixOf(ref.getLocation()) : baseProject.getLocation().isPrefixOf((IPath)includePath)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected IStatus methodStubsChanged() {
        StatusInfo status = new StatusInfo();
        return status;
    }

    protected IStatus headerFileChanged() {
        StatusInfo status = new StatusInfo();
        if (this.isUseDefaultSelected()) {
            return status;
        }
        IPath path = this.getHeaderFileFullPath();
        if (path == null) {
            status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.EnterHeaderFileName"));
            return status;
        }
        IPath sourceFolderPath = this.getSourceFolderFullPath();
        if (sourceFolderPath == null || !sourceFolderPath.isPrefixOf(path)) {
            status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.HeaderFileNotInSourceFolder"));
            return status;
        }
        boolean fileExists = false;
        IResource file = this.getWorkspaceRoot().findMember(path);
        if (file != null && file.exists()) {
            if (file.getType() == 1) {
                IProject proj = file.getProject();
                if (!proj.isOpen()) {
                    status.setError(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.error.NotAFile", path));
                    return status;
                }
                fileExists = true;
                if (!CoreModel.hasCCNature((IProject)proj) && !CoreModel.hasCNature((IProject)proj)) {
                    status.setWarning(NewClassWizardMessages.getString("NewClassCreationWizardPage.warning.NotInACProject"));
                } else {
                    status.setWarning(NewClassWizardMessages.getString("NewClassCreationWizardPage.warning.HeaderFileExists"));
                }
            } else {
                status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.NotAFile"));
                return status;
            }
        }
        IPath folderPath = path.removeLastSegments(1).makeRelative();
        IResource folder = this.getWorkspaceRoot().findMember(folderPath);
        if (folder == null || !folder.exists() || folder.getType() != 4 && folder.getType() != 2) {
            status.setError(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.error.FolderDoesNotExist", folderPath));
            return status;
        }
        if (!fileExists) {
            IStatus val = CConventions.validateHeaderFileName((IProject)this.getCurrentProject(), (String)path.lastSegment());
            if (val.getSeverity() == 4) {
                status.setError(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.error.InvalidHeaderFileName", val.getMessage()));
                return status;
            }
            if (val.getSeverity() == 2) {
                status.setWarning(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.warning.HeaderFileNameDiscouraged", val.getMessage()));
            }
        }
        return status;
    }

    protected IStatus sourceFileChanged() {
        StatusInfo status = new StatusInfo();
        if (this.isUseDefaultSelected()) {
            return status;
        }
        IPath path = this.getSourceFileFullPath();
        if (path == null) {
            status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.EnterSourceFileName"));
            return status;
        }
        IPath sourceFolderPath = this.getSourceFolderFullPath();
        if (sourceFolderPath == null || !sourceFolderPath.isPrefixOf(path)) {
            status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.SourceFileNotInSourceFolder"));
            return status;
        }
        boolean fileExists = false;
        IResource file = this.getWorkspaceRoot().findMember(path);
        if (file != null && file.exists()) {
            if (file.getType() == 1) {
                IProject proj = file.getProject();
                if (!proj.isOpen()) {
                    status.setError(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.error.NotAFile", path));
                    return status;
                }
                fileExists = true;
                if (!CoreModel.hasCCNature((IProject)proj) && !CoreModel.hasCNature((IProject)proj)) {
                    status.setWarning(NewClassWizardMessages.getString("NewClassCreationWizardPage.warning.NotInACProject"));
                } else {
                    status.setWarning(NewClassWizardMessages.getString("NewClassCreationWizardPage.warning.SourceFileExists"));
                }
            } else {
                status.setError(NewClassWizardMessages.getString("NewClassCreationWizardPage.error.NotAFile"));
                return status;
            }
        }
        IPath folderPath = path.removeLastSegments(1).makeRelative();
        IResource folder = this.getWorkspaceRoot().findMember(folderPath);
        if (folder == null || !folder.exists() || folder.getType() != 4 && folder.getType() != 2) {
            status.setError(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.error.FolderDoesNotExist", folderPath));
            return status;
        }
        if (!fileExists) {
            IStatus val = CConventions.validateSourceFileName((IProject)this.getCurrentProject(), (String)path.lastSegment());
            if (val.getSeverity() == 4) {
                status.setError(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.error.InvalidSourceFileName", val.getMessage()));
                return status;
            }
            if (val.getSeverity() == 2) {
                status.setWarning(NewClassWizardMessages.getFormattedString("NewClassCreationWizardPage.warning.SourceFileNameDiscouraged", val.getMessage()));
            }
        }
        return status;
    }

    protected void handleFieldChanged(int fields) {
        if (fields == 0) {
            return;
        }
        if (this.fieldChanged(fields, 1)) {
            this.fSourceFolderStatus = this.sourceFolderChanged();
        }
        if (this.fieldChanged(fields, 2)) {
            this.fEnclosingTypeStatus = this.enclosingTypeChanged();
        }
        if (this.fieldChanged(fields, 4)) {
            this.fClassNameStatus = this.classNameChanged();
        }
        if (this.fieldChanged(fields, 8)) {
            this.fBaseClassesStatus = this.baseClassesChanged();
        }
        if (this.fieldChanged(fields, 16)) {
            this.fMethodStubsStatus = this.methodStubsChanged();
        }
        if (this.fieldChanged(fields, 32)) {
            this.fHeaderFileStatus = this.headerFileChanged();
        }
        if (this.fieldChanged(fields, 64)) {
            this.fSourceFileStatus = this.sourceFileChanged();
        }
        this.doStatusUpdate();
    }

    private boolean fieldChanged(int fields, int fieldID) {
        return (fields & fieldID) != 0;
    }

    protected void doStatusUpdate() {
        IStatus lastStatus = this.getLastFocusedStatus();
        IStatus[] status = new IStatus[]{lastStatus, this.fSourceFolderStatus != lastStatus ? this.fSourceFolderStatus : this.STATUS_OK, this.fEnclosingTypeStatus != lastStatus ? this.fEnclosingTypeStatus : this.STATUS_OK, this.fClassNameStatus != lastStatus ? this.fClassNameStatus : this.STATUS_OK, this.fBaseClassesStatus != lastStatus ? this.fBaseClassesStatus : this.STATUS_OK, this.fMethodStubsStatus != lastStatus ? this.fMethodStubsStatus : this.STATUS_OK, this.fHeaderFileStatus != lastStatus ? this.fHeaderFileStatus : this.STATUS_OK, this.fSourceFileStatus != lastStatus ? this.fSourceFileStatus : this.STATUS_OK};
        this.updateStatus(status);
    }

    private IStatus getLastFocusedStatus() {
        switch (this.fLastFocusedField) {
            case 1: {
                return this.fSourceFolderStatus;
            }
            case 2: {
                return this.fEnclosingTypeStatus;
            }
            case 4: {
                return this.fClassNameStatus;
            }
            case 8: {
                return this.fBaseClassesStatus;
            }
            case 16: {
                return this.fMethodStubsStatus;
            }
            case 32: {
                return this.fHeaderFileStatus;
            }
            case 64: {
                return this.fSourceFileStatus;
            }
        }
        return this.STATUS_OK;
    }

    public IPath getSourceFolderFullPath() {
        String text = this.fSourceFolderDialogField.getText();
        if (text.length() > 0) {
            return new Path(text).makeAbsolute();
        }
        return null;
    }

    public void setSourceFolderFullPath(IPath folderPath, boolean update) {
        String str = folderPath != null ? folderPath.makeRelative().toString() : "";
        this.fSourceFolderDialogField.setTextWithoutUpdate(str);
        if (update) {
            this.fSourceFolderDialogField.dialogFieldChanged();
        }
    }

    private IProject getCurrentProject() {
        IPath folderPath = this.getSourceFolderFullPath();
        if (folderPath != null) {
            return PathUtil.getEnclosingProject((IPath)folderPath);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private ICElement getSourceFolderFromPath(IPath path) {
        if (path != null) ** GOTO lbl12
        return null;
lbl-1000:
        // 1 sources

        {
            res = this.fWorkspaceRoot.findMember(path);
            if (res != null && res.exists() && ((resType = res.getType()) == 4 || resType == 2)) {
                elem = CoreModel.getDefault().create(res.getFullPath());
                sourceFolder = CModelUtil.getSourceFolder(elem);
                if (sourceFolder != null) {
                    return sourceFolder;
                }
                if (resType == 4) {
                    return elem;
                }
            }
            path = path.removeLastSegments(1);
lbl12:
            // 2 sources

            ** while (!path.isEmpty())
        }
lbl13:
        // 1 sources

        return null;
    }

    public IQualifiedTypeName getEnclosingTypeName() {
        String text = this.fEnclosingTypeDialogField.getText();
        if (text.length() > 0) {
            return new QualifiedTypeName(text);
        }
        return null;
    }

    public void setEnclosingTypeName(IQualifiedTypeName typeName, boolean isNamespace, boolean update) {
        if (typeName != null) {
            this.fEnclosingTypeDialogField.setTextWithoutUpdate(typeName.toString());
        } else {
            this.fEnclosingTypeDialogField.setTextWithoutUpdate("");
        }
        if (update) {
            this.fEnclosingTypeDialogField.dialogFieldChanged();
        }
    }

    public boolean isEnclosingTypeSelected() {
        return this.fEnclosingTypeSelection.isSelected();
    }

    public IQualifiedTypeName getClassTypeName() {
        String text = this.fClassNameDialogField.getText();
        if (text.length() > 0) {
            return new QualifiedTypeName(text);
        }
        return null;
    }

    public void setClassTypeName(IQualifiedTypeName typeName, boolean update) {
        this.fClassNameDialogField.setTextWithoutUpdate(typeName != null ? typeName.toString() : "");
        if (update) {
            this.fClassNameDialogField.dialogFieldChanged();
        }
    }

    public IBaseClassInfo[] getBaseClasses() {
        List classesList = this.fBaseClassesDialogField.getElements();
        return classesList.toArray(new IBaseClassInfo[classesList.size()]);
    }

    public IMethodStub[] getCheckedMethodStubs() {
        return this.fMethodStubsDialogField.getCheckedMethodStubs();
    }

    public boolean isUseDefaultSelected() {
        return this.fUseDefaultSelection.isSelected();
    }

    public IPath getHeaderFileFullPath() {
        IPath folderPath;
        String str = this.fHeaderFileDialogField.getText();
        Path path = null;
        if (str.length() > 0 && !(path = new Path(str)).isAbsolute() && (folderPath = this.getSourceFolderFullPath()) != null) {
            path = folderPath.append((IPath)path);
        }
        return path;
    }

    public void setHeaderFileFullPath(IPath path, boolean update) {
        String str = "";
        if (path != null) {
            IPath relativePath;
            IPath sourceFolder = this.getSourceFolderFullPath();
            if (sourceFolder != null && (relativePath = PathUtil.makeRelativePath((IPath)path, (IPath)sourceFolder)) != null) {
                path = relativePath;
            }
            str = path.toString();
        }
        this.fHeaderFileDialogField.setTextWithoutUpdate(str);
        if (update) {
            this.fHeaderFileDialogField.dialogFieldChanged();
        }
    }

    public IPath getSourceFileFullPath() {
        IPath folderPath;
        String str = this.fSourceFileDialogField.getText();
        Path path = null;
        if (str.length() > 0 && !(path = new Path(str)).isAbsolute() && (folderPath = this.getSourceFolderFullPath()) != null) {
            path = folderPath.append((IPath)path);
        }
        return path;
    }

    public void setSourceFileFullPath(IPath path, boolean update) {
        String str = "";
        if (path != null) {
            IPath relativePath;
            IPath sourceFolder = this.getSourceFolderFullPath();
            if (sourceFolder != null && (relativePath = PathUtil.makeRelativePath((IPath)path, (IPath)sourceFolder)) != null) {
                path = relativePath;
            }
            str = path.makeRelative().toString();
        }
        this.fSourceFileDialogField.setTextWithoutUpdate(str);
        if (update) {
            this.fSourceFileDialogField.dialogFieldChanged();
        }
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return this.fWorkspaceRoot;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    protected void setFocus() {
        this.fClassNameDialogField.setFocus();
    }

    public void addBaseClass(ITypeInfo newBaseClass, ASTAccessVisibility access, boolean isVirtual) {
        List baseClasses = this.fBaseClassesDialogField.getElements();
        boolean classExists = false;
        if (baseClasses != null) {
            Iterator i = baseClasses.iterator();
            while (i.hasNext()) {
                BaseClassInfo info = (BaseClassInfo)i.next();
                if (!info.getType().equals(newBaseClass)) continue;
                classExists = true;
                break;
            }
        }
        if (!classExists) {
            this.prepareTypeCache();
            if (newBaseClass.getResolvedReference() == null) {
                final ITypeInfo[] typesToResolve = new ITypeInfo[]{newBaseClass};
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
                        AllTypesCache.resolveTypeLocation((ITypeInfo)typesToResolve[0], (IProgressMonitor)progressMonitor);
                        if (progressMonitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                    }
                };
                try {
                    this.getContainer().run(true, true, runnable);
                }
                catch (InvocationTargetException e) {
                    String title = NewClassWizardMessages.getString("NewClassCreationWizardPage.getTypes.exception.title");
                    String message = NewClassWizardMessages.getString("NewClassCreationWizardPage.getTypes.exception.message");
                    ExceptionHandler.handle(e, title, message);
                    return;
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            this.fBaseClassesDialogField.addBaseClass(new BaseClassInfo(newBaseClass, access, isVirtual));
        }
    }

    public void addMethodStub(IMethodStub methodStub, boolean checked) {
        this.fMethodStubsDialogField.addMethodStub(methodStub, checked);
    }

    void prepareTypeCache() {
        TypeSearchScope scope = new TypeSearchScope(true);
        if (!AllTypesCache.isCacheUpToDate((ITypeSearchScope)scope)) {
            IRunnableWithProgress runnable = new IRunnableWithProgress((ITypeSearchScope)scope){
                private final /* synthetic */ ITypeSearchScope val$scope;
                {
                    this.val$scope = iTypeSearchScope;
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    AllTypesCache.updateCache((ITypeSearchScope)this.val$scope, (IProgressMonitor)monitor);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
            };
            try {
                this.getContainer().run(true, true, runnable);
            }
            catch (InvocationTargetException e) {
                String title = NewClassWizardMessages.getString("NewClassCreationWizardPage.getTypes.exception.title");
                String message = NewClassWizardMessages.getString("NewClassCreationWizardPage.getTypes.exception.message");
                ExceptionHandler.handle(e, title, message);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void setEnclosingTypeSelection(boolean isSelected, boolean canBeModified) {
        this.fEnclosingTypeSelection.setSelection(isSelected);
        this.fEnclosingTypeSelection.setEnabled(canBeModified);
        this.updateEnclosingTypeEnableState();
    }

    public void setFileGroupSelection(boolean isSelected, boolean canBeModified) {
        this.fUseDefaultSelection.setSelection(isSelected);
        this.fUseDefaultSelection.setEnabled(canBeModified);
        this.updateFileGroupEnableState();
    }

    void updateEnclosingTypeEnableState() {
        boolean enclosing = this.isEnclosingTypeSelected();
        this.fEnclosingTypeDialogField.setEnabled(enclosing);
    }

    void updateFileGroupEnableState() {
        boolean filegroup = !this.isUseDefaultSelected();
        this.fHeaderFileDialogField.setEnabled(filegroup);
        this.fSourceFileDialogField.setEnabled(filegroup);
    }

    IPath chooseSourceFolder(IPath initialPath) {
        Object result;
        ICProject cProject;
        ISourceRoot projRoot;
        ICElement initElement = this.getSourceFolderFromPath(initialPath);
        if (initElement instanceof ISourceRoot && (projRoot = (cProject = initElement.getCProject()).findSourceRoot((IResource)cProject.getProject())) != null && projRoot.equals(initElement)) {
            initElement = cProject;
        }
        SourceFolderSelectionDialog dialog = new SourceFolderSelectionDialog(this.getShell());
        dialog.setInput(CoreModel.create((IWorkspaceRoot)this.fWorkspaceRoot));
        dialog.setInitialSelection(initElement);
        if (dialog.open() == 0 && (result = dialog.getFirstResult()) instanceof ICElement) {
            ICProject cproject;
            ISourceRoot folder;
            ICElement element = (ICElement)result;
            if (element instanceof ICProject && (folder = (cproject = (ICProject)element).findSourceRoot((IResource)cproject.getProject())) != null) {
                return folder.getResource().getFullPath();
            }
            return element.getResource().getFullPath();
        }
        return null;
    }

    ITypeInfo chooseNamespace() {
        IProject project = this.getCurrentProject();
        TypeSearchScope scope = project != null ? new TypeSearchScope(project) : new TypeSearchScope(true);
        this.prepareTypeCache();
        Object[] elements = AllTypesCache.getNamespaces((ITypeSearchScope)scope, (boolean)false);
        if (elements == null || elements.length == 0) {
            String title = NewClassWizardMessages.getString("NewClassCreationWizardPage.getTypes.noNamespaces.title");
            String message = NewClassWizardMessages.getString("NewClassCreationWizardPage.getTypes.noNamespaces.message");
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
            return null;
        }
        NamespaceSelectionDialog dialog = new NamespaceSelectionDialog(this.getShell());
        dialog.setElements(elements);
        int result = dialog.open();
        if (result == 0) {
            ITypeInfo namespace = (ITypeInfo)dialog.getFirstResult();
            return namespace;
        }
        return null;
    }

    ITypeInfo chooseEnclosingClass() {
        IProject project = this.getCurrentProject();
        TypeSearchScope scope = project != null ? new TypeSearchScope(project) : new TypeSearchScope(true);
        this.prepareTypeCache();
        Object[] elements = AllTypesCache.getTypes((ITypeSearchScope)scope, (int[])this.ENCLOSING_CLASS_TYPES);
        if (elements == null || elements.length == 0) {
            String title = NewClassWizardMessages.getString("NewClassCreationWizardPage.getTypes.noClasses.title");
            String message = NewClassWizardMessages.getString("NewClassCreationWizardPage.getTypes.noClasses.message");
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
            return null;
        }
        EnclosingClassSelectionDialog dialog = new EnclosingClassSelectionDialog(this.getShell());
        dialog.setElements(elements);
        int result = dialog.open();
        if (result == 0) {
            ITypeInfo enclosingClass = (ITypeInfo)dialog.getFirstResult();
            if (enclosingClass != null && enclosingClass.getResolvedReference() == null) {
                this.prepareTypeCache();
                final ITypeInfo[] typesToResolve = new ITypeInfo[]{enclosingClass};
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
                        AllTypesCache.resolveTypeLocation((ITypeInfo)typesToResolve[0], (IProgressMonitor)progressMonitor);
                        if (progressMonitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                    }
                };
                try {
                    this.getContainer().run(true, true, runnable);
                }
                catch (InvocationTargetException e) {
                    String title = NewClassWizardMessages.getString("NewClassCreationWizardPage.getTypes.exception.title");
                    String message = NewClassWizardMessages.getString("NewClassCreationWizardPage.getTypes.exception.message");
                    ExceptionHandler.handle(e, title, message);
                    return null;
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
            }
            return enclosingClass;
        }
        return null;
    }

    void chooseBaseClasses() {
        this.prepareTypeCache();
        Object[] elements = this.getAllReachableTypes();
        if (elements == null || elements.length == 0) {
            String title = NewClassWizardMessages.getString("NewClassCreationWizardPage.getTypes.noClasses.title");
            String message = NewClassWizardMessages.getString("NewClassCreationWizardPage.getTypes.noClasses.message");
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
            return;
        }
        List oldContents = this.fBaseClassesDialogField.getElements();
        NewBaseClassSelectionDialog dialog = new NewBaseClassSelectionDialog(this.getShell());
        dialog.addListener(new NewBaseClassSelectionDialog.ITypeSelectionListener(){

            public void typeAdded(ITypeInfo newBaseClass) {
                NewClassCreationWizardPage.this.addBaseClass(newBaseClass, ASTAccessVisibility.PUBLIC, false);
            }
        });
        dialog.setElements(elements);
        int result = dialog.open();
        if (result != 0) {
            this.fBaseClassesDialogField.setElements(oldContents);
        }
    }

    private ITypeInfo[] getAllReachableTypes() {
        IPath folderPath;
        ITypeInfo[] elements = AllTypesCache.getTypes((ITypeSearchScope)new TypeSearchScope(true), (int[])this.CLASS_TYPES);
        if (elements != null && elements.length > 0 && (folderPath = this.getSourceFolderFullPath()) != null) {
            IScannerInfo info;
            IProject project = PathUtil.getEnclosingProject((IPath)folderPath);
            IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(project);
            if (provider != null && (info = provider.getScannerInformation((IResource)project)) != null) {
                String[] includePaths = info.getIncludePaths();
                ArrayList<ITypeInfo> filteredTypes = new ArrayList<ITypeInfo>();
                int i = 0;
                while (i < elements.length) {
                    ITypeInfo baseType = elements[i];
                    if (this.isTypeReachable(baseType, project, includePaths)) {
                        filteredTypes.add(baseType);
                    }
                    ++i;
                }
                return filteredTypes.toArray(new ITypeInfo[filteredTypes.size()]);
            }
        }
        return elements;
    }

    IPath chooseHeaderFile() {
        SourceFileSelectionDialog dialog = new SourceFileSelectionDialog(this.getShell());
        dialog.setTitle(NewClassWizardMessages.getString("NewClassCreationWizardPage.ChooseHeaderFileDialog.title"));
        ICModel input = CoreModel.create((IWorkspaceRoot)this.fWorkspaceRoot);
        IProject project = this.getCurrentProject();
        if (project != null) {
            input = CoreModel.getDefault().create(project);
        }
        dialog.setInput((ICElement)input);
        IPath filePath = this.getHeaderFileFullPath();
        if (filePath != null) {
            String folderName = filePath.removeLastSegments(1).toString();
            String fileName = filePath.lastSegment();
            dialog.setInitialSelection(folderName, fileName);
        } else {
            filePath = this.getSourceFolderFullPath();
            if (filePath != null) {
                dialog.setInitialSelection(filePath.toString(), null);
            }
        }
        if (dialog.open() == 0) {
            return dialog.getFilePath();
        }
        return null;
    }

    IPath chooseSourceFile() {
        SourceFileSelectionDialog dialog = new SourceFileSelectionDialog(this.getShell());
        dialog.setTitle(NewClassWizardMessages.getString("NewClassCreationWizardPage.ChooseSourceFileDialog.title"));
        ICModel input = CoreModel.create((IWorkspaceRoot)this.fWorkspaceRoot);
        IProject project = this.getCurrentProject();
        if (project != null) {
            input = CoreModel.getDefault().create(project);
        }
        dialog.setInput((ICElement)input);
        IPath filePath = this.getSourceFileFullPath();
        if (filePath != null) {
            String folderName = filePath.removeLastSegments(1).toString();
            String fileName = filePath.lastSegment();
            dialog.setInitialSelection(folderName, fileName);
        } else {
            filePath = this.getSourceFolderFullPath();
            if (filePath != null) {
                dialog.setInitialSelection(filePath.toString(), null);
            }
        }
        if (dialog.open() == 0) {
            return dialog.getFilePath();
        }
        return null;
    }

    public void createClass(IProgressMonitor monitor) {
        try {
            this.fCodeGenerator = new NewClassCodeGenerator(this.getHeaderFileFullPath(), this.getSourceFileFullPath(), this.getClassTypeName(), this.isEnclosingTypeSelected() ? this.getEnclosingTypeName() : null, this.getBaseClasses(), this.getCheckedMethodStubs());
            this.fCodeGenerator.createClass(monitor);
        }
        catch (NewClassCodeGenerator.CodeGeneratorException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public ICElement getCreatedClass() {
        if (this.fCodeGenerator != null) {
            return this.fCodeGenerator.getCreatedClass();
        }
        return null;
    }

    public ITranslationUnit getCreatedHeaderTU() {
        if (this.fCodeGenerator != null) {
            return this.fCodeGenerator.getCreatedHeaderTU();
        }
        return null;
    }

    public ITranslationUnit getCreatedSourceTU() {
        if (this.fCodeGenerator != null) {
            return this.fCodeGenerator.getCreatedSourceTU();
        }
        return null;
    }

    private IPath updateSourceFolderFromPath(IPath filePath) {
        ICElement folder = this.getSourceFolderFromPath(filePath);
        if (folder != null) {
            return folder.getPath();
        }
        IProject proj = PathUtil.getEnclosingProject((IPath)filePath);
        if (proj != null) {
            return proj.getFullPath();
        }
        return null;
    }

    private final class StatusFocusListener
    implements FocusListener {
        private int fieldID;

        public StatusFocusListener(int fieldID) {
            this.fieldID = fieldID;
        }

        public void focusGained(FocusEvent e) {
            NewClassCreationWizardPage.this.fLastFocusedField = this.fieldID;
            NewClassCreationWizardPage.this.doStatusUpdate();
        }

        public void focusLost(FocusEvent e) {
            NewClassCreationWizardPage.this.fLastFocusedField = 0;
            NewClassCreationWizardPage.this.doStatusUpdate();
        }
    }

    private class SourceFolderFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        SourceFolderFieldAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            IPath oldFolderPath = NewClassCreationWizardPage.this.getSourceFolderFullPath();
            IPath newFolderPath = NewClassCreationWizardPage.this.chooseSourceFolder(oldFolderPath);
            if (newFolderPath != null) {
                IPath headerPath = NewClassCreationWizardPage.this.getHeaderFileFullPath();
                IPath sourcePath = NewClassCreationWizardPage.this.getSourceFileFullPath();
                NewClassCreationWizardPage.this.setSourceFolderFullPath(newFolderPath, false);
                if (!NewClassCreationWizardPage.this.isUseDefaultSelected()) {
                    if (oldFolderPath != null && oldFolderPath.matchingFirstSegments(newFolderPath) == 0) {
                        if (headerPath != null) {
                            headerPath = newFolderPath.append(headerPath.lastSegment());
                        }
                        if (sourcePath != null) {
                            sourcePath = newFolderPath.append(sourcePath.lastSegment());
                        }
                    }
                    NewClassCreationWizardPage.this.setHeaderFileFullPath(headerPath, false);
                    NewClassCreationWizardPage.this.setSourceFileFullPath(sourcePath, false);
                }
                NewClassCreationWizardPage.this.handleFieldChanged(127);
            }
        }

        public void dialogFieldChanged(DialogField field) {
            NewClassCreationWizardPage.this.handleFieldChanged(127);
        }
    }

    private class EnclosingTypeFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        EnclosingTypeFieldAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            if (field == NewClassCreationWizardPage.this.fEnclosingTypeDialogField) {
                ITypeInfo enclosingType = null;
                boolean isNamespace = true;
                enclosingType = NewClassCreationWizardPage.this.chooseNamespace();
                if (enclosingType != null) {
                    int changedFields = 6;
                    IPath oldFolderPath = NewClassCreationWizardPage.this.getSourceFolderFullPath();
                    if (oldFolderPath == null) {
                        IPath headerPath = NewClassCreationWizardPage.this.getHeaderFileFullPath();
                        IPath sourcePath = NewClassCreationWizardPage.this.getSourceFileFullPath();
                        IPath newFolderPath = NewClassCreationWizardPage.this.updateSourceFolderFromPath(enclosingType.getEnclosingProject().getFullPath());
                        if (newFolderPath != null) {
                            changedFields |= 0x61;
                            if (oldFolderPath != null && oldFolderPath.matchingFirstSegments(newFolderPath) == 0) {
                                if (headerPath != null) {
                                    headerPath = newFolderPath.append(headerPath.lastSegment());
                                }
                                if (sourcePath != null) {
                                    sourcePath = newFolderPath.append(sourcePath.lastSegment());
                                }
                            }
                            NewClassCreationWizardPage.this.setSourceFolderFullPath(newFolderPath, false);
                            NewClassCreationWizardPage.this.setHeaderFileFullPath(headerPath, false);
                            NewClassCreationWizardPage.this.setSourceFileFullPath(sourcePath, false);
                        }
                    }
                    IQualifiedTypeName typeName = enclosingType.getQualifiedTypeName();
                    NewClassCreationWizardPage.this.setEnclosingTypeName(typeName, isNamespace, false);
                    NewClassCreationWizardPage.this.handleFieldChanged(changedFields);
                }
            }
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == NewClassCreationWizardPage.this.fEnclosingTypeSelection) {
                NewClassCreationWizardPage.this.updateEnclosingTypeEnableState();
            }
            NewClassCreationWizardPage.this.handleFieldChanged(6);
        }
    }

    private class ClassNameFieldAdapter
    implements IDialogFieldListener {
        ClassNameFieldAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            int changedFields = 4;
            if (NewClassCreationWizardPage.this.isUseDefaultSelected()) {
                NewClassCreationWizardPage.this.updateFilesFromClassName(NewClassCreationWizardPage.this.fClassNameDialogField.getText());
                changedFields |= 0x60;
            }
            NewClassCreationWizardPage.this.handleFieldChanged(changedFields);
        }
    }

    private final class BaseClassesFieldAdapter
    implements IListAdapter {
        BaseClassesFieldAdapter() {
        }

        public void customButtonPressed(ListDialogField field, int index) {
            if (index == 0) {
                NewClassCreationWizardPage.this.chooseBaseClasses();
            }
            NewClassCreationWizardPage.this.handleFieldChanged(8);
        }

        public void selectionChanged(ListDialogField field) {
        }

        public void doubleClicked(ListDialogField field) {
        }
    }

    private final class MethodStubsFieldAdapter
    implements IListAdapter {
        MethodStubsFieldAdapter() {
        }

        public void customButtonPressed(ListDialogField field, int index) {
        }

        public void selectionChanged(ListDialogField field) {
        }

        public void doubleClicked(ListDialogField field) {
        }
    }

    private class FileGroupFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        FileGroupFieldAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            IPath filePath = null;
            IPath headerPath = NewClassCreationWizardPage.this.getHeaderFileFullPath();
            IPath sourcePath = NewClassCreationWizardPage.this.getSourceFileFullPath();
            if (field == NewClassCreationWizardPage.this.fHeaderFileDialogField) {
                filePath = NewClassCreationWizardPage.this.chooseHeaderFile();
                if (filePath != null) {
                    headerPath = filePath;
                }
            } else if (field == NewClassCreationWizardPage.this.fSourceFileDialogField && (filePath = NewClassCreationWizardPage.this.chooseSourceFile()) != null) {
                sourcePath = filePath;
            }
            if (filePath != null) {
                int segments;
                IPath folderPath = null;
                int changedFields = 0;
                int headerSegments = 0;
                int sourceSegments = 0;
                if (headerPath != null) {
                    headerSegments = filePath.matchingFirstSegments(headerPath);
                }
                if (sourcePath != null) {
                    sourceSegments = filePath.matchingFirstSegments(sourcePath);
                }
                if ((segments = Math.min(headerSegments, sourceSegments)) > 0) {
                    IPath newFolderPath = filePath.uptoSegment(segments);
                    folderPath = NewClassCreationWizardPage.this.updateSourceFolderFromPath(newFolderPath);
                }
                if (folderPath != null) {
                    changedFields |= 0x61;
                    NewClassCreationWizardPage.this.setSourceFolderFullPath(folderPath, false);
                    NewClassCreationWizardPage.this.setHeaderFileFullPath(headerPath, false);
                    NewClassCreationWizardPage.this.setSourceFileFullPath(sourcePath, false);
                }
                if (field == NewClassCreationWizardPage.this.fHeaderFileDialogField) {
                    NewClassCreationWizardPage.this.setHeaderFileFullPath(filePath, false);
                    changedFields |= 0x20;
                } else if (field == NewClassCreationWizardPage.this.fSourceFileDialogField) {
                    NewClassCreationWizardPage.this.setSourceFileFullPath(filePath, false);
                    changedFields |= 0x40;
                }
                NewClassCreationWizardPage.this.handleFieldChanged(changedFields);
            }
        }

        public void dialogFieldChanged(DialogField field) {
            int changedFields = 0;
            if (field == NewClassCreationWizardPage.this.fUseDefaultSelection) {
                boolean enabled = !NewClassCreationWizardPage.this.isUseDefaultSelected();
                NewClassCreationWizardPage.this.fHeaderFileDialogField.setEnabled(enabled);
                NewClassCreationWizardPage.this.fSourceFileDialogField.setEnabled(enabled);
                if (!enabled) {
                    NewClassCreationWizardPage.this.updateFilesFromClassName(NewClassCreationWizardPage.this.fClassNameDialogField.getText());
                }
                changedFields = 96;
                NewClassCreationWizardPage.this.updateFileGroupEnableState();
            }
            if (field == NewClassCreationWizardPage.this.fHeaderFileDialogField) {
                changedFields |= 0x20;
            } else if (field == NewClassCreationWizardPage.this.fSourceFileDialogField) {
                changedFields |= 0x40;
            }
            NewClassCreationWizardPage.this.handleFieldChanged(changedFields);
        }
    }
}

