/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Builder
extends BuildObject
implements IBuilder {
    private static final String EMPTY_STRING = new String();
    private IBuilder superClass;
    private String superClassId;
    private IToolChain parent;
    private String unusedChildren;
    private String errorParserIds;
    private Boolean isAbstract;
    private String command;
    private String args;
    private IConfigurationElement buildFileGeneratorElement;
    private boolean isExtensionBuilder = false;
    private boolean isDirty = false;
    private boolean resolved = true;

    public Builder(IToolChain parent, IManagedConfigElement element) {
        this.parent = parent;
        this.isExtensionBuilder = true;
        this.resolved = false;
        this.loadFromManifest(element);
        ManagedBuildManager.addExtensionBuilder(this);
    }

    public Builder(ToolChain parent, IBuilder superClass, String Id, String name, boolean isExtensionElement) {
        this.parent = parent;
        this.superClass = superClass;
        if (this.superClass != null) {
            this.superClassId = this.superClass.getId();
        }
        this.setId(Id);
        this.setName(name);
        this.isExtensionBuilder = isExtensionElement;
        if (isExtensionElement) {
            ManagedBuildManager.addExtensionBuilder(this);
        } else {
            this.setDirty(true);
        }
    }

    public Builder(IToolChain parent, Element element) {
        this.parent = parent;
        this.isExtensionBuilder = false;
        this.loadFromProject(element);
    }

    public Builder(IToolChain parent, String Id, String name, Builder builder) {
        this.parent = parent;
        this.superClass = builder.superClass;
        if (this.superClass != null && builder.superClassId != null) {
            this.superClassId = new String(builder.superClassId);
        }
        this.setId(Id);
        this.setName(name);
        this.isExtensionBuilder = false;
        if (builder.unusedChildren != null) {
            this.unusedChildren = new String(builder.unusedChildren);
        }
        if (builder.errorParserIds != null) {
            this.errorParserIds = new String(builder.errorParserIds);
        }
        if (builder.isAbstract != null) {
            this.isAbstract = new Boolean(builder.isAbstract);
        }
        if (builder.command != null) {
            this.command = new String(builder.command);
        }
        if (builder.args != null) {
            this.args = new String(builder.args);
        }
        this.buildFileGeneratorElement = builder.buildFileGeneratorElement;
        this.setDirty(true);
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        ManagedBuildManager.putConfigElement(this, element);
        this.setId(element.getAttribute("id"));
        this.setName(element.getAttribute("name"));
        this.superClassId = element.getAttribute("superClass");
        this.unusedChildren = element.getAttribute("unusedChildren");
        String isAbs = element.getAttribute("isAbstract");
        if (isAbs != null) {
            this.isAbstract = new Boolean("true".equals(isAbs));
        }
        this.command = element.getAttribute("command");
        this.args = element.getAttribute("arguments");
        this.errorParserIds = element.getAttribute("errorParsers");
        String buildfileGenerator = element.getAttribute("buildfileGenerator");
        if (buildfileGenerator != null && element instanceof DefaultManagedConfigElement) {
            this.buildFileGeneratorElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
    }

    protected void loadFromProject(Element element) {
        String isAbs;
        this.setId(element.getAttribute("id"));
        if (element.hasAttribute("name")) {
            this.setName(element.getAttribute("name"));
        }
        this.superClassId = element.getAttribute("superClass");
        if (this.superClassId != null && this.superClassId.length() > 0) {
            this.superClass = ManagedBuildManager.getExtensionBuilder(this.superClassId);
        }
        if (element.hasAttribute("unusedChildren")) {
            this.unusedChildren = element.getAttribute("unusedChildren");
        }
        if (element.hasAttribute("isAbstract") && (isAbs = element.getAttribute("isAbstract")) != null) {
            this.isAbstract = new Boolean("true".equals(isAbs));
        }
        if (element.hasAttribute("command")) {
            this.command = element.getAttribute("command");
        }
        if (element.hasAttribute("arguments")) {
            this.args = element.getAttribute("arguments");
        }
        if (element.hasAttribute("errorParsers")) {
            this.errorParserIds = element.getAttribute("errorParsers");
        }
        element.hasAttribute("buildfileGenerator");
    }

    public void serialize(Document doc, Element element) {
        if (this.superClass != null) {
            element.setAttribute("superClass", this.superClass.getId());
        }
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.unusedChildren != null) {
            element.setAttribute("unusedChildren", this.unusedChildren);
        }
        if (this.isAbstract != null) {
            element.setAttribute("isAbstract", this.isAbstract.toString());
        }
        if (this.errorParserIds != null) {
            element.setAttribute("errorParsers", this.errorParserIds);
        }
        if (this.command != null) {
            element.setAttribute("command", this.command);
        }
        if (this.args != null) {
            element.setAttribute("arguments", this.args);
        }
        this.isDirty = false;
    }

    public IToolChain getParent() {
        return this.parent;
    }

    public IBuilder getSuperClass() {
        return this.superClass;
    }

    public String getName() {
        return this.name == null && this.superClass != null ? this.superClass.getName() : this.name;
    }

    public boolean isAbstract() {
        if (this.isAbstract != null) {
            return this.isAbstract;
        }
        return false;
    }

    public String getUnusedChildren() {
        if (this.unusedChildren != null) {
            return this.unusedChildren;
        }
        return EMPTY_STRING;
    }

    public String getCommand() {
        if (this.command == null) {
            if (this.superClass != null) {
                return this.superClass.getCommand();
            }
            return new String("make");
        }
        return this.command;
    }

    public String getArguments() {
        if (this.args == null) {
            if (this.superClass != null) {
                return this.superClass.getArguments();
            }
            return new String("-k");
        }
        return this.args;
    }

    public String getErrorParserIds() {
        String ids = this.errorParserIds;
        if (ids == null && this.superClass != null) {
            ids = this.superClass.getErrorParserIds();
        }
        return ids;
    }

    public String[] getErrorParserList() {
        String parserIDs = this.getErrorParserIds();
        String[] errorParsers = null;
        if (parserIDs != null) {
            if (parserIDs.length() == 0) {
                errorParsers = new String[]{};
            } else {
                StringTokenizer tok = new StringTokenizer(parserIDs, ";");
                ArrayList<String> list = new ArrayList<String>(tok.countTokens());
                while (tok.hasMoreElements()) {
                    list.add(tok.nextToken());
                }
                String[] strArr = new String[]{""};
                errorParsers = list.toArray(strArr);
            }
        } else {
            errorParsers = new String[]{};
        }
        return errorParsers;
    }

    public void setCommand(String cmd) {
        if (cmd == null && this.command == null) {
            return;
        }
        if (this.command == null || cmd == null || !cmd.equals(this.command)) {
            this.command = cmd;
            this.setDirty(true);
        }
    }

    public void setArguments(String newArgs) {
        if (newArgs == null && this.args == null) {
            return;
        }
        if (this.args == null || newArgs == null || !newArgs.equals(this.args)) {
            this.args = newArgs;
            this.setDirty(true);
        }
    }

    public void setErrorParserIds(String ids) {
        String currentIds = this.getErrorParserIds();
        if (ids == null && currentIds == null) {
            return;
        }
        if (currentIds == null || ids == null || !currentIds.equals(ids)) {
            this.errorParserIds = ids;
            this.isDirty = true;
        }
    }

    public void setIsAbstract(boolean b) {
        this.isAbstract = new Boolean(b);
        this.setDirty(true);
    }

    public IConfigurationElement getBuildFileGeneratorElement() {
        if (this.buildFileGeneratorElement == null && this.superClass != null) {
            return this.superClass.getBuildFileGeneratorElement();
        }
        return this.buildFileGeneratorElement;
    }

    public void setBuildFileGeneratorElement(IConfigurationElement element) {
        this.buildFileGeneratorElement = element;
        this.setDirty(true);
    }

    public boolean isExtensionElement() {
        return this.isExtensionBuilder;
    }

    public boolean isDirty() {
        if (this.isExtensionBuilder) {
            return false;
        }
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            if (this.superClassId != null && this.superClassId.length() > 0) {
                this.superClass = ManagedBuildManager.getExtensionBuilder(this.superClassId);
                if (this.superClass == null) {
                    ManagedBuildManager.OutputResolveError("superClass", this.superClassId, "builder", this.getId());
                }
            }
        }
    }
}

