/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.editor;

import java.util.ResourceBundle;
import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.editor.IReconcilingParticipant;
import org.eclipse.cdt.make.internal.ui.editor.MakefileContentOutlinePage;
import org.eclipse.cdt.make.internal.ui.editor.MakefileSourceConfiguration;
import org.eclipse.cdt.make.internal.ui.editor.OpenDeclarationAction;
import org.eclipse.cdt.make.internal.ui.editor.ProjectionMakefileUpdater;
import org.eclipse.cdt.make.internal.ui.text.makefile.MakefileWordDetector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;

public class MakefileEditor
extends TextEditor
implements ISelectionChangedListener,
IReconcilingParticipant {
    protected MakefileContentOutlinePage page;
    ProjectionSupport projectionSupport;
    ProjectionMakefileUpdater fProjectionMakefileUpdater;
    private FindReplaceDocumentAdapter fFindReplaceDocumentAdapter;
    private ListenerList fReconcilingListeners = new ListenerList();
    final IPropertyChangeListener fPropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            MakefileEditor.this.handlePreferenceStoreChanged(event);
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    MakefileSourceConfiguration getMakefileSourceConfiguration() {
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        if (configuration instanceof MakefileSourceConfiguration) {
            return (MakefileSourceConfiguration)configuration;
        }
        return null;
    }

    public MakefileContentOutlinePage getOutlinePage() {
        if (this.page == null) {
            this.page = new MakefileContentOutlinePage(this);
            this.page.addSelectionChangedListener(this);
            this.page.setInput(this.getEditorInput());
        }
        return this.page;
    }

    protected void initializeEditor() {
        this.setSourceViewerConfiguration(new MakefileSourceConfiguration(this));
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.setEditorContextMenuId("#MakefileEditorContext");
        this.setRulerContextMenuId("#MakefileRulerContext");
        this.setDocumentProvider(MakeUIPlugin.getDefault().getMakefileDocumentProvider());
        this.setPreferenceStore(MakeUIPlugin.getDefault().getPreferenceStore());
    }

    public void dispose() {
        if (this.fProjectionMakefileUpdater != null) {
            this.fProjectionMakefileUpdater.uninstall();
            this.fProjectionMakefileUpdater = null;
        }
        if (this.fPropertyChangeListener != null) {
            IPreferenceStore preferenceStore = this.getPreferenceStore();
            preferenceStore.removePropertyChangeListener(this.fPropertyChangeListener);
        }
        super.dispose();
    }

    boolean isFoldingEnabled() {
        return MakeUIPlugin.getDefault().getPreferenceStore().getBoolean("editor_folding_enabled");
    }

    public void createPartControl(Composite parent) {
        Class<?> clazz;
        super.createPartControl(parent);
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.projectionSupport.install();
        if (this.isFoldingEnabled()) {
            projectionViewer.doOperation(19);
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.source.projection.ProjectionAnnotationModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ProjectionAnnotationModel cfr_ignored_0 = (ProjectionAnnotationModel)this.getAdapter(clazz);
        this.fProjectionMakefileUpdater = new ProjectionMakefileUpdater();
        if (this.fProjectionMakefileUpdater != null) {
            this.fProjectionMakefileUpdater.install(this, projectionViewer);
            this.fProjectionMakefileUpdater.initialize();
        }
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        preferenceStore.addPropertyChangeListener(this.fPropertyChangeListener);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        AdaptedSourceViewer viewer = new AdaptedSourceViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.source.projection.ProjectionAnnotationModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(key)) {
            Object result;
            if (this.projectionSupport != null && (result = this.projectionSupport.getAdapter(this.getSourceViewer(), key)) != null) {
                return result;
            }
        } else {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (key.equals(clazz2)) {
                return this.getOutlinePage();
            }
        }
        return super.getAdapter(key);
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        if (this.page != null) {
            this.page.update();
        }
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle bundle = MakeUIPlugin.getDefault().getResourceBundle();
        Object a = new TextOperationAction(bundle, "ContentAssistProposal.", (ITextEditor)this, 13);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)a);
        a = new TextOperationAction(bundle, "ContentAssistTip.", (ITextEditor)this, 14);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistTip", (IAction)a);
        a = new TextOperationAction(bundle, "Comment.", (ITextEditor)this, 11);
        a.setActionDefinitionId("org.eclipse.cdt.make.ui.edit.text.makefile.uncomment");
        this.setAction("Comment", (IAction)a);
        this.markAsStateDependentAction("Comment", true);
        a = new TextOperationAction(bundle, "Uncomment.", (ITextEditor)this, 12);
        a.setActionDefinitionId("org.eclipse.cdt.make.ui.edit.text.makefile.comment");
        this.setAction("Uncomment", (IAction)a);
        this.markAsStateDependentAction("Uncomment", true);
        a = new OpenDeclarationAction((ITextEditor)this);
        a.setActionDefinitionId("org.eclipse.cdt.make.ui.edit.text.makefile.opendcl");
        this.setAction("OpenDeclarationAction", (IAction)a);
        this.markAsStateDependentAction("OpenDeclarationAction", true);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.resetHighlightRange();
        } else if (selection instanceof IStructuredSelection) {
            Object element;
            if (!this.isActivePart() && MakeUIPlugin.getActivePage() != null) {
                MakeUIPlugin.getActivePage().bringToTop((IWorkbenchPart)this);
            }
            if ((element = ((IStructuredSelection)selection).getFirstElement()) instanceof IDirective) {
                IDirective statement = (IDirective)element;
                this.setSelection(statement, !this.isActivePart());
            }
        }
    }

    private boolean isActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IPartService service = window.getPartService();
        IWorkbenchPart part = service.getActivePart();
        return part != null && part.equals(this);
    }

    private FindReplaceDocumentAdapter getFindRepalceDocumentAdapter() {
        if (this.fFindReplaceDocumentAdapter == null) {
            IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
            this.fFindReplaceDocumentAdapter = new FindReplaceDocumentAdapter(doc);
        }
        return this.fFindReplaceDocumentAdapter;
    }

    public void setSelection(IDirective directive, boolean moveCursor) {
        int startLine = directive.getStartLine() - 1;
        int endLine = directive.getEndLine() - 1;
        try {
            IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
            int start = doc.getLineOffset(startLine);
            int len = doc.getLineLength(endLine) - 1;
            int length = doc.getLineOffset(endLine) + len - start;
            this.setHighlightRange(start, length, true);
            if (moveCursor) {
                IRegion region;
                String var = directive.toString().trim();
                MakefileWordDetector detector = new MakefileWordDetector();
                len = 0;
                while (len < var.length()) {
                    char c = var.charAt(len);
                    if (!detector.isWordPart(c) && !detector.isWordStart(c) && c != '-' && c != '_') break;
                    ++len;
                }
                if (len > 0) {
                    var = var.substring(0, len);
                }
                if ((region = this.getFindRepalceDocumentAdapter().find(start, var, true, true, true, false)) != null) {
                    len = region.getOffset();
                    length = region.getLength();
                    this.getSourceViewer().revealRange(len, length);
                    this.getSourceViewer().setSelectedRange(len, length);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.resetHighlightRange();
        }
        catch (BadLocationException badLocationException) {
            this.resetHighlightRange();
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addAction(menu, "group.edit", "Comment");
        this.addAction(menu, "group.edit", "Uncomment");
    }

    final void addReconcilingParticipant(IReconcilingParticipant listener) {
        ListenerList listenerList = this.fReconcilingListeners;
        synchronized (listenerList) {
            this.fReconcilingListeners.add((Object)listener);
        }
    }

    final void removeReconcilingParticipant(IReconcilingParticipant listener) {
        ListenerList listenerList = this.fReconcilingListeners;
        synchronized (listenerList) {
            this.fReconcilingListeners.remove((Object)listener);
        }
    }

    public void reconciled() {
        Object[] listeners = this.fReconcilingListeners.getListeners();
        int i = 0;
        int length = listeners.length;
        while (i < length) {
            ((IReconcilingParticipant)listeners[i]).reconciled();
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performRevert() {
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        projectionViewer.setRedraw(false);
        try {
            boolean projectionMode = projectionViewer.isProjectionMode();
            if (projectionMode) {
                projectionViewer.disableProjection();
                if (this.fProjectionMakefileUpdater != null) {
                    this.fProjectionMakefileUpdater.uninstall();
                }
            }
            super.performRevert();
            if (projectionMode) {
                if (this.fProjectionMakefileUpdater != null) {
                    this.fProjectionMakefileUpdater.install(this, projectionViewer);
                }
                projectionViewer.enableProjection();
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            projectionViewer.setRedraw(true);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        projectionViewer.setRedraw(true);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        String property = event.getProperty();
        MakefileSourceConfiguration makeConf = this.getMakefileSourceConfiguration();
        if (makeConf != null && makeConf.affectsBehavior(event)) {
            makeConf.adaptToPreferenceChange(event);
            sourceViewer.invalidateTextPresentation();
        }
        if ("editor_folding_enabled".equals(property)) {
            if (sourceViewer instanceof ProjectionViewer) {
                ProjectionViewer projectionViewer = (ProjectionViewer)sourceViewer;
                if (this.fProjectionMakefileUpdater != null) {
                    this.fProjectionMakefileUpdater.uninstall();
                }
                this.fProjectionMakefileUpdater = new ProjectionMakefileUpdater();
                if (this.fProjectionMakefileUpdater != null) {
                    this.fProjectionMakefileUpdater.install(this, projectionViewer);
                }
            }
            return;
        }
        super.handlePreferenceStoreChanged(event);
    }

    public class AdaptedSourceViewer
    extends ProjectionViewer
    implements ITextViewerExtension {
        public AdaptedSourceViewer(Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean showsAnnotation, int styles) {
            super(parent, ruler, overviewRuler, showsAnnotation, styles);
        }

        public void setRangeIndication(int offset, int length, boolean moveCursor) {
            if (this.isProjectionMode()) {
                super.setRangeIndication(offset, length, moveCursor);
            } else {
                super.setRangeIndication(offset, length, false);
            }
        }
    }
}

