/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.model.IJumpToAddress;
import org.eclipse.cdt.debug.core.model.IJumpToLine;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyEditorInput;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyView;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class ResumeAtLineActionDelegate
implements IWorkbenchWindowActionDelegate,
IPartListener,
IUpdate {
    protected IWorkbenchWindow fWindow = null;
    private IWorkbenchPart fActivePart = null;
    private IAction fAction = null;
    private IDebugElement fTargetElement = null;
    private static final ISelection EMPTY_SELECTION = new EmptySelection();
    private ISelectionListener fSelectionListener = new DebugSelectionListener();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private ISelection getTargetSelection() {
        ISelectionProvider selectionProvider;
        if (this.fActivePart != null && (selectionProvider = this.fActivePart.getSite().getSelectionProvider()) != null) {
            return selectionProvider.getSelection();
        }
        return EMPTY_SELECTION;
    }

    public void dispose() {
        this.fWindow.getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", this.fSelectionListener);
        this.fWindow.getPartService().removePartListener((IPartListener)this);
        this.fActivePart = null;
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
        IPartService partService = window.getPartService();
        partService.addPartListener((IPartListener)this);
        this.fWindow.getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", this.fSelectionListener);
        IWorkbenchPart part = partService.getActivePart();
        if (part != null) {
            this.partActivated(part);
        }
    }

    public void partActivated(IWorkbenchPart part) {
        this.fActivePart = part;
        this.update();
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        this.clearPart(part);
    }

    public void partDeactivated(IWorkbenchPart part) {
        this.clearPart(part);
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void update() {
        if (this.fAction == null) {
            return;
        }
        this.fAction.setEnabled(this.canPerformAction(this.getTargetSelection()));
    }

    public void run(IAction action) {
        if (this.fTargetElement != null) {
            try {
                this.performAction(this.getTargetSelection());
            }
            catch (CoreException e) {
                DebugUIPlugin.errorDialog((Shell)this.fWindow.getShell(), (String)ActionMessages.getString("ResumeAtLineActionDelegate.Error_1"), (String)ActionMessages.getString("ResumeAtLineActionDelegate.Operation_failed_1"), (IStatus)e.getStatus());
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fAction = action;
        this.update();
    }

    protected void clearPart(IWorkbenchPart part) {
        if (part.equals(this.fActivePart)) {
            this.fActivePart = null;
        }
    }

    protected IDebugElement getTargetElement() {
        return this.fTargetElement;
    }

    protected void setTargetElement(IDebugElement targetElement) {
        this.fTargetElement = targetElement;
    }

    private boolean canPerformAction(ISelection selection) {
        if (this.fTargetElement == null || !this.fTargetElement.getModelIdentifier().equals(CDIDebugModel.getPluginIdentifier())) {
            return false;
        }
        IDebugTarget debugTarget = this.fTargetElement.getDebugTarget();
        if (this.fActivePart instanceof IEditorPart) {
            String fileName;
            IJumpToLine jumpToLine;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IJumpToLine");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((jumpToLine = (IJumpToLine)debugTarget.getAdapter((Class)clazz)) == null) {
                return false;
            }
            IEditorPart editorPart = (IEditorPart)this.fActivePart;
            IEditorInput input = editorPart.getEditorInput();
            if (input == null) {
                return false;
            }
            if (!(editorPart instanceof ITextEditor)) {
                return false;
            }
            ITextEditor textEditor = (ITextEditor)editorPart;
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
            if (document == null) {
                return false;
            }
            try {
                fileName = this.getFileName(input);
            }
            catch (CoreException coreException) {
                return false;
            }
            ITextSelection textSelection = (ITextSelection)selection;
            int lineNumber = textSelection.getStartLine() + 1;
            return jumpToLine.canJumpToLine(fileName, lineNumber);
        }
        if (this.fActivePart instanceof DisassemblyView) {
            IJumpToAddress jumpToAddress;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.debug.core.model.IJumpToAddress");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((jumpToAddress = (IJumpToAddress)debugTarget.getAdapter((Class)clazz)) == null) {
                return false;
            }
            IEditorInput input = ((DisassemblyView)this.fActivePart).getInput();
            if (!(input instanceof DisassemblyEditorInput)) {
                return false;
            }
            ITextSelection textSelection = (ITextSelection)selection;
            int lineNumber = textSelection.getStartLine() + 1;
            IAddress address = ((DisassemblyEditorInput)input).getAddress(lineNumber);
            return jumpToAddress.canJumpToAddress(address);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void performAction(ISelection selection) throws CoreException {
        IDebugTarget debugTarget = this.fTargetElement.getDebugTarget();
        String errorMessage = null;
        if (this.fActivePart instanceof IEditorPart) {
            IJumpToLine jumpToLine;
            IEditorPart editorPart = (IEditorPart)this.fActivePart;
            IEditorInput input = editorPart.getEditorInput();
            if (input == null) {
                errorMessage = ActionMessages.getString("ResumeAtLineActionDelegate.Empty_editor_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            }
            ITextEditor textEditor = (ITextEditor)editorPart;
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
            if (document == null) {
                errorMessage = ActionMessages.getString("ResumeAtLineActionDelegate.Missing_document");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            }
            final String fileName = this.getFileName(input);
            ITextSelection textSelection = (ITextSelection)selection;
            final int lineNumber = textSelection.getStartLine() + 1;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IJumpToLine");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((jumpToLine = (IJumpToLine)debugTarget.getAdapter((Class)clazz)) == null) return;
            Runnable r = new Runnable(){

                public void run() {
                    try {
                        jumpToLine.jumpToLine(fileName, lineNumber);
                    }
                    catch (DebugException e) {
                        ResumeAtLineActionDelegate.this.failed(e);
                    }
                }
            };
            this.runInBackground(r);
            return;
        }
        if (this.fActivePart instanceof DisassemblyView) {
            IJumpToAddress jumpToAddress;
            IEditorInput input = ((DisassemblyView)this.fActivePart).getInput();
            if (!(input instanceof DisassemblyEditorInput)) {
                errorMessage = ActionMessages.getString("ResumeAtLineActionDelegate.Empty_editor_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            }
            ITextSelection textSelection = (ITextSelection)selection;
            int lineNumber = textSelection.getStartLine() + 1;
            final IAddress address = ((DisassemblyEditorInput)input).getAddress(lineNumber);
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.debug.core.model.IJumpToAddress");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((jumpToAddress = (IJumpToAddress)debugTarget.getAdapter((Class)clazz)) == null) return;
            Runnable r = new Runnable(){

                public void run() {
                    try {
                        jumpToAddress.jumpToAddress(address);
                    }
                    catch (DebugException e) {
                        ResumeAtLineActionDelegate.this.failed(e);
                    }
                }
            };
            this.runInBackground(r);
            return;
        }
        errorMessage = ActionMessages.getString("ResumeAtLineActionDelegate.Operation_is_not_supported_1");
        throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
    }

    private String getFileName(IEditorInput input) throws CoreException {
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile().getName();
        }
        if (input instanceof IStorageEditorInput) {
            return ((IStorageEditorInput)input).getStorage().getName();
        }
        return null;
    }

    private void runInBackground(Runnable r) {
        DebugPlugin.getDefault().asyncExec(r);
    }

    protected void failed(Throwable e) {
        MultiStatus ms = new MultiStatus(CDIDebugModel.getPluginIdentifier(), 10002, ActionMessages.getString("ResumeAtLineActionDelegate.0"), null);
        ms.add((IStatus)new Status(4, CDIDebugModel.getPluginIdentifier(), 10002, e.getMessage(), e));
        CDebugUtils.error((IStatus)ms, (Object)this);
    }

    static class EmptySelection
    implements ISelection {
        EmptySelection() {
        }

        public boolean isEmpty() {
            return true;
        }
    }

    class DebugSelectionListener
    implements ISelectionListener {
        DebugSelectionListener() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            Object object;
            IStructuredSelection ss;
            ResumeAtLineActionDelegate.this.setTargetElement(null);
            if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (object = ss.getFirstElement()) instanceof IDebugElement) {
                ResumeAtLineActionDelegate.this.setTargetElement((IDebugElement)object);
            }
            ResumeAtLineActionDelegate.this.update();
        }
    }
}

