/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.DefaultLogService;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IQuickParseCallback;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.KeywordSetKey;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ast.IASTFactory;
import org.eclipse.cdt.core.parser.extension.ExtensionDialect;
import org.eclipse.cdt.core.parser.extension.IParserExtension;
import org.eclipse.cdt.core.parser.extension.IParserExtensionFactory;
import org.eclipse.cdt.internal.core.parser.Parser;
import org.eclipse.cdt.internal.core.parser.ParserExtensionFactory;
import org.eclipse.cdt.internal.core.parser.QuickParseCallback;
import org.eclipse.cdt.internal.core.parser.StructuralParseCallback;
import org.eclipse.cdt.internal.core.parser.ast.complete.CompleteParseASTFactory;
import org.eclipse.cdt.internal.core.parser.ast.quick.QuickParseASTFactory;
import org.eclipse.cdt.internal.core.parser.scanner2.Scanner2;
import org.eclipse.cdt.internal.core.parser.token.KeywordSets;

public class ParserFactory {
    private static IParserExtensionFactory extensionFactory = new ParserExtensionFactory(ExtensionDialect.GCC);
    private static IParserLogService defaultLogService = new DefaultLogService();

    public static IASTFactory createASTFactory(ParserMode mode, ParserLanguage language) {
        if (mode == ParserMode.QUICK_PARSE) {
            return new QuickParseASTFactory(extensionFactory.createASTExtension(mode));
        }
        return new CompleteParseASTFactory(language, mode, extensionFactory.createASTExtension(mode));
    }

    public static IParser createParser(IScanner scanner, ISourceElementRequestor callback, ParserMode mode, ParserLanguage language, IParserLogService log) throws ParserFactoryError {
        if (scanner == null) {
            throw new ParserFactoryError(ParserFactoryError.Kind.NULL_SCANNER);
        }
        if (language == null) {
            throw new ParserFactoryError(ParserFactoryError.Kind.NULL_LANGUAGE);
        }
        IParserLogService logService = log == null ? ParserFactory.createDefaultLogService() : log;
        ParserMode ourMode = mode == null ? ParserMode.COMPLETE_PARSE : mode;
        ISourceElementRequestor ourCallback = callback == null ? new NullSourceElementRequestor() : callback;
        IParserExtension extension = extensionFactory.createParserExtension();
        return new Parser(scanner, ourMode, ourCallback, language, logService, extension);
    }

    public static IScanner createScanner(CodeReader code, IScannerInfo config, ParserMode mode, ParserLanguage language, ISourceElementRequestor requestor, IParserLogService log, List workingCopies) throws ParserFactoryError {
        if (config == null) {
            throw new ParserFactoryError(ParserFactoryError.Kind.NULL_CONFIG);
        }
        if (language == null) {
            throw new ParserFactoryError(ParserFactoryError.Kind.NULL_LANGUAGE);
        }
        IParserLogService logService = log == null ? ParserFactory.createDefaultLogService() : log;
        ParserMode ourMode = mode == null ? ParserMode.COMPLETE_PARSE : mode;
        ISourceElementRequestor ourRequestor = requestor == null ? new NullSourceElementRequestor() : requestor;
        return new Scanner2(code, config, ourRequestor, ourMode, language, logService, extensionFactory.createScannerExtension(), workingCopies);
    }

    public static IScanner createScanner(String fileName, IScannerInfo config, ParserMode mode, ParserLanguage language, ISourceElementRequestor requestor, IParserLogService log, List workingCopies) throws ParserFactoryError, IOException {
        return ParserFactory.createScanner(new CodeReader(fileName), config, mode, language, requestor, log, workingCopies);
    }

    public static IQuickParseCallback createQuickParseCallback() {
        return new QuickParseCallback();
    }

    public static IQuickParseCallback createStructuralParseCallback() {
        return new StructuralParseCallback();
    }

    public static IParserLogService createDefaultLogService() {
        return defaultLogService;
    }

    public static Set getKeywordSet(KeywordSetKey key, ParserLanguage language) {
        return KeywordSets.getKeywords(key, language);
    }
}

