/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner2;

import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.EndOfFileException;
import org.eclipse.cdt.core.parser.IMacro;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.KeywordSetKey;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.core.parser.OffsetLimitReachedException;
import org.eclipse.cdt.core.parser.ParseError;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ast.IASTCompletionNode;
import org.eclipse.cdt.core.parser.ast.IASTFactory;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.extension.IScannerExtension;
import org.eclipse.cdt.core.parser.util.CharArrayIntMap;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.parser.ast.ASTCompletionNode;
import org.eclipse.cdt.internal.core.parser.ast.EmptyIterator;
import org.eclipse.cdt.internal.core.parser.problem.IProblemFactory;
import org.eclipse.cdt.internal.core.parser.scanner2.DynamicFunctionStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.DynamicStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.ExpressionEvaluator;
import org.eclipse.cdt.internal.core.parser.scanner2.FunctionStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.IScannerData;
import org.eclipse.cdt.internal.core.parser.scanner2.MacroExpansionToken;
import org.eclipse.cdt.internal.core.parser.scanner2.ObjectStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.ScannerCallbackManager;
import org.eclipse.cdt.internal.core.parser.scanner2.ScannerProblemFactory;
import org.eclipse.cdt.internal.core.parser.scanner2.ScannerUtility;
import org.eclipse.cdt.internal.core.parser.token.ImagedExpansionToken;
import org.eclipse.cdt.internal.core.parser.token.ImagedToken;
import org.eclipse.cdt.internal.core.parser.token.KeywordSets;
import org.eclipse.cdt.internal.core.parser.token.SimpleExpansionToken;
import org.eclipse.cdt.internal.core.parser.token.SimpleToken;

public class Scanner2
implements IScanner,
IScannerData {
    private static final char[] ELLIPSIS_CHARARRAY = "...".toString().toCharArray();
    private static final char[] VA_ARGS_CHARARRAY = "__VA_ARGS__".toCharArray();
    private ISourceElementRequestor requestor;
    private ParserLanguage language;
    private IParserLogService log;
    private IScannerExtension scannerExtension;
    private CharArrayObjectMap definitions = new CharArrayObjectMap(512);
    private String[] includePaths;
    int count;
    private ExpressionEvaluator expressionEvaluator = new ExpressionEvaluator();
    private final CharArrayObjectMap fileCache = new CharArrayObjectMap(100);
    private static final int bufferInitialSize = 8;
    int bufferStackPos = -1;
    private char[][] bufferStack = new char[8][];
    private Object[] bufferData = new Object[8];
    private int[] bufferPos = new int[8];
    private int[] bufferLimit = new int[8];
    int[] lineNumbers = new int[8];
    private int[] lineOffsets = new int[8];
    private ScannerCallbackManager callbackManager;
    private int branchStackPos = -1;
    private int[] branches = new int[8];
    private static final int BRANCH_IF = 1;
    private static final int BRANCH_ELIF = 2;
    private static final int BRANCH_ELSE = 3;
    private static final int BRANCH_END = 4;
    private static String[] emptyStringArray = new String[0];
    private static char[] emptyCharArray = new char[0];
    private static EndOfFileException EOF = new EndOfFileException();
    PrintStream dlog;
    private ParserMode parserMode;
    private List workingCopies;
    private IToken lastToken;
    private IToken nextToken;
    private boolean finished = false;
    private static final String EMPTY_STRING = "";
    private static final char[] EMPTY_STRING_CHAR_ARRAY = new char[0];
    private boolean isCancelled = false;
    private static final ScannerProblemFactory spf = new ScannerProblemFactory();
    private static final ObjectStyleMacro __cplusplus = new ObjectStyleMacro("__cplusplus".toCharArray(), "1".toCharArray());
    private static final ObjectStyleMacro __STDC__ = new ObjectStyleMacro("__STDC__".toCharArray(), "1".toCharArray());
    private static final ObjectStyleMacro __STDC_HOSTED__ = new ObjectStyleMacro("__STDC_HOSTED_".toCharArray(), "1".toCharArray());
    private static final ObjectStyleMacro __STDC_VERSION__ = new ObjectStyleMacro("__STDC_VERSION_".toCharArray(), "199901L".toCharArray());
    private final DynamicStyleMacro __FILE__ = new DynamicStyleMacro("__FILE__".toCharArray()){

        public char[] execute() {
            StringBuffer buffer = new StringBuffer("\"");
            buffer.append(Scanner2.this.getCurrentFilename());
            buffer.append('\"');
            return buffer.toString().toCharArray();
        }
    };
    private final DynamicStyleMacro __DATE__ = new DynamicStyleMacro("__DATE__".toCharArray()){

        private final void append(StringBuffer buffer, int value) {
            if (value < 10) {
                buffer.append("0");
            }
            buffer.append(value);
        }

        public char[] execute() {
            StringBuffer buffer = new StringBuffer("\"");
            Calendar cal = Calendar.getInstance();
            buffer.append(cal.get(2));
            buffer.append(" ");
            this.append(buffer, cal.get(5));
            buffer.append(" ");
            buffer.append(cal.get(1));
            buffer.append("\"");
            return buffer.toString().toCharArray();
        }
    };
    private final DynamicStyleMacro __TIME__ = new DynamicStyleMacro("__TIME__".toCharArray()){

        private final void append(StringBuffer buffer, int value) {
            if (value < 10) {
                buffer.append("0");
            }
            buffer.append(value);
        }

        public char[] execute() {
            StringBuffer buffer = new StringBuffer("\"");
            Calendar cal = Calendar.getInstance();
            this.append(buffer, cal.get(10));
            buffer.append(":");
            this.append(buffer, cal.get(12));
            buffer.append(":");
            this.append(buffer, cal.get(13));
            buffer.append("\"");
            return buffer.toString().toCharArray();
        }
    };
    private final DynamicStyleMacro __LINE__ = new DynamicStyleMacro("__LINE__".toCharArray()){

        public char[] execute() {
            int lineNumber = Scanner2.this.lineNumbers[Scanner2.this.bufferStackPos];
            return Long.toString(lineNumber).toCharArray();
        }
    };
    private IASTFactory astFactory;
    private int offsetBoundary = -1;
    private final CharArrayIntMap keywords;
    private static CharArrayIntMap ckeywords;
    private static CharArrayIntMap cppkeywords;
    private static CharArrayIntMap ppKeywords;
    private static final int ppIf = 0;
    private static final int ppIfdef = 1;
    private static final int ppIfndef = 2;
    private static final int ppElif = 3;
    private static final int ppElse = 4;
    private static final int ppEndif = 5;
    private static final int ppInclude = 6;
    private static final int ppDefine = 7;
    private static final int ppUndef = 8;
    private static final int ppError = 9;
    private static final int ppInclude_next = 10;
    private static final char[] TAB;
    private static final char[] SPACE;

    static {
        TAB = new char[]{'\t'};
        SPACE = new char[]{' '};
        CharArrayIntMap words = new CharArrayIntMap(139, -1);
        words.put(Keywords.cAUTO, 57);
        words.put(Keywords.cBREAK, 61);
        words.put(Keywords.cCASE, 62);
        words.put(Keywords.cCHAR, 64);
        words.put(Keywords.cCONST, 67);
        words.put(Keywords.cCONTINUE, 70);
        words.put(Keywords.cDEFAULT, 71);
        words.put(Keywords.cDO, 73);
        words.put(Keywords.cDOUBLE, 74);
        words.put(Keywords.cELSE, 76);
        words.put(Keywords.cENUM, 77);
        words.put(Keywords.cEXTERN, 80);
        words.put(Keywords.cFLOAT, 82);
        words.put(Keywords.cFOR, 83);
        words.put(Keywords.cGOTO, 85);
        words.put(Keywords.cIF, 86);
        words.put(Keywords.cINLINE, 87);
        words.put(Keywords.cINT, 88);
        words.put(Keywords.cLONG, 89);
        words.put(Keywords.cREGISTER, 101);
        words.put(Keywords.cRETURN, 103);
        words.put(Keywords.cSHORT, 104);
        words.put(Keywords.cSIGNED, 108);
        words.put(Keywords.cSIZEOF, 105);
        words.put(Keywords.cSTATIC, 106);
        words.put(Keywords.cSTRUCT, 109);
        words.put(Keywords.cSWITCH, 110);
        words.put(Keywords.cTYPEDEF, 116);
        words.put(Keywords.cUNION, 119);
        words.put(Keywords.cUNSIGNED, 120);
        words.put(Keywords.cVOID, 123);
        words.put(Keywords.cVOLATILE, 124);
        words.put(Keywords.cWHILE, 126);
        ckeywords = (CharArrayIntMap)words.clone();
        ckeywords.put(Keywords.cRESTRICT, 137);
        ckeywords.put(Keywords.c_BOOL, 134);
        ckeywords.put(Keywords.c_COMPLEX, 135);
        ckeywords.put(Keywords.c_IMAGINARY, 136);
        cppkeywords = words;
        cppkeywords.put(Keywords.cASM, 56);
        cppkeywords.put(Keywords.cBOOL, 60);
        cppkeywords.put(Keywords.cCATCH, 63);
        cppkeywords.put(Keywords.cCLASS, 65);
        cppkeywords.put(Keywords.cCONST_CAST, 69);
        cppkeywords.put(Keywords.cDELETE, 72);
        cppkeywords.put(Keywords.cDYNAMIC_CAST, 75);
        cppkeywords.put(Keywords.cEXPLICIT, 78);
        cppkeywords.put(Keywords.cEXPORT, 79);
        cppkeywords.put(Keywords.cFALSE, 81);
        cppkeywords.put(Keywords.cFRIEND, 84);
        cppkeywords.put(Keywords.cMUTABLE, 90);
        cppkeywords.put(Keywords.cNAMESPACE, 91);
        cppkeywords.put(Keywords.cNEW, 92);
        cppkeywords.put(Keywords.cOPERATOR, 95);
        cppkeywords.put(Keywords.cPRIVATE, 98);
        cppkeywords.put(Keywords.cPROTECTED, 99);
        cppkeywords.put(Keywords.cPUBLIC, 100);
        cppkeywords.put(Keywords.cREINTERPRET_CAST, 102);
        cppkeywords.put(Keywords.cSTATIC_CAST, 107);
        cppkeywords.put(Keywords.cTEMPLATE, 111);
        cppkeywords.put(Keywords.cTHIS, 112);
        cppkeywords.put(Keywords.cTHROW, 113);
        cppkeywords.put(Keywords.cTRUE, 114);
        cppkeywords.put(Keywords.cTRY, 115);
        cppkeywords.put(Keywords.cTYPEID, 117);
        cppkeywords.put(Keywords.cTYPENAME, 118);
        cppkeywords.put(Keywords.cUSING, 121);
        cppkeywords.put(Keywords.cVIRTUAL, 122);
        cppkeywords.put(Keywords.cWCHAR_T, 125);
        cppkeywords.put(Keywords.cAND, 54);
        cppkeywords.put(Keywords.cAND_EQ, 55);
        cppkeywords.put(Keywords.cBITAND, 58);
        cppkeywords.put(Keywords.cBITOR, 59);
        cppkeywords.put(Keywords.cCOMPL, 66);
        cppkeywords.put(Keywords.cNOT, 93);
        cppkeywords.put(Keywords.cNOT_EQ, 94);
        cppkeywords.put(Keywords.cOR, 96);
        cppkeywords.put(Keywords.cOR_EQ, 97);
        cppkeywords.put(Keywords.cXOR, 127);
        cppkeywords.put(Keywords.cXOR_EQ, 128);
        ppKeywords = new CharArrayIntMap(16, -1);
        ppKeywords.put(Keywords.cIF, 0);
        ppKeywords.put(Keywords.cIFDEF, 1);
        ppKeywords.put(Keywords.cIFNDEF, 2);
        ppKeywords.put(Keywords.cELIF, 3);
        ppKeywords.put(Keywords.cELSE, 4);
        ppKeywords.put(Keywords.cENDIF, 5);
        ppKeywords.put(Keywords.cINCLUDE, 6);
        ppKeywords.put(Keywords.cDEFINE, 7);
        ppKeywords.put(Keywords.cUNDEF, 8);
        ppKeywords.put(Keywords.cERROR, 9);
        ppKeywords.put(Keywords.cINCLUDE_NEXT, 10);
    }

    public Scanner2(CodeReader reader, IScannerInfo info, ISourceElementRequestor requestor, ParserMode parserMode, ParserLanguage language, IParserLogService log, IScannerExtension extension, List workingCopies) {
        this.scannerExtension = extension;
        this.requestor = requestor;
        this.parserMode = parserMode;
        this.language = language;
        this.log = log;
        this.workingCopies = workingCopies;
        this.callbackManager = new ScannerCallbackManager(requestor);
        this.expressionEvaluator = new ExpressionEvaluator(this.callbackManager, spf);
        this.keywords = language == ParserLanguage.C ? ckeywords : cppkeywords;
        if (reader.filename != null) {
            this.fileCache.put(reader.filename, reader);
        }
        this.pushContext(reader.buffer, reader);
        this.setupBuiltInMacros();
        if (info.getDefinedSymbols() != null) {
            Map symbols = info.getDefinedSymbols();
            String[] keys = symbols.keySet().toArray(emptyStringArray);
            int i = 0;
            while (i < keys.length) {
                String symbolName = keys[i];
                Object value = symbols.get(symbolName);
                if (value instanceof String) {
                    this.addDefinition(symbolName.toCharArray(), this.scannerExtension.initializeMacroValue(this, ((String)value).toCharArray()));
                }
                ++i;
            }
        }
        this.includePaths = info.getIncludePaths();
    }

    private void pushContext(char[] buffer) {
        if (++this.bufferStackPos == this.bufferStack.length) {
            int size = this.bufferStack.length * 2;
            char[][] oldBufferStack = this.bufferStack;
            this.bufferStack = new char[size][];
            System.arraycopy(oldBufferStack, 0, this.bufferStack, 0, oldBufferStack.length);
            Object[] oldBufferData = this.bufferData;
            this.bufferData = new Object[size];
            System.arraycopy(oldBufferData, 0, this.bufferData, 0, oldBufferData.length);
            int[] oldBufferPos = this.bufferPos;
            this.bufferPos = new int[size];
            System.arraycopy(oldBufferPos, 0, this.bufferPos, 0, oldBufferPos.length);
            int[] oldBufferLimit = this.bufferLimit;
            this.bufferLimit = new int[size];
            System.arraycopy(oldBufferLimit, 0, this.bufferLimit, 0, oldBufferLimit.length);
            int[] oldLineNumbers = this.lineNumbers;
            this.lineNumbers = new int[size];
            System.arraycopy(oldLineNumbers, 0, this.lineNumbers, 0, oldLineNumbers.length);
            int[] oldLineOffsets = this.lineOffsets;
            this.lineOffsets = new int[size];
            System.arraycopy(oldLineOffsets, 0, this.lineOffsets, 0, oldLineOffsets.length);
        }
        this.bufferStack[this.bufferStackPos] = buffer;
        this.bufferPos[this.bufferStackPos] = -1;
        this.lineNumbers[this.bufferStackPos] = 1;
        this.lineOffsets[this.bufferStackPos] = 0;
        this.bufferLimit[this.bufferStackPos] = buffer.length;
    }

    private void pushContext(char[] buffer, Object data) {
        if (data instanceof InclusionData) {
            boolean isCircular = false;
            int i = 0;
            while (i < this.bufferStackPos) {
                if (this.bufferData[i] instanceof CodeReader && CharArrayUtils.equals(((CodeReader)this.bufferData[i]).filename, ((InclusionData)data).reader.filename)) {
                    isCircular = true;
                    break;
                }
                if (this.bufferData[i] instanceof InclusionData && CharArrayUtils.equals(((InclusionData)this.bufferData[i]).reader.filename, ((InclusionData)data).reader.filename)) {
                    isCircular = true;
                    break;
                }
                ++i;
            }
            if (isCircular) {
                this.handleProblem(0x200000B, ((InclusionData)data).inclusion.getStartingOffset(), ((InclusionData)data).inclusion.getFilename());
                return;
            }
        }
        this.pushContext(buffer);
        this.bufferData[this.bufferStackPos] = data;
        if (data instanceof InclusionData) {
            this.callbackManager.pushCallback(data);
            if (this.log.isTracing()) {
                StringBuffer b = new StringBuffer("Entering inclusion ");
                b.append(((InclusionData)data).reader.filename);
                this.log.traceLog(b.toString());
            }
        }
    }

    private void popContext() {
        this.bufferStack[this.bufferStackPos] = null;
        if (this.bufferData[this.bufferStackPos] instanceof InclusionData) {
            if (this.log.isTracing()) {
                StringBuffer buffer = new StringBuffer("Exiting inclusion ");
                buffer.append(((InclusionData)this.bufferData[this.bufferStackPos]).reader.filename);
                this.log.traceLog(buffer.toString());
            }
            this.callbackManager.pushCallback(((InclusionData)this.bufferData[this.bufferStackPos]).inclusion);
        }
        this.bufferData[this.bufferStackPos] = null;
        --this.bufferStackPos;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addDefinition(char[] key, char[] value) {
        int idx = CharArrayUtils.indexOf('(', key);
        if (idx == -1) {
            this.definitions.put(key, new ObjectStyleMacro(key, value));
            return;
        }
        this.pushContext(key);
        this.bufferPos[this.bufferStackPos] = idx;
        char[][] args = null;
        try {
            args = this.extractMacroParameters(0, EMPTY_STRING_CHAR_ARRAY, false);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.popContext();
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.popContext();
            if (args == null) return;
        }
        key = CharArrayUtils.extract(key, 0, idx);
        this.definitions.put(key, new FunctionStyleMacro(key, value, args));
    }

    public int getCount() {
        return this.count;
    }

    public Map getDefinitions() {
        CharArrayObjectMap objMap = this.getRealDefinitions();
        int size = objMap.size();
        HashMap<String, Object> hashMap = new HashMap<String, Object>(size);
        int i = 0;
        while (i < size) {
            hashMap.put(String.valueOf(objMap.keyAt(i)), objMap.getAt(i));
            ++i;
        }
        return hashMap;
    }

    public CharArrayObjectMap getRealDefinitions() {
        return this.definitions;
    }

    public String[] getIncludePaths() {
        return this.includePaths;
    }

    public boolean isOnTopContext() {
        return this.bufferStackPos <= 0;
    }

    public synchronized void cancel() {
        this.isCancelled = true;
        int index = this.bufferStackPos < 0 ? 0 : this.bufferStackPos;
        this.bufferPos[index] = this.bufferLimit[index];
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IToken nextToken() throws EndOfFileException {
        boolean exception = false;
        if (this.nextToken == null && !this.finished) {
            try {
                this.nextToken = this.fetchToken();
            }
            catch (Exception e) {
                if (e instanceof OffsetLimitReachedException) {
                    throw (OffsetLimitReachedException)e;
                }
                if (e instanceof ArrayIndexOutOfBoundsException && this.isCancelled) {
                    throw new ParseError(ParseError.ParseErrorKind.TIMEOUT_OR_CANCELLED);
                }
                exception = true;
                this.errorHandle();
            }
            if (this.nextToken == null && !exception) {
                this.finished = true;
            }
        }
        if (this.callbackManager.hasCallbacks()) {
            this.callbackManager.popCallbacks();
        }
        if (this.finished) {
            if (this.isCancelled) {
                throw new ParseError(ParseError.ParseErrorKind.TIMEOUT_OR_CANCELLED);
            }
            if (this.offsetBoundary == -1) {
                throw EOF;
            }
            this.throwOLRE();
        }
        if (this.lastToken != null) {
            this.lastToken.setNext(this.nextToken);
        }
        IToken oldToken = this.lastToken;
        this.lastToken = this.nextToken;
        try {
            this.nextToken = this.fetchToken();
        }
        catch (Exception e) {
            if (e instanceof OffsetLimitReachedException) {
                throw (OffsetLimitReachedException)e;
            }
            this.nextToken = null;
            exception = true;
            this.errorHandle();
        }
        if (this.nextToken == null) {
            if (exception) return this.lastToken;
            this.finished = true;
            return this.lastToken;
        }
        if (this.nextToken.getType() == 139) {
            IToken token2 = this.fetchToken();
            if (token2 == null) {
                this.nextToken = null;
                this.finished = true;
                return this.lastToken;
            }
            char[] pb = CharArrayUtils.concat(this.lastToken.getCharImage(), token2.getCharImage());
            this.pushContext(pb);
            this.lastToken = oldToken;
            this.nextToken = null;
            return this.nextToken();
        }
        if (this.lastToken == null) return this.lastToken;
        if (this.lastToken.getType() == 130) {
            if (this.nextToken == null) return this.lastToken;
            if (this.nextToken.getType() != 130 && this.nextToken.getType() != 131) {
                return this.lastToken;
            }
        } else {
            if (this.lastToken.getType() != 131) return this.lastToken;
            if (true) {
                if (this.nextToken == null) return this.lastToken;
                if (this.nextToken.getType() != 130 && this.nextToken.getType() != 131) return this.lastToken;
            }
        }
        do {
            int tokenType = 130;
            if (this.lastToken.getType() == 131 || this.nextToken.getType() == 131) {
                tokenType = 131;
            }
            this.lastToken = this.newToken(tokenType, CharArrayUtils.concat(this.lastToken.getCharImage(), this.nextToken.getCharImage()));
            if (oldToken != null) {
                oldToken.setNext(this.lastToken);
            }
            this.nextToken = this.fetchToken();
            if (this.nextToken == null) return this.lastToken;
        } while (this.nextToken.getType() == 130 || this.nextToken.getType() == 131);
        return this.lastToken;
    }

    protected void errorHandle() {
        int n = this.bufferStackPos;
        this.bufferPos[n] = this.bufferPos[n] + 1;
    }

    private void throwOLRE() throws OffsetLimitReachedException {
        if (this.lastToken != null && this.lastToken.getEndOffset() != this.offsetBoundary) {
            throw new OffsetLimitReachedException(null);
        }
        throw new OffsetLimitReachedException(this.lastToken);
    }

    private IToken fetchToken() throws EndOfFileException {
        ++this.count;
        block39: while (this.bufferStackPos >= 0) {
            if (this.isCancelled) {
                throw new ParseError(ParseError.ParseErrorKind.TIMEOUT_OR_CANCELLED);
            }
            this.skipOverWhiteSpace();
            int n = this.bufferStackPos;
            this.bufferPos[n] = this.bufferPos[n] + 1;
            if (this.bufferPos[n] >= this.bufferLimit[this.bufferStackPos]) {
                this.popContext();
                continue;
            }
            char[] buffer = this.bufferStack[this.bufferStackPos];
            int limit = this.bufferLimit[this.bufferStackPos];
            int pos = this.bufferPos[this.bufferStackPos];
            switch (buffer[pos]) {
                case '\n': {
                    break;
                }
                case 'L': {
                    if (pos + 1 < limit && buffer[pos + 1] == '\"') {
                        return this.scanString();
                    }
                    if (pos + 1 < limit && buffer[pos + 1] == '\'') {
                        return this.scanCharLiteral();
                    }
                    IToken t = this.scanIdentifier();
                    if (t instanceof MacroExpansionToken) continue block39;
                    return t;
                }
                case '\"': {
                    return this.scanString();
                }
                case '\'': {
                    return this.scanCharLiteral();
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    IToken t = this.scanIdentifier();
                    if (t instanceof MacroExpansionToken) continue block39;
                    return t;
                }
                case '\\': {
                    IToken t;
                    if (pos + 1 < limit && (buffer[pos + 1] == 'u' || buffer[pos + 1] == 'U')) {
                        t = this.scanIdentifier();
                        if (t instanceof MacroExpansionToken) continue block39;
                        return t;
                    }
                    this.handleProblem(0x1000001, this.bufferPos[this.bufferStackPos], new char[]{'\\'});
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return this.scanNumber();
                }
                case '.': {
                    if (pos + 1 < limit) {
                        switch (buffer[pos + 1]) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                return this.scanNumber();
                            }
                            case '.': {
                                if (pos + 2 < limit && buffer[pos + 2] == '.') {
                                    int n2 = this.bufferStackPos;
                                    this.bufferPos[n2] = this.bufferPos[n2] + 2;
                                    return this.newToken(48);
                                }
                            }
                            case '*': {
                                int n3 = this.bufferStackPos;
                                this.bufferPos[n3] = this.bufferPos[n3] + 1;
                                return this.newToken(49);
                            }
                        }
                    }
                    return this.newToken(50);
                }
                case '#': {
                    if (pos + 1 < limit && buffer[pos + 1] == '#') {
                        int n4 = this.bufferStackPos;
                        this.bufferPos[n4] = this.bufferPos[n4] + 1;
                        return this.newToken(139);
                    }
                    this.handlePPDirective(pos);
                    break;
                }
                case '{': {
                    return this.newToken(12);
                }
                case '}': {
                    return this.newToken(13);
                }
                case '[': {
                    return this.newToken(10);
                }
                case ']': {
                    return this.newToken(11);
                }
                case '(': {
                    return this.newToken(8);
                }
                case ')': {
                    return this.newToken(9);
                }
                case ';': {
                    return this.newToken(5);
                }
                case ':': {
                    if (pos + 1 < limit && buffer[pos + 1] == ':' && this.getLanguage() == ParserLanguage.CPP) {
                        int n5 = this.bufferStackPos;
                        this.bufferPos[n5] = this.bufferPos[n5] + 1;
                        return this.newToken(3);
                    }
                    return this.newToken(4);
                }
                case '?': {
                    return this.newToken(7);
                }
                case '+': {
                    if (pos + 1 < limit) {
                        if (buffer[pos + 1] == '+') {
                            int n6 = this.bufferStackPos;
                            this.bufferPos[n6] = this.bufferPos[n6] + 1;
                            return this.newToken(15);
                        }
                        if (buffer[pos + 1] == '=') {
                            int n7 = this.bufferStackPos;
                            this.bufferPos[n7] = this.bufferPos[n7] + 1;
                            return this.newToken(14);
                        }
                    }
                    return this.newToken(16);
                }
                case '-': {
                    if (pos + 1 < limit) {
                        if (buffer[pos + 1] == '>') {
                            if (pos + 2 < limit && buffer[pos + 2] == '*') {
                                int n8 = this.bufferStackPos;
                                this.bufferPos[n8] = this.bufferPos[n8] + 2;
                                return this.newToken(19);
                            }
                            int n9 = this.bufferStackPos;
                            this.bufferPos[n9] = this.bufferPos[n9] + 1;
                            return this.newToken(20);
                        }
                        if (buffer[pos + 1] == '-') {
                            int n10 = this.bufferStackPos;
                            this.bufferPos[n10] = this.bufferPos[n10] + 1;
                            return this.newToken(18);
                        }
                        if (buffer[pos + 1] == '=') {
                            int n11 = this.bufferStackPos;
                            this.bufferPos[n11] = this.bufferPos[n11] + 1;
                            return this.newToken(17);
                        }
                    }
                    return this.newToken(21);
                }
                case '*': {
                    if (pos + 1 < limit && buffer[pos + 1] == '=') {
                        int n12 = this.bufferStackPos;
                        this.bufferPos[n12] = this.bufferPos[n12] + 1;
                        return this.newToken(22);
                    }
                    return this.newToken(23);
                }
                case '/': {
                    if (pos + 1 < limit && buffer[pos + 1] == '=') {
                        int n13 = this.bufferStackPos;
                        this.bufferPos[n13] = this.bufferPos[n13] + 1;
                        return this.newToken(51);
                    }
                    return this.newToken(52);
                }
                case '%': {
                    if (pos + 1 < limit && buffer[pos + 1] == '=') {
                        int n14 = this.bufferStackPos;
                        this.bufferPos[n14] = this.bufferPos[n14] + 1;
                        return this.newToken(24);
                    }
                    return this.newToken(25);
                }
                case '^': {
                    if (pos + 1 < limit && buffer[pos + 1] == '=') {
                        int n15 = this.bufferStackPos;
                        this.bufferPos[n15] = this.bufferPos[n15] + 1;
                        return this.newToken(26);
                    }
                    return this.newToken(27);
                }
                case '&': {
                    if (pos + 1 < limit) {
                        if (buffer[pos + 1] == '&') {
                            int n16 = this.bufferStackPos;
                            this.bufferPos[n16] = this.bufferPos[n16] + 1;
                            return this.newToken(29);
                        }
                        if (buffer[pos + 1] == '=') {
                            int n17 = this.bufferStackPos;
                            this.bufferPos[n17] = this.bufferPos[n17] + 1;
                            return this.newToken(28);
                        }
                    }
                    return this.newToken(30);
                }
                case '|': {
                    if (pos + 1 < limit) {
                        if (buffer[pos + 1] == '|') {
                            int n18 = this.bufferStackPos;
                            this.bufferPos[n18] = this.bufferPos[n18] + 1;
                            return this.newToken(32);
                        }
                        if (buffer[pos + 1] == '=') {
                            int n19 = this.bufferStackPos;
                            this.bufferPos[n19] = this.bufferPos[n19] + 1;
                            return this.newToken(31);
                        }
                    }
                    return this.newToken(33);
                }
                case '~': {
                    return this.newToken(34);
                }
                case '!': {
                    if (pos + 1 < limit && buffer[pos + 1] == '=') {
                        int n20 = this.bufferStackPos;
                        this.bufferPos[n20] = this.bufferPos[n20] + 1;
                        return this.newToken(35);
                    }
                    return this.newToken(36);
                }
                case '=': {
                    if (pos + 1 < limit && buffer[pos + 1] == '=') {
                        int n21 = this.bufferStackPos;
                        this.bufferPos[n21] = this.bufferPos[n21] + 1;
                        return this.newToken(37);
                    }
                    return this.newToken(38);
                }
                case '<': {
                    if (pos + 1 < limit) {
                        if (buffer[pos + 1] == '=') {
                            int n22 = this.bufferStackPos;
                            this.bufferPos[n22] = this.bufferPos[n22] + 1;
                            return this.newToken(41);
                        }
                        if (buffer[pos + 1] == '<') {
                            if (pos + 2 < limit && buffer[pos + 2] == '=') {
                                int n23 = this.bufferStackPos;
                                this.bufferPos[n23] = this.bufferPos[n23] + 2;
                                return this.newToken(47);
                            }
                            int n24 = this.bufferStackPos;
                            this.bufferPos[n24] = this.bufferPos[n24] + 1;
                            return this.newToken(40);
                        }
                        char[] queryCharArray = CharArrayUtils.extract(buffer, pos, 2);
                        if (this.scannerExtension.isExtensionOperator(this.language, queryCharArray)) {
                            int n25 = this.bufferStackPos;
                            this.bufferPos[n25] = this.bufferPos[n25] + 1;
                            return this.scannerExtension.createExtensionToken(this, queryCharArray);
                        }
                    }
                    return this.newToken(42);
                }
                case '>': {
                    if (pos + 1 < limit) {
                        if (buffer[pos + 1] == '=') {
                            int n26 = this.bufferStackPos;
                            this.bufferPos[n26] = this.bufferPos[n26] + 1;
                            return this.newToken(45);
                        }
                        if (buffer[pos + 1] == '>') {
                            if (pos + 2 < limit && buffer[pos + 2] == '=') {
                                int n27 = this.bufferStackPos;
                                this.bufferPos[n27] = this.bufferPos[n27] + 2;
                                return this.newToken(43);
                            }
                            int n28 = this.bufferStackPos;
                            this.bufferPos[n28] = this.bufferPos[n28] + 1;
                            return this.newToken(44);
                        }
                        char[] queryCharArray = CharArrayUtils.extract(buffer, pos, 2);
                        if (this.scannerExtension.isExtensionOperator(this.language, queryCharArray)) {
                            int n29 = this.bufferStackPos;
                            this.bufferPos[n29] = this.bufferPos[n29] + 1;
                            return this.scannerExtension.createExtensionToken(this, queryCharArray);
                        }
                    }
                    return this.newToken(46);
                }
                case ',': {
                    return this.newToken(6);
                }
                default: {
                    IToken t;
                    if (!Character.isLetter(buffer[pos]) && !this.scannerExtension.isValidIdentifierStartCharacter(buffer[pos]) || (t = this.scanIdentifier()) instanceof MacroExpansionToken) continue block39;
                    return t;
                }
            }
        }
        return null;
    }

    private IToken newToken(int signal) {
        if (this.bufferData[this.bufferStackPos] instanceof MacroData) {
            int mostRelevant = this.bufferStackPos;
            while (mostRelevant >= 0) {
                if (this.bufferData[mostRelevant] instanceof InclusionData || this.bufferData[mostRelevant] instanceof CodeReader) break;
                --mostRelevant;
            }
            MacroData data = (MacroData)this.bufferData[mostRelevant + 1];
            return new SimpleExpansionToken(signal, data.startOffset, data.endOffset - data.startOffset + 1, this.getCurrentFilename(), this.getLineNumber(this.bufferPos[mostRelevant] + 1));
        }
        return new SimpleToken(signal, this.bufferPos[this.bufferStackPos] + 1, this.getCurrentFilename(), this.getLineNumber(this.bufferPos[this.bufferStackPos] + 1));
    }

    private IToken newToken(int signal, char[] buffer) {
        if (this.bufferData[this.bufferStackPos] instanceof MacroData) {
            int mostRelevant = this.bufferStackPos;
            while (mostRelevant >= 0) {
                if (this.bufferData[mostRelevant] instanceof InclusionData || this.bufferData[mostRelevant] instanceof CodeReader) break;
                --mostRelevant;
            }
            MacroData data = (MacroData)this.bufferData[mostRelevant + 1];
            return new ImagedExpansionToken(signal, buffer, data.startOffset, data.endOffset - data.startOffset + 1, this.getCurrentFilename(), this.getLineNumber(this.bufferPos[mostRelevant] + 1));
        }
        ImagedToken i = new ImagedToken(signal, buffer, this.bufferPos[this.bufferStackPos] + 1, this.getCurrentFilename(), this.getLineNumber(this.bufferPos[this.bufferStackPos] + 1));
        if (buffer != null && buffer.length == 0 && signal != 130 && signal != 131) {
            int n = this.bufferStackPos;
            this.bufferPos[n] = this.bufferPos[n] + 1;
        }
        return i;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private IToken scanIdentifier() {
        int tokenType;
        char[] result;
        int len;
        int start;
        boolean escapedNewline;
        char[] buffer;
        block24: {
            int n;
            int limit;
            block23: {
                buffer = this.bufferStack[this.bufferStackPos];
                escapedNewline = false;
                start = this.bufferPos[this.bufferStackPos];
                limit = this.bufferLimit[this.bufferStackPos];
                len = 1;
                if (!true) break block23;
                n = this.bufferStackPos;
                if ((this.bufferPos[n] = this.bufferPos[n] + 1) >= limit) break block24;
            }
            do {
                char c;
                if ((c = buffer[this.bufferPos[this.bufferStackPos]]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9' || Character.isUnicodeIdentifierPart(c)) {
                    ++len;
                } else if (c == '\\' && this.bufferPos[this.bufferStackPos] + 1 < limit && buffer[this.bufferPos[this.bufferStackPos] + 1] == '\n') {
                    int n2 = this.bufferStackPos;
                    this.bufferPos[n2] = this.bufferPos[n2] + 1;
                    len += 2;
                    escapedNewline = true;
                } else if (c == '\\' && this.bufferPos[this.bufferStackPos] + 1 < limit) {
                    if (buffer[this.bufferPos[this.bufferStackPos] + 1] != 'u' && buffer[this.bufferPos[this.bufferStackPos] + 1] != 'U') break;
                    int n3 = this.bufferStackPos;
                    this.bufferPos[n3] = this.bufferPos[n3] + 1;
                    len += 2;
                } else {
                    if (!this.scannerExtension.isValidIdentifierCharacter(c)) break;
                    ++len;
                }
                n = this.bufferStackPos;
            } while ((this.bufferPos[n] = this.bufferPos[n] + 1) < limit);
        }
        int n = this.bufferStackPos;
        this.bufferPos[n] = this.bufferPos[n] - 1;
        Object expObject = this.definitions.get(buffer, start, len);
        if (expObject != null && !this.isLimitReached() && this.shouldExpandMacro((IMacro)expObject)) {
            char[] expText;
            IMacro expMacro;
            boolean expanding = true;
            if (expObject instanceof FunctionStyleMacro) {
                if (this.handleFunctionStyleMacro((FunctionStyleMacro)expObject, true) == null) {
                    expanding = false;
                }
            } else if (expObject instanceof ObjectStyleMacro) {
                expMacro = (ObjectStyleMacro)expObject;
                char[] expText2 = ((ObjectStyleMacro)expMacro).expansion;
                if (expText2.length > 0) {
                    this.pushContext(expText2, new MacroData(this.bufferPos[this.bufferStackPos] - ((ObjectStyleMacro)expMacro).name.length + 1, this.bufferPos[this.bufferStackPos], expMacro));
                }
            } else if (expObject instanceof DynamicStyleMacro) {
                expMacro = (DynamicStyleMacro)expObject;
                char[] expText3 = ((DynamicStyleMacro)expMacro).execute();
                if (expText3.length > 0) {
                    this.pushContext(expText3, new MacroData(this.bufferPos[this.bufferStackPos] - ((DynamicStyleMacro)expMacro).name.length + 1, this.bufferPos[this.bufferStackPos], expMacro));
                }
            } else if (expObject instanceof char[] && (expText = (char[])expObject).length > 0) {
                this.pushContext(expText);
            }
            if (expanding) {
                return new MacroExpansionToken();
            }
        }
        char[] cArray = result = escapedNewline ? this.removedEscapedNewline(buffer, start, len) : CharArrayUtils.extract(buffer, start, len);
        if (this.scannerExtension.isExtensionKeyword(this.language, result)) {
            return this.scannerExtension.createExtensionToken(this, result);
        }
        int n4 = tokenType = escapedNewline ? this.keywords.get(result, 0, result.length) : this.keywords.get(buffer, start, len);
        if (tokenType != this.keywords.undefined) {
            return this.newToken(tokenType);
        }
        result = result != null ? result : CharArrayUtils.extract(buffer, start, len);
        return this.newToken(1, result);
    }

    private boolean shouldExpandMacro(IMacro macro) {
        if (macro != null && !this.isLimitReached()) {
            int stackPos = this.bufferStackPos;
            while (stackPos >= 0) {
                if (this.bufferData[stackPos] != null && this.bufferData[stackPos] instanceof MacroData && CharArrayUtils.equals(macro.getName(), ((MacroData)this.bufferData[stackPos]).macro.getName())) {
                    return false;
                }
                --stackPos;
            }
        }
        return true;
    }

    private final boolean isLimitReached() {
        char c;
        if (this.offsetBoundary == -1 || this.bufferStackPos != 0) {
            return false;
        }
        if (this.bufferPos[this.bufferStackPos] == this.offsetBoundary - 1) {
            return true;
        }
        return this.bufferPos[this.bufferStackPos] == this.offsetBoundary && ((c = this.bufferStack[this.bufferStackPos][this.bufferPos[this.bufferStackPos]]) == '\n' || c == ' ' || c == '\t' || c == '\r');
    }

    /*
     * Unable to fully structure code
     */
    private IToken scanString() {
        buffer = this.bufferStack[this.bufferStackPos];
        tokenType = 130;
        if (buffer[this.bufferPos[this.bufferStackPos]] == 'L') {
            v0 = this.bufferStackPos;
            this.bufferPos[v0] = this.bufferPos[v0] + 1;
            tokenType = 131;
        }
        stringStart = this.bufferPos[this.bufferStackPos] + 1;
        stringLen = 0;
        escaped = false;
        foundClosingQuote = false;
        if (true) ** GOTO lbl33
        do {
            block10: {
                ++stringLen;
                c = buffer[this.bufferPos[this.bufferStackPos]];
                if (c != '\"') break block10;
                if (!escaped) {
                    foundClosingQuote = true;
                    break;
                }
                ** GOTO lbl32
            }
            if (c == '\\') {
                escaped = escaped == false;
            } else {
                if (c == '\n') {
                    if (!escaped) {
                        break;
                    }
                } else if (c == '\r' && this.bufferPos[this.bufferStackPos] + 1 < this.bufferLimit[this.bufferStackPos] && buffer[this.bufferPos[this.bufferStackPos] + 1] == '\n') {
                    v1 = this.bufferStackPos;
                    this.bufferPos[v1] = this.bufferPos[v1] + 1;
                    if (!escaped) break;
                }
lbl32:
                // 5 sources

                escaped = false;
            }
lbl33:
            // 3 sources

            v2 = this.bufferStackPos;
        } while ((this.bufferPos[v2] = this.bufferPos[v2] + 1) < this.bufferLimit[this.bufferStackPos]);
        result = CharArrayUtils.extract(buffer, stringStart, --stringLen);
        if (!foundClosingQuote) {
            this.handleProblem(0x1000002, stringStart, result);
        }
        return this.newToken(tokenType, result);
    }

    /*
     * Unable to fully structure code
     */
    private IToken scanCharLiteral() {
        buffer = this.bufferStack[this.bufferStackPos];
        start = this.bufferPos[this.bufferStackPos];
        limit = this.bufferLimit[this.bufferStackPos];
        tokenType = 132;
        length = 1;
        if (buffer[this.bufferPos[this.bufferStackPos]] == 'L') {
            v0 = this.bufferStackPos;
            this.bufferPos[v0] = this.bufferPos[v0] + 1;
            tokenType = 133;
            ++length;
        }
        if (start >= limit) {
            return this.newToken(tokenType, Scanner2.emptyCharArray);
        }
        escaped = false;
        if (true) ** GOTO lbl27
        do {
            block7: {
                ++length;
                pos = this.bufferPos[this.bufferStackPos];
                if (buffer[pos] != '\'') break block7;
                if (!escaped) {
                    break;
                }
                ** GOTO lbl-1000
            }
            if (buffer[pos] == '\\') {
                escaped = escaped == false;
            } else lbl-1000:
            // 2 sources

            {
                escaped = false;
            }
lbl27:
            // 3 sources

            v1 = this.bufferStackPos;
        } while ((this.bufferPos[v1] = this.bufferPos[v1] + 1) < limit);
        if (this.bufferPos[this.bufferStackPos] == limit) {
            this.handleProblem(0x1000001, start, CharArrayUtils.extract(buffer, start, length));
            return this.newToken(tokenType, Scanner2.emptyCharArray);
        }
        image = length > 0 ? CharArrayUtils.extract(buffer, start, length) : Scanner2.emptyCharArray;
        return this.newToken(tokenType, image);
    }

    private void handleProblem(int id, int startOffset, char[] arg) {
        if (this.parserMode == ParserMode.COMPLETION_PARSE) {
            return;
        }
        IProblem p = spf.createProblem(id, startOffset, this.bufferPos[this.bufferStackPos], this.getLineNumber(this.bufferPos[this.bufferStackPos]), this.getCurrentFilename(), arg != null ? arg : emptyCharArray, false, true);
        this.callbackManager.pushCallback(p);
    }

    public int getLineNumber(int offset) {
        int startingPoint;
        if (this.parserMode == ParserMode.COMPLETION_PARSE) {
            return -1;
        }
        int index = this.getCurrentFileIndex();
        if (offset >= this.bufferLimit[index]) {
            return -1;
        }
        int lineNum = this.lineNumbers[index];
        int i = startingPoint = this.lineOffsets[index];
        while (i < offset) {
            if (this.bufferStack[index][i] == '\n') {
                ++lineNum;
            }
            ++i;
        }
        if (startingPoint < offset) {
            this.lineNumbers[index] = lineNum;
            this.lineOffsets[index] = offset;
        }
        return lineNum;
    }

    /*
     * Unable to fully structure code
     */
    private IToken scanNumber() throws EndOfFileException {
        buffer = this.bufferStack[this.bufferStackPos];
        start = this.bufferPos[this.bufferStackPos];
        limit = this.bufferLimit[this.bufferStackPos];
        isFloat = buffer[start] == '.';
        hasExponent = false;
        isHex = false;
        isOctal = false;
        isMalformedOctal = false;
        if (buffer[start] != '0' || start + 1 >= limit) ** GOTO lbl89
        switch (buffer[start + 1]) {
            case 'X': 
            case 'x': {
                isHex = true;
                v0 = this.bufferStackPos;
                this.bufferPos[v0] = this.bufferPos[v0] + 1;
                break;
            }
            default: {
                if (buffer[start + 1] > '0' && buffer[start + 1] < '7') {
                    isOctal = true;
                    break;
                }
                if (buffer[start + 1] == '8' || buffer[start + 1] == '9') {
                    isOctal = true;
                    isMalformedOctal = true;
                    break;
                }
                ** GOTO lbl89
            }
        }
        if (true) ** GOTO lbl89
        block21: do {
            pos = this.bufferPos[this.bufferStackPos];
            block3 : switch (buffer[pos]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (buffer[pos] != '8' && buffer[pos] != '9' || !isOctal) break;
                    isMalformedOctal = true;
                    break block21;
                }
                case '.': {
                    if (this.isLimitReached()) {
                        this.handleNoSuchCompletion();
                    }
                    if (isFloat) {
                        this.handleProblem(0x1000004, start, null);
                        break block21;
                    }
                    isFloat = true;
                    break;
                }
                case 'E': 
                case 'e': {
                    if (isHex) break;
                    if (hasExponent || pos + 1 >= limit) break block21;
                    switch (buffer[pos + 1]) {
                        case '+': 
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            isFloat = true;
                            hasExponent = true;
                            v1 = this.bufferStackPos;
                            this.bufferPos[v1] = this.bufferPos[v1] + 1;
                            break block3;
                        }
                    }
                    break block21;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': {
                    if (!isHex) break block21;
                    break;
                }
                case 'F': 
                case 'f': {
                    if (isHex) break;
                    v2 = this.bufferStackPos;
                    this.bufferPos[v2] = this.bufferPos[v2] + 1;
                    if (this.bufferPos[this.bufferStackPos] >= buffer.length || buffer[this.bufferPos[this.bufferStackPos]] != 'i') break block21;
                    break;
                }
                case 'P': 
                case 'p': {
                    if (!isFloat || !isHex) {
                        v3 = this.bufferStackPos;
                        this.bufferPos[v3] = this.bufferPos[v3] - 1;
                        break block21;
                    }
                    if (hasExponent || pos + 1 >= limit) break block21;
                    switch (buffer[pos + 1]) {
                        case '+': 
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            isFloat = true;
                            hasExponent = true;
                            v4 = this.bufferStackPos;
                            this.bufferPos[v4] = this.bufferPos[v4] + 1;
                            break block3;
                        }
                    }
                    break block21;
                }
                case 'L': 
                case 'U': 
                case 'l': 
                case 'u': {
                    if (true) ** GOTO lbl83
                    do {
                        switch (buffer[this.bufferPos[this.bufferStackPos]]) {
                            case 'L': 
                            case 'U': 
                            case 'l': 
                            case 'u': {
                                break;
                            }
                            default: {
                                break block21;
                            }
                        }
lbl83:
                        // 2 sources

                        v5 = this.bufferStackPos;
                    } while ((this.bufferPos[v5] = this.bufferPos[v5] + 1) < limit);
                    break block21;
                }
                default: {
                    if (!this.scannerExtension.isValidNumericLiteralSuffix(buffer[pos])) break block21;
                    break;
                }
            }
lbl89:
            // 12 sources

            v6 = this.bufferStackPos;
        } while ((this.bufferPos[v6] = this.bufferPos[v6] + 1) < limit);
        v7 = this.bufferStackPos;
        this.bufferPos[v7] = this.bufferPos[v7] - 1;
        result = CharArrayUtils.extract(buffer, start, this.bufferPos[this.bufferStackPos] - start + 1);
        v8 = tokenType = isFloat != false ? 129 : 2;
        if (tokenType == 2 && isHex && result.length == 2) {
            this.handleProblem(0x1000005, start, result);
        } else if (tokenType == 2 && isOctal && isMalformedOctal) {
            this.handleProblem(0x1000007, start, result);
        }
        return this.newToken(tokenType, result);
    }

    private boolean branchState(int state) {
        if (state != 1 && this.branchStackPos == -1) {
            return false;
        }
        switch (state) {
            case 1: {
                if (++this.branchStackPos == this.branches.length) {
                    int[] temp = new int[this.branches.length << 1];
                    System.arraycopy(this.branches, 0, temp, 0, this.branches.length);
                    this.branches = temp;
                }
                this.branches[this.branchStackPos] = 1;
                return true;
            }
            case 2: 
            case 3: {
                switch (this.branches[this.branchStackPos]) {
                    case 1: 
                    case 2: {
                        this.branches[this.branchStackPos] = state;
                        return true;
                    }
                }
                return false;
            }
            case 4: {
                switch (this.branches[this.branchStackPos]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        --this.branchStackPos;
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private void handlePPDirective(int pos) throws EndOfFileException {
        block28: {
            block27: {
                buffer = this.bufferStack[this.bufferStackPos];
                limit = this.bufferLimit[this.bufferStackPos];
                startingLineNumber = this.getLineNumber(pos);
                this.skipOverWhiteSpace();
                if (this.isLimitReached()) {
                    this.handleCompletionOnPreprocessorDirective("#");
                }
                v0 = this.bufferStackPos;
                this.bufferPos[v0] = this.bufferPos[v0] + 1;
                start = this.bufferPos[v0];
                if (start >= limit || buffer[start] == '\n') {
                    return;
                }
                problem = false;
                c = buffer[start];
                if (c < 'a' || c > 'z') break block27;
                ** GOTO lbl-1000
                while ((c = buffer[this.bufferPos[this.bufferStackPos]]) >= 'a' && c <= 'z' || c == '_') lbl-1000:
                // 2 sources

                {
                    v1 = this.bufferStackPos;
                    this.bufferPos[v1] = this.bufferPos[v1] + 1;
                    if (this.bufferPos[v1] < limit) continue;
                }
                v2 = this.bufferStackPos;
                this.bufferPos[v2] = this.bufferPos[v2] - 1;
                len = this.bufferPos[this.bufferStackPos] - start + 1;
                if (this.isLimitReached()) {
                    this.handleCompletionOnPreprocessorDirective(new String(buffer, pos, len + 1));
                }
                if ((type = Scanner2.ppKeywords.get(buffer, start, len)) == Scanner2.ppKeywords.undefined) break block28;
                switch (type) {
                    case 6: {
                        this.handlePPInclude(pos, false, startingLineNumber);
                        return;
                    }
                    case 10: {
                        this.handlePPInclude(pos, true, startingLineNumber);
                        return;
                    }
                    case 7: {
                        this.handlePPDefine(pos, startingLineNumber);
                        return;
                    }
                    case 8: {
                        this.handlePPUndef();
                        return;
                    }
                    case 1: {
                        this.handlePPIfdef(true);
                        return;
                    }
                    case 2: {
                        this.handlePPIfdef(false);
                        return;
                    }
                    case 0: {
                        start = this.bufferPos[this.bufferStackPos] + 1;
                        this.skipToNewLine();
                        len = this.bufferPos[this.bufferStackPos] - start;
                        if (this.isLimitReached()) {
                            this.handleCompletionOnExpression(CharArrayUtils.extract(buffer, start, len));
                        }
                        this.branchState(1);
                        if (this.expressionEvaluator.evaluate(buffer, start, len, this.definitions, this.getLineNumber(this.bufferPos[this.bufferStackPos]), this.getCurrentFilename()) == 0L) {
                            if (this.dlog != null) {
                                this.dlog.println("#if <FALSE> " + new String(buffer, start + 1, len - 1));
                            }
                            this.skipOverConditionalCode(true);
                            if (this.isLimitReached()) {
                                this.handleInvalidCompletion();
                            }
                        } else if (this.dlog != null) {
                            this.dlog.println("#if <TRUE> " + new String(buffer, start + 1, len - 1));
                        }
                        return;
                    }
                    case 3: 
                    case 4: {
                        if (this.branchState(type == 4 ? 3 : 2)) {
                            this.skipToNewLine();
                            this.skipOverConditionalCode(false);
                        } else {
                            this.handleProblem(0x2000004, start, Scanner2.ppKeywords.findKey(buffer, start, len));
                            this.skipToNewLine();
                        }
                        if (this.isLimitReached()) {
                            this.handleInvalidCompletion();
                        }
                        return;
                    }
                    case 9: {
                        this.skipOverWhiteSpace();
                        start = this.bufferPos[this.bufferStackPos] + 1;
                        this.skipToNewLine();
                        len = this.bufferPos[this.bufferStackPos] - start;
                        this.handleProblem(0x2000001, start, CharArrayUtils.extract(buffer, start, len));
                        ** break;
                    }
                    case 5: {
                        if (!this.branchState(4)) {
                            this.handleProblem(0x2000004, start, Scanner2.ppKeywords.findKey(buffer, start, len));
                            ** break;
                        }
                        break block28;
                    }
                    default: {
                        problem = true;
                        ** break;
                    }
                }
lbl91:
                // 3 sources

                break block28;
            }
            problem = true;
        }
        if (problem) {
            this.handleProblem(0x2000006, start, null);
        }
        this.skipToNewLine();
    }

    /*
     * Unable to fully structure code
     */
    private void handlePPInclude(int pos2, boolean next, int startingLineNumber) {
        block36: {
            block37: {
                block34: {
                    buffer = this.bufferStack[this.bufferStackPos];
                    limit = this.bufferLimit[this.bufferStackPos];
                    this.skipOverWhiteSpace();
                    startOffset = pos2;
                    v0 = this.bufferStackPos;
                    v1 = this.bufferPos[v0] + 1;
                    this.bufferPos[v0] = v1;
                    pos = v1;
                    if (pos >= limit) {
                        return;
                    }
                    local = false;
                    filename = null;
                    endOffset = startOffset;
                    nameOffset = 0;
                    nameEndOffset = 0;
                    nameLine = 0;
                    endLine = 0;
                    c = buffer[pos];
                    if (c == '\n') {
                        return;
                    }
                    if (c != '\"') break block34;
                    nameLine = this.getLineNumber(this.bufferPos[this.bufferStackPos]);
                    local = true;
                    start = this.bufferPos[this.bufferStackPos] + 1;
                    length = 0;
                    escaped = false;
                    if (true) ** GOTO lbl41
                    do {
                        block35: {
                            ++length;
                            c = buffer[this.bufferPos[this.bufferStackPos]];
                            if (c != '\"') break block35;
                            if (!escaped) {
                                break;
                            }
                            ** GOTO lbl-1000
                        }
                        if (c == '\\') {
                            escaped = escaped == false;
                        } else lbl-1000:
                        // 2 sources

                        {
                            escaped = false;
                        }
lbl41:
                        // 3 sources

                        v2 = this.bufferStackPos;
                    } while ((this.bufferPos[v2] = this.bufferPos[v2] + 1) < limit);
                    filename = new String(buffer, start, --length);
                    nameOffset = start;
                    nameEndOffset = start + length;
                    endOffset = start + length + 1;
                    break block36;
                }
                if (c != '<') break block37;
                nameLine = this.getLineNumber(this.bufferPos[this.bufferStackPos]);
                local = false;
                start = this.bufferPos[this.bufferStackPos] + 1;
                length = 0;
                if (true) ** GOTO lbl57
                do {
                    ++length;
lbl57:
                    // 2 sources

                    v3 = this.bufferStackPos;
                } while ((this.bufferPos[v3] = this.bufferPos[v3] + 1) < limit && buffer[this.bufferPos[this.bufferStackPos]] != '>');
                endOffset = start + length + 1;
                nameOffset = start;
                nameEndOffset = start + length;
                filename = new String(buffer, start, length);
                break block36;
            }
            startPos = pos;
            len = 1;
            if (true) ** GOTO lbl76
            do {
                if ((c = buffer[this.bufferPos[this.bufferStackPos]]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9' || Character.isUnicodeIdentifierPart(c)) {
                    ++len;
                } else {
                    if (c != '\\' || this.bufferPos[this.bufferStackPos] + 1 >= buffer.length || buffer[this.bufferPos[this.bufferStackPos] + 1] != '\n') break;
                    v4 = this.bufferStackPos;
                    this.bufferPos[v4] = this.bufferPos[v4] + 1;
                    len += 2;
                }
lbl76:
                // 3 sources

                v5 = this.bufferStackPos;
            } while ((this.bufferPos[v5] = this.bufferPos[v5] + 1) < limit);
            if ((expObject = this.definitions.get(buffer, startPos, len)) != null) {
                v6 = this.bufferStackPos;
                this.bufferPos[v6] = this.bufferPos[v6] - 1;
                t = null;
                if (expObject instanceof FunctionStyleMacro) {
                    t = this.handleFunctionStyleMacro((FunctionStyleMacro)expObject, false);
                } else if (expObject instanceof ObjectStyleMacro) {
                    t = ((ObjectStyleMacro)expObject).expansion;
                }
                if (t != null) {
                    if ((t = this.replaceArgumentMacros(t))[t.length - 1] == t[0] && t[0] == '\"') {
                        local = true;
                        filename = new String(t, 1, t.length - 2);
                    } else if (t[0] == '<' && t[t.length - 1] == '>') {
                        local = false;
                        filename = new String(t, 1, t.length - 2);
                    }
                }
            }
        }
        if (filename == null || filename == "") {
            this.handleProblem(0x2000006, startOffset, null);
            return;
        }
        fileNameArray = filename.toCharArray();
        endLine = this.getLineNumber(this.bufferPos[this.bufferStackPos]);
        this.skipToNewLine();
        if (this.parserMode == ParserMode.QUICK_PARSE) {
            inclusion = this.getASTFactory().createInclusion(fileNameArray, Scanner2.EMPTY_STRING_CHAR_ARRAY, local, startOffset, startingLineNumber, nameOffset, nameEndOffset, nameLine, endOffset, endLine, this.getCurrentFilename());
            this.callbackManager.pushCallback(new InclusionData(null, inclusion));
            this.callbackManager.pushCallback(inclusion);
        } else {
            reader = null;
            if (local && (parentFile = (file = new File(String.valueOf(this.getCurrentFilename()))).getParentFile()) != null) {
                absolutePath = parentFile.getAbsolutePath();
                finalPath = ScannerUtility.createReconciledPath(absolutePath, filename);
                reader = (CodeReader)this.fileCache.get(finalPath.toCharArray());
                if (reader == null && (reader = ScannerUtility.createReaderDuple(finalPath, this.requestor, this.getWorkingCopies())) != null && reader.filename != null) {
                    this.fileCache.put(reader.filename, reader);
                }
                if (reader != null) {
                    if (this.dlog != null) {
                        this.dlog.println("#include \"" + finalPath + "\"");
                    }
                    inclusion = this.getASTFactory().createInclusion(fileNameArray, reader.filename, local, startOffset, startingLineNumber, nameOffset, nameEndOffset, nameLine, endOffset, endLine, this.getCurrentFilename());
                    this.pushContext(reader.buffer, new InclusionData(reader, inclusion));
                    return;
                }
            }
            v7 = foundme = next == false;
            if (this.includePaths != null) {
                i = 0;
                while (i < this.includePaths.length) {
                    finalPath = ScannerUtility.createReconciledPath(this.includePaths[i], filename);
                    if (!foundme) {
                        if (finalPath.equals(((InclusionData)this.bufferData[this.bufferStackPos]).reader.filename)) {
                            foundme = true;
                        }
                    } else {
                        reader = (CodeReader)this.fileCache.get(finalPath.toCharArray());
                        if (reader == null && (reader = ScannerUtility.createReaderDuple(finalPath, this.requestor, this.getWorkingCopies())) != null && reader.filename != null) {
                            this.fileCache.put(reader.filename, reader);
                        }
                        if (reader != null) {
                            if (this.dlog != null) {
                                this.dlog.println("#include <" + finalPath + ">");
                            }
                            inclusion = this.getASTFactory().createInclusion(fileNameArray, reader.filename, local, startOffset, startingLineNumber, nameOffset, nameEndOffset, nameLine, endOffset, endLine, this.getCurrentFilename());
                            this.pushContext(reader.buffer, new InclusionData(reader, inclusion));
                            return;
                        }
                    }
                    ++i;
                }
            }
            if (reader == null) {
                this.handleProblem(0x2000002, startOffset, fileNameArray);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void handlePPDefine(int pos2, int startingLineNumber) {
        buffer = this.bufferStack[this.bufferStackPos];
        limit = this.bufferLimit[this.bufferStackPos];
        startingOffset = pos2;
        endingLine = 0;
        nameLine = 0;
        this.skipOverWhiteSpace();
        v0 = this.bufferStackPos;
        v1 = this.bufferPos[v0] + 1;
        this.bufferPos[v0] = v1;
        idstart = v1;
        if (idstart >= limit) {
            return;
        }
        c = buffer[idstart];
        if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || Character.isUnicodeIdentifierPart(c))) {
            this.handleProblem(0x2000005, idstart, null);
            this.skipToNewLine();
            return;
        }
        idlen = 1;
        ** GOTO lbl23
        while ((c = buffer[this.bufferPos[this.bufferStackPos]]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9' || Character.isUnicodeIdentifierPart(c)) {
            ++idlen;
lbl23:
            // 2 sources

            v2 = this.bufferStackPos;
            this.bufferPos[v2] = this.bufferPos[v2] + 1;
            if (this.bufferPos[v2] < limit) continue;
        }
        v3 = this.bufferStackPos;
        this.bufferPos[v3] = this.bufferPos[v3] - 1;
        nameLine = this.getLineNumber(this.bufferPos[this.bufferStackPos]);
        name = new char[idlen];
        System.arraycopy(buffer, idstart, name, 0, idlen);
        if (this.dlog != null) {
            this.dlog.println("#define " + new String(buffer, idstart, idlen));
        }
        arglist = null;
        pos = this.bufferPos[this.bufferStackPos];
        if (pos + 1 < limit && buffer[pos + 1] == '(') {
            v4 = this.bufferStackPos;
            this.bufferPos[v4] = this.bufferPos[v4] + 1;
            arglist = this.extractMacroParameters(idstart, name, true);
            if (arglist == null) {
                return;
            }
        }
        this.skipOverWhiteSpace();
        textstart = this.bufferPos[this.bufferStackPos] + 1;
        textend = textstart - 1;
        varArgDefinitionInd = -1;
        encounteredMultilineComment = false;
        usesVarArgInDefinition = false;
        while (this.bufferPos[this.bufferStackPos] + 1 < limit && buffer[this.bufferPos[this.bufferStackPos] + 1] != '\n') {
            if (CharArrayUtils.equals(buffer, this.bufferPos[this.bufferStackPos] + 1, Scanner2.VA_ARGS_CHARARRAY.length, Scanner2.VA_ARGS_CHARARRAY)) {
                usesVarArgInDefinition = true;
                varArgDefinitionInd = this.bufferPos[this.bufferStackPos] + 1;
            }
            if (arglist != null && !this.skipOverNonWhiteSpace(true)) {
                v5 = this.bufferStackPos;
                this.bufferPos[v5] = this.bufferPos[v5] + 1;
                if (this.skipOverWhiteSpace()) {
                    encounteredMultilineComment = true;
                }
                isArg = false;
                if (this.bufferPos[this.bufferStackPos] + 1 < limit) {
                    v6 = this.bufferStackPos;
                    this.bufferPos[v6] = this.bufferPos[v6] + 1;
                    i = 0;
                    while (i < arglist.length && arglist[i] != null) {
                        if (this.bufferPos[this.bufferStackPos] + arglist[i].length - 1 < limit) {
                            if (arglist[i].length > 3 && arglist[i][arglist[i].length - 3] == '.' && arglist[i][arglist[i].length - 2] == '.' && arglist[i][arglist[i].length - 3] == '.') {
                                varArgName = new char[arglist[i].length - 3];
                                System.arraycopy(arglist[i], 0, varArgName, 0, arglist[i].length - 3);
                                if (CharArrayUtils.equals(buffer, this.bufferPos[this.bufferStackPos], varArgName.length, varArgName)) {
                                    isArg = true;
                                    v7 = this.bufferStackPos;
                                    this.bufferPos[v7] = this.bufferPos[v7] + (arglist[i].length - 4);
                                    break;
                                }
                            } else if (CharArrayUtils.equals(buffer, this.bufferPos[this.bufferStackPos], arglist[i].length, arglist[i]) || CharArrayUtils.equals(arglist[i], Scanner2.ELLIPSIS_CHARARRAY) && CharArrayUtils.equals(buffer, this.bufferPos[this.bufferStackPos], Scanner2.VA_ARGS_CHARARRAY.length, Scanner2.VA_ARGS_CHARARRAY)) {
                                isArg = true;
                                v8 = this.bufferStackPos;
                                this.bufferPos[v8] = this.bufferPos[v8] + (arglist[i].length - 1);
                                break;
                            }
                        }
                        ++i;
                    }
                }
                if (!isArg) {
                    this.handleProblem(0x200000A, this.bufferPos[this.bufferStackPos], null);
                }
            } else {
                this.skipOverNonWhiteSpace();
            }
            textend = this.bufferPos[this.bufferStackPos];
            if (!this.skipOverWhiteSpace()) continue;
            encounteredMultilineComment = true;
        }
        textlen = textend - textstart + 1;
        endingLine = this.getLineNumber(this.bufferPos[this.bufferStackPos]);
        text = Scanner2.emptyCharArray;
        if (textlen > 0) {
            text = new char[textlen];
            System.arraycopy(buffer, textstart, text, 0, textlen);
        }
        if (encounteredMultilineComment) {
            text = this.removeMultilineCommentFromBuffer(text);
        }
        text = this.removedEscapedNewline(text, 0, text.length);
        this.definitions.put(name, arglist == null ? new ObjectStyleMacro(name, text) : new FunctionStyleMacro(name, text, arglist));
        if (usesVarArgInDefinition && this.definitions.get(name) instanceof FunctionStyleMacro && !((FunctionStyleMacro)this.definitions.get(name)).hasVarArgs()) {
            this.handleProblem(0x200000D, varArgDefinitionInd, null);
        }
        this.callbackManager.pushCallback(this.getASTFactory().createMacro(name, startingOffset, startingLineNumber, idstart, idstart + idlen, nameLine, textstart + textlen, endingLine, this.getCurrentFilename()));
    }

    private char[][] extractMacroParameters(int idstart, char[] name, boolean reportProblems) {
        char[] buffer = this.bufferStack[this.bufferStackPos];
        int limit = this.bufferLimit[this.bufferStackPos];
        if (this.bufferPos[this.bufferStackPos] >= limit || buffer[this.bufferPos[this.bufferStackPos]] != '(') {
            return null;
        }
        char[][] arglist = new char[4][];
        int currarg = -1;
        while (this.bufferPos[this.bufferStackPos] < limit) {
            this.skipOverWhiteSpace();
            int n = this.bufferStackPos;
            this.bufferPos[n] = this.bufferPos[n] + 1;
            if (this.bufferPos[n] >= limit) {
                return null;
            }
            char c = buffer[this.bufferPos[this.bufferStackPos]];
            int argstart = this.bufferPos[this.bufferStackPos];
            if (c == ')') break;
            if (c == ',') continue;
            if (c == '.' && this.bufferPos[this.bufferStackPos] + 1 < limit && buffer[this.bufferPos[this.bufferStackPos] + 1] == '.' && this.bufferPos[this.bufferStackPos] + 2 < limit && buffer[this.bufferPos[this.bufferStackPos] + 2] == '.') {
                int n2 = this.bufferStackPos;
                this.bufferPos[n2] = this.bufferPos[n2] - 1;
            } else if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || Character.isUnicodeIdentifierPart(c) || !reportProblems)) {
                this.handleProblem(0x2000005, idstart, name);
                this.skipToNewLine();
                return null;
            }
            this.skipOverIdentifier();
            if (++currarg == arglist.length) {
                char[][] oldarglist = arglist;
                arglist = new char[oldarglist.length * 2][];
                System.arraycopy(oldarglist, 0, arglist, 0, oldarglist.length);
            }
            int arglen = this.bufferPos[this.bufferStackPos] - argstart + 1;
            char[] arg = new char[arglen];
            System.arraycopy(buffer, argstart, arg, 0, arglen);
            arglist[currarg] = arg;
        }
        return arglist;
    }

    private char[] removedEscapedNewline(char[] text, int start, int len) {
        if (CharArrayUtils.indexOf('\n', text, start, len) == -1) {
            return text;
        }
        char[] result = new char[text.length];
        Arrays.fill(result, ' ');
        int counter = 0;
        int i = 0;
        while (i < text.length) {
            if (text[i] == '\\' && i + 1 < text.length && text[i + 1] == '\n') {
                ++i;
            } else if (text[i] == '\\' && i + 1 < text.length && text[i + 1] == '\r' && i + 2 < text.length && text[i + 2] == '\n') {
                i += 2;
            } else {
                result[counter++] = text[i];
            }
            ++i;
        }
        return CharArrayUtils.trim(result);
    }

    private char[] removeMultilineCommentFromBuffer(char[] text) {
        char[] result = new char[text.length];
        Arrays.fill(result, ' ');
        int resultCount = 0;
        int i = 0;
        while (i < text.length) {
            if (text[i] == '/' && i + 1 < text.length && text[i + 1] == '*') {
                i += 2;
                while (i < text.length && (text[i] != '*' || i + 1 >= text.length || text[i + 1] != '/')) {
                    ++i;
                }
                ++i;
            } else {
                result[resultCount++] = text[i];
            }
            ++i;
        }
        return CharArrayUtils.trim(result);
    }

    /*
     * Unable to fully structure code
     */
    private void handlePPUndef() throws EndOfFileException {
        buffer = this.bufferStack[this.bufferStackPos];
        limit = this.bufferLimit[this.bufferStackPos];
        this.skipOverWhiteSpace();
        v0 = this.bufferStackPos;
        v1 = this.bufferPos[v0] + 1;
        this.bufferPos[v0] = v1;
        idstart = v1;
        if (idstart >= limit) {
            return;
        }
        c = buffer[idstart];
        if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || Character.isUnicodeIdentifierPart(c))) {
            this.skipToNewLine();
            return;
        }
        idlen = 1;
        ** GOTO lbl19
        while ((c = buffer[this.bufferPos[this.bufferStackPos]]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9' || Character.isUnicodeIdentifierPart(c)) {
            ++idlen;
lbl19:
            // 2 sources

            v2 = this.bufferStackPos;
            this.bufferPos[v2] = this.bufferPos[v2] + 1;
            if (this.bufferPos[v2] < limit) continue;
        }
        v3 = this.bufferStackPos;
        this.bufferPos[v3] = this.bufferPos[v3] - 1;
        if (this.isLimitReached()) {
            this.handleCompletionOnDefinition(new String(buffer, idstart, idlen));
        }
        this.skipToNewLine();
        this.definitions.remove(buffer, idstart, idlen);
        if (this.dlog != null) {
            this.dlog.println("#undef " + new String(buffer, idstart, idlen));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void handlePPIfdef(boolean positive) throws EndOfFileException {
        buffer = this.bufferStack[this.bufferStackPos];
        limit = this.bufferLimit[this.bufferStackPos];
        if (this.isLimitReached()) {
            this.handleCompletionOnDefinition("");
        }
        this.skipOverWhiteSpace();
        if (this.isLimitReached()) {
            this.handleCompletionOnDefinition("");
        }
        v0 = this.bufferStackPos;
        this.bufferPos[v0] = this.bufferPos[v0] + 1;
        idstart = this.bufferPos[v0];
        if (idstart >= limit) {
            return;
        }
        c = buffer[idstart];
        if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || Character.isUnicodeIdentifierPart(c))) {
            this.skipToNewLine();
            return;
        }
        idlen = 1;
        ** GOTO lbl22
        while ((c = buffer[this.bufferPos[this.bufferStackPos]]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9' || Character.isUnicodeIdentifierPart(c)) {
            ++idlen;
lbl22:
            // 2 sources

            v1 = this.bufferStackPos;
            this.bufferPos[v1] = this.bufferPos[v1] + 1;
            if (this.bufferPos[v1] < limit) continue;
        }
        v2 = this.bufferStackPos;
        this.bufferPos[v2] = this.bufferPos[v2] - 1;
        if (this.isLimitReached()) {
            this.handleCompletionOnDefinition(new String(buffer, idstart, idlen));
        }
        this.skipToNewLine();
        this.branchState(1);
        if (this.definitions.get(buffer, idstart, idlen) != null == positive) {
            if (this.dlog != null) {
                this.dlog.println(String.valueOf(positive != false ? "#ifdef" : "#ifndef") + " <TRUE> " + new String(buffer, idstart, idlen));
            }
            return;
        }
        if (this.dlog != null) {
            this.dlog.println(String.valueOf(positive != false ? "#ifdef" : "#ifndef") + " <FALSE> " + new String(buffer, idstart, idlen));
        }
        this.skipOverConditionalCode(true);
        if (this.isLimitReached()) {
            this.handleInvalidCompletion();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void skipOverConditionalCode(boolean checkelse) {
        buffer = this.bufferStack[this.bufferStackPos];
        limit = this.bufferLimit[this.bufferStackPos];
        nesting = 0;
        block6: while (this.bufferPos[this.bufferStackPos] < limit) {
            block13: {
                this.skipOverWhiteSpace();
                v0 = this.bufferStackPos;
                this.bufferPos[v0] = this.bufferPos[v0] + 1;
                if (this.bufferPos[v0] >= limit) {
                    return;
                }
                c = buffer[this.bufferPos[this.bufferStackPos]];
                if (c != '#') break block13;
                this.skipOverWhiteSpace();
                v1 = this.bufferStackPos;
                v2 = this.bufferPos[v1] + 1;
                this.bufferPos[v1] = v2;
                start = v2;
                if (start >= limit || buffer[start] == '\n' || (c = buffer[start]) < 'a' || c > 'z') continue;
                ** GOTO lbl-1000
                while ((c = buffer[this.bufferPos[this.bufferStackPos]]) >= 'a' && c <= 'z') lbl-1000:
                // 2 sources

                {
                    v3 = this.bufferStackPos;
                    this.bufferPos[v3] = this.bufferPos[v3] + 1;
                    if (this.bufferPos[v3] < limit) continue;
                }
                v4 = this.bufferStackPos;
                this.bufferPos[v4] = this.bufferPos[v4] - 1;
                len = this.bufferPos[this.bufferStackPos] - start + 1;
                type = Scanner2.ppKeywords.get(buffer, start, len);
                if (type == Scanner2.ppKeywords.undefined) continue;
                switch (type) {
                    case 0: 
                    case 1: 
                    case 2: {
                        ++nesting;
                        this.branchState(1);
                        break;
                    }
                    case 4: {
                        if (this.branchState(3)) {
                            if (!checkelse || nesting != 0) continue block6;
                            this.skipToNewLine();
                            return;
                        }
                        this.handleProblem(0x2000004, start, Scanner2.ppKeywords.findKey(buffer, start, len));
                        this.skipToNewLine();
                        break;
                    }
                    case 3: {
                        if (this.branchState(2)) {
                            if (!checkelse || nesting != 0) continue block6;
                            start = this.bufferPos[this.bufferStackPos] + 1;
                            this.skipToNewLine();
                            len = this.bufferPos[this.bufferStackPos] - start;
                            if (this.expressionEvaluator.evaluate(buffer, start, len, this.definitions, this.getLineNumber(this.bufferPos[this.bufferStackPos]), this.getCurrentFilename()) == 0L) break;
                            return;
                        }
                        this.handleProblem(0x2000004, start, Scanner2.ppKeywords.findKey(buffer, start, len));
                        this.skipToNewLine();
                        break;
                    }
                    case 5: {
                        if (this.branchState(4)) {
                            if (nesting > 0) {
                                --nesting;
                                break;
                            }
                            this.skipToNewLine();
                            return;
                        }
                        this.handleProblem(0x2000004, start, Scanner2.ppKeywords.findKey(buffer, start, len));
                        this.skipToNewLine();
                    }
                }
                continue;
            }
            if (c == '\n') continue;
            this.skipToNewLine();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private boolean skipOverWhiteSpace() {
        boolean encounteredMultiLineComment;
        block13: {
            int n;
            int pos;
            int limit;
            char[] buffer;
            block12: {
                buffer = this.bufferStack[this.bufferStackPos];
                limit = this.bufferLimit[this.bufferStackPos];
                pos = this.bufferPos[this.bufferStackPos];
                encounteredMultiLineComment = false;
                if (!true) break block12;
                n = this.bufferStackPos;
                if ((this.bufferPos[n] = this.bufferPos[n] + 1) >= limit) break block13;
            }
            do {
                block11: {
                    pos = this.bufferPos[this.bufferStackPos];
                    switch (buffer[pos]) {
                        case '\t': 
                        case '\r': 
                        case ' ': {
                            break block11;
                        }
                        case '/': {
                            if (pos + 1 >= limit) break;
                            if (buffer[pos + 1] == '/') {
                                this.skipToNewLine();
                                int n2 = this.bufferStackPos;
                                this.bufferPos[n2] = this.bufferPos[n2] - 1;
                                return false;
                            }
                            if (buffer[pos + 1] != '*') break;
                            int n3 = this.bufferStackPos;
                            this.bufferPos[n3] = this.bufferPos[n3] + 2;
                            while (this.bufferPos[this.bufferStackPos] < limit) {
                                pos = this.bufferPos[this.bufferStackPos];
                                if (buffer[pos] == '*' && pos + 1 < limit && buffer[pos + 1] == '/') {
                                    int n4 = this.bufferStackPos;
                                    this.bufferPos[n4] = this.bufferPos[n4] + 1;
                                    encounteredMultiLineComment = true;
                                    break block11;
                                }
                                int n5 = this.bufferStackPos;
                                this.bufferPos[n5] = this.bufferPos[n5] + 1;
                            }
                            break block11;
                        }
                        case '\\': {
                            if (pos + 1 < limit && buffer[pos + 1] == '\n') {
                                int n6 = this.bufferStackPos;
                                this.bufferPos[n6] = this.bufferPos[n6] + 1;
                            } else {
                                if (pos + 1 >= limit || buffer[pos + 1] != '\r' || pos + 2 >= limit || buffer[pos + 2] != '\n') break;
                                int n7 = this.bufferStackPos;
                                this.bufferPos[n7] = this.bufferPos[n7] + 2;
                            }
                            break block11;
                        }
                    }
                    int n8 = this.bufferStackPos;
                    this.bufferPos[n8] = this.bufferPos[n8] - 1;
                    return encounteredMultiLineComment;
                }
                n = this.bufferStackPos;
            } while ((this.bufferPos[n] = this.bufferPos[n] + 1) < limit);
        }
        int n = this.bufferStackPos;
        this.bufferPos[n] = this.bufferPos[n] - 1;
        return encounteredMultiLineComment;
    }

    private int indexOfNextNonWhiteSpace(char[] buffer, int start, int limit) {
        if (start < 0 || start >= buffer.length || limit > buffer.length) {
            return -1;
        }
        int pos = start + 1;
        block8: while (pos < limit) {
            block0 : switch (buffer[pos++]) {
                case '\t': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '/': {
                    if (pos >= limit) continue block8;
                    if (buffer[pos] == '/') {
                        while (++pos < limit) {
                            switch (buffer[pos]) {
                                case '\\': {
                                    ++pos;
                                    break;
                                }
                            }
                        }
                        continue block8;
                    }
                    if (buffer[pos] != '*') continue block8;
                    while (++pos < limit) {
                        if (buffer[pos] != '*' || pos + 1 >= limit || buffer[pos + 1] != '/') continue;
                        pos += 2;
                        break block0;
                    }
                    continue block8;
                }
                case '\\': {
                    if (pos < limit && (buffer[pos] == '\n' || buffer[pos] == '\r')) {
                        ++pos;
                        break;
                    }
                }
                default: {
                    return --pos;
                }
            }
        }
        return pos;
    }

    private void skipOverNonWhiteSpace() {
        this.skipOverNonWhiteSpace(false);
    }

    /*
     * Unable to fully structure code
     */
    private boolean skipOverNonWhiteSpace(boolean stopAtPound) {
        buffer = this.bufferStack[this.bufferStackPos];
        limit = this.bufferLimit[this.bufferStackPos];
        if (true) ** GOTO lbl83
        do {
            switch (buffer[this.bufferPos[this.bufferStackPos]]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    v0 = this.bufferStackPos;
                    this.bufferPos[v0] = this.bufferPos[v0] - 1;
                    return true;
                }
                case '/': {
                    pos = this.bufferPos[this.bufferStackPos];
                    if ((pos + 1 >= limit || buffer[pos + 1] != '/') && buffer[pos + 1] != '*') break;
                    v1 = this.bufferStackPos;
                    this.bufferPos[v1] = this.bufferPos[v1] - 1;
                    return true;
                }
                case '\\': {
                    pos = this.bufferPos[this.bufferStackPos];
                    if (pos + 1 < limit && buffer[pos + 1] == '\n') {
                        v2 = this.bufferStackPos;
                        this.bufferPos[v2] = this.bufferPos[v2] - 1;
                        return true;
                    }
                    if (pos + 1 >= limit || buffer[pos + 1] != '\r' || pos + 2 >= limit || buffer[pos + 2] != '\n') break;
                    v3 = this.bufferStackPos;
                    this.bufferPos[v3] = this.bufferPos[v3] + 2;
                    break;
                }
                case '\"': {
                    escaped = false;
                    if (this.bufferPos[this.bufferStackPos] - 1 <= 0 || buffer[this.bufferPos[this.bufferStackPos] - 1] != '\\') ** GOTO lbl49
                    escaped = true;
                    if (true) ** GOTO lbl49
                    block19: do {
                        switch (buffer[this.bufferPos[this.bufferStackPos]]) {
                            case '\\': {
                                escaped = escaped == false;
                                break;
                            }
                            case '\"': {
                                if (!escaped) break block19;
                                escaped = false;
                                break;
                            }
                            case '\n': {
                                if (!escaped) break block19;
                            }
                            case '/': {
                                if (escaped && this.bufferPos[this.bufferStackPos] + 1 < limit && (buffer[this.bufferPos[this.bufferStackPos] + 1] == '/' || buffer[this.bufferPos[this.bufferStackPos] + 1] == '*')) {
                                    v4 = this.bufferStackPos;
                                    this.bufferPos[v4] = this.bufferPos[v4] - 1;
                                    return true;
                                }
                            }
                            default: {
                                escaped = false;
                            }
                        }
lbl49:
                        // 5 sources

                        v5 = this.bufferStackPos;
                    } while ((this.bufferPos[v5] = this.bufferPos[v5] + 1) < this.bufferLimit[this.bufferStackPos]);
                    if (this.bufferPos[this.bufferStackPos] != this.bufferLimit[this.bufferStackPos]) break;
                    v6 = this.bufferStackPos;
                    this.bufferPos[v6] = this.bufferPos[v6] - 1;
                    break;
                }
                case '\'': {
                    escaped = false;
                    if (true) ** GOTO lbl69
                    block20: do {
                        switch (buffer[this.bufferPos[this.bufferStackPos]]) {
                            case '\\': {
                                escaped = escaped == false;
                                break;
                            }
                            case '\'': {
                                if (!escaped) break block20;
                                escaped = false;
                                break;
                            }
                            default: {
                                escaped = false;
                            }
                        }
lbl69:
                        // 4 sources

                        v7 = this.bufferStackPos;
                    } while ((this.bufferPos[v7] = this.bufferPos[v7] + 1) < this.bufferLimit[this.bufferStackPos]);
                    if (this.bufferPos[this.bufferStackPos] != this.bufferLimit[this.bufferStackPos]) break;
                    v8 = this.bufferStackPos;
                    this.bufferPos[v8] = this.bufferPos[v8] - 1;
                    break;
                }
                case '#': {
                    if (!stopAtPound) break;
                    if (this.bufferPos[this.bufferStackPos] + 1 >= limit || buffer[this.bufferPos[this.bufferStackPos] + 1] != '#') {
                        v9 = this.bufferStackPos;
                        this.bufferPos[v9] = this.bufferPos[v9] - 1;
                        return false;
                    }
                    v10 = this.bufferStackPos;
                    this.bufferPos[v10] = this.bufferPos[v10] + 1;
                }
            }
lbl83:
            // 11 sources

            v11 = this.bufferStackPos;
        } while ((this.bufferPos[v11] = this.bufferPos[v11] + 1) < limit);
        v12 = this.bufferStackPos;
        this.bufferPos[v12] = this.bufferPos[v12] - 1;
        return true;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private int skipOverMacroArg() {
        int argEnd;
        block15: {
            int n;
            int nesting;
            int limit;
            char[] buffer;
            block14: {
                buffer = this.bufferStack[this.bufferStackPos];
                limit = this.bufferLimit[this.bufferStackPos];
                int n2 = this.bufferStackPos;
                int n3 = this.bufferPos[n2];
                this.bufferPos[n2] = n3 - 1;
                argEnd = n3;
                nesting = 0;
                if (!true) break block14;
                n = this.bufferStackPos;
                if ((this.bufferPos[n] = this.bufferPos[n] + 1) >= limit) break block15;
            }
            do {
                block0 : switch (buffer[this.bufferPos[this.bufferStackPos]]) {
                    case '(': {
                        ++nesting;
                        break;
                    }
                    case ')': {
                        if (nesting == 0) {
                            int n4 = this.bufferStackPos;
                            this.bufferPos[n4] = this.bufferPos[n4] - 1;
                            return argEnd;
                        }
                        --nesting;
                        break;
                    }
                    case ',': {
                        if (nesting != 0) break;
                        int n5 = this.bufferStackPos;
                        this.bufferPos[n5] = this.bufferPos[n5] - 1;
                        return argEnd;
                    }
                    case '\"': {
                        boolean escaped = false;
                        while (true) {
                            int n6 = this.bufferStackPos;
                            this.bufferPos[n6] = this.bufferPos[n6] + 1;
                            if (this.bufferPos[n6] >= this.bufferLimit[this.bufferStackPos]) break block0;
                            switch (buffer[this.bufferPos[this.bufferStackPos]]) {
                                case '\\': {
                                    escaped = !escaped;
                                    break;
                                }
                                case '\"': {
                                    if (!escaped) break block0;
                                    escaped = false;
                                    break;
                                }
                                default: {
                                    escaped = false;
                                    break;
                                }
                            }
                        }
                    }
                }
                argEnd = this.bufferPos[this.bufferStackPos];
                this.skipOverWhiteSpace();
                n = this.bufferStackPos;
            } while ((this.bufferPos[n] = this.bufferPos[n] + 1) < limit);
        }
        int n = this.bufferStackPos;
        this.bufferPos[n] = this.bufferPos[n] - 1;
        return argEnd;
    }

    /*
     * Unable to fully structure code
     */
    private void skipOverIdentifier() {
        buffer = this.bufferStack[this.bufferStackPos];
        limit = this.bufferLimit[this.bufferStackPos];
        if (true) ** GOTO lbl34
        do {
            block8: {
                if ((c = buffer[this.bufferPos[this.bufferStackPos]]) != '.' || this.bufferPos[this.bufferStackPos] + 1 >= limit || buffer[this.bufferPos[this.bufferStackPos] + 1] != '.' || this.bufferPos[this.bufferStackPos] + 2 >= limit || buffer[this.bufferPos[this.bufferStackPos] + 2] != '.') break block8;
                v0 = this.bufferStackPos;
                this.bufferPos[v0] = this.bufferPos[v0] + 2;
                end = this.bufferPos[this.bufferStackPos];
                if (true) ** GOTO lbl29
                do {
                    if ((c2 = buffer[this.bufferPos[this.bufferStackPos]]) == ')') {
                        this.bufferPos[this.bufferStackPos] = end;
                        return;
                    }
                    switch (c2) {
                        case '\t': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        case '\\': {
                            if (this.bufferPos[this.bufferStackPos] + 1 < limit && buffer[this.bufferPos[this.bufferStackPos] + 1] == '\n') {
                                v1 = this.bufferStackPos;
                                this.bufferPos[v1] = this.bufferPos[v1] + 1;
                                break;
                            }
                            if (this.bufferPos[this.bufferStackPos] + 1 >= limit || buffer[this.bufferPos[this.bufferStackPos] + 1] != '\r' || this.bufferPos[this.bufferStackPos] + 2 >= limit || buffer[this.bufferPos[this.bufferStackPos] + 2] != '\n') break;
                            v2 = this.bufferStackPos;
                            this.bufferPos[v2] = this.bufferPos[v2] + 2;
                            break;
                        }
                        default: {
                            this.handleProblem(0x200000C, this.bufferPos[this.bufferStackPos], String.valueOf(c2).toCharArray());
                            return;
                        }
                    }
lbl29:
                    // 5 sources

                    v3 = this.bufferStackPos;
                } while ((this.bufferPos[v3] = this.bufferPos[v3] + 1) < limit);
                break;
            }
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9') && !Character.isUnicodeIdentifierPart(c)) break;
lbl34:
            // 2 sources

            v4 = this.bufferStackPos;
        } while ((this.bufferPos[v4] = this.bufferPos[v4] + 1) < limit);
        v5 = this.bufferStackPos;
        this.bufferPos[v5] = this.bufferPos[v5] - 1;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private void skipToNewLine() {
        block12: {
            int n;
            boolean escaped;
            int pos;
            int limit;
            char[] buffer;
            block11: {
                buffer = this.bufferStack[this.bufferStackPos];
                limit = this.bufferLimit[this.bufferStackPos];
                int n2 = this.bufferStackPos;
                this.bufferPos[n2] = this.bufferPos[n2] + 1;
                pos = this.bufferPos[n2];
                if (pos < limit && buffer[pos] == '\n') {
                    return;
                }
                escaped = false;
                if (!true) break block11;
                n = this.bufferStackPos;
                if ((this.bufferPos[n] = this.bufferPos[n] + 1) >= limit) break block12;
            }
            do {
                block13: {
                    block0 : switch (buffer[this.bufferPos[this.bufferStackPos]]) {
                        case '/': {
                            pos = this.bufferPos[this.bufferStackPos];
                            if (pos + 1 >= limit || buffer[pos + 1] != '*') break;
                            int n3 = this.bufferStackPos;
                            this.bufferPos[n3] = this.bufferPos[n3] + 1;
                            do {
                                int n4 = this.bufferStackPos;
                                this.bufferPos[n4] = this.bufferPos[n4] + 1;
                                if (this.bufferPos[n4] >= limit) break block0;
                            } while (buffer[pos = this.bufferPos[this.bufferStackPos]] != '*' || pos + 1 >= limit || buffer[pos + 1] != '/');
                            int n5 = this.bufferStackPos;
                            this.bufferPos[n5] = this.bufferPos[n5] + 1;
                            break;
                        }
                        case '\\': {
                            escaped = !escaped;
                            break block13;
                        }
                        case '\n': {
                            if (!escaped) {
                                return;
                            }
                            escaped = false;
                            break;
                        }
                        case '\r': {
                            if (escaped && this.bufferPos[this.bufferStackPos] < limit && buffer[this.bufferPos[this.bufferStackPos] + 1] == '\n') {
                                escaped = false;
                                int n6 = this.bufferStackPos;
                                this.bufferPos[n6] = this.bufferPos[n6] + 1;
                                break;
                            }
                            if (escaped || this.bufferPos[this.bufferStackPos] >= limit || buffer[this.bufferPos[this.bufferStackPos] + 1] != '\n') break;
                            int n7 = this.bufferStackPos;
                            this.bufferPos[n7] = this.bufferPos[n7] + 1;
                            return;
                        }
                    }
                    escaped = false;
                }
                n = this.bufferStackPos;
            } while ((this.bufferPos[n] = this.bufferPos[n] + 1) < limit);
        }
    }

    /*
     * Unable to fully structure code
     */
    private char[] handleFunctionStyleMacro(FunctionStyleMacro macro, boolean pushContext) {
        buffer = this.bufferStack[this.bufferStackPos];
        limit = this.bufferLimit[this.bufferStackPos];
        start = this.bufferPos[this.bufferStackPos] - macro.name.length + 1;
        this.skipOverWhiteSpace();
        while (this.bufferPos[this.bufferStackPos] < limit && buffer[this.bufferPos[this.bufferStackPos]] == '\\' && this.bufferPos[this.bufferStackPos] + 1 < buffer.length && buffer[this.bufferPos[this.bufferStackPos] + 1] == '\n') {
            v0 = this.bufferStackPos;
            this.bufferPos[v0] = this.bufferPos[v0] + 2;
            this.skipOverWhiteSpace();
        }
        v1 = this.bufferStackPos;
        this.bufferPos[v1] = this.bufferPos[v1] + 1;
        if (this.bufferPos[v1] >= limit) {
            if (pushContext) {
                idx = -1;
                stackpPos = this.bufferStackPos;
                while (this.bufferData[stackpPos] != null && this.bufferData[stackpPos] instanceof MacroData) {
                    if (--stackpPos < 0) {
                        return Scanner2.emptyCharArray;
                    }
                    idx = this.indexOfNextNonWhiteSpace(this.bufferStack[stackpPos], this.bufferPos[stackpPos], this.bufferLimit[stackpPos]);
                    if (idx >= this.bufferLimit[stackpPos]) continue;
                    if (idx > 0 && this.bufferStack[stackpPos][idx] == '(') break;
                    v2 = this.bufferStackPos;
                    this.bufferPos[v2] = this.bufferPos[v2] - 1;
                    return null;
                }
                if (idx == -1) {
                    v3 = this.bufferStackPos;
                    this.bufferPos[v3] = this.bufferPos[v3] - 1;
                    return null;
                }
                data = (MacroData)this.bufferData[stackpPos + 1];
                i = this.bufferStackPos;
                while (i > stackpPos) {
                    this.popContext();
                    --i;
                }
                this.bufferPos[this.bufferStackPos] = idx;
                buffer = this.bufferStack[this.bufferStackPos];
                limit = this.bufferLimit[this.bufferStackPos];
                start = data.startOffset;
            } else {
                v4 = this.bufferStackPos;
                this.bufferPos[v4] = this.bufferPos[v4] - 1;
                return null;
            }
        }
        if (buffer[this.bufferPos[this.bufferStackPos]] != '(') {
            v5 = this.bufferStackPos;
            this.bufferPos[v5] = this.bufferPos[v5] - 1;
            return null;
        }
        arglist = macro.arglist;
        currarg = -1;
        argmap = new CharArrayObjectMap(arglist.length);
        while (this.bufferPos[this.bufferStackPos] < limit) {
            block21: {
                block20: {
                    this.skipOverWhiteSpace();
                    v6 = this.bufferStackPos;
                    this.bufferPos[v6] = this.bufferPos[v6] + 1;
                    if (buffer[this.bufferPos[v6]] == ')') break;
                    if (buffer[this.bufferPos[this.bufferStackPos]] == ',') continue;
                    if (!(++currarg < arglist.length && arglist[currarg] != null || macro.hasVarArgs() || macro.hasGCCVarArgs())) {
                        this.handleProblem(0x2000009, this.bufferPos[this.bufferStackPos], macro.name);
                        break;
                    }
                    argstart = this.bufferPos[this.bufferStackPos];
                    argend = -1;
                    if (!macro.hasGCCVarArgs() && !macro.hasVarArgs() || currarg != macro.getVarArgsPosition()) break block20;
                    if (true) ** GOTO lbl71
                    do {
                        if (buffer[this.bufferPos[this.bufferStackPos]] == ')') {
                            v7 = this.bufferStackPos;
                            this.bufferPos[v7] = this.bufferPos[v7] - 1;
                            break;
                        }
lbl71:
                        // 3 sources

                        v8 = this.bufferStackPos;
                    } while ((this.bufferPos[v8] = this.bufferPos[v8] + 1) < limit);
                    argend = this.bufferPos[this.bufferStackPos];
                    break block21;
                }
                argend = this.skipOverMacroArg();
            }
            arg = Scanner2.emptyCharArray;
            arglen = argend - argstart + 1;
            if (arglen > 0) {
                arg = new char[arglen];
                System.arraycopy(buffer, argstart, arg, 0, arglen);
            }
            argmap.put(arglist[currarg], arg);
        }
        numArgs = arglist.length;
        i = 0;
        while (i < arglist.length) {
            if (arglist[i] == null) {
                numArgs = i;
                break;
            }
            ++i;
        }
        if (argmap.size() < numArgs) {
            this.handleProblem(0x2000009, this.bufferPos[this.bufferStackPos], macro.name);
        }
        result = null;
        if (macro instanceof DynamicFunctionStyleMacro) {
            result = ((DynamicFunctionStyleMacro)macro).execute(argmap);
        } else {
            replacedArgs = new CharArrayObjectMap(argmap.size());
            size = this.expandFunctionStyleMacro(macro.expansion, argmap, replacedArgs, null);
            result = new char[size];
            this.expandFunctionStyleMacro(macro.expansion, argmap, replacedArgs, result);
        }
        if (pushContext) {
            this.pushContext(result, new MacroData(start, this.bufferPos[this.bufferStackPos], macro));
        }
        return result;
    }

    private char[] replaceArgumentMacros(char[] arg) {
        int limit = arg.length;
        int start = -1;
        int end = -1;
        Object expObject = null;
        int pos = 0;
        while (pos < limit) {
            char c = arg[pos];
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || Character.isLetter(c) || this.scannerExtension.isValidIdentifierStartCharacter(c)) {
                start = pos;
                while (++pos < limit) {
                    c = arg[pos];
                    if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9' || this.scannerExtension.isValidIdentifierCharacter(c)) && !Character.isUnicodeIdentifierPart(c)) break;
                }
                end = pos - 1;
            }
            if (start != -1 && end >= start) {
                expObject = this.definitions.get(arg, start, end - start + 1);
                if (expObject != null && this.shouldExpandMacro((IMacro)expObject)) break;
                expObject = null;
                start = -1;
            }
            ++pos;
        }
        if (expObject == null) {
            return arg;
        }
        char[] expansion = null;
        if (expObject instanceof FunctionStyleMacro) {
            FunctionStyleMacro expMacro = (FunctionStyleMacro)expObject;
            this.pushContext(start == 0 ? arg : CharArrayUtils.extract(arg, start, arg.length - start));
            int n = this.bufferStackPos;
            this.bufferPos[n] = this.bufferPos[n] + (end - start + 1);
            expansion = this.handleFunctionStyleMacro(expMacro, false);
            end = this.bufferPos[this.bufferStackPos] + start;
            this.popContext();
        } else if (expObject instanceof ObjectStyleMacro) {
            ObjectStyleMacro expMacro = (ObjectStyleMacro)expObject;
            expansion = expMacro.expansion;
        } else if (expObject instanceof char[]) {
            expansion = (char[])expObject;
        } else if (expObject instanceof DynamicStyleMacro) {
            DynamicStyleMacro expMacro = (DynamicStyleMacro)expObject;
            expansion = expMacro.execute();
        }
        if (expansion != null) {
            int newlength = start + expansion.length + (limit - end - 1);
            char[] result = new char[newlength];
            System.arraycopy(arg, 0, result, 0, start);
            System.arraycopy(expansion, 0, result, start, expansion.length);
            if (arg.length > end + 1) {
                System.arraycopy(arg, end + 1, result, start + expansion.length, limit - end - 1);
            }
            this.pushContext(emptyCharArray, new MacroData(start, start + ((IMacro)expObject).getName().length, (IMacro)expObject));
            arg = this.replaceArgumentMacros(result);
            this.popContext();
        }
        return arg;
    }

    /*
     * Unable to fully structure code
     */
    private int expandFunctionStyleMacro(char[] expansion, CharArrayObjectMap argmap, CharArrayObjectMap replacedArgs, char[] result) {
        pos = -1;
        lastcopy = -1;
        outpos = 0;
        wsstart = -1;
        prevConcat = false;
        prevArg = null;
        prevArgStart = -1;
        prevArgLength = -1;
        prevArgTarget = -1;
        limit = expansion.length;
        block8: while (++pos < limit) {
            block66: {
                block67: {
                    c = expansion[pos];
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c < '9' || Character.isUnicodeIdentifierPart(c)) {
                        wsstart = -1;
                        idstart = pos;
                        while (++pos < limit) {
                            c = expansion[pos];
                            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_') && !Character.isUnicodeIdentifierPart(c)) break;
                        }
                        repObject = (char[])argmap.get(expansion, idstart, --pos - idstart + 1);
                        next = this.indexOfNextNonWhiteSpace(expansion, pos, limit);
                        v0 = nextIsPoundPound = next + 1 < limit && expansion[next] == '#' && expansion[next + 1] == '#';
                        if (prevConcat && prevArgStart > -1 && prevArgLength > 0) {
                            l1 = prevArg != null ? prevArg.length : prevArgLength;
                            l2 = repObject != null ? repObject.length : pos - idstart + 1;
                            newRep = new char[l1 + l2];
                            if (prevArg != null) {
                                System.arraycopy(prevArg, 0, newRep, 0, l1);
                            } else {
                                System.arraycopy(expansion, prevArgStart, newRep, 0, l1);
                            }
                            if (repObject != null) {
                                System.arraycopy(repObject, 0, newRep, l1, l2);
                            } else {
                                System.arraycopy(expansion, idstart, newRep, l1, l2);
                            }
                            repObject = newRep;
                        }
                        if (repObject != null) {
                            if (++lastcopy < idstart) {
                                n = idstart - lastcopy;
                                if (result != null) {
                                    System.arraycopy(expansion, lastcopy, result, outpos, n);
                                }
                                outpos += n;
                            }
                            if (prevConcat) {
                                outpos = prevArgTarget;
                            }
                            if (!nextIsPoundPound) {
                                rep = (char[])(replacedArgs != null ? replacedArgs.get(repObject) : null);
                                if (rep != null) {
                                    repObject = rep;
                                } else {
                                    rep = this.replaceArgumentMacros(repObject);
                                    if (replacedArgs != null) {
                                        replacedArgs.put(repObject, rep);
                                    }
                                    repObject = rep;
                                }
                            }
                            if (result != null) {
                                System.arraycopy(repObject, 0, result, outpos, repObject.length);
                            }
                            outpos += repObject.length;
                            lastcopy = pos;
                        }
                        prevArg = repObject;
                        prevArgStart = idstart;
                        prevArgLength = pos - idstart + 1;
                        prevArgTarget = repObject != null ? outpos - repObject.length : outpos + idstart - lastcopy - 1;
                        prevConcat = false;
                        continue;
                    }
                    if (c == '\"') {
                        wsstart = -1;
                        escaped = false;
                        while (++pos < limit) {
                            c = expansion[pos];
                            if (c == '\"') {
                                if (!escaped) {
                                    break;
                                }
                            } else if (c == '\\') {
                                escaped = escaped == false;
                            }
                            escaped = false;
                        }
                        prevConcat = false;
                        continue;
                    }
                    if (c == '\'') {
                        wsstart = -1;
                        escaped = false;
                        while (++pos < limit) {
                            c = expansion[pos];
                            if (c == '\'') {
                                if (!escaped) {
                                    break;
                                }
                            } else if (c == '\\') {
                                escaped = escaped == false;
                            }
                            escaped = false;
                        }
                        prevConcat = false;
                        continue;
                    }
                    if (c == ' ' || c == '\t') {
                        if (wsstart >= 0) continue;
                        wsstart = pos;
                        continue;
                    }
                    if (c == '/' && pos + 1 < limit) {
                        if ((c = expansion[++pos]) == '/') {
                            v1 = n = wsstart < 0 ? pos - 1 - lastcopy : wsstart - ++lastcopy;
                            if (result != null) {
                                System.arraycopy(expansion, lastcopy, result, outpos, n);
                            }
                            outpos += n;
                            lastcopy = expansion.length - 1;
                            continue;
                        }
                        if (c == '*') {
                            if (wsstart < 1) {
                                wsstart = pos - 1;
                            }
                            while (++pos < limit) {
                                if (expansion[pos] != '*' || pos + 1 >= limit || expansion[pos + 1] != '/') continue;
                                ++pos;
                                continue block8;
                            }
                            continue;
                        }
                        wsstart = -1;
                        continue;
                    }
                    if (c == '\\' && pos + 1 < limit && expansion[pos + 1] == 'n') {
                        ++pos;
                        continue;
                    }
                    if (c != '#') break block66;
                    if (pos + 1 >= limit || expansion[pos + 1] != '#') break block67;
                    prevConcat = true;
                    ++pos;
                    if (wsstart < 0) {
                        wsstart = pos - 1;
                    }
                    block13: while (++pos < limit) {
                        block0 : switch (expansion[pos]) {
                            case '\t': 
                            case ' ': {
                                break;
                            }
                            case '/': {
                                if (pos + 1 >= limit) ** GOTO lbl142
                                c = expansion[pos + 1];
                                if (c != '/') ** GOTO lbl135
                                pos = expansion.length;
                                ** GOTO lbl142
lbl135:
                                // 1 sources

                                if (c == '*') {
                                    ++pos;
                                    while (++pos < limit) {
                                        if (expansion[pos] != '*' || pos + 1 >= limit || expansion[pos + 1] != '/') continue;
                                        ++pos;
                                        break block0;
                                    }
                                    continue block13;
                                }
                            }
lbl142:
                            // 5 sources

                            default: {
                                break block13;
                            }
                        }
                    }
                    n = wsstart - ++lastcopy;
                    if (n > 0 && result != null) {
                        System.arraycopy(expansion, lastcopy, result, outpos, n);
                    }
                    outpos += n;
                    lastcopy = --pos;
                    wsstart = -1;
                    continue;
                }
                prevConcat = false;
                if (++lastcopy < pos) {
                    n = pos - lastcopy;
                    if (result != null) {
                        System.arraycopy(expansion, lastcopy, result, outpos, n);
                    }
                    outpos += n;
                }
                block15: while (++pos < limit) {
                    block4 : switch (expansion[pos]) {
                        case '\t': 
                        case ' ': {
                            break;
                        }
                        case '/': {
                            if (pos + 1 >= limit) ** GOTO lbl176
                            c = expansion[pos + 1];
                            if (c != '/') ** GOTO lbl169
                            pos = expansion.length;
                            ** GOTO lbl176
lbl169:
                            // 1 sources

                            if (c == '*') {
                                ++pos;
                                while (++pos < limit) {
                                    if (expansion[pos] != '*' || pos + 1 >= limit || expansion[pos + 1] != '/') continue;
                                    ++pos;
                                    break block4;
                                }
                                continue block15;
                            }
                        }
lbl176:
                        // 5 sources

                        default: {
                            break block15;
                        }
                    }
                }
                c = expansion[pos];
                idstart = pos;
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'X' || c == '_' || Character.isUnicodeIdentifierPart(c)) {
                    while (++pos < limit) {
                        c = expansion[pos];
                        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'X' || c >= '0' && c <= '9' || c == '_') && !Character.isUnicodeIdentifierPart(c)) break;
                    }
                }
                if ((argvalue = (char[])argmap.get(expansion, idstart, idlen = --pos - idstart + 1)) != null) {
                    if (result != null) {
                        result[outpos++] = 34;
                        i = 0;
                        while (i < argvalue.length) {
                            if (argvalue[i] == '\"' || argvalue[i] == '\\') {
                                result[outpos++] = 92;
                            }
                            result[outpos++] = argvalue[i] == '\r' || argvalue[i] == '\n' ? 32 : argvalue[i];
                            ++i;
                        }
                        result[outpos++] = 34;
                    } else {
                        i = 0;
                        while (i < argvalue.length) {
                            if (argvalue[i] == '\"' || argvalue[i] == '\\') {
                                ++outpos;
                            }
                            ++outpos;
                            ++i;
                        }
                        outpos += 2;
                    }
                }
                lastcopy = pos;
                wsstart = -1;
                continue;
            }
            prevConcat = false;
            wsstart = -1;
        }
        if (wsstart < 0 && ++lastcopy < expansion.length) {
            n = expansion.length - lastcopy;
            if (result != null) {
                System.arraycopy(expansion, lastcopy, result, outpos, n);
            }
            outpos += n;
        }
        return outpos;
    }

    protected void setupBuiltInMacros() {
        this.definitions.put(Scanner2.__STDC__.name, __STDC__);
        this.definitions.put(this.__FILE__.name, this.__FILE__);
        this.definitions.put(this.__DATE__.name, this.__DATE__);
        this.definitions.put(this.__TIME__.name, this.__TIME__);
        this.definitions.put(this.__LINE__.name, this.__LINE__);
        if (this.language == ParserLanguage.CPP) {
            this.definitions.put(Scanner2.__cplusplus.name, __cplusplus);
        } else {
            this.definitions.put(Scanner2.__STDC_HOSTED__.name, __STDC_HOSTED__);
            this.definitions.put(Scanner2.__STDC_VERSION__.name, __STDC_VERSION__);
        }
        this.scannerExtension.setupBuiltInMacros(this);
    }

    public final void setASTFactory(IASTFactory f) {
        this.astFactory = f;
    }

    public final void setOffsetBoundary(int offset) {
        this.offsetBoundary = offset;
        this.bufferLimit[0] = offset;
    }

    public final IASTFactory getASTFactory() {
        if (this.astFactory == null) {
            this.astFactory = ParserFactory.createASTFactory(this.parserMode, this.language);
        }
        return this.astFactory;
    }

    public ISourceElementRequestor getClientRequestor() {
        return this.requestor;
    }

    public ParserLanguage getLanguage() {
        return this.language;
    }

    public IParserLogService getLogService() {
        return this.log;
    }

    public ParserMode getParserMode() {
        return this.parserMode;
    }

    public IProblemFactory getProblemFactory() {
        return spf;
    }

    public Iterator getWorkingCopies() {
        if (this.workingCopies == null) {
            return EmptyIterator.EMPTY_ITERATOR;
        }
        return this.workingCopies.iterator();
    }

    public char[] getMainFilename() {
        if (this.bufferData[0] instanceof CodeReader && this.bufferData != null && this.bufferData[0] != null) {
            return ((CodeReader)this.bufferData[0]).filename;
        }
        return emptyCharArray;
    }

    public final char[] getCurrentFilename() {
        int i = this.bufferStackPos;
        while (i >= 0) {
            if (this.bufferData[i] instanceof InclusionData) {
                return ((InclusionData)this.bufferData[i]).reader.filename;
            }
            if (this.bufferData[i] instanceof CodeReader) {
                return ((CodeReader)this.bufferData[i]).filename;
            }
            --i;
        }
        return emptyCharArray;
    }

    private final int getCurrentFileIndex() {
        int i = this.bufferStackPos;
        while (i >= 0) {
            if (this.bufferData[i] instanceof InclusionData || this.bufferData[i] instanceof CodeReader) {
                return i;
            }
            --i;
        }
        return 0;
    }

    protected void handleCompletionOnDefinition(String definition) throws EndOfFileException {
        ASTCompletionNode node = new ASTCompletionNode(IASTCompletionNode.CompletionKind.MACRO_REFERENCE, null, null, definition, KeywordSets.getKeywords(KeywordSetKey.EMPTY, this.language), EMPTY_STRING, null);
        throw new OffsetLimitReachedException(node);
    }

    protected void handleCompletionOnExpression(char[] buffer) throws EndOfFileException {
        int lastTab;
        IASTCompletionNode.CompletionKind kind = IASTCompletionNode.CompletionKind.MACRO_REFERENCE;
        int lastSpace = CharArrayUtils.lastIndexOf(SPACE, buffer);
        int max = lastSpace > (lastTab = CharArrayUtils.lastIndexOf(TAB, buffer)) ? lastSpace : lastTab;
        char[] prefix = CharArrayUtils.trim(CharArrayUtils.extract(buffer, max, buffer.length - max));
        int i = 0;
        while (i < prefix.length) {
            char c = prefix[i];
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9' || Character.isUnicodeIdentifierPart(c))) {
                this.handleInvalidCompletion();
            }
            ++i;
        }
        ASTCompletionNode node = new ASTCompletionNode(kind, null, null, new String(prefix), KeywordSets.getKeywords(kind == IASTCompletionNode.CompletionKind.NO_SUCH_KIND ? KeywordSetKey.EMPTY : KeywordSetKey.MACRO, this.language), EMPTY_STRING, null);
        throw new OffsetLimitReachedException(node);
    }

    protected void handleNoSuchCompletion() throws EndOfFileException {
        throw new OffsetLimitReachedException(new ASTCompletionNode(IASTCompletionNode.CompletionKind.NO_SUCH_KIND, null, null, EMPTY_STRING, KeywordSets.getKeywords(KeywordSetKey.EMPTY, this.language), EMPTY_STRING, null));
    }

    protected void handleInvalidCompletion() throws EndOfFileException {
        throw new OffsetLimitReachedException(new ASTCompletionNode(IASTCompletionNode.CompletionKind.UNREACHABLE_CODE, null, null, EMPTY_STRING, KeywordSets.getKeywords(KeywordSetKey.EMPTY, this.language), EMPTY_STRING, null));
    }

    protected void handleCompletionOnPreprocessorDirective(String prefix) throws EndOfFileException {
        throw new OffsetLimitReachedException(new ASTCompletionNode(IASTCompletionNode.CompletionKind.PREPROCESSOR_DIRECTIVE, null, null, prefix, KeywordSets.getKeywords(KeywordSetKey.PP_DIRECTIVE, this.language), EMPTY_STRING, null));
    }

    public int getCurrentOffset() {
        return this.bufferPos[this.bufferStackPos];
    }

    protected static class InclusionData {
        public final IASTInclusion inclusion;
        public final CodeReader reader;

        public InclusionData(CodeReader reader, IASTInclusion inclusion) {
            this.reader = reader;
            this.inclusion = inclusion;
        }
    }

    private static class MacroData {
        public final int startOffset;
        public final int endOffset;
        public final IMacro macro;

        public MacroData(int start, int end, IMacro macro) {
            this.startOffset = start;
            this.endOffset = end;
            this.macro = macro;
        }
    }
}

