/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.browser;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeCacheChangedListener;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeInfoVisitor;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.IWorkingCopyProvider;
import org.eclipse.cdt.core.browser.TypeSearchScope;
import org.eclipse.cdt.core.browser.typehierarchy.ITypeHierarchy;
import org.eclipse.cdt.core.browser.typehierarchy.TypeHierarchyBuilder;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.browser.cache.ITypeCache;
import org.eclipse.cdt.internal.core.browser.cache.TypeCacheManager;
import org.eclipse.cdt.internal.core.browser.util.ArrayUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;

public class AllTypesCache {
    private static final int INITIAL_DELAY = 5000;
    private static IWorkingCopyProvider fgWorkingCopyProvider;
    private static TypeHierarchyBuilder fgTypeHierarchyBuilder;
    private static IElementChangedListener fgElementChangedListener;
    private static Preferences.IPropertyChangeListener fgPropertyChangeListener;
    static boolean fgEnableIndexing;
    public static final String ENABLE_BACKGROUND_TYPE_CACHE = "enableBackgroundTypeCache";

    static {
        fgEnableIndexing = true;
    }

    public static void initialize(IWorkingCopyProvider workingCopyProvider) {
        fgWorkingCopyProvider = workingCopyProvider;
        TypeCacheManager.getInstance().setWorkingCopyProvider(fgWorkingCopyProvider);
        fgTypeHierarchyBuilder = new TypeHierarchyBuilder();
        Preferences prefs = CCorePlugin.getDefault().getPluginPreferences();
        if (prefs.contains(ENABLE_BACKGROUND_TYPE_CACHE)) {
            fgEnableIndexing = prefs.getBoolean(ENABLE_BACKGROUND_TYPE_CACHE);
        } else {
            prefs.setDefault(ENABLE_BACKGROUND_TYPE_CACHE, true);
            prefs.setValue(ENABLE_BACKGROUND_TYPE_CACHE, true);
            CCorePlugin.getDefault().savePluginPreferences();
            fgEnableIndexing = true;
        }
        TypeCacheManager.getInstance().reconcile(fgEnableIndexing, 40, 5000);
        fgElementChangedListener = new IElementChangedListener(){

            public void elementChanged(ElementChangedEvent event) {
                TypeCacheManager.getInstance().processElementChanged(event, fgEnableIndexing);
            }
        };
        CoreModel.getDefault().addElementChangedListener(fgElementChangedListener);
        fgPropertyChangeListener = new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent event) {
                String property = event.getProperty();
                if (property.equals(AllTypesCache.ENABLE_BACKGROUND_TYPE_CACHE)) {
                    String value = (String)event.getNewValue();
                    fgEnableIndexing = Boolean.valueOf(value);
                    if (!fgEnableIndexing) {
                        TypeCacheManager.getInstance().cancelJobs();
                    } else {
                        TypeCacheManager.getInstance().reconcile(fgEnableIndexing, 40, 0);
                    }
                }
            }
        };
        prefs.addPropertyChangeListener(fgPropertyChangeListener);
    }

    public static void terminate() {
        if (fgElementChangedListener != null) {
            CoreModel.getDefault().removeElementChangedListener(fgElementChangedListener);
        }
        if (fgPropertyChangeListener != null) {
            CCorePlugin.getDefault().getPluginPreferences().removePropertyChangeListener(fgPropertyChangeListener);
        }
        if (TypeCacheManager.getInstance() != null) {
            TypeCacheManager.getInstance().cancelJobs();
        }
    }

    public static ITypeInfo[] getAllTypes() {
        final ArrayList fAllTypes = new ArrayList();
        TypeSearchScope workspaceScope = new TypeSearchScope(true);
        IProject[] projects = workspaceScope.getEnclosingProjects();
        ITypeInfoVisitor visitor = new ITypeInfoVisitor(){

            public boolean visit(ITypeInfo info) {
                fAllTypes.add(info);
                return true;
            }

            public boolean shouldContinue() {
                return true;
            }
        };
        int i = 0;
        while (i < projects.length) {
            TypeCacheManager.getInstance().getCache(projects[i]).accept(visitor);
            ++i;
        }
        return fAllTypes.toArray(new ITypeInfo[fAllTypes.size()]);
    }

    public static ITypeInfo[] getTypes(ITypeSearchScope scope, int[] kinds) {
        final ArrayList fTypesFound = new ArrayList();
        final ITypeSearchScope fScope = scope;
        final int[] fKinds = kinds;
        IProject[] projects = scope.getEnclosingProjects();
        ITypeInfoVisitor visitor = new ITypeInfoVisitor(){

            public boolean visit(ITypeInfo info) {
                if (ArrayUtil.contains(fKinds, info.getCElementType()) && fScope != null && info.isEnclosed(fScope)) {
                    fTypesFound.add(info);
                }
                return true;
            }

            public boolean shouldContinue() {
                return true;
            }
        };
        int i = 0;
        while (i < projects.length) {
            TypeCacheManager.getInstance().getCache(projects[i]).accept(visitor);
            ++i;
        }
        return fTypesFound.toArray(new ITypeInfo[fTypesFound.size()]);
    }

    public static ITypeInfo[] getTypes(ITypeSearchScope scope, IQualifiedTypeName qualifiedName, int[] kinds, boolean matchEnclosed) {
        final ArrayList fTypesFound = new ArrayList();
        final ITypeSearchScope fScope = scope;
        final int[] fKinds = kinds;
        final IQualifiedTypeName fQualifiedName = qualifiedName;
        final boolean fMatchEnclosed = matchEnclosed;
        IProject[] projects = scope.getEnclosingProjects();
        ITypeInfoVisitor visitor = new ITypeInfoVisitor(){

            public boolean visit(ITypeInfo info) {
                if (ArrayUtil.contains(fKinds, info.getCElementType()) && fScope != null && info.isEnclosed(fScope)) {
                    IQualifiedTypeName currName = info.getQualifiedTypeName();
                    if (fMatchEnclosed && currName.segmentCount() > fQualifiedName.segmentCount() && currName.lastSegment().equals(fQualifiedName.lastSegment())) {
                        currName = currName.removeFirstSegments(currName.segmentCount() - fQualifiedName.segmentCount());
                    }
                    if (currName.equals(fQualifiedName)) {
                        fTypesFound.add(info);
                    }
                }
                return true;
            }

            public boolean shouldContinue() {
                return true;
            }
        };
        int i = 0;
        while (i < projects.length) {
            TypeCacheManager.getInstance().getCache(projects[i]).accept(visitor);
            ++i;
        }
        return fTypesFound.toArray(new ITypeInfo[fTypesFound.size()]);
    }

    public static ITypeInfo[] getNamespaces(ITypeSearchScope scope, boolean includeGlobalNamespace) {
        final ArrayList<ITypeInfo> fTypesFound = new ArrayList<ITypeInfo>();
        final ITypeSearchScope fScope = scope;
        IProject[] projects = scope.getEnclosingProjects();
        ITypeInfoVisitor visitor = new ITypeInfoVisitor(){

            public boolean visit(ITypeInfo info) {
                if (info.getCElementType() == 61 && fScope != null && info.isEnclosed(fScope)) {
                    fTypesFound.add(info);
                }
                return true;
            }

            public boolean shouldContinue() {
                return true;
            }
        };
        int i = 0;
        while (i < projects.length) {
            ITypeCache cache = TypeCacheManager.getInstance().getCache(projects[i]);
            cache.accept(visitor);
            if (includeGlobalNamespace) {
                fTypesFound.add(cache.getGlobalNamespace());
            }
            ++i;
        }
        return fTypesFound.toArray(new ITypeInfo[fTypesFound.size()]);
    }

    public static ITypeInfo getGlobalNamespace(IProject project) {
        ITypeCache cache = TypeCacheManager.getInstance().getCache(project);
        return cache.getGlobalNamespace();
    }

    public static boolean isCacheUpToDate(ITypeSearchScope scope) {
        AllTypesCache.forceDeltaComplete();
        IProject[] projects = scope.getEnclosingProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (project.exists() && project.isOpen() && !TypeCacheManager.getInstance().getCache(project).isUpToDate()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static void forceDeltaComplete() {
        if (fgWorkingCopyProvider != null) {
            IWorkingCopy[] workingCopies = fgWorkingCopyProvider.getWorkingCopies();
            int i = 0;
            while (i < workingCopies.length) {
                IWorkingCopy wc = workingCopies[i];
                try {
                    IWorkingCopy iWorkingCopy = wc;
                    synchronized (iWorkingCopy) {
                        wc.reconcile();
                    }
                }
                catch (CModelException cModelException) {}
                ++i;
            }
        }
    }

    public static void updateCache(ITypeSearchScope scope, IProgressMonitor monitor) {
        TypeCacheManager.getInstance().updateCache(scope, monitor);
    }

    public static ITypeReference resolveTypeLocation(ITypeInfo info, IProgressMonitor monitor) {
        return TypeCacheManager.getInstance().resolveTypeLocation(info, monitor, fgEnableIndexing);
    }

    public static ITypeInfo getType(IProject project, int type, IQualifiedTypeName qualifiedName) {
        ITypeCache cache = TypeCacheManager.getInstance().getCache(project);
        return cache.getType(type, qualifiedName);
    }

    public static ITypeInfo[] getTypes(IProject project, IQualifiedTypeName qualifiedName, boolean matchEnclosed, boolean ignoreCase) {
        ITypeCache cache = TypeCacheManager.getInstance().getCache(project);
        return cache.getTypes(qualifiedName, matchEnclosed, ignoreCase);
    }

    public static ITypeHierarchy createTypeHierarchy(ICElement type, IProgressMonitor monitor) throws CModelException {
        ITypeInfo info = TypeCacheManager.getInstance().getTypeForElement(type, true, true, fgEnableIndexing, monitor);
        if (info != null) {
            return fgTypeHierarchyBuilder.createTypeHierarchy(info, fgEnableIndexing, monitor);
        }
        return null;
    }

    public static void addTypeCacheChangedListener(ITypeCacheChangedListener listener) {
        TypeCacheManager.getInstance().addTypeCacheChangedListener(listener);
    }

    public static void removeTypeCacheChangedListener(ITypeCacheChangedListener listener) {
        TypeCacheManager.getInstance().removeTypeCacheChangedListener(listener);
    }

    public static ITypeInfo getTypeForElement(ICElement element, boolean forceUpdate, boolean forceResolve, IProgressMonitor monitor) {
        return TypeCacheManager.getInstance().getTypeForElement(element, forceUpdate, forceResolve, fgEnableIndexing, monitor);
    }

    public static ICElement getElementForType(ITypeInfo type, boolean forceUpdate, boolean forceResolve, IProgressMonitor monitor) {
        return TypeCacheManager.getInstance().getElementForType(type, forceUpdate, forceResolve, fgEnableIndexing, monitor);
    }
}

