/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.cdt.debug.mi.core.output.MIAsyncRecord;
import org.eclipse.cdt.debug.mi.core.output.MIConsoleStreamOutput;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIExecAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MIList;
import org.eclipse.cdt.debug.mi.core.output.MILogStreamOutput;
import org.eclipse.cdt.debug.mi.core.output.MINotifyAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MIOOBRecord;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MIStatusAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MIStreamRecord;
import org.eclipse.cdt.debug.mi.core.output.MITargetStreamOutput;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIParser {
    public String primaryPrompt;
    public String cliPrompt;
    public String secondaryPrompt;

    public MIParser() {
        this.cliPrompt = this.primaryPrompt = "(gdb)";
        this.secondaryPrompt = ">";
    }

    public MIOutput parse(String buffer) {
        MIOutput mi = new MIOutput();
        MIResultRecord rr = null;
        ArrayList<MIOOBRecord> oobs = new ArrayList<MIOOBRecord>(1);
        int id = -1;
        StringTokenizer st = new StringTokenizer(buffer, "\n");
        while (st.hasMoreTokens()) {
            MIOOBRecord band;
            StringBuffer token = new StringBuffer(st.nextToken());
            if (token.length() > 0 && Character.isDigit(token.charAt(0))) {
                int i = 1;
                while (i < token.length() && Character.isDigit(token.charAt(i))) {
                    ++i;
                }
                String numbers = token.substring(0, i);
                try {
                    id = Integer.parseInt(numbers);
                }
                catch (NumberFormatException numberFormatException) {}
                token.delete(0, i);
            }
            if (token.length() <= 0) continue;
            if (token.charAt(0) == '^') {
                token.deleteCharAt(0);
                rr = this.processMIResultRecord(token, id);
                continue;
            }
            if (this.startsWith(token, this.primaryPrompt) || (band = this.processMIOOBRecord(token, id)) == null) continue;
            oobs.add(band);
        }
        MIOOBRecord[] bands = oobs.toArray(new MIOOBRecord[oobs.size()]);
        mi.setMIOOBRecords(bands);
        mi.setMIResultRecord(rr);
        return mi;
    }

    private MIResultRecord processMIResultRecord(StringBuffer buffer, int id) {
        MIResultRecord rr = new MIResultRecord();
        rr.setToken(id);
        if (buffer.toString().startsWith("done")) {
            rr.setResultClass("done");
            buffer.delete(0, "done".length());
        } else if (buffer.toString().startsWith("error")) {
            rr.setResultClass("error");
            buffer.delete(0, "error".length());
        } else if (buffer.toString().startsWith("exit")) {
            rr.setResultClass("exit");
            buffer.delete(0, "exit".length());
        } else if (buffer.toString().startsWith("running")) {
            rr.setResultClass("running");
            buffer.delete(0, "running".length());
        } else if (buffer.toString().startsWith("connected")) {
            rr.setResultClass("connected");
            buffer.delete(0, "connected".length());
        }
        if (buffer.length() > 0 && buffer.charAt(0) == ',') {
            buffer.deleteCharAt(0);
            MIResult[] res = this.processMIResults(new FSB(buffer));
            rr.setMIResults(res);
        }
        return rr;
    }

    private MIOOBRecord processMIOOBRecord(StringBuffer buffer, int id) {
        MIOOBRecord oob = null;
        char c = buffer.charAt(0);
        if (c == '*' || c == '+' || c == '=') {
            buffer.deleteCharAt(0);
            MIAsyncRecord async = null;
            switch (c) {
                case '*': {
                    async = new MIExecAsyncOutput();
                    break;
                }
                case '+': {
                    async = new MIStatusAsyncOutput();
                    break;
                }
                case '=': {
                    async = new MINotifyAsyncOutput();
                }
            }
            async.setToken(id);
            int i = buffer.toString().indexOf(44);
            if (i != -1) {
                String asyncClass = buffer.substring(0, i);
                async.setAsyncClass(asyncClass);
                buffer.delete(0, i + 1);
            } else {
                async.setAsyncClass(buffer.toString().trim());
                buffer.setLength(0);
            }
            MIResult[] res = this.processMIResults(new FSB(buffer));
            async.setMIResults(res);
            oob = async;
        } else if (c == '~' || c == '@' || c == '&') {
            buffer.deleteCharAt(0);
            MIStreamRecord stream = null;
            switch (c) {
                case '~': {
                    stream = new MIConsoleStreamOutput();
                    break;
                }
                case '@': {
                    stream = new MITargetStreamOutput();
                    break;
                }
                case '&': {
                    stream = new MILogStreamOutput();
                }
            }
            if (buffer.length() > 0 && buffer.charAt(0) == '\"') {
                buffer.deleteCharAt(0);
            }
            stream.setCString(this.translateCString(new FSB(buffer)));
            oob = stream;
        } else {
            MITargetStreamOutput stream = new MITargetStreamOutput();
            stream.setCString(String.valueOf(buffer.toString()) + "\n");
            oob = stream;
        }
        return oob;
    }

    private MIResult[] processMIResults(FSB buffer) {
        ArrayList<MIResult> aList = new ArrayList<MIResult>();
        MIResult result = this.processMIResult(buffer);
        if (result != null) {
            aList.add(result);
        }
        while (buffer.length() > 0 && buffer.charAt(0) == ',') {
            buffer.deleteCharAt(0);
            result = this.processMIResult(buffer);
            if (result == null) continue;
            aList.add(result);
        }
        return aList.toArray(new MIResult[aList.size()]);
    }

    private MIResult processMIResult(FSB buffer) {
        int equal;
        MIResult result = new MIResult();
        if (buffer.length() > 0 && Character.isLetter(buffer.charAt(0)) && (equal = buffer.indexOf('=')) != -1) {
            String variable = buffer.substring(0, equal);
            result.setVariable(variable);
            buffer.delete(0, equal + 1);
            MIValue value = this.processMIValue(buffer);
            result.setMIValue(value);
        } else {
            result.setVariable(buffer.toString());
            result.setMIValue(new MIConst());
            buffer.setLength(0);
        }
        return result;
    }

    private MIValue processMIValue(FSB buffer) {
        MIValue value = null;
        if (buffer.length() > 0) {
            if (buffer.charAt(0) == '{') {
                buffer.deleteCharAt(0);
                value = this.processMITuple(buffer);
            } else if (buffer.charAt(0) == '[') {
                buffer.deleteCharAt(0);
                value = this.processMIList(buffer);
            } else if (buffer.charAt(0) == '\"') {
                buffer.deleteCharAt(0);
                MIConst cnst = new MIConst();
                cnst.setCString(this.translateCString(buffer));
                value = cnst;
            }
        }
        return value;
    }

    private MIValue processMITuple(FSB buffer) {
        MITuple tuple = new MITuple();
        MIResult[] results = null;
        while (buffer.length() > 0 && buffer.charAt(0) != '}') {
            results = this.processMIResults(buffer);
        }
        if (buffer.length() > 0 && buffer.charAt(0) == '}') {
            buffer.deleteCharAt(0);
        }
        if (results == null) {
            results = new MIResult[]{};
        }
        tuple.setMIResults(results);
        return tuple;
    }

    private MIValue processMIList(FSB buffer) {
        MIList list = new MIList();
        ArrayList<MIValue> valueList = new ArrayList<MIValue>();
        ArrayList<MIResult> resultList = new ArrayList<MIResult>();
        while (buffer.length() > 0 && buffer.charAt(0) != ']') {
            MIValue value = this.processMIValue(buffer);
            if (value != null) {
                valueList.add(value);
            } else {
                MIResult result = this.processMIResult(buffer);
                if (result != null) {
                    resultList.add(result);
                }
            }
            if (buffer.length() <= 0 || buffer.charAt(0) != ',') continue;
            buffer.deleteCharAt(0);
        }
        if (buffer.length() > 0 && buffer.charAt(0) == ']') {
            buffer.deleteCharAt(0);
        }
        MIValue[] values = valueList.toArray(new MIValue[valueList.size()]);
        MIResult[] res = resultList.toArray(new MIResult[resultList.size()]);
        list.setMIValues(values);
        list.setMIResults(res);
        return list;
    }

    private String translateCString(FSB buffer) {
        boolean escape = false;
        boolean closingQuotes = false;
        StringBuffer sb = new StringBuffer();
        int index = 0;
        while (index < buffer.length() && !closingQuotes) {
            char c = buffer.charAt(index);
            if (c == '\\') {
                if (escape) {
                    sb.append(c);
                    escape = false;
                } else {
                    escape = true;
                }
            } else if (c == '\"') {
                if (escape) {
                    sb.append(c);
                    escape = false;
                } else {
                    closingQuotes = true;
                }
            } else {
                if (escape) {
                    sb.append('\\');
                }
                sb.append(c);
                escape = false;
            }
            ++index;
        }
        buffer.delete(0, index);
        return sb.toString();
    }

    public boolean startsWith(StringBuffer value, String prefix) {
        int plen;
        int vlen = value.length();
        if (vlen < (plen = prefix.length())) {
            return false;
        }
        int i = 0;
        while (i < plen) {
            if (value.charAt(i) != prefix.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public class FSB {
        StringBuffer buf;
        int pos;
        boolean shared;

        public FSB(StringBuffer buf) {
            this.buf = buf;
            this.pos = 0;
            this.shared = false;
        }

        public FSB(FSB fbuf) {
            this.pos = fbuf.pos;
            this.buf = fbuf.buf;
            this.shared = true;
        }

        public int length() {
            int res = this.buf.length() - this.pos;
            if (res < 0) {
                return 0;
            }
            return res;
        }

        public char charAt(int index) {
            return this.buf.charAt(index + this.pos);
        }

        private void resolveCopy() {
            if (this.shared) {
                this.buf = new StringBuffer(this.buf.toString());
                this.shared = false;
            }
        }

        public FSB deleteCharAt(int index) {
            if (index == 0) {
                ++this.pos;
            } else {
                this.resolveCopy();
                this.buf = this.buf.deleteCharAt(this.pos + index);
            }
            return this;
        }

        public FSB delete(int start, int end) {
            if (start == 0) {
                this.pos = this.pos + end - start;
            } else {
                this.resolveCopy();
                this.buf.delete(start + this.pos, end + this.pos);
            }
            return this;
        }

        public void setLength(int a) {
            if (a == 0) {
                this.pos = this.buf.length();
            }
        }

        public String substring(int start, int end) {
            return this.buf.substring(start + this.pos, end + this.pos);
        }

        public String toString() {
            return this.buf.substring(this.pos, this.buf.length());
        }

        int indexOf(char c) {
            int len = this.buf.length();
            int i = this.pos;
            while (i < len) {
                if (this.buf.charAt(i) == c) {
                    return i - this.pos;
                }
                ++i;
            }
            return -1;
        }

        boolean startsWith(String s) {
            int len = Math.min(s.length(), this.length());
            if (len < s.length()) {
                return false;
            }
            int i = 0;
            while (i < len) {
                if (s.charAt(i) != this.buf.charAt(this.pos + i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

