/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.preferences.TodoTaskConfigurationBlock;
import org.eclipse.cdt.internal.ui.preferences.TodoTaskPreferencePage;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class TodoTaskPropertyPage
extends PropertyPage {
    private TodoTaskConfigurationBlock fConfigurationBlock;
    private Control fConfigurationBlockControl;
    private ControlEnableState fBlockEnableState = null;
    private SelectionButtonDialogField fUseWorkspaceSettings;
    private SelectionButtonDialogField fChangeWorkspaceSettings;
    private SelectionButtonDialogField fUseProjectSettings;
    IStatus fBlockStatus = new StatusInfo();
    static /* synthetic */ Class class$0;

    public TodoTaskPropertyPage() {
        IDialogFieldListener listener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                TodoTaskPropertyPage.this.doDialogFieldChanged(field);
            }
        };
        this.fUseWorkspaceSettings = new SelectionButtonDialogField(16);
        this.fUseWorkspaceSettings.setDialogFieldListener(listener);
        this.fUseWorkspaceSettings.setLabelText(PreferencesMessages.getString("TodoTaskPropertyPage.useworkspacesettings.label"));
        this.fChangeWorkspaceSettings = new SelectionButtonDialogField(8);
        this.fChangeWorkspaceSettings.setLabelText(PreferencesMessages.getString("TodoTaskPropertyPage.useworkspacesettings.change"));
        this.fChangeWorkspaceSettings.setDialogFieldListener(listener);
        this.fUseWorkspaceSettings.attachDialogField(this.fChangeWorkspaceSettings);
        this.fUseProjectSettings = new SelectionButtonDialogField(16);
        this.fUseProjectSettings.setDialogFieldListener(listener);
        this.fUseProjectSettings.setLabelText(PreferencesMessages.getString("TodoTaskPropertyPage.useprojectsettings.label"));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.cdt.ui.tasktags_property_page_context");
    }

    protected Control createContents(Composite parent) {
        IStatusChangeListener listener = new IStatusChangeListener(){

            public void statusChanged(IStatus status) {
                TodoTaskPropertyPage.this.fBlockStatus = status;
                TodoTaskPropertyPage.this.doStatusChanged();
            }
        };
        this.fConfigurationBlock = new TodoTaskConfigurationBlock(listener, this.getProject());
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.fUseWorkspaceSettings.doFillIntoGrid(composite, 1);
        LayoutUtil.setHorizontalGrabbing((Control)this.fUseWorkspaceSettings.getSelectionButton(null));
        this.fChangeWorkspaceSettings.doFillIntoGrid(composite, 1);
        GridData data = (GridData)this.fChangeWorkspaceSettings.getSelectionButton(null).getLayoutData();
        data.horizontalIndent = this.convertWidthInCharsToPixels(3);
        data.horizontalAlignment = 1;
        this.fUseProjectSettings.doFillIntoGrid(composite, 1);
        data = new GridData(272);
        data.horizontalSpan = 1;
        data.horizontalIndent = this.convertWidthInCharsToPixels(2);
        this.fConfigurationBlockControl = this.fConfigurationBlock.createContents(composite);
        this.fConfigurationBlockControl.setLayoutData((Object)data);
        boolean useProjectSettings = this.fConfigurationBlock.hasProjectSpecificOptions();
        this.fUseProjectSettings.setSelection(useProjectSettings);
        this.fUseWorkspaceSettings.setSelection(!useProjectSettings);
        this.updateEnableState();
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private boolean useProjectSettings() {
        return this.fUseProjectSettings.isSelected();
    }

    void doDialogFieldChanged(DialogField field) {
        if (field == this.fChangeWorkspaceSettings) {
            TodoTaskPreferencePage page = new TodoTaskPreferencePage();
            this.showPreferencePage("org.eclipse.cdt.ui.propertyPages.TodoTaskPropertyPage", (IPreferencePage)page);
        } else {
            this.updateEnableState();
            this.doStatusChanged();
        }
    }

    void doStatusChanged() {
        this.updateStatus((IStatus)(this.useProjectSettings() ? this.fBlockStatus : new StatusInfo()));
    }

    private ICProject getProject() {
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.ICElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ICProject)iAdaptable.getAdapter((Class)clazz);
    }

    private void updateEnableState() {
        if (this.useProjectSettings()) {
            if (this.fBlockEnableState != null) {
                this.fBlockEnableState.restore();
                this.fBlockEnableState = null;
            }
        } else if (this.fBlockEnableState == null) {
            this.fBlockEnableState = ControlEnableState.disable((Control)this.fConfigurationBlockControl);
        }
    }

    protected void performDefaults() {
        if (this.useProjectSettings()) {
            this.fUseProjectSettings.setSelection(false);
            this.fUseWorkspaceSettings.setSelection(true);
            this.fConfigurationBlock.performDefaults();
        }
        super.performDefaults();
    }

    public boolean performOk() {
        return this.fConfigurationBlock.performOk(this.useProjectSettings());
    }

    private void updateStatus(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    private boolean showPreferencePage(String id, IPreferencePage page) {
        PreferenceNode targetNode = new PreferenceNode(id, page);
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot((IPreferenceNode)targetNode);
        final PreferenceDialog dialog = new PreferenceDialog(this.getShell(), manager);
        boolean[] result = new boolean[1];
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable((IPreferenceNode)targetNode, result){
            private final /* synthetic */ IPreferenceNode val$targetNode;
            private final /* synthetic */ boolean[] val$result;
            {
                this.val$targetNode = iPreferenceNode;
                this.val$result = blArray;
            }

            public void run() {
                dialog.create();
                dialog.setMessage(this.val$targetNode.getLabelText());
                this.val$result[0] = dialog.open() == 0;
            }
        });
        return result[0];
    }
}

