/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.internal.corext.refactoring.base.ChangeAbortException;
import org.eclipse.cdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.cdt.internal.corext.refactoring.base.IChange;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.cdt.internal.ui.refactoring.CreateChangeOperation;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.IEditorPart;

public class PerformChangeOperation
implements IRunnableWithProgress {
    private IChange fChange;
    private ChangeContext fChangeContext;
    private CreateChangeOperation fCreateChangeOperation;
    private int fCheckPassedSeverity;
    private boolean fChangeExecuted;
    static /* synthetic */ Class class$0;

    public PerformChangeOperation(IChange change) {
        this.fChange = change;
        Assert.isNotNull((Object)this.fChange);
    }

    public PerformChangeOperation(CreateChangeOperation op) {
        this.fCreateChangeOperation = op;
        Assert.isNotNull((Object)this.fCreateChangeOperation);
        this.fCheckPassedSeverity = 1;
    }

    public boolean changeExecuted() {
        return this.fChangeExecuted;
    }

    public IChange getChange() {
        return this.fChange;
    }

    public RefactoringStatus getStatus() {
        return this.fCreateChangeOperation != null ? this.fCreateChangeOperation.getStatus() : null;
    }

    public void setCheckPassedSeverity(int severity) {
        this.fCheckPassedSeverity = severity;
        Assert.isTrue((this.fCheckPassedSeverity < 4 ? 1 : 0) != 0);
    }

    public void setChangeContext(ChangeContext context) {
        this.fChangeContext = context;
        Assert.isNotNull((Object)this.fChangeContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
        try {
            block8: {
                try {
                    this.fChangeExecuted = false;
                    if (this.createChange()) {
                        pm.beginTask("", 2);
                        this.fCreateChangeOperation.run((IProgressMonitor)new SubProgressMonitor(pm, 1, 4));
                        this.fChange = this.fCreateChangeOperation.getChange();
                        RefactoringStatus status = this.fCreateChangeOperation.getStatus();
                        int conditionCheckingStyle = this.fCreateChangeOperation.getConditionCheckingStyle();
                        if (this.fChange != null && (conditionCheckingStyle == 0 || status != null && status.getSeverity() <= this.fCheckPassedSeverity)) {
                            this.executeChange((IProgressMonitor)new SubProgressMonitor(pm, 1, 4));
                            this.fChangeExecuted = true;
                            break block8;
                        } else {
                            pm.worked(1);
                        }
                        break block8;
                    }
                    this.executeChange(pm);
                    this.fChangeExecuted = true;
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
            Object var4_7 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeChange(IProgressMonitor pm) throws CoreException {
        Assert.isNotNull((Object)this.fChangeContext);
        IRewriteTarget[] targets = null;
        try {
            targets = PerformChangeOperation.getRewriteTargets();
            PerformChangeOperation.beginCompoundChange(targets);
            this.fChange.aboutToPerform(this.fChangeContext, (IProgressMonitor)new NullProgressMonitor());
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        PerformChangeOperation.this.fChange.perform(PerformChangeOperation.this.fChangeContext, monitor);
                    }
                    catch (ChangeAbortException e) {
                        throw new CoreException((IStatus)new Status(4, CUIPlugin.getPluginId(), 10004, RefactoringMessages.getString("PerformChangeOperation.unrecoverable_error"), (Throwable)e));
                    }
                }
            };
            CoreModel.run((IWorkspaceRunnable)runnable, (IProgressMonitor)pm);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.fChange.performed();
            if (targets == null) throw throwable;
            PerformChangeOperation.endCompoundChange(targets);
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.fChange.performed();
            if (targets == null) return;
        }
        PerformChangeOperation.endCompoundChange(targets);
    }

    private boolean createChange() {
        return this.fCreateChangeOperation != null;
    }

    private static void beginCompoundChange(IRewriteTarget[] targets) {
        int i = 0;
        while (i < targets.length) {
            targets[i].beginCompoundChange();
            ++i;
        }
    }

    private static void endCompoundChange(IRewriteTarget[] targets) {
        int i = 0;
        while (i < targets.length) {
            targets[i].endCompoundChange();
            ++i;
        }
    }

    private static IRewriteTarget[] getRewriteTargets() {
        IEditorPart[] editors = CUIPlugin.getInstanciatedEditors();
        ArrayList<IRewriteTarget> result = new ArrayList<IRewriteTarget>(editors.length);
        int i = 0;
        while (i < editors.length) {
            IRewriteTarget target;
            IEditorPart iEditorPart = editors[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.jface.text.IRewriteTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((target = (IRewriteTarget)iEditorPart.getAdapter((Class)clazz)) != null) {
                result.add(target);
            }
            ++i;
        }
        return result.toArray(new IRewriteTarget[result.size()]);
    }
}

