/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICRegisterManager;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegisterGroup;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CRegisterGroup;
import org.eclipse.cdt.debug.internal.core.model.CStackFrame;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;

public class CRegisterManager
implements ICRegisterManager {
    private CDebugTarget fDebugTarget;
    private List fRegisterGroups;
    private CStackFrame fStackFrame;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CRegisterManager(CDebugTarget target) {
        this.fDebugTarget = target;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.ICRegisterManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.cdt.debug.internal.core.CRegisterManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(adapter)) {
            return this;
        }
        return null;
    }

    public void dispose() {
        this.setStackFrame(null);
        this.removeAllRegisterGroups();
    }

    public void addRegisterGroup(IRegisterGroup group) {
    }

    public IRegisterGroup[] getRegisterGroups(CStackFrame frame) throws DebugException {
        this.setStackFrame(frame);
        return this.fRegisterGroups.toArray(new IRegisterGroup[this.fRegisterGroups.size()]);
    }

    public void initialize() {
        this.createRegisterGroups();
    }

    public void removeAllRegisterGroups() {
        Iterator it = this.fRegisterGroups.iterator();
        while (it.hasNext()) {
            ((CRegisterGroup)it.next()).dispose();
        }
        this.fRegisterGroups.clear();
    }

    public void removeRegisterGroup(IRegisterGroup group) {
        this.fRegisterGroups.remove(group);
    }

    private void createRegisterGroups() {
        this.fRegisterGroups = new ArrayList(20);
        this.createMainRegisterGroup();
    }

    private void createMainRegisterGroup() {
        ICDIRegisterGroup[] groups = null;
        try {
            groups = this.getDebugTarget().getCDITarget().getRegisterGroups();
        }
        catch (CDIException e) {
            CDebugCorePlugin.log(e);
        }
        int i = 0;
        while (i < groups.length) {
            this.fRegisterGroups.add(new CRegisterGroup(this.getDebugTarget(), groups[i]));
            ++i;
        }
    }

    public void targetSuspended() {
        Iterator it = this.fRegisterGroups.iterator();
        while (it.hasNext()) {
            ((CRegisterGroup)it.next()).targetSuspended();
        }
    }

    public CStackFrame getStackFrame() {
        return this.fStackFrame;
    }

    private void setStackFrame(CStackFrame stackFrame) {
        this.fStackFrame = stackFrame;
    }

    protected CDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }
}

