/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.ui;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.launch.internal.ui.AbstractCDebuggerTab;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class CoreFileDebuggerTab
extends AbstractCDebuggerTab {
    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.cdt.launch.launch_configuration_dialog_debugger_tab");
        GridLayout topLayout = new GridLayout(1, false);
        comp.setLayout((Layout)topLayout);
        this.createDebuggerCombo(comp, 1);
        this.createDebuggerGroup(comp, 1);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "core");
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (this.getDebugConfig() != null) {
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", this.getDebugConfig().getID());
            ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
            if (dynamicTab == null) {
                config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_SPECIFIC_ATTRS_MAP", null);
            } else {
                dynamicTab.performApply(config);
            }
        }
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.setInitializing(true);
        super.initializeFrom(config);
        try {
            String id = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", "");
            this.loadDebuggerComboBox(config, id);
        }
        catch (CoreException coreException) {}
        this.setInitializing(false);
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.setInitializing(true);
        try {
            String id = workingCopy.getAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", "");
            this.loadDebuggerComboBox((ILaunchConfiguration)workingCopy, id);
        }
        catch (CoreException coreException) {}
        this.setInitializing(false);
        super.activated(workingCopy);
    }

    public boolean isValid(ILaunchConfiguration config) {
        if (!this.validateDebuggerConfig(config)) {
            return false;
        }
        return super.isValid(config);
    }

    protected boolean validateDebuggerConfig(ILaunchConfiguration config) {
        ICDebugConfiguration debugConfig = this.getDebugConfig();
        if (debugConfig == null) {
            this.setErrorMessage(LaunchMessages.getString("CoreFileDebuggerTab.No_debugger_available"));
            return false;
        }
        if (!this.validatePlatform(config, debugConfig)) {
            this.setErrorMessage(LaunchMessages.getString("CoreFileDebuggerTab.platform_is_not_supported"));
            return false;
        }
        return true;
    }

    protected void loadDebuggerComboBox(ILaunchConfiguration config, String selection) {
        ICDebugConfiguration[] debugConfigs = CDebugCorePlugin.getDefault().getDebugConfigurations();
        String projectPlatform = this.getProjectPlatform(config);
        String defaultSelection = null;
        ArrayList<ICDebugConfiguration> list = new ArrayList<ICDebugConfiguration>();
        int i = 0;
        while (i < debugConfigs.length) {
            if (debugConfigs[i].supportsMode("core")) {
                if (this.validatePlatform(config, debugConfigs[i])) {
                    list.add(debugConfigs[i]);
                    String debuggerPlatform = debugConfigs[i].getPlatform();
                    if (defaultSelection == null && debuggerPlatform.equalsIgnoreCase(projectPlatform)) {
                        defaultSelection = debugConfigs[i].getID();
                    }
                }
                if (selection.equals(debugConfigs[i].getID())) {
                    defaultSelection = debugConfigs[i].getID();
                }
            }
            ++i;
        }
        this.setInitializeDefault(selection.equals(""));
        this.loadDebuggerCombo(list.toArray(new ICDebugConfiguration[list.size()]), defaultSelection);
    }

    protected boolean validatePlatform(ILaunchConfiguration config, ICDebugConfiguration debugConfig) {
        String projectPlatform = this.getProjectPlatform(config);
        String debuggerPlatform = debugConfig.getPlatform();
        return projectPlatform.equals("*") || debuggerPlatform.equals("*") || debuggerPlatform.equalsIgnoreCase(projectPlatform);
    }

    private String getProjectPlatform(ILaunchConfiguration config) {
        ICElement ce = this.getContext(config, null);
        String projectPlatform = "*";
        if (ce != null) {
            try {
                ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(ce.getCProject().getProject(), false);
                if (descriptor != null) {
                    projectPlatform = descriptor.getPlatform();
                }
            }
            catch (Exception exception) {}
        }
        return projectPlatform;
    }
}

