/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.debug.mi.core.IMIConstants;
import org.eclipse.cdt.debug.mi.core.IMITTY;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIProcess;
import org.eclipse.cdt.debug.mi.core.MIProcessAdapter;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.MITTYAdapter;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIStackListFrames;
import org.eclipse.cdt.debug.mi.core.command.MITargetAttach;
import org.eclipse.cdt.debug.mi.core.command.MITargetSelect;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.osgi.framework.BundleContext;

public class MIPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.cdt.debug.mi.core";
    private static MIPlugin plugin;
    private static final String GDBINIT = ".gdbinit";
    private static final String GDB = "gdb";
    private static ResourceBundle fgResourceBundle;

    static {
        try {
            fgResourceBundle = ResourceBundle.getBundle("org.eclipse.cdt.debug.mi.core.MIPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            fgResourceBundle = null;
        }
    }

    public MIPlugin() {
        plugin = this;
    }

    public static MIPlugin getDefault() {
        return plugin;
    }

    public MISession createMISession(MIProcess process, IMITTY pty, int timeout, int type, int launchTimeout) throws MIException {
        return new MISession(process, pty, timeout, type, launchTimeout);
    }

    public MISession createMISession(MIProcess process, IMITTY pty, int type) throws MIException {
        MIPlugin miPlugin = MIPlugin.getDefault();
        Preferences prefs = miPlugin.getPluginPreferences();
        int timeout = prefs.getInt(IMIConstants.PREF_REQUEST_TIMEOUT);
        int launchTimeout = prefs.getInt(IMIConstants.PREF_REQUEST_LAUNCH_TIMEOUT);
        return this.createMISession(process, pty, timeout, type, launchTimeout);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Session createCSession(String gdb, File program, File cwd, String gdbinit, IProgressMonitor monitor) throws IOException, MIException {
        InputStream in2;
        Session session;
        MITTYAdapter pty = null;
        boolean failed = false;
        try {
            PTY pseudo = new PTY();
            pty = new MITTYAdapter(pseudo);
        }
        catch (IOException iOException) {}
        try {
            try {
                session = this.createCSession(gdb, program, cwd, gdbinit, pty, monitor);
                Object var9_12 = null;
                if (!failed) return session;
                if (pty == null) return session;
            }
            catch (IOException exc) {
                failed = true;
                throw exc;
            }
            catch (MIException exc) {
                failed = true;
                throw exc;
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (!failed) throw throwable;
            if (pty == null) throw throwable;
            try {
                InputStream in2;
                OutputStream out = pty.getOutputStream();
                if (out != null) {
                    out.close();
                }
                if ((in2 = pty.getInputStream()) == null) throw throwable;
                in2.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {}
        OutputStream out = pty.getOutputStream();
        if (out != null) {
            out.close();
        }
        if ((in2 = pty.getInputStream()) == null) return session;
        in2.close();
        return session;
    }

    public Session createCSession(String gdb, File program, File cwd, String gdbinit, IMITTY pty, IProgressMonitor monitor) throws IOException, MIException {
        MISession session;
        if (gdb == null || gdb.length() == 0) {
            gdb = GDB;
        }
        if (gdbinit == null || gdbinit.length() == 0) {
            gdbinit = GDBINIT;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String[] args = pty != null ? (program == null ? new String[]{gdb, "--cd=" + cwd.getAbsolutePath(), "--command=" + gdbinit, "-q", "-nw", "-tty", pty.getSlaveName(), "-i", "mi1"} : new String[]{gdb, "--cd=" + cwd.getAbsolutePath(), "--command=" + gdbinit, "-q", "-nw", "-tty", pty.getSlaveName(), "-i", "mi1", program.getAbsolutePath()}) : (program == null ? new String[]{gdb, "--cd=" + cwd.getAbsolutePath(), "--command=" + gdbinit, "-q", "-nw", "-i", "mi1"} : new String[]{gdb, "--cd=" + cwd.getAbsolutePath(), "--command=" + gdbinit, "-q", "-nw", "-i", "mi1", program.getAbsolutePath()});
        MIProcessAdapter pgdb = new MIProcessAdapter(args, monitor);
        try {
            session = this.createMISession(pgdb, pty, 0);
        }
        catch (MIException e) {
            pgdb.destroy();
            throw e;
        }
        try {
            CommandFactory factory = session.getCommandFactory();
            MIStackListFrames frames = factory.createMIStackListFrames();
            session.postCommand(frames);
            MIInfo info = frames.getMIInfo();
            if (info == null) {
                pgdb.destroy();
                throw new MIException(MIPlugin.getResourceString("src.common.No_answer"));
            }
            session.getMIInferior().setSuspended();
            session.getMIInferior().update();
        }
        catch (MIException mIException) {}
        return new Session(session, false);
    }

    public Session createCSession(String gdb, File program, File core, File cwd, String gdbinit, IProgressMonitor monitor) throws IOException, MIException {
        MISession session;
        if (gdb == null || gdb.length() == 0) {
            gdb = GDB;
        }
        if (gdbinit == null || gdbinit.length() == 0) {
            gdbinit = GDBINIT;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String[] args = program == null ? new String[]{gdb, "--cd=" + cwd.getAbsolutePath(), "--command=" + gdbinit, "--quiet", "-nw", "-i", "mi1", "-c", core.getAbsolutePath()} : new String[]{gdb, "--cd=" + cwd.getAbsolutePath(), "--command=" + gdbinit, "--quiet", "-nw", "-i", "mi1", "-c", core.getAbsolutePath(), program.getAbsolutePath()};
        MIProcessAdapter pgdb = new MIProcessAdapter(args, monitor);
        try {
            session = this.createMISession(pgdb, null, 2);
            session.getMIInferior().setSuspended();
        }
        catch (MIException e) {
            pgdb.destroy();
            throw e;
        }
        return new Session(session);
    }

    public Session createCSession(String gdb, File program, int pid, String[] targetParams, File cwd, String gdbinit, IProgressMonitor monitor) throws IOException, MIException {
        MISession session;
        if (gdb == null || gdb.length() == 0) {
            gdb = GDB;
        }
        if (gdbinit == null || gdbinit.length() == 0) {
            gdbinit = GDBINIT;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String[] args = program == null ? new String[]{gdb, "--cd=" + cwd.getAbsolutePath(), "--command=" + gdbinit, "--quiet", "-nw", "-i", "mi1"} : new String[]{gdb, "--cd=" + cwd.getAbsolutePath(), "--command=" + gdbinit, "--quiet", "-nw", "-i", "mi1", program.getAbsolutePath()};
        MIProcessAdapter pgdb = new MIProcessAdapter(args, monitor);
        try {
            session = this.createMISession(pgdb, null, 1);
        }
        catch (MIException e) {
            pgdb.destroy();
            throw e;
        }
        CommandFactory factory = session.getCommandFactory();
        try {
            MIInfo info;
            if (targetParams != null && targetParams.length > 0) {
                MITargetSelect target = factory.createMITargetSelect(targetParams);
                session.postCommand(target);
                info = target.getMIInfo();
                if (info == null) {
                    throw new MIException(MIPlugin.getResourceString("src.common.No_answer"));
                }
            }
            if (pid > 0) {
                MITargetAttach attach = factory.createMITargetAttach(pid);
                session.postCommand(attach);
                info = attach.getMIInfo();
                if (info == null) {
                    throw new MIException(MIPlugin.getResourceString("src.common.No_answer"));
                }
                session.getMIInferior().setInferiorPID(pid);
                session.getMIInferior().setConnected();
            }
        }
        catch (MIException e) {
            pgdb.destroy();
            throw e;
        }
        session.getMIInferior().setSuspended();
        session.getMIInferior().update();
        return new Session(session, true);
    }

    public static String getUniqueIdentifier() {
        if (MIPlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return MIPlugin.getDefault().getBundle().getSymbolicName();
    }

    public void debugLog(String message) {
        if (MIPlugin.getDefault().isDebugging()) {
            message = MessageFormat.format("[{0}] {1}", new Long(System.currentTimeMillis()), message);
            while (message.length() > 100) {
                String partial = message.substring(0, 100);
                message = message.substring(100);
                System.err.println(String.valueOf(partial) + "\\");
            }
            if (message.endsWith("\n")) {
                System.err.print(message);
            } else {
                System.err.println(message);
            }
        }
    }

    public static String getResourceString(String key) {
        try {
            return fgResourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return String.valueOf('!') + key + '!';
        }
        catch (NullPointerException nullPointerException) {
            return String.valueOf('#') + key + '#';
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        this.savePluginPreferences();
        super.stop(context);
    }
}

