/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExceptionpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDILocationBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIWatchpoint;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIFormat;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.Condition;
import org.eclipse.cdt.debug.mi.core.cdi.Location;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Manager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.Breakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.Exceptionpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.cdi.model.Watchpoint;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIBreakDelete;
import org.eclipse.cdt.debug.mi.core.command.MIBreakDisable;
import org.eclipse.cdt.debug.mi.core.command.MIBreakEnable;
import org.eclipse.cdt.debug.mi.core.command.MIBreakInsert;
import org.eclipse.cdt.debug.mi.core.command.MIBreakList;
import org.eclipse.cdt.debug.mi.core.command.MIBreakWatch;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointDeletedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.output.MIBreakInsertInfo;
import org.eclipse.cdt.debug.mi.core.output.MIBreakListInfo;
import org.eclipse.cdt.debug.mi.core.output.MIBreakWatchInfo;
import org.eclipse.cdt.debug.mi.core.output.MIBreakpoint;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;

public class BreakpointManager
extends Manager {
    public static ICDIBreakpoint[] EMPTY_BREAKPOINTS = new ICDIBreakpoint[0];
    Map breakMap;
    Map deferredMap;
    boolean allowInterrupt = true;
    Breakpoint[] exceptionBps = new Breakpoint[2];
    final int EXCEPTION_THROW_IDX = 0;
    final int EXCEPTION_CATCH_IDX = 1;
    static final String[] EXCEPTION_FUNCS = new String[]{"__cxa_throw", "__cxa_begin_catch"};

    public BreakpointManager(Session session) {
        super(session, false);
        this.breakMap = Collections.synchronizedMap(new HashMap());
        this.deferredMap = Collections.synchronizedMap(new HashMap());
    }

    synchronized List getBreakpointsList(Target target) {
        List bList = (List)this.breakMap.get(target);
        if (bList == null) {
            bList = Collections.synchronizedList(new ArrayList());
            this.breakMap.put(target, bList);
        }
        return bList;
    }

    MIBreakpoint[] getAllMIBreakpoints(MISession miSession) throws CDIException {
        CommandFactory factory = miSession.getCommandFactory();
        MIBreakList breakpointList = factory.createMIBreakList();
        try {
            miSession.postCommand(breakpointList);
            MIBreakListInfo info = breakpointList.getMIBreakListInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
            return info.getMIBreakpoints();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    boolean hasBreakpointChanged(MIBreakpoint miBreak, MIBreakpoint miBreakpoint) {
        return miBreak.isEnabled() != miBreakpoint.isEnabled() || !miBreak.getCondition().equals(miBreakpoint.getCondition()) || miBreak.getIgnoreCount() != miBreakpoint.getIgnoreCount();
    }

    public Watchpoint getWatchpoint(MISession miSession, int number) {
        return (Watchpoint)this.getBreakpoint(miSession, number);
    }

    public Breakpoint getBreakpoint(MISession miSession, int number) {
        Session session = (Session)this.getSession();
        Target target = session.getTarget(miSession);
        if (target != null) {
            return this.getBreakpoint(target, number);
        }
        return null;
    }

    public Breakpoint getBreakpoint(Target target, int number) {
        List bList = (List)this.breakMap.get(target);
        if (bList != null) {
            Breakpoint[] bkpts = bList.toArray(new Breakpoint[0]);
            int i = 0;
            while (i < bkpts.length) {
                MIBreakpoint[] miBreakpoints = bkpts[i].getMIBreakpoints();
                int j = 0;
                while (j < miBreakpoints.length) {
                    if (miBreakpoints[j].getNumber() == number) {
                        return bkpts[i];
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    boolean suspendInferior(Target target) throws CDIException {
        boolean shouldRestart = false;
        if (this.allowInterrupt && target.isRunning()) {
            target.suspend();
            shouldRestart = true;
        }
        return shouldRestart;
    }

    void resumeInferior(Target target, boolean shouldRestart) throws CDIException {
        if (shouldRestart) {
            target.resume();
        }
    }

    public void deleteBreakpoint(MISession miSession, int no) {
        Session session = (Session)this.getSession();
        Target target = session.getTarget(miSession);
        if (target != null) {
            this.deleteBreakpoint(target, no);
        }
    }

    void deleteBreakpoint(Target target, int no) {
        List bList = (List)this.breakMap.get(target);
        if (bList != null) {
            Breakpoint[] points = bList.toArray(new Breakpoint[0]);
            int i = 0;
            while (i < points.length) {
                MIBreakpoint[] miBreakpoints = points[i].getMIBreakpoints();
                int j = 0;
                while (j < miBreakpoints.length) {
                    if (miBreakpoints[j].getNumber() == no) {
                        bList.remove(points[i]);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void enableBreakpoint(Breakpoint breakpoint) throws CDIException {
        Target target = (Target)breakpoint.getTarget();
        List bList = (List)this.breakMap.get(target);
        if (bList == null) {
            throw new CDIException(CdiResources.getString("cdi.BreakpointManager.Not_a_CDT_breakpoint"));
        }
        if (!bList.contains(breakpoint)) {
            throw new CDIException(CdiResources.getString("cdi.BreakpointManager.Not_a_CDT_breakpoint"));
        }
        MIBreakpoint[] miBreakpoints = breakpoint.getMIBreakpoints();
        if (miBreakpoints == null || miBreakpoints.length == 0) {
            throw new CDIException(CdiResources.getString("cdi.BreakpointManager.Not_a_CDT_breakpoint"));
        }
        int[] numbers = new int[miBreakpoints.length];
        int i = 0;
        while (i < miBreakpoints.length) {
            numbers[i] = miBreakpoints[i].getNumber();
            ++i;
        }
        boolean state = this.suspendInferior(target);
        MISession miSession = target.getMISession();
        CommandFactory factory = miSession.getCommandFactory();
        MIBreakEnable breakEnable = factory.createMIBreakEnable(numbers);
        try {
            try {
                miSession.postCommand(breakEnable);
                MIInfo info = breakEnable.getMIInfo();
                if (info == null) {
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
            Object var11_15 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            this.resumeInferior(target, state);
            throw throwable;
        }
        this.resumeInferior(target, state);
        int i2 = 0;
        while (i2 < miBreakpoints.length) {
            miBreakpoints[i2].setEnabled(true);
            ++i2;
        }
        breakpoint.setEnabled0(true);
        miSession.fireEvent(new MIBreakpointChangedEvent(miSession, numbers[0]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void disableBreakpoint(Breakpoint breakpoint) throws CDIException {
        Target target = (Target)breakpoint.getTarget();
        List bList = (List)this.breakMap.get(target);
        if (bList == null) {
            throw new CDIException(CdiResources.getString("cdi.BreakpointManager.Not_a_CDT_breakpoint"));
        }
        if (!bList.contains(breakpoint)) {
            throw new CDIException(CdiResources.getString("cdi.BreakpointManager.Not_a_CDT_breakpoint"));
        }
        MIBreakpoint[] miBreakpoints = breakpoint.getMIBreakpoints();
        if (miBreakpoints == null || miBreakpoints.length == 0) {
            throw new CDIException(CdiResources.getString("cdi.BreakpointManager.Not_a_CDT_breakpoint"));
        }
        int[] numbers = new int[miBreakpoints.length];
        int i = 0;
        while (i < miBreakpoints.length) {
            numbers[i] = miBreakpoints[i].getNumber();
            ++i;
        }
        boolean state = this.suspendInferior(target);
        MISession miSession = target.getMISession();
        CommandFactory factory = miSession.getCommandFactory();
        MIBreakDisable breakDisable = factory.createMIBreakDisable(numbers);
        try {
            try {
                miSession.postCommand(breakDisable);
                MIInfo info = breakDisable.getMIInfo();
                if (info == null) {
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
            Object var11_15 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            this.resumeInferior(target, state);
            throw throwable;
        }
        this.resumeInferior(target, state);
        int i2 = 0;
        while (i2 < miBreakpoints.length) {
            miBreakpoints[i2].setEnabled(false);
            ++i2;
        }
        breakpoint.setEnabled0(false);
        miSession.fireEvent(new MIBreakpointChangedEvent(miSession, numbers[0]));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCondition(ICDIBreakpoint breakpoint, ICDICondition newCondition) throws CDIException {
        MIBreakpoint[] miBreakpoints;
        Breakpoint bpt;
        Target target;
        block7: {
            target = (Target)breakpoint.getTarget();
            List bList = (List)this.breakMap.get(target);
            if (bList == null) {
                throw new CDIException(CdiResources.getString("cdi.BreakpointManager.Not_a_CDT_breakpoint"));
            }
            if (!bList.contains(breakpoint)) {
                throw new CDIException(CdiResources.getString("cdi.BreakpointManager.Not_a_CDT_breakpoint"));
            }
            bpt = (Breakpoint)breakpoint;
            miBreakpoints = bpt.getMIBreakpoints();
            this.deleteMIBreakpoints(target, miBreakpoints);
            ICDICondition oldCondition = bpt.getCondition();
            boolean success = false;
            try {
                bpt.setCondition0(newCondition);
                this.setLocationBreakpoint(bpt);
                success = true;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (!success) {
                    bpt.setCondition0(oldCondition);
                    this.setLocationBreakpoint(bpt);
                }
                throw throwable;
            }
            {
                Object var9_11 = null;
                if (success) break block7;
                bpt.setCondition0(oldCondition);
            }
            this.setLocationBreakpoint(bpt);
        }
        if ((miBreakpoints = bpt.getMIBreakpoints()) != null && miBreakpoints.length > 0) {
            MISession miSession = target.getMISession();
            miSession.fireEvent(new MIBreakpointChangedEvent(miSession, miBreakpoints[0].getNumber()));
        }
    }

    public void update(Target target) throws CDIException {
        MISession miSession = target.getMISession();
        MIBreakpoint[] allMIBreakpoints = this.getAllMIBreakpoints(miSession);
        List bList = this.getBreakpointsList(target);
        ArrayList<MIEvent> eventList = new ArrayList<MIEvent>(allMIBreakpoints.length);
        int i = 0;
        while (i < allMIBreakpoints.length) {
            int no = allMIBreakpoints[i].getNumber();
            Breakpoint bp = this.getBreakpoint(target, no);
            if (bp != null) {
                MIBreakpoint[] miBps = bp.getMIBreakpoints();
                int j = 0;
                while (j < miBps.length) {
                    if (miBps[j].getNumber() == no && this.hasBreakpointChanged(miBps[j], allMIBreakpoints[i])) {
                        miBps[j] = allMIBreakpoints[i];
                        bp.setEnabled0(allMIBreakpoints[i].isEnabled());
                        ICDICondition oldCond = bp.getCondition();
                        String[] tids = oldCond.getThreadIds();
                        Condition newCondition = new Condition(allMIBreakpoints[i].getIgnoreCount(), allMIBreakpoints[i].getCondition(), tids);
                        bp.setCondition0(newCondition);
                        eventList.add(new MIBreakpointChangedEvent(miSession, no));
                    }
                    ++j;
                }
            } else {
                int type = 0;
                if (allMIBreakpoints[i].isHardware()) {
                    type = 2;
                } else if (allMIBreakpoints[i].isTemporary()) {
                    type = 1;
                }
                String[] tids = null;
                String tid = allMIBreakpoints[i].getThreadId();
                if (tid != null && tid.length() > 0) {
                    tids = new String[]{tid};
                }
                Condition condition = new Condition(allMIBreakpoints[i].getIgnoreCount(), allMIBreakpoints[i].getCondition(), tids);
                if (allMIBreakpoints[i].isWatchpoint()) {
                    int watchType = 0;
                    if (allMIBreakpoints[i].isAccessWatchpoint() || allMIBreakpoints[i].isReadWatchpoint()) {
                        watchType &= 2;
                    }
                    if (allMIBreakpoints[i].isAccessWatchpoint() || allMIBreakpoints[i].isWriteWatchpoint()) {
                        watchType &= 1;
                    }
                    Watchpoint wpoint = new Watchpoint(target, allMIBreakpoints[i].getWhat(), type, watchType, condition);
                    wpoint.setMIBreakpoints(new MIBreakpoint[]{allMIBreakpoints[i]});
                    bList.add(wpoint);
                } else {
                    Location location = new Location(allMIBreakpoints[i].getFile(), allMIBreakpoints[i].getFunction(), allMIBreakpoints[i].getLine(), MIFormat.getBigInteger(allMIBreakpoints[i].getAddress()));
                    Breakpoint newBreakpoint = new Breakpoint(target, type, location, condition);
                    newBreakpoint.setMIBreakpoints(new MIBreakpoint[]{allMIBreakpoints[i]});
                    bList.add(newBreakpoint);
                }
                eventList.add(new MIBreakpointCreatedEvent(miSession, no));
            }
            ++i;
        }
        Breakpoint[] oldBreakpoints = bList.toArray(new Breakpoint[0]);
        int i2 = 0;
        while (i2 < oldBreakpoints.length) {
            boolean found = false;
            MIBreakpoint[] miBreakpoints = oldBreakpoints[i2].getMIBreakpoints();
            int j = 0;
            while (j < miBreakpoints.length) {
                int no = miBreakpoints[j].getNumber();
                int k = 0;
                while (k < allMIBreakpoints.length) {
                    if (no == allMIBreakpoints[k].getNumber()) {
                        found = true;
                        break;
                    }
                    ++k;
                }
                if (!found) {
                    eventList.add(new MIBreakpointDeletedEvent(miSession, no));
                }
                ++j;
            }
            ++i2;
        }
        MIEvent[] events = eventList.toArray(new MIEvent[0]);
        miSession.fireEvents(events);
    }

    public void allowProgramInterruption(boolean e) {
        this.allowInterrupt = e;
    }

    public void deleteFromDeferredList(Breakpoint bkpt) {
        List dList = (List)this.deferredMap.get(bkpt.getTarget());
        if (dList != null) {
            dList.remove(bkpt);
        }
    }

    public void addToBreakpointList(Breakpoint bkpt) {
        List bList = (List)this.breakMap.get(bkpt.getTarget());
        if (bList != null) {
            bList.add(bkpt);
        }
    }

    public void deleteAllBreakpoints(Target target) throws CDIException {
        List bList = (List)this.breakMap.get(target);
        if (bList != null) {
            ICDIBreakpoint[] bps = new ICDIBreakpoint[bList.size()];
            bList.toArray(bps);
            this.deleteBreakpoints(target, bps);
        }
    }

    public void deleteBreakpoint(ICDIBreakpoint breakpoint) throws CDIException {
        this.deleteBreakpoints((Target)breakpoint.getTarget(), new ICDIBreakpoint[]{breakpoint});
    }

    public void deleteBreakpoints(Target target, ICDIBreakpoint[] breakpoints) throws CDIException {
        List bList = (List)this.breakMap.get(target);
        if (bList == null) {
            throw new CDIException(CdiResources.getString("cdi.BreakpointManager.Not_a_CDT_breakpoint"));
        }
        int i = 0;
        while (i < breakpoints.length) {
            if (!(breakpoints[i] instanceof Breakpoint) || !bList.contains(breakpoints[i])) {
                throw new CDIException(CdiResources.getString("cdi.BreakpointManager.Not_a_CDT_breakpoint"));
            }
            ++i;
        }
        MISession miSession = target.getMISession();
        ArrayList<MIBreakpointDeletedEvent> eventList = new ArrayList<MIBreakpointDeletedEvent>(breakpoints.length);
        int i2 = 0;
        while (i2 < breakpoints.length) {
            MIBreakpoint[] miBreakpoints = ((Breakpoint)breakpoints[i2]).getMIBreakpoints();
            if (miBreakpoints.length > 0) {
                this.deleteMIBreakpoints(target, miBreakpoints);
                eventList.add(new MIBreakpointDeletedEvent(miSession, miBreakpoints[0].getNumber()));
            }
            ++i2;
        }
        MIEvent[] events = eventList.toArray(new MIEvent[0]);
        miSession.fireEvents(events);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void deleteMIBreakpoints(Target target, MIBreakpoint[] miBreakpoints) throws CDIException {
        MISession miSession = target.getMISession();
        int[] numbers = new int[miBreakpoints.length];
        int i = 0;
        while (i < miBreakpoints.length) {
            numbers[i] = miBreakpoints[i].getNumber();
            ++i;
        }
        boolean state = this.suspendInferior(target);
        try {
            this.deleteMIBreakpoints(miSession, numbers);
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.resumeInferior(target, state);
            throw throwable;
        }
        this.resumeInferior(target, state);
    }

    void deleteMIBreakpoints(MISession miSession, int[] numbers) throws CDIException {
        CommandFactory factory = miSession.getCommandFactory();
        MIBreakDelete breakDelete = factory.createMIBreakDelete(numbers);
        try {
            miSession.postCommand(breakDelete);
            MIInfo info = breakDelete.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public ICDIBreakpoint[] getBreakpoints(Target target) throws CDIException {
        List list = (List)this.breakMap.get(target);
        if (list != null) {
            ICDIBreakpoint[] bps = new ICDIBreakpoint[list.size()];
            list.toArray(bps);
            return bps;
        }
        return EMPTY_BREAKPOINTS;
    }

    public ICDIBreakpoint[] getDeferredBreakpoints(Target target) throws CDIException {
        List dlist = (List)this.deferredMap.get(target);
        if (dlist != null) {
            ICDIBreakpoint[] bps = new ICDIBreakpoint[dlist.size()];
            dlist.toArray(bps);
            return bps;
        }
        return EMPTY_BREAKPOINTS;
    }

    public ICDILocationBreakpoint setLocationBreakpoint(Target target, int type, ICDILocation location, ICDICondition condition, boolean deferred) throws CDIException {
        MISession miSession = target.getMISession();
        Breakpoint bkpt = new Breakpoint(target, type, location, condition);
        try {
            this.setLocationBreakpoint(bkpt);
            List blist = this.getBreakpointsList(target);
            blist.add(bkpt);
            bkpt.setLocation(null);
            MIBreakpoint[] miBreakpoints = bkpt.getMIBreakpoints();
            if (miBreakpoints != null && miBreakpoints.length > 0) {
                miSession.fireEvent(new MIBreakpointCreatedEvent(miSession, miBreakpoints[0].getNumber()));
            }
        }
        catch (CDIException e) {
            if (!deferred) {
                throw e;
            }
            Session session = (Session)target.getSession();
            SharedLibraryManager sharedMgr = session.getSharedLibraryManager();
            if (sharedMgr.isDeferredBreakpoint()) {
                List<Breakpoint> dList = (List<Breakpoint>)this.deferredMap.get(target);
                if (dList == null) {
                    dList = Collections.synchronizedList(new ArrayList());
                    this.deferredMap.put(target, dList);
                }
                dList.add(bkpt);
            }
            throw e;
        }
        return bkpt;
    }

    MIBreakInsert[] createMIBreakInsert(Breakpoint bkpt) throws CDIException {
        MIBreakInsert[] miBreakInserts;
        boolean hardware = bkpt.isHardware();
        boolean temporary = bkpt.isTemporary();
        String exprCond = null;
        int ignoreCount = 0;
        String[] threadIds = null;
        StringBuffer line = new StringBuffer();
        if (bkpt.getCondition() != null) {
            ICDICondition condition = bkpt.getCondition();
            exprCond = condition.getExpression();
            ignoreCount = condition.getIgnoreCount();
            threadIds = condition.getThreadIds();
        }
        if (bkpt.getLocation() != null) {
            ICDILocation location = bkpt.getLocation();
            String file = location.getFile();
            String function = location.getFunction();
            if (file != null && file.length() > 0) {
                line.append(file).append(':');
                if (function != null && function.length() > 0) {
                    int paren = function.indexOf(40);
                    if (paren != -1) {
                        int no = location.getLineNumber();
                        if (no <= 0) {
                            String func = function.substring(0, paren);
                            line.append(func);
                        } else {
                            line.append(no);
                        }
                    } else {
                        line.append(function);
                    }
                } else {
                    line.append(location.getLineNumber());
                }
            } else if (function != null && function.length() > 0) {
                line.append(function);
            } else if (location.getLineNumber() != 0) {
                line.append(location.getLineNumber());
            } else {
                line.append('*').append(location.getAddress());
            }
        }
        MISession miSession = ((Target)bkpt.getTarget()).getMISession();
        CommandFactory factory = miSession.getCommandFactory();
        if (threadIds == null || threadIds.length == 0) {
            MIBreakInsert bi = factory.createMIBreakInsert(temporary, hardware, exprCond, ignoreCount, line.toString(), 0);
            miBreakInserts = new MIBreakInsert[]{bi};
        } else {
            ArrayList<MIBreakInsert> list = new ArrayList<MIBreakInsert>(threadIds.length);
            int i = 0;
            while (i < threadIds.length) {
                String threadId = threadIds[i];
                int tid = 0;
                if (threadId != null && threadId.length() > 0) {
                    try {
                        tid = Integer.parseInt(threadId);
                        list.add(factory.createMIBreakInsert(temporary, hardware, exprCond, ignoreCount, line.toString(), tid));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                ++i;
            }
            miBreakInserts = list.toArray(new MIBreakInsert[list.size()]);
        }
        return miBreakInserts;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setLocationBreakpoint(Breakpoint bkpt) throws CDIException {
        Target target = (Target)bkpt.getTarget();
        MISession miSession = target.getMISession();
        boolean state = this.suspendInferior(target);
        MIBreakInsert[] breakInserts = this.createMIBreakInsert(bkpt);
        ArrayList<MIBreakpoint> pointList = new ArrayList<MIBreakpoint>();
        try {
            try {
                CommandFactory factory = miSession.getCommandFactory();
                boolean enable = bkpt.isEnabled();
                int i = 0;
                while (i < breakInserts.length) {
                    miSession.postCommand(breakInserts[i]);
                    MIBreakInsertInfo info = breakInserts[i].getMIBreakInsertInfo();
                    if (info == null) {
                        throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                    }
                    MIBreakpoint[] points = info.getMIBreakpoints();
                    if (points == null) throw new CDIException(CdiResources.getString("cdi.BreakpointManager.Parsing_Error"));
                    if (points.length == 0) {
                        throw new CDIException(CdiResources.getString("cdi.BreakpointManager.Parsing_Error"));
                    }
                    if (!enable) {
                        int[] numbers = new int[points.length];
                        int j = 0;
                        while (true) {
                            if (j >= points.length) {
                                MIBreakDisable breakDisable = factory.createMIBreakDisable(numbers);
                                try {
                                    miSession.postCommand(breakDisable);
                                    MIInfo disableInfo = breakDisable.getMIInfo();
                                    if (disableInfo == null) {
                                        throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                                    }
                                    break;
                                }
                                catch (MIException e) {
                                    throw new MI2CDIException(e);
                                }
                            }
                            numbers[j] = points[j].getNumber();
                            ++j;
                        }
                    }
                    pointList.addAll(Arrays.asList(points));
                    ++i;
                }
            }
            catch (MIException e) {
                try {
                    MIBreakpoint[] allPoints = pointList.toArray(new MIBreakpoint[pointList.size()]);
                    if (allPoints == null) throw new MI2CDIException(e);
                    if (allPoints.length <= 0) throw new MI2CDIException(e);
                    this.deleteMIBreakpoints(target, allPoints);
                    throw new MI2CDIException(e);
                }
                catch (CDIException cDIException) {}
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            this.resumeInferior(target, state);
            throw throwable;
        }
        {
            Object var15_21 = null;
        }
        this.resumeInferior(target, state);
        MIBreakpoint[] allPoints = pointList.toArray(new MIBreakpoint[pointList.size()]);
        bkpt.setMIBreakpoints(allPoints);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDIWatchpoint setWatchpoint(Target target, int type, int watchType, String expression, ICDICondition condition) throws CDIException {
        boolean access = (watchType & 1) == 1 && (watchType & 2) == 2;
        boolean read = (watchType & 1) != 1 && (watchType & 2) == 2;
        try {
            Integer.decode(expression);
            expression = String.valueOf('*') + expression;
        }
        catch (NumberFormatException numberFormatException) {}
        MISession miSession = target.getMISession();
        boolean state = this.suspendInferior(target);
        CommandFactory factory = miSession.getCommandFactory();
        MIBreakWatch breakWatch = factory.createMIBreakWatch(access, read, expression);
        MIBreakpoint[] points = null;
        try {
            try {
                miSession.postCommand(breakWatch);
                MIBreakWatchInfo info = breakWatch.getMIBreakWatchInfo();
                points = info.getMIBreakpoints();
                if (info == null) {
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
                if (points == null || points.length == 0) {
                    throw new CDIException(CdiResources.getString("cdi.BreakpointManager.Parsing_Error"));
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            this.resumeInferior(target, state);
            throw throwable;
        }
        {
            Object var14_18 = null;
        }
        this.resumeInferior(target, state);
        Watchpoint bkpt = new Watchpoint(target, expression, type, watchType, condition);
        bkpt.setMIBreakpoints(points);
        List bList = this.getBreakpointsList(target);
        bList.add(bkpt);
        MIBreakpoint[] miBreakpoints = bkpt.getMIBreakpoints();
        if (miBreakpoints != null && miBreakpoints.length > 0) {
            miSession.fireEvent(new MIBreakpointCreatedEvent(miSession, miBreakpoints[0].getNumber()));
        }
        return bkpt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ICDIExceptionpoint setExceptionpoint(Target target, String clazz, boolean stopOnThrow, boolean stopOnCatch) throws CDIException {
        Breakpoint bp;
        Location location;
        int id;
        Breakpoint[] breakpointArray;
        if (!stopOnThrow && !stopOnCatch) {
            throw new CDIException("Must suspend on throw or catch");
        }
        MIBreakpoint[] miBreakpoints = null;
        if (stopOnThrow) {
            breakpointArray = this.exceptionBps;
            // MONITORENTER : this.exceptionBps
            id = 0;
            if (this.exceptionBps[0] == null) {
                location = new Location(null, EXCEPTION_FUNCS[id], 0);
                bp = new Breakpoint(target, 0, location, null);
                this.setLocationBreakpoint(bp);
                this.exceptionBps[id] = bp;
                miBreakpoints = bp.getMIBreakpoints();
            }
            // MONITOREXIT : breakpointArray
        }
        if (stopOnCatch) {
            breakpointArray = this.exceptionBps;
            // MONITORENTER : this.exceptionBps
            id = 0;
            if (this.exceptionBps[id] == null) {
                location = new Location(null, EXCEPTION_FUNCS[id], 0);
                bp = new Breakpoint(target, 0, location, null);
                this.setLocationBreakpoint(bp);
                this.exceptionBps[id] = bp;
                if (miBreakpoints != null) {
                    MIBreakpoint[] mibp = bp.getMIBreakpoints();
                    MIBreakpoint[] temp = new MIBreakpoint[miBreakpoints.length + mibp.length];
                    System.arraycopy(miBreakpoints, 0, temp, 0, miBreakpoints.length);
                    System.arraycopy(mibp, 0, temp, miBreakpoints.length, mibp.length);
                } else {
                    miBreakpoints = bp.getMIBreakpoints();
                }
            }
            // MONITOREXIT : breakpointArray
        }
        Exceptionpoint excp = new Exceptionpoint(target, clazz, stopOnThrow, stopOnCatch);
        if (miBreakpoints == null) return excp;
        if (miBreakpoints.length <= 0) return excp;
        excp.setMIBreakpoints(miBreakpoints);
        List blist = this.getBreakpointsList(target);
        blist.add(excp);
        MISession miSession = target.getMISession();
        miSession.fireEvent(new MIBreakpointCreatedEvent(miSession, miBreakpoints[0].getNumber()));
        return excp;
    }

    public Condition createCondition(int ignoreCount, String expression, String[] tids) {
        return new Condition(ignoreCount, expression, tids);
    }

    public Location createLocation(String file, String function, int line) {
        return new Location(file, function, line);
    }

    public Location createLocation(BigInteger address) {
        return new Location(address);
    }
}

