/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui;

import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpointHit;
import org.eclipse.cdt.debug.core.cdi.ICDIExitInfo;
import org.eclipse.cdt.debug.core.cdi.ICDISharedLibraryEvent;
import org.eclipse.cdt.debug.core.cdi.ICDISignalExitInfo;
import org.eclipse.cdt.debug.core.cdi.ICDISignalReceived;
import org.eclipse.cdt.debug.core.cdi.ICDIWatchpointScope;
import org.eclipse.cdt.debug.core.cdi.ICDIWatchpointTrigger;
import org.eclipse.cdt.debug.core.cdi.model.ICDISignal;
import org.eclipse.cdt.debug.core.model.CDebugElementState;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICDebugElement;
import org.eclipse.cdt.debug.core.model.ICDebugElementStatus;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICGlobalVariable;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICSharedLibrary;
import org.eclipse.cdt.debug.core.model.ICSignal;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.ICThread;
import org.eclipse.cdt.debug.core.model.ICType;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.core.model.ICVariable;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.core.model.IEnableDisableTarget;
import org.eclipse.cdt.debug.internal.ui.CDebugImageDescriptorRegistry;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.CDebugUIMessages;
import org.eclipse.cdt.debug.internal.ui.CValueDetailProvider;
import org.eclipse.cdt.debug.internal.ui.OverlayImageCache;
import org.eclipse.cdt.debug.internal.ui.OverlayImageDescriptor;
import org.eclipse.cdt.debug.internal.ui.editors.CDebugEditor;
import org.eclipse.cdt.debug.internal.ui.editors.EditorInputDelegate;
import org.eclipse.cdt.debug.internal.ui.editors.FileNotFoundElement;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IRegister;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class CDTDebugModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    public static final String DISPLAY_FULL_PATHS = "DISPLAY_FULL_PATHS";
    private static final String DUMMY_STACKFRAME_LABEL = "...";
    protected HashMap fAttributes = new HashMap(3);
    protected CDebugImageDescriptorRegistry fDebugImageRegistry = CDebugUIPlugin.getImageDescriptorRegistry();
    private static CDTDebugModelPresentation fInstance = null;
    private OverlayImageCache fImageCache = new OverlayImageCache();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public CDTDebugModelPresentation() {
        fInstance = this;
    }

    public static CDTDebugModelPresentation getDefault() {
        return fInstance;
    }

    public void setAttribute(String attribute, Object value) {
        if (value != null) {
            this.fAttributes.put(attribute, value);
        }
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        CValueDetailProvider.getDefault().computeDetail(value, listener);
    }

    public IEditorInput getEditorInput(Object element) {
        IResource resource;
        if (element instanceof IMarker && (resource = ((IMarker)element).getResource()) instanceof IFile) {
            return new FileEditorInput((IFile)resource);
        }
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof ICLineBreakpoint) {
            IFile file;
            IResource iResource = ((ICLineBreakpoint)element).getMarker().getResource();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((file = (IFile)iResource.getAdapter((Class)clazz)) != null) {
                return new FileEditorInput(file);
            }
        }
        if (element instanceof FileStorage) {
            return new ExternalEditorInput((IStorage)element);
        }
        if (element instanceof FileNotFoundElement) {
            return new EditorInputDelegate((FileNotFoundElement)element);
        }
        return null;
    }

    public String getEditorId(IEditorInput input, Object element) {
        if (input instanceof EditorInputDelegate) {
            if (((EditorInputDelegate)input).getDelegate() == null) {
                return CDebugEditor.EDITOR_ID;
            }
            return this.getEditorId(((EditorInputDelegate)input).getDelegate(), element);
        }
        String id = null;
        if (input != null) {
            IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
            IEditorDescriptor descriptor = registry.getDefaultEditor(input.getName());
            String string = id = descriptor != null ? descriptor.getId() : "org.eclipse.cdt.ui.editor.CEditor";
        }
        if ("org.eclipse.cdt.ui.editor.CEditor".equals(id)) {
            return CDebugEditor.EDITOR_ID;
        }
        return id;
    }

    public Image getImage(Object element) {
        Image baseImage = this.getBaseImage(element);
        if (baseImage != null) {
            ImageDescriptor[] overlays = new ImageDescriptor[4];
            if (element instanceof ICDebugElementStatus && !((ICDebugElementStatus)element).isOK()) {
                switch (((ICDebugElementStatus)element).getSeverity()) {
                    case 1: {
                        overlays[2] = CDebugImages.DESC_OVRS_WARNING;
                        break;
                    }
                    case 2: {
                        overlays[2] = CDebugImages.DESC_OVRS_ERROR;
                    }
                }
            }
            if (element instanceof IWatchExpression && ((IWatchExpression)element).hasErrors()) {
                overlays[2] = CDebugImages.DESC_OVRS_ERROR;
            }
            if (element instanceof ICVariable && ((ICVariable)element).isArgument()) {
                overlays[1] = CDebugImages.DESC_OVRS_ARGUMENT;
            }
            if (element instanceof ICGlobalVariable && !(element instanceof IRegister)) {
                overlays[1] = CDebugImages.DESC_OVRS_GLOBAL;
            }
            return this.fImageCache.getImageFor(new OverlayImageDescriptor(baseImage, overlays));
        }
        return null;
    }

    private Image getBaseImage(Object element) {
        if (element instanceof ICDebugTarget) {
            ICDebugTarget target = (ICDebugTarget)element;
            if (target.isPostMortem()) {
                return this.fDebugImageRegistry.get(DebugUITools.getImageDescriptor((String)"IMG_OBJS_DEBUG_TARGET_TERMINATED"));
            }
            if (target.isTerminated() || target.isDisconnected()) {
                return this.fDebugImageRegistry.get(DebugUITools.getImageDescriptor((String)"IMG_OBJS_DEBUG_TARGET_TERMINATED"));
            }
            return this.fDebugImageRegistry.get(DebugUITools.getImageDescriptor((String)"IMG_OBJS_DEBUG_TARGET"));
        }
        if (element instanceof ICThread) {
            ICThread thread = (ICThread)element;
            ICDebugTarget target = (ICDebugTarget)thread.getDebugTarget();
            if (target.isPostMortem()) {
                return this.fDebugImageRegistry.get(DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_TERMINATED"));
            }
            if (thread.isSuspended()) {
                return this.fDebugImageRegistry.get(DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_SUSPENDED"));
            }
            if (thread.isTerminated()) {
                return this.fDebugImageRegistry.get(DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_TERMINATED"));
            }
            return this.fDebugImageRegistry.get(DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_RUNNING"));
        }
        try {
            IBreakpoint bp;
            if (element instanceof IMarker && (bp = this.getBreakpoint((IMarker)element)) != null && bp instanceof ICBreakpoint) {
                return this.getBreakpointImage((ICBreakpoint)bp);
            }
            if (element instanceof ICBreakpoint) {
                return this.getBreakpointImage((ICBreakpoint)element);
            }
            if (element instanceof IRegisterGroup) {
                return this.getRegisterGroupImage((IRegisterGroup)element);
            }
            if (element instanceof IExpression) {
                return this.getExpressionImage((IExpression)element);
            }
            if (element instanceof IRegister) {
                return this.getRegisterImage((IRegister)element);
            }
            if (element instanceof IVariable) {
                return this.getVariableImage((IVariable)element);
            }
            if (element instanceof ICSharedLibrary) {
                return this.getSharedLibraryImage((ICSharedLibrary)element);
            }
        }
        catch (CoreException coreException) {}
        return super.getImage(element);
    }

    public String getText(Object element) {
        StringBuffer baseText = new StringBuffer(this.getBaseText(element));
        if (element instanceof ICDebugElementStatus && !((ICDebugElementStatus)element).isOK()) {
            baseText.append(CDTDebugModelPresentation.getFormattedString(" <{0}>", ((ICDebugElementStatus)element).getMessage()));
        }
        if (element instanceof IAdaptable) {
            IEnableDisableTarget target;
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.debug.core.model.IEnableDisableTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((target = (IEnableDisableTarget)iAdaptable.getAdapter((Class)clazz)) != null && !target.isEnabled()) {
                baseText.append(' ');
                baseText.append(CDebugUIMessages.getString("CDTDebugModelPresentation.25"));
            }
        }
        return baseText.toString();
    }

    private String getBaseText(Object element) {
        boolean showQualified = this.isShowQualifiedNames();
        StringBuffer label = new StringBuffer();
        try {
            if (element instanceof ICSharedLibrary) {
                label.append(this.getSharedLibraryText((ICSharedLibrary)element, showQualified));
                return label.toString();
            }
            if (element instanceof ICSignal) {
                label.append(this.getSignalText((ICSignal)element));
                return label.toString();
            }
            if (element instanceof IRegisterGroup) {
                label.append(((IRegisterGroup)element).getName());
                return label.toString();
            }
            if (element instanceof IWatchExpression) {
                return this.getWatchExpressionText((IWatchExpression)element);
            }
            if (element instanceof IVariable) {
                label.append(this.getVariableText((IVariable)element));
                return label.toString();
            }
            if (element instanceof IValue) {
                label.append(this.getValueText((IValue)element));
                return label.toString();
            }
            if (element instanceof IStackFrame) {
                label.append(this.getStackFrameText((IStackFrame)element, showQualified));
                return label.toString();
            }
            if (element instanceof IMarker) {
                IBreakpoint breakpoint = this.getBreakpoint((IMarker)element);
                if (breakpoint != null) {
                    return this.getBreakpointText(breakpoint, showQualified);
                }
                return null;
            }
            if (element instanceof IBreakpoint) {
                return this.getBreakpointText((IBreakpoint)element, showQualified);
            }
            if (element instanceof IDebugTarget) {
                label.append(this.getTargetText((IDebugTarget)element, showQualified));
            } else if (element instanceof IThread) {
                label.append(this.getThreadText((IThread)element, showQualified));
            }
            if (element instanceof ITerminate && ((ITerminate)element).isTerminated()) {
                label.insert(0, CDebugUIMessages.getString("CDTDebugModelPresentation.0"));
                return label.toString();
            }
            if (element instanceof IDisconnect && ((IDisconnect)element).isDisconnected()) {
                label.insert(0, CDebugUIMessages.getString("CDTDebugModelPresentation.1"));
                return label.toString();
            }
            if (label.length() > 0) {
                return label.toString();
            }
        }
        catch (DebugException e) {
            return MessageFormat.format(CDebugUIMessages.getString("CDTDebugModelPresentation.2"), e.getMessage());
        }
        catch (CoreException e) {
            CDebugUIPlugin.log(e);
        }
        return this.getDefaultText(element);
    }

    protected boolean isShowQualifiedNames() {
        Boolean showQualified = (Boolean)this.fAttributes.get(DISPLAY_FULL_PATHS);
        showQualified = showQualified == null ? Boolean.FALSE : showQualified;
        return showQualified;
    }

    protected boolean isShowVariableTypeNames() {
        Boolean show = (Boolean)this.fAttributes.get(IDebugModelPresentation.DISPLAY_VARIABLE_TYPE_NAMES);
        show = show == null ? Boolean.FALSE : show;
        return show;
    }

    protected String getTargetText(IDebugTarget target, boolean qualified) throws DebugException {
        ICDebugTarget t;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.cdt.debug.core.model.ICDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((t = (ICDebugTarget)target.getAdapter((Class)clazz)) != null && !t.isPostMortem()) {
            CDebugElementState state = t.getState();
            if (state.equals(CDebugElementState.EXITED)) {
                Object info = t.getCurrentStateInfo();
                String label = CDebugUIMessages.getString("CDTDebugModelPresentation.3");
                String reason = "";
                if (info != null && info instanceof ICDISignalExitInfo) {
                    ICDISignalExitInfo sigInfo = (ICDISignalExitInfo)info;
                    reason = String.valueOf(' ') + MessageFormat.format(CDebugUIMessages.getString("CDTDebugModelPresentation.5"), sigInfo.getName(), sigInfo.getDescription());
                } else if (info != null && info instanceof ICDIExitInfo) {
                    reason = String.valueOf(' ') + MessageFormat.format(CDebugUIMessages.getString("CDTDebugModelPresentation.6"), new Integer(((ICDIExitInfo)info).getCode()));
                }
                return MessageFormat.format(label, target.getName(), reason);
            }
            if (state.equals(CDebugElementState.SUSPENDED)) {
                return MessageFormat.format(CDebugUIMessages.getString("CDTDebugModelPresentation.7"), target.getName());
            }
        }
        return target.getName();
    }

    protected String getThreadText(IThread thread, boolean qualified) throws DebugException {
        ICDebugTarget target;
        IDebugTarget iDebugTarget = thread.getDebugTarget();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.cdt.debug.core.model.ICDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((target = (ICDebugTarget)iDebugTarget.getAdapter((Class)clazz)).isPostMortem()) {
            return CDTDebugModelPresentation.getFormattedString(CDebugUIMessages.getString("CDTDebugModelPresentation.8"), thread.getName());
        }
        if (thread.isTerminated()) {
            return CDTDebugModelPresentation.getFormattedString(CDebugUIMessages.getString("CDTDebugModelPresentation.9"), thread.getName());
        }
        if (thread.isStepping()) {
            return CDTDebugModelPresentation.getFormattedString(CDebugUIMessages.getString("CDTDebugModelPresentation.10"), thread.getName());
        }
        if (!thread.isSuspended()) {
            return CDTDebugModelPresentation.getFormattedString(CDebugUIMessages.getString("CDTDebugModelPresentation.11"), thread.getName());
        }
        if (thread.isSuspended()) {
            ICDebugElement element;
            String reason = "";
            Class<?> clazz2 = class$3;
            if (clazz2 == null) {
                try {
                    clazz2 = class$3 = Class.forName("org.eclipse.cdt.debug.core.model.ICDebugElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((element = (ICDebugElement)thread.getAdapter((Class)clazz2)) != null) {
                Object info = element.getCurrentStateInfo();
                if (info != null && info instanceof ICDISignalReceived) {
                    ICDISignal signal = ((ICDISignalReceived)info).getSignal();
                    reason = MessageFormat.format(CDebugUIMessages.getString("CDTDebugModelPresentation.13"), signal.getName(), signal.getDescription());
                } else if (info != null && info instanceof ICDIWatchpointTrigger) {
                    reason = MessageFormat.format(CDebugUIMessages.getString("CDTDebugModelPresentation.14"), ((ICDIWatchpointTrigger)info).getOldValue(), ((ICDIWatchpointTrigger)info).getNewValue());
                } else if (info != null && info instanceof ICDIWatchpointScope) {
                    reason = CDebugUIMessages.getString("CDTDebugModelPresentation.15");
                } else if (info != null && info instanceof ICDIBreakpointHit) {
                    reason = CDebugUIMessages.getString("CDTDebugModelPresentation.16");
                } else if (info != null && info instanceof ICDISharedLibraryEvent) {
                    reason = CDebugUIMessages.getString("CDTDebugModelPresentation.17");
                }
            }
            return MessageFormat.format(CDebugUIMessages.getString("CDTDebugModelPresentation.18"), thread.getName(), reason);
        }
        return MessageFormat.format(CDebugUIMessages.getString("CDTDebugModelPresentation.19"), thread.getName());
    }

    protected String getStackFrameText(IStackFrame f, boolean qualified) throws DebugException {
        if (f instanceof ICStackFrame) {
            ICStackFrame frame = (ICStackFrame)f;
            StringBuffer label = new StringBuffer();
            label.append(frame.getLevel());
            label.append(' ');
            String function = frame.getFunction();
            if (function != null && (function = function.trim()).length() > 0) {
                Path path;
                label.append(function);
                label.append("() ");
                if (frame.getFile() != null && !(path = new Path(frame.getFile())).isEmpty()) {
                    label.append(CDebugUIMessages.getString("CDTDebugModelPresentation.20"));
                    label.append(' ');
                    label.append(qualified ? path.toOSString() : path.lastSegment());
                    label.append(':');
                    if (frame.getFrameLineNumber() != 0) {
                        label.append(frame.getFrameLineNumber());
                    }
                }
            }
            if (this.isEmpty(function)) {
                label.append(CDebugUIMessages.getString("CDTDebugModelPresentation.21"));
            }
            return label.toString();
        }
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.cdt.debug.core.model.IDummyStackFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return f.getAdapter((Class)clazz) != null ? this.getDummyStackFrameLabel(f) : f.getName();
    }

    private String getDummyStackFrameLabel(IStackFrame stackFrame) {
        return DUMMY_STACKFRAME_LABEL;
    }

    protected String getWatchExpressionText(IWatchExpression expression) {
        StringBuffer result = new StringBuffer();
        result.append('\"').append(expression.getExpressionText()).append('\"');
        if (expression.isPending()) {
            result.append(" = ").append(DUMMY_STACKFRAME_LABEL);
        } else {
            IValue value = expression.getValue();
            if (value instanceof ICValue) {
                String valueString;
                String typeName;
                ICType type = null;
                try {
                    type = ((ICValue)value).getType();
                }
                catch (DebugException debugException) {}
                if (type != null && this.isShowVariableTypeNames() && !this.isEmpty(typeName = this.getVariableTypeName(type))) {
                    result.insert(0, String.valueOf(typeName) + ' ');
                }
                if (expression.isEnabled() && (valueString = this.getValueText(value)).length() > 0) {
                    result.append(" = ").append(valueString);
                }
            }
        }
        if (!expression.isEnabled()) {
            result.append(' ');
            result.append(CDebugUIMessages.getString("CDTDebugModelPresentation.22"));
        }
        return result.toString();
    }

    protected String getVariableText(IVariable var) throws DebugException {
        StringBuffer label = new StringBuffer();
        if (var instanceof ICVariable) {
            String valueString;
            IValue value;
            String name;
            String typeName;
            ICType type = null;
            try {
                type = ((ICVariable)var).getType();
            }
            catch (DebugException debugException) {}
            if (type != null && this.isShowVariableTypeNames() && (typeName = this.getVariableTypeName(type)) != null && typeName.length() > 0) {
                label.append(typeName).append(' ');
            }
            if ((name = var.getName()) != null) {
                label.append(name.trim());
            }
            if ((value = var.getValue()) != null && !this.isEmpty(valueString = this.getValueText(value))) {
                label.append(" = ");
                label.append(valueString);
            }
        }
        return label.toString();
    }

    protected String getValueText(IValue value) {
        StringBuffer label = new StringBuffer();
        if (value instanceof ICDebugElementStatus && !((ICDebugElementStatus)value).isOK()) {
            label.append(CDTDebugModelPresentation.getFormattedString(CDebugUIMessages.getString("CDTDebugModelPresentation.4"), ((ICDebugElementStatus)value).getMessage()));
        } else if (value instanceof ICValue) {
            ICType type = null;
            try {
                type = ((ICValue)value).getType();
            }
            catch (DebugException debugException) {}
            try {
                String valueString = value.getValueString();
                if (valueString != null) {
                    valueString = valueString.trim();
                    if (type != null && type.isCharacter()) {
                        if (valueString.length() == 0) {
                            valueString = ".";
                        }
                        label.append(valueString);
                    } else if (type != null && type.isFloatingPointType()) {
                        Number floatingPointValue = CDebugUtils.getFloatingPointValue((ICValue)((ICValue)value));
                        if (CDebugUtils.isNaN((Number)floatingPointValue)) {
                            valueString = "NAN";
                        }
                        if (CDebugUtils.isPositiveInfinity((Number)floatingPointValue)) {
                            valueString = CDebugUIMessages.getString("CDTDebugModelPresentation.23");
                        }
                        if (CDebugUtils.isNegativeInfinity((Number)floatingPointValue)) {
                            valueString = CDebugUIMessages.getString("CDTDebugModelPresentation.24");
                        }
                        label.append(valueString);
                    } else if ((type == null || !type.isArray() && !type.isStructure()) && valueString.length() > 0) {
                        label.append(valueString);
                    }
                }
            }
            catch (DebugException debugException) {}
        }
        return label.toString();
    }

    protected String getSharedLibraryText(ICSharedLibrary library, boolean qualified) {
        String label = new String();
        Path path = new Path(library.getFileName());
        if (!path.isEmpty()) {
            label = String.valueOf(label) + (qualified ? path.toOSString() : path.lastSegment());
        }
        return label;
    }

    protected String getSignalText(ICSignal signal) {
        StringBuffer sb = new StringBuffer(CDebugUIMessages.getString("CDTDebugModelPresentation.12"));
        try {
            String name = signal.getName();
            sb.append(" '").append(name).append('\'');
        }
        catch (DebugException debugException) {}
        return sb.toString();
    }

    public static String getFormattedString(String key, String arg) {
        return CDTDebugModelPresentation.getFormattedString(key, new String[]{arg});
    }

    public static String getFormattedString(String string, String[] args) {
        return MessageFormat.format(string, args);
    }

    protected Image getBreakpointImage(ICBreakpoint breakpoint) throws CoreException {
        if (breakpoint instanceof ICLineBreakpoint) {
            return this.getLineBreakpointImage((ICLineBreakpoint)breakpoint);
        }
        if (breakpoint instanceof ICWatchpoint) {
            return this.getWatchpointImage((ICWatchpoint)breakpoint);
        }
        return null;
    }

    protected Image getLineBreakpointImage(ICLineBreakpoint breakpoint) throws CoreException {
        ImageDescriptor descriptor = null;
        descriptor = breakpoint.isEnabled() ? CDebugImages.DESC_OBJS_BREAKPOINT_ENABLED : CDebugImages.DESC_OBJS_BREAKPOINT_DISABLED;
        return this.fImageCache.getImageFor(new OverlayImageDescriptor(this.fDebugImageRegistry.get(descriptor), this.computeBreakpointOverlays((ICBreakpoint)breakpoint)));
    }

    protected Image getWatchpointImage(ICWatchpoint watchpoint) throws CoreException {
        ImageDescriptor descriptor = null;
        descriptor = watchpoint.isEnabled() ? (watchpoint.isReadType() && !watchpoint.isWriteType() ? CDebugImages.DESC_OBJS_READ_WATCHPOINT_ENABLED : (!watchpoint.isReadType() && watchpoint.isWriteType() ? CDebugImages.DESC_OBJS_WRITE_WATCHPOINT_ENABLED : CDebugImages.DESC_OBJS_WATCHPOINT_ENABLED)) : (watchpoint.isReadType() && !watchpoint.isWriteType() ? CDebugImages.DESC_OBJS_READ_WATCHPOINT_DISABLED : (!watchpoint.isReadType() && watchpoint.isWriteType() ? CDebugImages.DESC_OBJS_WRITE_WATCHPOINT_DISABLED : CDebugImages.DESC_OBJS_WATCHPOINT_DISABLED));
        return this.fImageCache.getImageFor(new OverlayImageDescriptor(this.fDebugImageRegistry.get(descriptor), this.computeBreakpointOverlays((ICBreakpoint)watchpoint)));
    }

    protected IBreakpoint getBreakpoint(IMarker marker) {
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker);
    }

    protected String getBreakpointText(IBreakpoint breakpoint, boolean qualified) throws CoreException {
        if (breakpoint instanceof ICAddressBreakpoint) {
            return this.getAddressBreakpointText((ICAddressBreakpoint)breakpoint, qualified);
        }
        if (breakpoint instanceof ICFunctionBreakpoint) {
            return this.getFunctionBreakpointText((ICFunctionBreakpoint)breakpoint, qualified);
        }
        if (breakpoint instanceof ICLineBreakpoint) {
            return this.getLineBreakpointText((ICLineBreakpoint)breakpoint, qualified);
        }
        if (breakpoint instanceof ICWatchpoint) {
            return this.getWatchpointText((ICWatchpoint)breakpoint, qualified);
        }
        return "";
    }

    protected String getLineBreakpointText(ICLineBreakpoint breakpoint, boolean qualified) throws CoreException {
        StringBuffer label = new StringBuffer();
        this.appendSourceName((ICBreakpoint)breakpoint, label, qualified);
        this.appendLineNumber(breakpoint, label);
        this.appendIgnoreCount((ICBreakpoint)breakpoint, label);
        this.appendCondition((ICBreakpoint)breakpoint, label);
        return label.toString();
    }

    protected String getWatchpointText(ICWatchpoint watchpoint, boolean qualified) throws CoreException {
        StringBuffer label = new StringBuffer();
        this.appendSourceName((ICBreakpoint)watchpoint, label, qualified);
        this.appendWatchExpression(watchpoint, label);
        this.appendIgnoreCount((ICBreakpoint)watchpoint, label);
        this.appendCondition((ICBreakpoint)watchpoint, label);
        return label.toString();
    }

    protected String getAddressBreakpointText(ICAddressBreakpoint breakpoint, boolean qualified) throws CoreException {
        StringBuffer label = new StringBuffer();
        this.appendSourceName((ICBreakpoint)breakpoint, label, qualified);
        this.appendAddress(breakpoint, label);
        this.appendIgnoreCount((ICBreakpoint)breakpoint, label);
        this.appendCondition((ICBreakpoint)breakpoint, label);
        return label.toString();
    }

    protected String getFunctionBreakpointText(ICFunctionBreakpoint breakpoint, boolean qualified) throws CoreException {
        StringBuffer label = new StringBuffer();
        this.appendSourceName((ICBreakpoint)breakpoint, label, qualified);
        this.appendFunction(breakpoint, label);
        this.appendIgnoreCount((ICBreakpoint)breakpoint, label);
        this.appendCondition((ICBreakpoint)breakpoint, label);
        return label.toString();
    }

    protected StringBuffer appendSourceName(ICBreakpoint breakpoint, StringBuffer label, boolean qualified) throws CoreException {
        Path path;
        String handle = breakpoint.getSourceHandle();
        if (!this.isEmpty(handle) && (path = new Path(handle)).isValidPath(handle)) {
            label.append(qualified ? path.toOSString() : path.lastSegment());
        }
        return label;
    }

    protected StringBuffer appendLineNumber(ICLineBreakpoint breakpoint, StringBuffer label) throws CoreException {
        int lineNumber = breakpoint.getLineNumber();
        if (lineNumber > 0) {
            label.append(' ');
            label.append(MessageFormat.format(CDebugUIMessages.getString("CDTDebugModelPresentation.26"), Integer.toString(lineNumber)));
        }
        return label;
    }

    protected StringBuffer appendAddress(ICAddressBreakpoint breakpoint, StringBuffer label) throws CoreException {
        try {
            label.append(' ');
            label.append(MessageFormat.format(CDebugUIMessages.getString("CDTDebugModelPresentation.27"), breakpoint.getAddress()));
        }
        catch (NumberFormatException numberFormatException) {}
        return label;
    }

    protected StringBuffer appendFunction(ICFunctionBreakpoint breakpoint, StringBuffer label) throws CoreException {
        String function = breakpoint.getFunction();
        if (function != null && function.trim().length() > 0) {
            label.append(' ');
            label.append(MessageFormat.format(CDebugUIMessages.getString("CDTDebugModelPresentation.28"), function.trim()));
        }
        return label;
    }

    protected StringBuffer appendIgnoreCount(ICBreakpoint breakpoint, StringBuffer label) throws CoreException {
        int ignoreCount = breakpoint.getIgnoreCount();
        if (ignoreCount > 0) {
            label.append(' ');
            label.append(MessageFormat.format(CDebugUIMessages.getString("CDTDebugModelPresentation.29"), Integer.toString(ignoreCount)));
        }
        return label;
    }

    protected void appendCondition(ICBreakpoint breakpoint, StringBuffer buffer) throws CoreException {
        String condition = breakpoint.getCondition();
        if (condition != null && condition.length() > 0) {
            buffer.append(' ');
            buffer.append(CDebugUIMessages.getString("CDTDebugModelPresentation.30"));
            buffer.append(' ');
            buffer.append(condition);
        }
    }

    private void appendWatchExpression(ICWatchpoint watchpoint, StringBuffer label) throws CoreException {
        String expression = watchpoint.getExpression();
        if (expression != null && expression.length() > 0) {
            label.append(' ');
            label.append(CDebugUIMessages.getString("CDTDebugModelPresentation.31"));
            label.append(" '");
            label.append(expression);
            label.append('\'');
        }
    }

    private ImageDescriptor[] computeBreakpointOverlays(ICBreakpoint breakpoint) {
        ImageDescriptor[] overlays = new ImageDescriptor[4];
        try {
            if (breakpoint.isConditional()) {
                ImageDescriptor imageDescriptor = overlays[0] = breakpoint.isEnabled() ? CDebugImages.DESC_OVRS_BREAKPOINT_CONDITIONAL : CDebugImages.DESC_OVRS_BREAKPOINT_CONDITIONAL_DISABLED;
            }
            if (breakpoint.isInstalled()) {
                ImageDescriptor imageDescriptor = overlays[2] = breakpoint.isEnabled() ? CDebugImages.DESC_OVRS_BREAKPOINT_INSTALLED : CDebugImages.DESC_OVRS_BREAKPOINT_INSTALLED_DISABLED;
            }
            if (breakpoint instanceof ICAddressBreakpoint) {
                ImageDescriptor imageDescriptor = overlays[1] = breakpoint.isEnabled() ? CDebugImages.DESC_OVRS_ADDRESS_BREAKPOINT : CDebugImages.DESC_OVRS_ADDRESS_BREAKPOINT_DISABLED;
            }
            if (breakpoint instanceof ICFunctionBreakpoint) {
                overlays[1] = breakpoint.isEnabled() ? CDebugImages.DESC_OVRS_FUNCTION_BREAKPOINT : CDebugImages.DESC_OVRS_FUNCTION_BREAKPOINT_DISABLED;
            }
        }
        catch (CoreException e) {
            CDebugUIPlugin.log(e);
        }
        return overlays;
    }

    protected Image getVariableImage(IVariable element) {
        if (element instanceof ICVariable) {
            ICType type = null;
            try {
                type = ((ICVariable)element).getType();
            }
            catch (DebugException debugException) {}
            if (type != null && (type.isPointer() || type.isReference())) {
                return this.fDebugImageRegistry.get(((ICVariable)element).isEnabled() ? CDebugImages.DESC_OBJS_VARIABLE_POINTER : CDebugImages.DESC_OBJS_VARIABLE_POINTER_DISABLED);
            }
            if (type != null && (type.isArray() || type.isStructure())) {
                return this.fDebugImageRegistry.get(((ICVariable)element).isEnabled() ? CDebugImages.DESC_OBJS_VARIABLE_AGGREGATE : CDebugImages.DESC_OBJS_VARIABLE_AGGREGATE_DISABLED);
            }
            return this.fDebugImageRegistry.get(((ICVariable)element).isEnabled() ? CDebugImages.DESC_OBJS_VARIABLE_SIMPLE : CDebugImages.DESC_OBJS_VARIABLE_SIMPLE_DISABLED);
        }
        return null;
    }

    protected Image getRegisterGroupImage(IRegisterGroup element) {
        IEnableDisableTarget target;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.cdt.debug.core.model.IEnableDisableTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((target = (IEnableDisableTarget)element.getAdapter((Class)clazz)) != null && !target.isEnabled()) {
            return this.fDebugImageRegistry.get(CDebugImages.DESC_OBJS_REGISTER_GROUP_DISABLED);
        }
        return this.fDebugImageRegistry.get(CDebugImages.DESC_OBJS_REGISTER_GROUP);
    }

    protected Image getRegisterImage(IRegister element) {
        return element instanceof ICVariable && ((ICVariable)element).isEnabled() ? this.fDebugImageRegistry.get(CDebugImages.DESC_OBJS_REGISTER) : this.fDebugImageRegistry.get(CDebugImages.DESC_OBJS_REGISTER_DISABLED);
    }

    protected Image getExpressionImage(IExpression element) {
        return this.fDebugImageRegistry.get(DebugUITools.getImageDescriptor((String)"IMG_OBJS_EXPRESSION"));
    }

    protected Image getSharedLibraryImage(ICSharedLibrary element) {
        if (element.areSymbolsLoaded()) {
            ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[4];
            imageDescriptorArray[1] = CDebugImages.DESC_OVRS_SYMBOLS;
            return this.fImageCache.getImageFor(new OverlayImageDescriptor(this.fDebugImageRegistry.get(CDebugImages.DESC_OBJS_LOADED_SHARED_LIBRARY), imageDescriptorArray));
        }
        return CDebugUIPlugin.getImageDescriptorRegistry().get(CDebugImages.DESC_OBJS_SHARED_LIBRARY);
    }

    private String getVariableTypeName(ICType type) {
        int index;
        StringBuffer result = new StringBuffer();
        String typeName = type.getName();
        if (typeName != null) {
            typeName = typeName.trim();
        }
        if (type.isArray() && typeName != null && (index = typeName.indexOf(91)) != -1) {
            typeName = typeName.substring(0, index).trim();
        }
        if (typeName != null && typeName.length() > 0) {
            result.append(typeName);
            if (type.isArray()) {
                int[] dims = type.getArrayDimensions();
                int i = 0;
                while (i < dims.length) {
                    result.append('[');
                    result.append(dims[i]);
                    result.append(']');
                    ++i;
                }
            }
        }
        return result.toString();
    }

    public void dispose() {
        this.fImageCache.disposeAll();
    }

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    protected String getDefaultText(Object element) {
        return DebugUIPlugin.getDefaultLabelProvider().getText(element);
    }

    protected Image getDefaultImage(Object element) {
        return DebugUIPlugin.getDefaultLabelProvider().getImage(element);
    }
}

