/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.Vector;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.EventManager;
import org.eclipse.cdt.debug.mi.core.cdi.Manager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.event.MIInferiorCreatedEvent;

public class ProcessManager
extends Manager {
    static final Target[] EMPTY_TARGETS = new Target[0];
    Vector debugTargetList = new Vector(1);

    public ProcessManager(Session session) {
        super(session, true);
    }

    public Target[] getTargets() {
        return this.debugTargetList.toArray(new Target[this.debugTargetList.size()]);
    }

    public ICDITarget[] getCDITargets() {
        return this.debugTargetList.toArray(new ICDITarget[this.debugTargetList.size()]);
    }

    public void addTargets(Target[] targets) {
        EventManager eventManager = (EventManager)this.getSession().getEventManager();
        int i = 0;
        while (i < targets.length) {
            Target target = targets[i];
            MISession miSession = target.getMISession();
            if (miSession != null) {
                miSession.addObserver(eventManager);
                miSession.fireEvent(new MIInferiorCreatedEvent(miSession, 0));
                if (!this.debugTargetList.contains(target)) {
                    this.debugTargetList.add(target);
                }
            }
            ++i;
        }
        this.debugTargetList.trimToSize();
    }

    public void removeTargets(Target[] targets) {
        EventManager eventManager = (EventManager)this.getSession().getEventManager();
        int i = 0;
        while (i < targets.length) {
            Target target = targets[i];
            MISession miSession = target.getMISession();
            if (miSession != null) {
                miSession.deleteObserver(eventManager);
            }
            this.debugTargetList.remove(target);
            ++i;
        }
        this.debugTargetList.trimToSize();
    }

    public Target getTarget(MISession miSession) {
        Vector vector = this.debugTargetList;
        synchronized (vector) {
            int i = 0;
            while (i < this.debugTargetList.size()) {
                Target target = (Target)this.debugTargetList.get(i);
                MISession mi = target.getMISession();
                if (mi.equals(miSession)) {
                    return target;
                }
                ++i;
            }
        }
        return null;
    }

    public void update(Target target) throws CDIException {
    }
}

