/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.ListIterator;
import org.eclipse.cdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewConfigurationDialog
extends StatusDialog {
    private static final String PREFIX = "NewConfiguration";
    private static final String LABEL = "NewConfiguration.label";
    private static final String ERROR = "NewConfiguration.error";
    private static final String NAME = "NewConfiguration.label.name";
    private static final String GROUP = "NewConfiguration.label.group";
    private static final String COPY = "NewConfiguration.label.copy";
    private static final String CLONE = "NewConfiguration.label.clone";
    private static final String DUPLICATE = "NewConfiguration.error.duplicateName";
    private static final String CASE = "NewConfiguration.error.caseName";
    private static final String INVALID = "NewConfiguration.error.invalidName";
    private Button btnClone;
    private Button btnCopy;
    private Text configName;
    private Combo copyConfigSelector;
    private Combo cloneConfigSelector;
    private boolean clone;
    private IConfiguration[] defaultConfigs;
    private IConfiguration[] definedConfigs;
    private IConfiguration parentConfig;
    private IManagedProject managedProject;
    private String newName;
    private final ArrayList reservedNames;
    private final String title;

    protected NewConfigurationDialog(Shell parentShell, IManagedProject managedProject, ArrayList nameList, String title) {
        super(parentShell);
        this.title = title;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.newName = new String();
        this.parentConfig = null;
        this.managedProject = managedProject;
        this.reservedNames = nameList;
        this.clone = true;
        this.definedConfigs = managedProject.getConfigurations();
        IProjectType projectType = managedProject.getProjectType();
        this.defaultConfigs = projectType.getConfigurations();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.newName = this.configName.getText().trim();
            String baseConfigName = new String();
            if (this.clone) {
                baseConfigName = this.cloneConfigSelector.getItem(this.cloneConfigSelector.getSelectionIndex());
                int i = 0;
                while (i < this.definedConfigs.length) {
                    IConfiguration config = this.definedConfigs[i];
                    if (config.getName().equals(baseConfigName)) {
                        this.parentConfig = config;
                        break;
                    }
                    ++i;
                }
            } else {
                baseConfigName = this.copyConfigSelector.getItem(this.copyConfigSelector.getSelectionIndex());
                int i = 0;
                while (i < this.defaultConfigs.length) {
                    IConfiguration config = this.defaultConfigs[i];
                    if (config.getName().equals(baseConfigName)) {
                        this.parentConfig = config;
                        break;
                    }
                    ++i;
                }
            }
        } else {
            this.newName = null;
            this.parentConfig = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.configName.setFocus();
        if (this.configName != null) {
            this.configName.setText(this.newName);
        }
        this.validateState();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        Label nameLabel = new Label(composite, 16384);
        nameLabel.setFont(parent.getFont());
        nameLabel.setText(ManagedBuilderUIMessages.getResourceString(NAME));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        nameLabel.setLayoutData((Object)gd);
        this.configName = new Text(composite, 2052);
        this.configName.setFont(composite.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 200;
        this.configName.setLayoutData((Object)gd);
        this.configName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewConfigurationDialog.this.validateState();
            }
        });
        Group group = new Group(composite, 0);
        group.setFont(composite.getFont());
        group.setText(ManagedBuilderUIMessages.getResourceString(GROUP));
        GridLayout layout = new GridLayout(3, false);
        group.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        group.setLayoutData((Object)gd);
        SelectionAdapter radioListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewConfigurationDialog.this.clone = NewConfigurationDialog.this.btnClone.getSelection();
                NewConfigurationDialog.this.updateComboState();
            }
        };
        this.btnCopy = new Button((Composite)group, 16);
        this.btnCopy.setFont(group.getFont());
        this.btnCopy.setText(ManagedBuilderUIMessages.getResourceString(COPY));
        this.setButtonLayoutData(this.btnCopy);
        this.btnCopy.addSelectionListener((SelectionListener)radioListener);
        this.copyConfigSelector = new Combo((Composite)group, 2060);
        this.copyConfigSelector.setFont(group.getFont());
        this.copyConfigSelector.setItems(this.getDefaultConfigNames());
        int index = this.copyConfigSelector.indexOf(this.newName);
        this.copyConfigSelector.select(index < 0 ? 0 : index);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 200;
        this.copyConfigSelector.setLayoutData((Object)gd);
        this.copyConfigSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewConfigurationDialog.this.validateState();
            }
        });
        this.copyConfigSelector.setEnabled(false);
        this.btnClone = new Button((Composite)group, 16);
        this.btnClone.setFont(group.getFont());
        this.btnClone.setText(ManagedBuilderUIMessages.getResourceString(CLONE));
        this.setButtonLayoutData(this.btnClone);
        this.btnClone.addSelectionListener((SelectionListener)radioListener);
        this.btnClone.setSelection(true);
        this.cloneConfigSelector = new Combo((Composite)group, 2060);
        this.cloneConfigSelector.setFont(group.getFont());
        this.cloneConfigSelector.setItems(this.getDefinedConfigNames());
        index = this.cloneConfigSelector.indexOf(this.newName);
        this.cloneConfigSelector.select(index < 0 ? 0 : index);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 200;
        this.cloneConfigSelector.setLayoutData((Object)gd);
        this.cloneConfigSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewConfigurationDialog.this.validateState();
            }
        });
        return composite;
    }

    public IConfiguration getParentConfiguration() {
        return this.parentConfig;
    }

    private String[] getDefaultConfigNames() {
        String[] names = new String[this.defaultConfigs.length];
        int index = 0;
        while (index < this.defaultConfigs.length) {
            IConfiguration config = this.defaultConfigs[index];
            names[index] = config.getName();
            ++index;
        }
        return names;
    }

    private String[] getDefinedConfigNames() {
        String[] names = new String[this.definedConfigs.length];
        int index = 0;
        while (index < this.definedConfigs.length) {
            IConfiguration config = this.definedConfigs[index];
            names[index] = config.getName();
            ++index;
        }
        return names;
    }

    public String getNewName() {
        return this.newName;
    }

    protected boolean isDuplicateName(String newName) {
        int index = 0;
        while (index < this.definedConfigs.length) {
            IConfiguration configuration = this.definedConfigs[index];
            if (configuration.getName().equals(newName)) {
                return true;
            }
            ++index;
        }
        return this.reservedNames.contains(newName);
    }

    protected boolean isSimilarName(String newName) {
        int index = 0;
        while (index < this.definedConfigs.length) {
            IConfiguration configuration = this.definedConfigs[index];
            if (configuration.getName().equalsIgnoreCase(newName)) {
                return true;
            }
            ++index;
        }
        ListIterator iter = this.reservedNames.listIterator();
        while (iter.hasNext()) {
            if (!((String)iter.next()).equalsIgnoreCase(newName)) continue;
            return true;
        }
        return false;
    }

    protected void updateComboState() {
        this.cloneConfigSelector.setEnabled(this.clone);
        this.copyConfigSelector.setEnabled(!this.clone);
    }

    private boolean validateName(String name) {
        char[] chars = name.toCharArray();
        if (Character.isWhitespace(chars[0])) {
            return false;
        }
        int index = 0;
        while (index < chars.length) {
            if (!Character.isLetterOrDigit(chars[index])) {
                switch (chars[index]) {
                    case '\"': 
                    case '*': 
                    case '/': 
                    case ':': 
                    case '<': 
                    case '>': 
                    case '?': 
                    case '\\': {
                        return false;
                    }
                }
            }
            ++index;
        }
        return true;
    }

    private void validateState() {
        StatusInfo status = new StatusInfo();
        String currentName = this.configName.getText();
        int nameLength = currentName.length();
        if (nameLength == 0) {
            status.setError("");
        } else if (this.isDuplicateName(currentName)) {
            status.setError(ManagedBuilderUIMessages.getFormattedString(DUPLICATE, currentName));
        } else if (this.isSimilarName(currentName)) {
            status.setError(ManagedBuilderUIMessages.getFormattedString(CASE, currentName));
        } else if (!this.validateName(currentName)) {
            status.setError(ManagedBuilderUIMessages.getFormattedString(INVALID, currentName));
        }
        this.updateStatus((IStatus)status);
    }
}

