/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public abstract class CModelOperation
implements IWorkspaceRunnable,
IProgressMonitor {
    protected ICElement[] fElementsToProcess;
    protected ICElement[] fParentElements;
    protected static ICElement[] fgEmptyResult = new ICElement[0];
    protected ICElementDelta[] fDeltas = null;
    protected ICElement[] fResultElements = fgEmptyResult;
    protected IProgressMonitor fMonitor = null;
    protected boolean fNested = false;
    protected boolean fForce = false;
    protected boolean hasModifiedResource = false;

    protected CModelOperation() {
    }

    protected CModelOperation(ICElement[] elements) {
        this.fElementsToProcess = elements;
    }

    protected CModelOperation(ICElement[] elementsToProcess, ICElement[] parentElements) {
        this.fElementsToProcess = elementsToProcess;
        this.fParentElements = parentElements;
    }

    protected CModelOperation(ICElement[] elementsToProcess, ICElement[] parentElements, boolean force) {
        this.fElementsToProcess = elementsToProcess;
        this.fParentElements = parentElements;
        this.fForce = force;
    }

    protected CModelOperation(ICElement[] elements, boolean force) {
        this.fElementsToProcess = elements;
        this.fForce = force;
    }

    protected CModelOperation(ICElement element) {
        this.fElementsToProcess = new ICElement[]{element};
    }

    protected CModelOperation(ICElement element, boolean force) {
        this.fElementsToProcess = new ICElement[]{element};
        this.fForce = force;
    }

    protected void addDelta(ICElementDelta delta) {
        if (this.fDeltas == null) {
            this.fDeltas = new ICElementDelta[]{delta};
        } else {
            ICElementDelta[] copy = new ICElementDelta[this.fDeltas.length + 1];
            System.arraycopy(this.fDeltas, 0, copy, 0, this.fDeltas.length);
            copy[this.fDeltas.length] = delta;
            this.fDeltas = copy;
        }
    }

    protected void addReconcileDelta(IWorkingCopy workingCopy, ICElementDelta delta) {
        HashMap reconcileDeltas = CModelManager.getDefault().reconcileDeltas;
        CElementDelta previousDelta = (CElementDelta)reconcileDeltas.get(workingCopy);
        if (previousDelta != null) {
            ICElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            int length = children.length;
            while (i < length) {
                CElementDelta child = (CElementDelta)children[i];
                previousDelta.insertDeltaTree(child.getElement(), child);
                ++i;
            }
        } else {
            reconcileDeltas.put(workingCopy, delta);
        }
    }

    protected void removeReconcileDelta(IWorkingCopy workingCopy) {
        CModelManager.getDefault().reconcileDeltas.remove(workingCopy);
    }

    public void beginTask(String name, int totalWork) {
        if (this.fMonitor != null) {
            this.fMonitor.beginTask(name, totalWork);
        }
    }

    protected void checkCanceled() {
        if (this.isCanceled()) {
            throw new OperationCanceledException("operation.cancelled");
        }
    }

    protected ICModelStatus commonVerify() {
        if (this.fElementsToProcess == null || this.fElementsToProcess.length == 0) {
            return new CModelStatus(968);
        }
        int i = 0;
        while (i < this.fElementsToProcess.length) {
            if (this.fElementsToProcess[i] == null) {
                return new CModelStatus(968);
            }
            ++i;
        }
        return CModelStatus.VERIFIED_OK;
    }

    protected void copyResources(IResource[] resources, IPath destinationPath) throws CModelException {
        IProgressMonitor subProgressMonitor = this.getSubProgressMonitor(resources.length);
        IWorkspace workspace = resources[0].getWorkspace();
        try {
            workspace.copy(resources, destinationPath, false, subProgressMonitor);
            this.hasModifiedResource = true;
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
    }

    protected void createFile(IContainer folder, String name, InputStream contents, boolean force) throws CModelException {
        IFile file = folder.getFile((IPath)new Path(name));
        try {
            file.create(contents, force, this.getSubProgressMonitor(1));
            this.hasModifiedResource = true;
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
    }

    protected void createFolder(IContainer parentFolder, String name, boolean force) throws CModelException {
        IFolder folder = parentFolder.getFolder((IPath)new Path(name));
        try {
            folder.create(force, true, this.getSubProgressMonitor(1));
            this.hasModifiedResource = true;
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
    }

    protected void deleteResource(IResource resource, boolean force) throws CModelException {
        try {
            resource.delete(force, this.getSubProgressMonitor(1));
            this.hasModifiedResource = true;
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
    }

    protected void deleteResources(IResource[] resources, boolean force) throws CModelException {
        if (resources == null || resources.length == 0) {
            return;
        }
        IProgressMonitor subProgressMonitor = this.getSubProgressMonitor(resources.length);
        IWorkspace workspace = resources[0].getWorkspace();
        try {
            workspace.delete(resources, force, subProgressMonitor);
            this.hasModifiedResource = true;
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
    }

    public void done() {
        if (this.fMonitor != null) {
            this.fMonitor.done();
        }
    }

    protected void execute() throws CModelException {
        ICModelStatus status = this.verify();
        if (!status.isOK()) {
            throw new CModelException(status);
        }
        this.executeOperation();
    }

    public void executeNestedOperation(CModelOperation operation, int subWorkAmount) throws CModelException {
        IProgressMonitor subProgressMonitor = this.getSubProgressMonitor(subWorkAmount);
        try {
            operation.setNested(true);
            operation.run(subProgressMonitor);
            if (operation.hasModifiedResource()) {
                this.hasModifiedResource = true;
            }
            if (operation.fDeltas != null) {
                int i = 0;
                while (i < operation.fDeltas.length) {
                    this.addDelta(operation.fDeltas[i]);
                    ++i;
                }
            }
        }
        catch (CoreException ce) {
            Throwable e;
            if (ce instanceof CModelException) {
                throw (CModelException)ce;
            }
            if (ce.getStatus().getCode() == 76 && (e = ce.getStatus().getException()) instanceof CModelException) {
                throw (CModelException)((Object)e);
            }
            throw new CModelException(ce);
        }
    }

    protected abstract void executeOperation() throws CModelException;

    protected ICElement[] getElementsToProcess() {
        return this.fElementsToProcess;
    }

    protected ICElement getElementToProcess() {
        if (this.fElementsToProcess == null || this.fElementsToProcess.length == 0) {
            return null;
        }
        return this.fElementsToProcess[0];
    }

    public ICModel getCModel() {
        if (this.fElementsToProcess == null || this.fElementsToProcess.length == 0) {
            return this.getParentElement().getCModel();
        }
        return this.fElementsToProcess[0].getCModel();
    }

    protected ICElement getParentElement() {
        if (this.fParentElements == null || this.fParentElements.length == 0) {
            return null;
        }
        return this.fParentElements[0];
    }

    protected ICElement[] getParentElements() {
        return this.fParentElements;
    }

    public ICElement[] getResultElements() {
        return this.fResultElements;
    }

    public ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected IProgressMonitor getSubProgressMonitor(int workAmount) {
        SubProgressMonitor sub = null;
        if (this.fMonitor != null) {
            sub = new SubProgressMonitor(this.fMonitor, workAmount, 4);
        }
        return sub;
    }

    protected IWorkspace getWorkspace() {
        ICProject project;
        if (this.fElementsToProcess != null && this.fElementsToProcess.length > 0 && (project = this.fElementsToProcess[0].getCProject()) != null) {
            return project.getCModel().getWorkspace();
        }
        return null;
    }

    public boolean hasModifiedResource() {
        return !this.isReadOnly() && this.hasModifiedResource;
    }

    public void internalWorked(double work) {
        if (this.fMonitor != null) {
            this.fMonitor.internalWorked(work);
        }
    }

    public boolean isCanceled() {
        if (this.fMonitor != null) {
            return this.fMonitor.isCanceled();
        }
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    protected void moveResources(IResource[] resources, IPath destinationPath) throws CModelException {
        SubProgressMonitor subProgressMonitor = null;
        if (this.fMonitor != null) {
            subProgressMonitor = new SubProgressMonitor(this.fMonitor, resources.length, 4);
        }
        IWorkspace workspace = resources[0].getWorkspace();
        try {
            workspace.move(resources, destinationPath, false, (IProgressMonitor)subProgressMonitor);
            this.hasModifiedResource = true;
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
    }

    public CElementDelta newCElementDelta() {
        return new CElementDelta(this.getCModel());
    }

    protected void registerDeltas() {
        if (this.fDeltas != null && !this.fNested) {
            CModelManager manager = CModelManager.getDefault();
            int i = 0;
            while (i < this.fDeltas.length) {
                manager.registerCModelDelta(this.fDeltas[i]);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws CoreException {
        CModelManager manager = CModelManager.getDefault();
        int previousDeltaCount = manager.fCModelDeltas.size();
        try {
            this.fMonitor = monitor;
            this.execute();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.registerDeltas();
            if (manager.fCModelDeltas.size() <= previousDeltaCount) {
                if (manager.reconcileDeltas.isEmpty()) throw throwable;
            }
            if (this.hasModifiedResource()) throw throwable;
            manager.fire(1);
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.registerDeltas();
            if (manager.fCModelDeltas.size() <= previousDeltaCount) {
                if (manager.reconcileDeltas.isEmpty()) return;
            }
            if (this.hasModifiedResource()) return;
            manager.fire(1);
            return;
        }
    }

    public void setCanceled(boolean b) {
        if (this.fMonitor != null) {
            this.fMonitor.setCanceled(b);
        }
    }

    protected void setNested(boolean nested) {
        this.fNested = nested;
    }

    public void setTaskName(String name) {
        if (this.fMonitor != null) {
            this.fMonitor.setTaskName(name);
        }
    }

    public void subTask(String name) {
        if (this.fMonitor != null) {
            this.fMonitor.subTask(name);
        }
    }

    protected ICModelStatus verify() {
        return this.commonVerify();
    }

    public void worked(int work) {
        if (this.fMonitor != null) {
            this.fMonitor.worked(work);
            this.checkCanceled();
        }
    }
}

