/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.indexing;

import java.io.IOException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.processing.IJob;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public abstract class IndexRequest
implements IJob {
    protected boolean isCancelled = false;
    protected IPath indexPath;
    protected IndexManager manager;

    public IndexRequest(IPath indexPath, IndexManager manager) {
        this.indexPath = indexPath;
        this.manager = manager;
    }

    public boolean belongsTo(String projectName) {
        return projectName.equals(this.indexPath.segment(0));
    }

    public void cancel() {
        this.manager.jobFinishedNotification(this);
        this.manager.jobWasCancelled(this.indexPath);
        this.isCancelled = true;
    }

    public boolean isReadyToRun() {
        IProject project = CCorePlugin.getWorkspace().getRoot().getProject(this.indexPath.segment(0));
        if (!project.isAccessible() || !this.manager.isIndexEnabled(project)) {
            return false;
        }
        this.manager.aboutToUpdateIndex(this.indexPath, this.updatedIndexState());
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void saveIfNecessary(IIndex index, ReadWriteMonitor monitor) throws IOException {
        if (!index.hasChanged()) return;
        try {
            monitor.exitRead();
            monitor.enterWrite();
            this.manager.saveIndex(index);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            monitor.exitWriteEnterRead();
            throw throwable;
        }
        {
            Object var3_5 = null;
            monitor.exitWriteEnterRead();
            return;
        }
    }

    protected Integer updatedIndexState() {
        return IndexManager.UPDATING_STATE;
    }
}

