/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.folding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.cdt.ui.text.folding.ICFoldingStructureProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class DefaultCFoldingStructureProvider
implements IProjectionListener,
ICFoldingStructureProvider {
    private IDocument fCachedDocument;
    private ITextEditor fEditor;
    private ProjectionViewer fViewer;
    protected ICElement fInput;
    private IElementChangedListener fElementListener;
    private boolean fAllowCollapsing = false;
    private boolean fCollapseMacros = false;
    private boolean fCollapseFunctions = true;
    private boolean fCollapseStructures = true;
    private boolean fCollapseMethods = false;
    static /* synthetic */ Class class$0;

    public void install(ITextEditor editor, ProjectionViewer viewer) {
        if (editor instanceof CEditor) {
            this.fEditor = editor;
            this.fViewer = viewer;
            this.fViewer.addProjectionListener((IProjectionListener)this);
        }
    }

    public void uninstall() {
        if (this.isInstalled()) {
            this.projectionDisabled();
            this.fViewer.removeProjectionListener((IProjectionListener)this);
            this.fViewer = null;
            this.fEditor = null;
        }
    }

    protected boolean isInstalled() {
        return this.fEditor != null;
    }

    public void projectionEnabled() {
        this.projectionDisabled();
        if (this.fEditor instanceof CEditor) {
            this.initialize();
            this.fElementListener = new ElementChangedListener();
            CoreModel.getDefault().addElementChangedListener(this.fElementListener);
        }
    }

    public void projectionDisabled() {
        this.fCachedDocument = null;
        if (this.fElementListener != null) {
            CoreModel.getDefault().removeElementChangedListener(this.fElementListener);
            this.fElementListener = null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize() {
        if (!this.isInstalled()) {
            return;
        }
        this.initializePreferences();
        try {
            try {
                IDocumentProvider provider = this.fEditor.getDocumentProvider();
                this.fCachedDocument = provider.getDocument((Object)this.fEditor.getEditorInput());
                this.fAllowCollapsing = true;
                if (this.fEditor instanceof CEditor) {
                    IWorkingCopyManager manager = CUIPlugin.getDefault().getWorkingCopyManager();
                    this.fInput = manager.getWorkingCopy(this.fEditor.getEditorInput());
                }
                if (this.fInput != null) {
                    ProjectionAnnotationModel model;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        Class<?> clazz2;
                        try {
                            clazz2 = Class.forName("org.eclipse.jface.text.source.projection.ProjectionAnnotationModel");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz = class$0 = clazz2;
                    }
                    if ((model = (ProjectionAnnotationModel)this.fEditor.getAdapter((Class)clazz)) != null) {
                        if (this.fInput instanceof IWorkingCopy) {
                            IWorkingCopy unit;
                            IWorkingCopy iWorkingCopy = unit = (IWorkingCopy)this.fInput;
                            synchronized (iWorkingCopy) {
                                try {
                                    unit.reconcile();
                                }
                                catch (CModelException cModelException) {}
                            }
                        }
                        Map additions = this.computeAdditions((IParent)this.fInput);
                        model.removeAllAnnotations();
                        model.replaceAnnotations(null, additions);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.fCachedDocument = null;
            this.fAllowCollapsing = false;
            throw throwable;
        }
        {
            Object var5_8 = null;
            this.fCachedDocument = null;
            this.fAllowCollapsing = false;
            return;
        }
    }

    private void initializePreferences() {
        IPreferenceStore store = CUIPlugin.getDefault().getPreferenceStore();
        this.fCollapseFunctions = store.getBoolean("editor_folding_default_functions");
        this.fCollapseStructures = store.getBoolean("editor_folding_default_structures");
        this.fCollapseMacros = store.getBoolean("editor_folding_default_macros");
        this.fCollapseMethods = store.getBoolean("editor_folding_default_methods");
    }

    private Map computeAdditions(IParent parent) {
        HashMap map = new HashMap();
        try {
            this.computeAdditions(parent.getChildren(), map);
        }
        catch (CModelException cModelException) {}
        return map;
    }

    private void computeAdditions(ICElement[] elements, Map map) throws CModelException {
        int i = 0;
        while (i < elements.length) {
            ICElement element = elements[i];
            this.computeAdditions(element, map);
            if (element instanceof IParent) {
                IParent parent = (IParent)element;
                this.computeAdditions(parent.getChildren(), map);
            }
            ++i;
        }
    }

    private void computeAdditions(ICElement element, Map map) {
        Position position;
        boolean createProjection = false;
        boolean collapse = false;
        switch (element.getElementType()) {
            case 64: 
            case 65: {
                collapse = this.fAllowCollapsing && this.fCollapseStructures;
                createProjection = true;
                break;
            }
            case 77: {
                collapse = this.fAllowCollapsing && this.fCollapseMacros;
                createProjection = true;
                break;
            }
            case 71: {
                collapse = this.fAllowCollapsing && this.fCollapseFunctions;
                createProjection = true;
                break;
            }
            case 67: {
                collapse = this.fAllowCollapsing && this.fCollapseMethods;
                createProjection = true;
            }
        }
        if (createProjection && (position = this.createProjectionPosition(element)) != null) {
            map.put(new CProjectionAnnotation(element, collapse, false), position);
        }
    }

    private Position createProjectionPosition(ICElement element) {
        if (this.fCachedDocument == null) {
            return null;
        }
        try {
            int end;
            ISourceReference reference;
            ISourceRange range;
            int start;
            if (element instanceof ISourceReference && (start = this.fCachedDocument.getLineOfOffset((range = (reference = (ISourceReference)element).getSourceRange()).getStartPos())) < (end = this.fCachedDocument.getLineOfOffset(range.getStartPos() + range.getLength()))) {
                int offset = this.fCachedDocument.getLineOffset(start);
                int endOffset = this.fCachedDocument.getLineOffset(end + 1);
                return new Position(offset, endOffset - offset);
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (CModelException cModelException) {}
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processDelta(ICElementDelta delta) {
        ProjectionAnnotationModel model;
        if (!this.isInstalled()) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.jface.text.source.projection.ProjectionAnnotationModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        if ((model = (ProjectionAnnotationModel)this.fEditor.getAdapter((Class)clazz)) == null) {
            return;
        }
        try {
            IDocumentProvider provider = this.fEditor.getDocumentProvider();
            this.fCachedDocument = provider.getDocument((Object)this.fEditor.getEditorInput());
            this.fAllowCollapsing = false;
            HashMap<CProjectionAnnotation, Position> additions = new HashMap<CProjectionAnnotation, Position>();
            ArrayList deletions = new ArrayList();
            ArrayList<CProjectionAnnotation> updates = new ArrayList<CProjectionAnnotation>();
            Map updated = this.computeAdditions((IParent)this.fInput);
            Map previous = this.createAnnotationMap((IAnnotationModel)model);
            Iterator<Object> e = updated.keySet().iterator();
            while (true) {
                if (!e.hasNext()) break;
                CProjectionAnnotation annotation = (CProjectionAnnotation)((Object)e.next());
                ICElement element = annotation.getElement();
                Position position = (Position)updated.get((Object)annotation);
                List annotations = (List)previous.get(element);
                if (annotations == null) {
                    additions.put(annotation, position);
                    continue;
                }
                Iterator x = annotations.iterator();
                while (x.hasNext()) {
                    CProjectionAnnotation a = (CProjectionAnnotation)((Object)x.next());
                    if (annotation.isComment() != a.isComment()) continue;
                    Position p = model.getPosition((Annotation)a);
                    if (p != null && !position.equals((Object)p)) {
                        p.setOffset(position.getOffset());
                        p.setLength(position.getLength());
                        updates.add(a);
                    }
                    x.remove();
                    break;
                }
                if (!annotations.isEmpty()) continue;
                previous.remove(element);
            }
            e = previous.values().iterator();
            block7: while (true) {
                block14: {
                    if (e.hasNext()) break block14;
                    this.match(model, deletions, additions, updates);
                    Annotation[] removals = new Annotation[deletions.size()];
                    deletions.toArray(removals);
                    Annotation[] changes = new Annotation[updates.size()];
                    updates.toArray(changes);
                    model.modifyAnnotations(removals, additions, changes);
                    break;
                }
                List list = (List)e.next();
                int size = list.size();
                int i = 0;
                while (true) {
                    if (i >= size) continue block7;
                    deletions.add(list.get(i));
                    ++i;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var17_20 = null;
            this.fCachedDocument = null;
            this.fAllowCollapsing = true;
            throw throwable;
        }
        {
            Object var17_21 = null;
            this.fCachedDocument = null;
            this.fAllowCollapsing = true;
            return;
        }
    }

    private void match(ProjectionAnnotationModel model, List deletions, Map additions, List changes) {
        if (deletions.isEmpty() || additions.isEmpty() && changes.isEmpty()) {
            return;
        }
        ArrayList<CProjectionAnnotation> newDeletions = new ArrayList<CProjectionAnnotation>();
        ArrayList<CProjectionAnnotation> newChanges = new ArrayList<CProjectionAnnotation>();
        Iterator deletionIterator = deletions.iterator();
        block0: while (deletionIterator.hasNext()) {
            CProjectionAnnotation deleted = (CProjectionAnnotation)((Object)deletionIterator.next());
            Position deletedPosition = model.getPosition((Annotation)deleted);
            if (deletedPosition == null) continue;
            Iterator changesIterator = changes.iterator();
            while (changesIterator.hasNext()) {
                Position changedPosition;
                CProjectionAnnotation changed = (CProjectionAnnotation)((Object)changesIterator.next());
                if (deleted.isComment() != changed.isComment() || (changedPosition = model.getPosition((Annotation)changed)) == null || deletedPosition.getOffset() != changedPosition.getOffset()) continue;
                deletedPosition.setLength(changedPosition.getLength());
                deleted.setElement(changed.getElement());
                deletionIterator.remove();
                newChanges.add(deleted);
                changesIterator.remove();
                newDeletions.add(changed);
                continue block0;
            }
            Iterator additionsIterator = additions.keySet().iterator();
            while (additionsIterator.hasNext()) {
                CProjectionAnnotation added = (CProjectionAnnotation)((Object)additionsIterator.next());
                if (deleted.isComment() != added.isComment()) continue;
                Position addedPosition = (Position)additions.get((Object)added);
                if (deletedPosition.getOffset() != addedPosition.getOffset()) continue;
                deletedPosition.setLength(addedPosition.getLength());
                deleted.setElement(added.getElement());
                deletionIterator.remove();
                newChanges.add(deleted);
                additionsIterator.remove();
                continue block0;
            }
        }
        deletions.addAll(newDeletions);
        changes.addAll(newChanges);
    }

    private Map createAnnotationMap(IAnnotationModel model) {
        HashMap<ICElement, ArrayList<CProjectionAnnotation>> map = new HashMap<ICElement, ArrayList<CProjectionAnnotation>>();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Object annotation = e.next();
            if (!(annotation instanceof CProjectionAnnotation)) continue;
            CProjectionAnnotation c = (CProjectionAnnotation)((Object)annotation);
            ArrayList<CProjectionAnnotation> list = (ArrayList<CProjectionAnnotation>)map.get(c.getElement());
            if (list == null) {
                list = new ArrayList<CProjectionAnnotation>(2);
                map.put(c.getElement(), list);
            }
            list.add(c);
        }
        return map;
    }

    private static class CProjectionAnnotation
    extends ProjectionAnnotation {
        private ICElement fCElement;
        private boolean fIsComment;

        public CProjectionAnnotation(ICElement element, boolean isCollapsed, boolean isComment) {
            super(isCollapsed);
            this.fCElement = element;
            this.fIsComment = isComment;
        }

        public ICElement getElement() {
            return this.fCElement;
        }

        public void setElement(ICElement element) {
            this.fCElement = element;
        }

        public boolean isComment() {
            return this.fIsComment;
        }

        public void setIsComment(boolean isComment) {
            this.fIsComment = isComment;
        }
    }

    private class ElementChangedListener
    implements IElementChangedListener {
        ElementChangedListener() {
        }

        public void elementChanged(ElementChangedEvent e) {
            ICElementDelta delta = this.findElement(DefaultCFoldingStructureProvider.this.fInput, e.getDelta());
            if (delta != null) {
                DefaultCFoldingStructureProvider.this.processDelta(delta);
            }
        }

        private ICElementDelta findElement(ICElement target, ICElementDelta delta) {
            if (delta == null || target == null) {
                return null;
            }
            ICElement element = delta.getElement();
            if (element.getElementType() > 60) {
                return null;
            }
            if (target.equals(element)) {
                return delta;
            }
            ICElementDelta[] children = delta.getAffectedChildren();
            if (children == null || children.length == 0) {
                return null;
            }
            int i = 0;
            while (i < children.length) {
                ICElementDelta d = this.findElement(target, children[i]);
                if (d != null) {
                    return d;
                }
                ++i;
            }
            return null;
        }
    }
}

