/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.debug.core.model.IJumpToAddress;
import org.eclipse.cdt.debug.core.model.IJumpToLine;
import org.eclipse.cdt.debug.internal.ui.actions.AbstractEditorActionDelegate;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class JumpToLineActionDelegate
extends AbstractEditorActionDelegate {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IDebugTarget target = null;
        if (part != null && part.getSite().getId().equals("org.eclipse.debug.ui.DebugView")) {
            IDebugTarget target1;
            Object element;
            if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) != null && element instanceof IDebugElement && (target1 = ((IDebugElement)element).getDebugTarget()) != null && (target1 instanceof IJumpToLine || target1 instanceof IJumpToAddress)) {
                target = target1;
            }
            this.setDebugTarget(target);
            this.update();
        }
    }

    public void run(IAction action) {
        if (this.getTargetPart() != null && this.getTargetPart() instanceof ITextEditor) {
            IEditorInput input = ((ITextEditor)this.getTargetPart()).getEditorInput();
            if (input != null && input instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)input).getFile();
                if (file != null) {
                    ITextSelection selection = (ITextSelection)((ITextEditor)this.getTargetPart()).getSelectionProvider().getSelection();
                    int lineNumber = selection.getStartLine() + 1;
                    this.jumpToLine(file, lineNumber);
                }
            } else if (input != null && input instanceof IStorageEditorInput) {
                try {
                    IPath path;
                    IStorage storage = ((IStorageEditorInput)input).getStorage();
                    if (storage instanceof FileStorage && (path = storage.getFullPath()) != null) {
                        ITextSelection selection = (ITextSelection)((ITextEditor)this.getTargetPart()).getSelectionProvider().getSelection();
                        int lineNumber = selection.getStartLine() + 1;
                        this.jumpToLine(path.lastSegment(), lineNumber);
                    }
                }
                catch (CoreException coreException) {}
            }
        }
    }

    protected void initializeDebugTarget() {
        IDebugTarget target;
        this.setDebugTarget(null);
        IAdaptable context = DebugUITools.getDebugContext();
        if (context != null && context instanceof IDebugElement && (target = ((IDebugElement)context).getDebugTarget()) != null && (target instanceof IJumpToLine || target instanceof IJumpToAddress)) {
            this.setDebugTarget(target);
        }
    }

    protected void jumpToLine(IFile file, int lineNumber) {
        IJumpToLine target;
        IDebugTarget iDebugTarget = this.getDebugTarget();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IJumpToLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((target = (IJumpToLine)iDebugTarget.getAdapter((Class)clazz)) != null) {
            if (!target.canJumpToLine(file, lineNumber)) {
                this.getTargetPart().getSite().getShell().getDisplay().beep();
                return;
            }
            try {
                target.jumpToLine(file, lineNumber);
            }
            catch (DebugException e) {
                CDebugUIPlugin.errorDialog(e.getMessage(), e);
            }
        }
    }

    protected void jumpToLine(String fileName, int lineNumber) {
        IJumpToLine target;
        IDebugTarget iDebugTarget = this.getDebugTarget();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IJumpToLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((target = (IJumpToLine)iDebugTarget.getAdapter((Class)clazz)) != null) {
            if (!target.canJumpToLine(fileName, lineNumber)) {
                this.getTargetPart().getSite().getShell().getDisplay().beep();
                return;
            }
            try {
                target.jumpToLine(fileName, lineNumber);
            }
            catch (DebugException e) {
                CDebugUIPlugin.errorDialog(e.getMessage(), e);
            }
        }
    }

    protected void jumpToAddress(IAddress address) {
        IJumpToAddress target;
        IDebugTarget iDebugTarget = this.getDebugTarget();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.cdt.debug.core.model.IJumpToAddress");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((target = (IJumpToAddress)iDebugTarget.getAdapter((Class)clazz)) != null) {
            if (!target.canJumpToAddress(address)) {
                this.getTargetPart().getSite().getShell().getDisplay().beep();
                return;
            }
            try {
                target.jumpToAddress(address);
            }
            catch (DebugException e) {
                CDebugUIPlugin.errorDialog(e.getMessage(), e);
            }
        }
    }
}

