/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.cdt.debug.mi.core.CLIProcessor;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.command.CLICommand;
import org.eclipse.cdt.debug.mi.core.command.Command;
import org.eclipse.cdt.debug.mi.core.command.MIInterpreterExecConsole;
import org.eclipse.cdt.debug.mi.core.command.RawCommand;

public class SessionProcess
extends Process {
    MISession session;
    OutputStream out;

    public SessionProcess(MISession s) {
        this.session = s;
    }

    public void destroy() {
        this.session.terminate();
    }

    public int exitValue() {
        return this.session.getGDBProcess().exitValue();
    }

    public InputStream getErrorStream() {
        return this.session.getMILogStream();
    }

    public InputStream getInputStream() {
        return this.session.getMIConsoleStream();
    }

    public OutputStream getOutputStream() {
        if (this.out == null) {
            this.out = new OutputStream(){
                StringBuffer buf = new StringBuffer();

                public void write(int b) throws IOException {
                    this.buf.append((char)b);
                    if (b == 10) {
                        this.post();
                    }
                }

                public void post() throws IOException {
                    String str = this.buf.toString().trim();
                    this.buf.setLength(0);
                    Command cmd = null;
                    boolean secondary = SessionProcess.this.session.inSecondaryPrompt();
                    cmd = secondary ? new RawCommand(str) : (SessionProcess.this.session.useExecConsole() && str.length() > 0 && !CLIProcessor.isSteppingOperation(str) ? new MIInterpreterExecConsole(str) : new CLICommand(str));
                    try {
                        SessionProcess.this.session.postCommand(cmd, -1L);
                    }
                    catch (MIException e) {
                        throw new IOException(e.getMessage());
                    }
                }
            };
        }
        return this.out;
    }

    public int waitFor() throws InterruptedException {
        return this.session.getGDBProcess().waitFor();
    }
}

