/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class DiscoveredPathContainer
implements IPathEntryContainer {
    public static IPath CONTAINER_ID = new Path("org.eclipse.cdt.make.core.DISCOVERED_SCANNER_INFO");
    private final IProject fProject;
    static Map fgPathEntries;

    public DiscoveredPathContainer(IProject project) {
        this.fProject = project;
    }

    public static IPathEntry[] getPathEntries(IProject project) throws CoreException {
        IPathEntry[] entries;
        if (fgPathEntries == null) {
            fgPathEntries = new HashMap(10);
            IDiscoveredPathManager.IDiscoveredInfoListener listener = new IDiscoveredPathManager.IDiscoveredInfoListener(){

                public void infoRemoved(IProject project) {
                    fgPathEntries.remove(project);
                }

                public void infoChanged(IDiscoveredPathManager.IDiscoveredPathInfo info) {
                    fgPathEntries.remove(info.getProject());
                }
            };
            MakeCorePlugin.getDefault().getDiscoveryManager().addDiscoveredInfoListener(listener);
        }
        if ((entries = (IPathEntry[])fgPathEntries.get(project)) == null) {
            entries = DiscoveredPathContainer.computeNewPathEntries(project);
            fgPathEntries.put(project, entries);
        }
        return entries;
    }

    private static IPathEntry[] computeNewPathEntries(IProject project) throws CoreException {
        IDiscoveredPathManager.IDiscoveredPathInfo info = MakeCorePlugin.getDefault().getDiscoveryManager().getDiscoveredInfo(project);
        IPath[] includes = info.getIncludePaths();
        Map syms = info.getSymbols();
        ArrayList<Object> entries = new ArrayList<Object>(includes.length + syms.size());
        int i = 0;
        while (i < includes.length) {
            entries.add(CoreModel.newIncludeEntry((IPath)Path.EMPTY, (IPath)Path.EMPTY, (IPath)includes[i]));
            ++i;
        }
        Iterator iter = syms.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            entries.add(CoreModel.newMacroEntry((IPath)Path.EMPTY, (String)((String)entry.getKey()), (String)((String)entry.getValue())));
        }
        return entries.toArray(new IPathEntry[entries.size()]);
    }

    public IPathEntry[] getPathEntries() {
        IPathEntry[] fPathEntries;
        try {
            fPathEntries = DiscoveredPathContainer.getPathEntries(this.fProject);
        }
        catch (CoreException e) {
            MakeCorePlugin.log(e);
            return new IPathEntry[0];
        }
        return fPathEntries;
    }

    public String getDescription() {
        return MakeMessages.getString("DiscoveredContainer.description");
    }

    public IPath getPath() {
        return CONTAINER_ID;
    }
}

