/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.impl;

import java.io.File;
import java.io.IOException;
import org.eclipse.cdt.internal.core.index.IDocument;
import org.eclipse.cdt.internal.core.index.impl.BlocksIndexOutput;
import org.eclipse.cdt.internal.core.index.impl.IncludeEntry;
import org.eclipse.cdt.internal.core.index.impl.IncludeEntryHashedArray;
import org.eclipse.cdt.internal.core.index.impl.IndexOutput;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.index.impl.IndexedFileHashedArray;
import org.eclipse.cdt.internal.core.index.impl.Util;
import org.eclipse.cdt.internal.core.index.impl.WordEntry;
import org.eclipse.cdt.internal.core.index.impl.WordEntryHashedArray;

public class InMemoryIndex {
    protected IncludeEntryHashedArray includes = new IncludeEntryHashedArray(501);
    protected WordEntryHashedArray words;
    protected IndexedFileHashedArray files;
    protected long footprint;
    private IncludeEntry[] sortedIncludeEntries;
    private WordEntry[] sortedWordEntries;
    private IndexedFile[] sortedFiles;
    private int lastId;

    public InMemoryIndex() {
        this.init();
    }

    public IndexedFile addDocument(IDocument document) {
        IndexedFile indexedFile = this.files.add(document);
        this.footprint += (long)(indexedFile.footprint() + 4);
        this.sortedFiles = null;
        return indexedFile;
    }

    public IndexedFile addExternalFilePath(String path) {
        IndexedFile indexedFile = this.files.add(path);
        this.footprint += (long)(indexedFile.footprint() + 4);
        this.sortedFiles = null;
        return indexedFile;
    }

    public void addIncludeRef(IndexedFile indexedFile, char[] include) {
        this.addIncludeRef(include, indexedFile.getFileNumber());
    }

    public void addIncludeRef(IndexedFile indexedFile, String include) {
        this.addIncludeRef(include.toCharArray(), indexedFile.getFileNumber());
    }

    protected void addIncludeRef(char[] include, int[] references) {
        int size = references.length;
        int i = 0;
        while (i < size) {
            if (references[i] != 0) {
                this.addIncludeRef(include, references[i]);
            }
            ++i;
        }
    }

    protected void addIncludeRef(char[] include, int fileNum) {
        IncludeEntry entry = this.includes.get(include);
        if (entry == null) {
            entry = new IncludeEntry(include, ++this.lastId);
            entry.addRef(fileNum);
            this.includes.add(entry);
            this.sortedIncludeEntries = null;
            this.footprint += entry.footprint();
        } else {
            this.footprint += (long)entry.addRef(fileNum);
        }
    }

    protected void addRef(char[] word, int[] references, int[] indexFlags) {
        int size = references.length;
        int i = 0;
        while (i < size) {
            if (references[i] != 0) {
                this.addRef(word, references[i], indexFlags[i]);
            }
            ++i;
        }
    }

    protected void addRef(char[] word, int fileNum, int indexFlags) {
        WordEntry entry = this.words.get(word);
        if (entry == null) {
            entry = new WordEntry(word);
            entry.addRef(indexFlags, indexFlags);
            this.words.add(entry);
            this.sortedWordEntries = null;
            this.footprint += (long)entry.footprint();
        } else {
            this.footprint += (long)entry.addRef(indexFlags, indexFlags);
        }
    }

    public void addRef(IndexedFile indexedFile, char[] word, int indexFlags) {
        this.addRef(word, indexedFile.getFileNumber(), indexFlags);
    }

    public void addRef(IndexedFile indexedFile, String word, int indexFlags) {
        this.addRef(word.toCharArray(), indexedFile.getFileNumber(), indexFlags);
    }

    public void addRelatives(IndexedFile indexedFile, String inclusion, String parent) {
        this.addRelatives(indexedFile.getFileNumber(), inclusion.toCharArray(), parent != null ? parent.toCharArray() : null);
    }

    protected void addRelatives(int fileNumber, char[] inclusion, char[] parent) {
        IncludeEntry childEntry = null;
        IncludeEntry parentEntry = null;
        if (inclusion != null) {
            childEntry = this.includes.get(inclusion);
        }
        if (parent != null) {
            parentEntry = this.includes.get(parent);
        }
        childEntry.addParent(fileNumber, parentEntry != null ? parentEntry.getID() : -1);
        if (parent != null) {
            parentEntry.addChild(fileNumber, childEntry != null ? childEntry.getID() : -1);
        }
    }

    public long getFootprint() {
        return this.footprint;
    }

    public IndexedFile[] getIndexedFiles() {
        return this.files.asArray();
    }

    public IndexedFile getIndexedFile(String path) {
        return this.files.get(path);
    }

    public IncludeEntry[] getIncludeEntries() {
        return this.includes.asArray();
    }

    protected IncludeEntry getIncludeEntry(char[] include) {
        return this.includes.get(include);
    }

    public int getNumFiles() {
        return this.files.size();
    }

    public int getNumWords() {
        return this.words.elementSize;
    }

    public int getNumIncludes() {
        return this.includes.elementSize;
    }

    protected IndexedFile[] getSortedFiles() {
        if (this.sortedFiles == null) {
            IndexedFile[] indexedFiles = this.files.asArray();
            Util.sort(indexedFiles);
            this.sortedFiles = indexedFiles;
        }
        return this.sortedFiles;
    }

    protected WordEntry[] getSortedWordEntries() {
        if (this.sortedWordEntries == null) {
            WordEntry[] words = this.words.asArray();
            Util.sort(words);
            this.sortedWordEntries = words;
        }
        return this.sortedWordEntries;
    }

    protected IncludeEntry[] getSortedIncludeEntries() {
        if (this.sortedIncludeEntries == null) {
            IncludeEntry[] includes = this.includes.asArray();
            Util.sort(includes);
            this.sortedIncludeEntries = includes;
        }
        return this.sortedIncludeEntries;
    }

    protected WordEntry getWordEntry(char[] word) {
        return this.words.get(word);
    }

    public void init() {
        this.includes = new IncludeEntryHashedArray(501);
        this.words = new WordEntryHashedArray(501);
        this.files = new IndexedFileHashedArray(101);
        this.footprint = 0L;
        this.lastId = 0;
        this.sortedWordEntries = null;
        this.sortedFiles = null;
        this.sortedIncludeEntries = null;
    }

    public void save(File file) throws IOException {
        BlocksIndexOutput output = new BlocksIndexOutput(file);
        this.save(output);
    }

    /*
     * Exception decompiling
     */
    protected void save(IndexOutput output) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 118->122)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

