/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.cdt.managedbuilder.internal.core.Target;
import org.eclipse.cdt.managedbuilder.internal.scannerconfig.ManagedBuildCPathEntryContainer;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ManagedBuildInfo
implements IManagedBuildInfo,
IScannerInfo {
    public static final IContainerEntry containerEntry = CoreModel.newContainerEntry((IPath)new Path("org.eclipse.cdt.managedbuilder.MANAGED_CONTAINER"));
    private static final QualifiedName defaultConfigProperty = new QualifiedName(ManagedBuilderCorePlugin.getUniqueIdentifier(), "defaultConfig");
    private static final QualifiedName defaultTargetProperty = new QualifiedName(ManagedBuilderCorePlugin.getUniqueIdentifier(), "defaultTarget");
    public static final String MAJOR_SEPERATOR = ";";
    public static final String MINOR_SEPERATOR = "::";
    private static final String EMPTY_STRING = new String();
    private IManagedProject managedProject;
    private ICProject cProject;
    private IConfiguration defaultConfig;
    private String defaultConfigId;
    private boolean isDirty;
    private boolean isValid = false;
    private IResource owner;
    private boolean rebuildNeeded;
    private String version;
    private IConfiguration selectedConfig;
    private List targetList;
    private Map targetMap;
    private boolean isReadOnly = false;
    private boolean bIsContainerInited = false;

    public ManagedBuildInfo(IResource owner) {
        this.owner = owner;
        this.cProject = CoreModel.getDefault().create(owner.getProject());
        this.isDirty = false;
        this.rebuildNeeded = true;
        IProject project = owner.getProject();
        this.defaultConfigId = null;
        try {
            this.defaultConfigId = project.getPersistentProperty(defaultConfigProperty);
        }
        catch (CoreException coreException) {
            return;
        }
    }

    public ManagedBuildInfo(IResource owner, Element element) {
        this(owner);
        NodeList projNodes = element.getElementsByTagName("project");
        int projIndex = projNodes.getLength() - 1;
        while (projIndex >= 0) {
            ManagedProject proj = new ManagedProject(this, (Element)projNodes.item(projIndex));
            if (!proj.resolveReferences()) {
                proj.setValid(false);
            }
            --projIndex;
        }
        this.rebuildNeeded = false;
    }

    public void setManagedProject(IManagedProject managedProject) {
        this.managedProject = managedProject;
    }

    public IManagedProject getManagedProject() {
        return this.managedProject;
    }

    public boolean buildsFileType(String srcExt) {
        IConfiguration config = this.getDefaultConfiguration();
        ITool[] tools = config.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool != null && tool.buildsFileType(srcExt)) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public String getBuildArtifactExtension() {
        String ext = new String();
        IConfiguration config = this.getDefaultConfiguration();
        if (config != null) {
            ext = config.getArtifactExtension();
        }
        return ext;
    }

    public String getBuildArtifactName() {
        String name = new String();
        IConfiguration config = this.getDefaultConfiguration();
        if (config != null) {
            name = config.getArtifactName();
        }
        return name;
    }

    public String getCleanCommand() {
        String command = new String();
        IConfiguration config = this.getDefaultConfiguration();
        if (config != null) {
            command = config.getCleanCommand();
        }
        return command;
    }

    public String getConfigurationName() {
        IConfiguration config = this.getDefaultConfiguration();
        return config == null ? new String() : config.getName();
    }

    public String[] getConfigurationNames() {
        ArrayList<String> configNames = new ArrayList<String>();
        IConfiguration[] configs = this.managedProject.getConfigurations();
        int i = 0;
        while (i < configs.length) {
            IConfiguration configuration = configs[i];
            configNames.add(configuration.getName());
            ++i;
        }
        configNames.trimToSize();
        return configNames.toArray(new String[configNames.size()]);
    }

    public ICProject getCProject() {
        return this.cProject;
    }

    public IConfiguration getDefaultConfiguration() {
        if (this.defaultConfig == null && this.managedProject != null) {
            IConfiguration[] configs;
            if (this.defaultConfigId != null) {
                this.defaultConfig = this.managedProject.getConfiguration(this.defaultConfigId);
            }
            if (this.defaultConfig == null && (configs = this.managedProject.getConfigurations()).length > 0) {
                this.defaultConfig = configs[0];
                this.defaultConfigId = this.defaultConfig.getId();
            }
        }
        return this.defaultConfig;
    }

    public Map getDefinedSymbols() {
        HashMap symbols = this.getMacroPathEntries();
        IConfiguration config = this.getDefaultConfiguration();
        if (config == null) {
            return symbols;
        }
        ITool[] tools = config.getFilteredTools();
        int i = 0;
        while (i < tools.length) {
            ITool tool = tools[i];
            IOption[] opts = tool.getOptions();
            int j = 0;
            while (j < opts.length) {
                IOption option = opts[j];
                try {
                    if (option.getValueType() == 5) {
                        ArrayList<String> symbolList = new ArrayList<String>();
                        symbolList.addAll(Arrays.asList(option.getDefinedSymbols()));
                        ListIterator iter = symbolList.listIterator();
                        while (iter.hasNext()) {
                            String symbol = (String)iter.next();
                            if (symbol.length() == 0) continue;
                            String[] tokens = symbol.split("=");
                            String key = tokens[0].trim();
                            String value = tokens.length > 1 ? tokens[1].trim() : new String();
                            symbols.put(key, value);
                        }
                    }
                }
                catch (BuildException buildException) {}
                ++j;
            }
            ++i;
        }
        return symbols;
    }

    public IManagedDependencyGenerator getDependencyGenerator(String sourceExtension) {
        try {
            if (this.getDefaultConfiguration() != null) {
                ITool[] tools = this.getDefaultConfiguration().getFilteredTools();
                int index = 0;
                while (index < tools.length) {
                    if (tools[index].buildsFileType(sourceExtension)) {
                        return tools[index].getDependencyGenerator();
                    }
                    ++index;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        return null;
    }

    private ITool[] getFilteredTools() {
        IConfiguration config = this.getDefaultConfiguration();
        return config.getFilteredTools();
    }

    public String getFlagsForSource(String extension) {
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool != null && tool.buildsFileType(extension)) {
                try {
                    return tool.getToolFlags();
                }
                catch (BuildException buildException) {
                    return null;
                }
            }
            ++index;
        }
        return null;
    }

    public String getFlagsForConfiguration(String extension) {
        String ext = extension == null ? new String() : extension;
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.producesFileType(ext)) {
                try {
                    return tool.getToolFlags();
                }
                catch (BuildException buildException) {
                    return null;
                }
            }
            ++index;
        }
        return null;
    }

    private ArrayList getIncludePathEntries() {
        ArrayList<String> paths = new ArrayList<String>();
        if (this.cProject != null) {
            try {
                IPathEntry[] entries = this.cProject.getResolvedPathEntries();
                int index = 0;
                while (index < entries.length) {
                    IIncludeEntry include;
                    int kind = entries[index].getEntryKind();
                    if (kind == 4 && (include = (IIncludeEntry)entries[index]).isSystemInclude()) {
                        IPath entryPath = include.getFullIncludePath();
                        paths.add(entryPath.toString());
                    }
                    ++index;
                }
            }
            catch (CModelException cModelException) {
                paths.clear();
                return paths;
            }
        }
        return paths;
    }

    public String[] getIncludePaths() {
        ArrayList paths = this.getIncludePathEntries();
        IConfiguration config = this.getDefaultConfiguration();
        IPath location = this.owner.getLocation();
        if (location == null) {
            location = new Path(".");
        }
        if (config != null) {
            IPath root = location.addTrailingSeparator().append(config.getName());
            ITool[] tools = config.getFilteredTools();
            int i = 0;
            while (i < tools.length) {
                ITool tool = tools[i];
                IOption[] opts = tool.getOptions();
                int j = 0;
                while (j < opts.length) {
                    IOption option = opts[j];
                    try {
                        if (option.getValueType() == 4) {
                            String[] userPaths = option.getIncludePaths();
                            int index = 0;
                            while (index < userPaths.length) {
                                Path userPath = new Path(userPaths[index]);
                                if (userPath.isAbsolute()) {
                                    paths.add(userPath.toOSString());
                                } else {
                                    IPath absPath = root.addTrailingSeparator().append((IPath)userPath);
                                    paths.add(absPath.makeAbsolute().toOSString());
                                }
                                ++index;
                            }
                        }
                    }
                    catch (BuildException buildException) {}
                    ++j;
                }
                ++i;
            }
        }
        return paths.toArray(new String[paths.size()]);
    }

    public String[] getLibsForConfiguration(String extension) {
        Vector<String> libs = new Vector<String>();
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.producesFileType(extension)) {
                IOption[] opts = tool.getOptions();
                int i = 0;
                while (i < opts.length) {
                    IOption option = opts[i];
                    try {
                        if (option.getValueType() == 6) {
                            String command = option.getCommand();
                            String[] allLibs = option.getLibraries();
                            int j = 0;
                            while (j < allLibs.length) {
                                String string = allLibs[j];
                                libs.add(String.valueOf(command) + string);
                                ++j;
                            }
                        }
                    }
                    catch (BuildException buildException) {}
                    ++i;
                }
            }
            ++index;
        }
        return libs.toArray(new String[libs.size()]);
    }

    private HashMap getMacroPathEntries() {
        HashMap<String, String> macros = new HashMap<String, String>();
        if (this.cProject != null) {
            try {
                IPathEntry[] entries = this.cProject.getResolvedPathEntries();
                int index = 0;
                while (index < entries.length) {
                    if (entries[index].getEntryKind() == 6) {
                        IMacroEntry macro = (IMacroEntry)entries[index];
                        macros.put(macro.getMacroName(), macro.getMacroValue());
                    }
                    ++index;
                }
            }
            catch (CModelException cModelException) {
                macros.clear();
                return macros;
            }
        }
        return macros;
    }

    public String getBuildArguments() {
        if (this.getDefaultConfiguration() != null) {
            IToolChain toolChain = this.getDefaultConfiguration().getToolChain();
            IBuilder builder = toolChain.getBuilder();
            return builder.getArguments();
        }
        return EMPTY_STRING;
    }

    public String getBuildCommand() {
        if (this.getDefaultConfiguration() != null) {
            IToolChain toolChain = this.getDefaultConfiguration().getToolChain();
            IBuilder builder = toolChain.getBuilder();
            return builder.getCommand();
        }
        return EMPTY_STRING;
    }

    public String getOutputExtension(String resourceExtension) {
        String outputExtension = null;
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            outputExtension = tool.getOutputExtension(resourceExtension);
            if (outputExtension != null) {
                return outputExtension;
            }
            ++index;
        }
        return null;
    }

    public String getOutputFlag(String outputExt) {
        String ext = outputExt == null ? new String() : outputExt;
        String flags = new String();
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.producesFileType(ext)) {
                flags = tool.getOutputFlag();
            }
            ++index;
        }
        return flags;
    }

    public String getOutputPrefix(String outputExtension) {
        String ext = outputExtension == null ? new String() : outputExtension;
        String flags = new String();
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.producesFileType(ext)) {
                flags = tool.getOutputPrefix();
            }
            ++index;
        }
        return flags;
    }

    public IResource getOwner() {
        return this.owner;
    }

    public String getToolForSource(String sourceExtension) {
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.buildsFileType(sourceExtension)) {
                return tool.getToolCommand();
            }
            ++index;
        }
        return null;
    }

    public String getToolForConfiguration(String extension) {
        String ext = extension == null ? new String() : extension;
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.producesFileType(ext)) {
                return tool.getToolCommand();
            }
            ++index;
        }
        return null;
    }

    public IManagedCommandLineInfo generateCommandLineInfo(String sourceExtension, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources) {
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.buildsFileType(sourceExtension)) {
                IManagedCommandLineGenerator gen = tool.getCommandLineGenerator();
                return gen.generateCommandLineInfo(tool, tool.getToolCommand(), flags, outputFlag, outputPrefix, outputName, inputResources, tool.getCommandLinePattern());
            }
            ++index;
        }
        return null;
    }

    public String[] getUserObjectsForConfiguration(String extension) {
        Vector<String> objs = new Vector<String>();
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.producesFileType(extension)) {
                IOption[] opts = tool.getOptions();
                int i = 0;
                while (i < opts.length) {
                    IOption option = opts[i];
                    try {
                        if (option.getValueType() == 7) {
                            objs.addAll(Arrays.asList(option.getUserObjects()));
                        }
                    }
                    catch (BuildException buildException) {}
                    ++i;
                }
            }
            ++index;
        }
        return objs.toArray(new String[objs.size()]);
    }

    public String getVersion() {
        return this.version;
    }

    private void initializePathEntries() {
        try {
            ManagedBuildCPathEntryContainer container = new ManagedBuildCPathEntryContainer(this.getOwner().getProject());
            CoreModel.getDefault().setPathEntryContainer(new ICProject[]{this.cProject}, (IPathEntryContainer)container, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CModelException cModelException) {}
    }

    public boolean isDirty() {
        if (this.isDirty) {
            return true;
        }
        if (this.managedProject != null) {
            return this.managedProject.isDirty();
        }
        return false;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isHeaderFile(String ext) {
        IProject project = (IProject)this.owner;
        IConfiguration config = this.getDefaultConfiguration();
        ITool[] tools = config.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            try {
                switch (tool.getNatureFilter()) {
                    case 0: {
                        if (project.hasNature("org.eclipse.cdt.core.cnature") && !project.hasNature("org.eclipse.cdt.core.ccnature")) {
                            return tool.isHeaderFile(ext);
                        }
                        break;
                    }
                    case 1: {
                        if (!project.hasNature("org.eclipse.cdt.core.ccnature")) break;
                        return tool.isHeaderFile(ext);
                    }
                    case 2: {
                        return tool.isHeaderFile(ext);
                    }
                }
            }
            catch (CoreException coreException) {}
            ++index;
        }
        return false;
    }

    public boolean isContainerInited() {
        return this.bIsContainerInited;
    }

    public boolean needsRebuild() {
        if (this.rebuildNeeded) {
            return true;
        }
        if (this.getDefaultConfiguration() != null) {
            return this.getDefaultConfiguration().needsRebuild();
        }
        return false;
    }

    private void persistDefaultConfiguration() {
        IProject project = this.owner.getProject();
        try {
            if (this.defaultConfigId != null) {
                project.setPersistentProperty(defaultConfigProperty, this.defaultConfigId.toString().trim());
            }
        }
        catch (CoreException coreException) {}
    }

    public void serialize(Document doc, Element element) {
        if (this.managedProject != null) {
            Element projElement = doc.createElement("project");
            element.appendChild(projElement);
            this.managedProject.serialize(doc, projElement);
        } else {
            ListIterator iter = this.getTargets().listIterator();
            while (iter.hasNext()) {
                Target targ = (Target)iter.next();
                Element targetElement = doc.createElement("target");
                element.appendChild(targetElement);
                targ.serialize(doc, targetElement);
            }
        }
        this.persistDefaultConfiguration();
        this.setDirty(false);
    }

    public void setDefaultConfiguration(IConfiguration configuration) {
        if (configuration == null) {
            return;
        }
        if (!configuration.equals(this.getDefaultConfiguration())) {
            this.defaultConfig = configuration;
            this.defaultConfigId = configuration.getId();
            this.persistDefaultConfiguration();
        }
    }

    public boolean setDefaultConfiguration(String configName) {
        if (configName != null) {
            IConfiguration[] configs = this.managedProject.getConfigurations();
            int index = configs.length - 1;
            while (index >= 0) {
                IConfiguration config = configs[index];
                if (configName.equalsIgnoreCase(config.getName())) {
                    this.setDefaultConfiguration(config);
                    return true;
                }
                --index;
            }
        }
        return false;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        if (this.managedProject != null) {
            this.managedProject.setDirty(isDirty);
        }
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public void setReadOnly(boolean readOnly) {
        if (!readOnly && this.isReadOnly) {
            this.setDirty(true);
        }
        this.isReadOnly = readOnly;
    }

    public void setRebuildState(boolean rebuild) {
        this.rebuildNeeded = rebuild;
        if (this.getDefaultConfiguration() != null) {
            this.getDefaultConfiguration().setRebuildState(rebuild);
        }
    }

    public void setVersion(String version) {
        if (version != null && !version.equals(this.version)) {
            this.version = version;
        }
    }

    public void setContainerInited(boolean bInited) {
        this.bIsContainerInited = bInited;
    }

    public String toString() {
        return "Managed build information for " + this.owner.getName();
    }

    public void updateOwner(IResource resource) {
        if (resource != null && !this.owner.equals((Object)resource)) {
            this.owner = resource;
            this.managedProject.updateOwner(resource);
            this.cProject = CoreModel.getDefault().create(this.owner.getProject());
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public IConfiguration getSelectedConfiguration() {
        return this.selectedConfig;
    }

    public void setSelectedConfiguration(IConfiguration config) {
        this.selectedConfig = config;
    }

    public void addTarget(ITarget target) {
        this.getTargetMap().put(target.getId(), target);
        this.getTargets().add(target);
        this.setDirty(true);
    }

    public void removeTarget(String id) {
        this.getTargets().remove(this.getTarget(id));
        this.getTargetMap().remove(id);
        this.setDirty(true);
    }

    public ITarget getTarget(String id) {
        return (ITarget)this.getTargetMap().get(id);
    }

    private Map getTargetMap() {
        if (this.targetMap == null) {
            this.targetMap = new HashMap();
        }
        return this.targetMap;
    }

    public List getTargets() {
        if (this.targetList == null) {
            this.targetList = new ArrayList();
        }
        return this.targetList;
    }
}

