/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineInfo;

public class ManagedCommandLineGenerator
implements IManagedCommandLineGenerator {
    public final String AT = "@";
    public final String COLON = ":";
    public final String DOT = ".";
    public final String ECHO = "echo";
    public final String IN_MACRO = "$<";
    public final String LINEBREAK = "\\\n";
    public final String NEWLINE = System.getProperty("line.separator");
    public final String OUT_MACRO = "$@";
    public final String SEPARATOR = "/";
    public final String SINGLE_QUOTE = "'";
    public final String TAB = "\t";
    public final String WHITESPACE = " ";
    public final String WILDCARD = "%";
    public final String UNDERLINE = "_";
    public final String VAR_FIRST_CHAR = "$";
    public final char VAR_SECOND_CHAR = (char)123;
    public final String VAR_FINAL_CHAR = "}";
    public final String CLASS_PROPERTY_PREFIX = "get";
    public final String CMD_LINE_PRM_NAME = "COMMAND";
    public final String FLAGS_PRM_NAME = "FLAGS";
    public final String OUTPUT_FLAG_PRM_NAME = "OUTPUT_FLAG";
    public final String OUTPUT_PREFIX_PRM_NAME = "OUTPUT_PREFIX";
    public final String OUTPUT_PRM_NAME = "OUTPUT";
    public final String INPUTS_PRM_NAME = "INPUTS";
    private static ManagedCommandLineGenerator cmdLineGen;

    protected ManagedCommandLineGenerator() {
        cmdLineGen = null;
    }

    public static ManagedCommandLineGenerator getCommandLineGenerator() {
        if (cmdLineGen == null) {
            cmdLineGen = new ManagedCommandLineGenerator();
        }
        return cmdLineGen;
    }

    public IManagedCommandLineInfo generateCommandLineInfo(ITool tool, String commandName, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources, String commandLinePattern) {
        StringBuffer sb = new StringBuffer();
        if (commandLinePattern == null || commandLinePattern.length() <= 0) {
            commandLinePattern = "${COMMAND} ${FLAGS} ${OUTPUT_FLAG}${OUTPUT_PREFIX}${OUTPUT} ${INPUTS}";
        }
        int start = 0;
        int stop = 0;
        while ((start = commandLinePattern.indexOf("$", start)) >= 0) {
            if (commandLinePattern.charAt(start + 1) != '{') continue;
            if (start > stop) {
                sb.append(commandLinePattern.substring(stop, start));
            }
            if ((stop = commandLinePattern.indexOf("}", start + 1)) > 0 && stop <= commandLinePattern.length()) {
                try {
                    String varName = commandLinePattern.substring(start + 2, stop).trim();
                    if (varName.compareToIgnoreCase("COMMAND") == 0) {
                        sb.append(commandName.trim());
                    } else if (varName.compareToIgnoreCase("FLAGS") == 0) {
                        sb.append(this.stringArrayToString(flags));
                    } else if (varName.compareToIgnoreCase("OUTPUT_FLAG") == 0) {
                        sb.append(outputFlag.trim());
                    } else if (varName.compareToIgnoreCase("OUTPUT_PREFIX") == 0) {
                        sb.append(outputPrefix.trim());
                    } else if (varName.compareToIgnoreCase("OUTPUT") == 0) {
                        sb.append(outputName.trim());
                    } else if (varName.compareToIgnoreCase("INPUTS") == 0) {
                        sb.append(this.stringArrayToString(inputResources));
                    } else {
                        sb.append("${" + varName + "}");
                    }
                }
                catch (Exception exception) {}
            }
            start = ++stop;
        }
        return new ManagedCommandLineInfo(sb.toString().trim(), commandLinePattern, commandName, this.stringArrayToString(flags), outputFlag, outputPrefix, outputName, this.stringArrayToString(inputResources));
    }

    private String stringArrayToString(String[] array) {
        if (array == null || array.length <= 0) {
            return new String();
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            sb.append(String.valueOf(array[i]) + " ");
            ++i;
        }
        return sb.toString().trim();
    }
}

