/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfigurationV2;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolReference;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.ConfigurationV2;
import org.eclipse.cdt.managedbuilder.internal.core.OptionReference;
import org.eclipse.cdt.managedbuilder.internal.core.Target;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ToolReference
implements IToolReference {
    private static final String DEFAULT_SEPARATOR = ",";
    private String command;
    private boolean isDirty = false;
    private List optionReferences;
    private IBuildObject owner;
    private String outputExtensions;
    private String outputFlag;
    private String outputPrefix;
    protected ITool parent;
    private boolean resolved = true;

    public ToolReference(BuildObject owner, Element element) {
        this.owner = owner;
        if (owner instanceof ConfigurationV2) {
            if (this.parent == null) {
                Target parentTarget = (Target)((ConfigurationV2)owner).getTarget();
                try {
                    this.parent = ((Target)parentTarget.getParent()).getTool(element.getAttribute("id"));
                }
                catch (NullPointerException nullPointerException) {
                    this.parent = null;
                }
            }
            ((ConfigurationV2)owner).addToolReference(this);
        } else if (owner instanceof Target) {
            if (this.parent == null) {
                try {
                    this.parent = ((Target)((Target)owner).getParent()).getTool(element.getAttribute("id"));
                }
                catch (NullPointerException nullPointerException) {
                    this.parent = null;
                }
            }
            ((Target)owner).addToolReference(this);
        }
        if (element.hasAttribute("command")) {
            this.command = element.getAttribute("command");
        }
        if (element.hasAttribute("outputPrefix")) {
            this.outputPrefix = element.getAttribute("outputPrefix");
        }
        if (element.hasAttribute("outputs")) {
            this.outputExtensions = element.getAttribute("outputs");
        }
        if (element.hasAttribute("outputFlag")) {
            this.outputFlag = element.getAttribute("outputFlag");
        }
        NodeList configElements = element.getChildNodes();
        int i = 0;
        while (i < configElements.getLength()) {
            Node configElement = configElements.item(i);
            if (configElement.getNodeName().equals("optionReference")) {
                new OptionReference(this, (Element)configElement);
            }
            ++i;
        }
    }

    public ToolReference(BuildObject owner, IManagedConfigElement element) {
        ManagedBuildManager.putConfigElement(this, element);
        this.resolved = false;
        this.owner = owner;
        if (owner instanceof ConfigurationV2) {
            ((ConfigurationV2)owner).addToolReference(this);
        } else if (owner instanceof Target) {
            ((Target)owner).addToolReference(this);
        }
        this.command = element.getAttribute("command");
        this.outputPrefix = element.getAttribute("outputPrefix");
        String output = element.getAttribute("outputs");
        if (output != null) {
            this.outputExtensions = output;
        }
        this.outputFlag = element.getAttribute("outputFlag");
        IManagedConfigElement[] toolElements = element.getChildren();
        int m = 0;
        while (m < toolElements.length) {
            IManagedConfigElement toolElement = toolElements[m];
            if (toolElement.getName().equals("optionReference")) {
                new OptionReference(this, toolElement);
            }
            ++m;
        }
    }

    public ToolReference(BuildObject owner, ITool tool) {
        this.owner = owner;
        this.parent = tool instanceof ToolReference ? ((ToolReference)tool).getTool() : tool;
        this.command = tool.getToolCommand();
        this.outputFlag = tool.getOutputFlag();
        this.outputPrefix = tool.getOutputPrefix();
        String[] extensions = tool.getOutputExtensions();
        this.outputExtensions = new String();
        if (extensions != null) {
            int index = 0;
            while (index < extensions.length) {
                if (extensions[index] != null) {
                    this.outputExtensions = String.valueOf(this.outputExtensions) + extensions[index];
                    if (index < extensions.length - 1) {
                        this.outputExtensions = String.valueOf(this.outputExtensions) + DEFAULT_SEPARATOR;
                    }
                }
                ++index;
            }
        }
        if (tool instanceof ToolReference) {
            List parentRefs = ((ToolReference)tool).getOptionReferenceList();
            Iterator iter = parentRefs.iterator();
            while (iter.hasNext()) {
                IOption parent = (IOption)iter.next();
                OptionReference clone = this.createOptionReference(parent);
                try {
                    switch (parent.getValueType()) {
                        case 0: {
                            clone.setValue(parent.getBooleanValue());
                            break;
                        }
                        case 2: {
                            clone.setValue(parent.getStringValue());
                        }
                        case 1: {
                            clone.setValue(parent.getSelectedEnum());
                            break;
                        }
                        default: {
                            clone.setValue(parent.getStringListValue());
                            break;
                        }
                    }
                }
                catch (BuildException buildException) {}
            }
        }
        if (owner instanceof ConfigurationV2) {
            ((ConfigurationV2)owner).addToolReference(this);
        } else if (owner instanceof Target) {
            ((Target)owner).addToolReference(this);
        }
    }

    public boolean references(ITool target) {
        if (this.equals(target)) {
            return true;
        }
        if (this.parent == null) {
            return false;
        }
        if (this.parent instanceof IToolReference) {
            return ((IToolReference)this.parent).references(target);
        }
        if (target instanceof IToolReference) {
            return this.parent.equals(((IToolReference)target).getTool());
        }
        return this.parent.equals(target);
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            IManagedConfigElement element = ManagedBuildManager.getConfigElement(this);
            if (this.owner instanceof ConfigurationV2) {
                Target target = (Target)((ConfigurationV2)this.owner).getTarget();
                this.parent = target.getTool(element.getAttribute("id"));
            } else if (this.owner instanceof Target) {
                this.parent = ((Target)this.owner).getTool(element.getAttribute("id"));
            }
            if (this.parent instanceof Tool) {
                ((Tool)this.parent).resolveReferences();
            } else if (this.parent instanceof ToolReference) {
                ((ToolReference)this.parent).resolveReferences();
            }
            Iterator it = this.getOptionReferenceList().iterator();
            while (it.hasNext()) {
                OptionReference optRef = (OptionReference)it.next();
                optRef.resolveReferences();
            }
        }
    }

    public void addOptionReference(OptionReference optionRef) {
        this.getOptionReferenceList().add(optionRef);
        this.isDirty = true;
    }

    public boolean buildsFileType(String extension) {
        if (this.parent == null) {
            return false;
        }
        return this.parent.buildsFileType(extension);
    }

    public OptionReference createOptionReference(IOption option) {
        OptionReference ref = this.getOptionReference(option);
        if (ref == null || !ref.getToolReference().owner.equals(this.owner)) {
            ref = new OptionReference(this, option);
        }
        return ref;
    }

    protected List getAllOptionRefs() {
        if (this.owner instanceof ConfigurationV2) {
            return ((ConfigurationV2)this.owner).getOptionReferences(this.parent);
        }
        if (this.owner instanceof Target) {
            return ((Target)this.owner).getOptionReferences(this.parent);
        }
        return null;
    }

    public String getId() {
        if (this.parent == null) {
            return new String();
        }
        return this.parent.getId();
    }

    public List getInputExtensions() {
        return this.getTool().getInputExtensions();
    }

    public String getName() {
        if (this.parent == null) {
            return new String();
        }
        return this.parent.getName();
    }

    public int getNatureFilter() {
        if (this.parent == null) {
            return 2;
        }
        return this.parent.getNatureFilter();
    }

    public IOption getOption(String id) {
        return this.getOptionById(id);
    }

    public IOption getOptionById(String id) {
        IOption[] options = this.getOptions();
        int i = 0;
        while (i < options.length) {
            IOption current = options[i];
            if (current.getId().equals(id)) {
                return current;
            }
            ++i;
        }
        return null;
    }

    public boolean producesFileType(String outputExtension) {
        if (!this.getOutputsList().contains(outputExtension)) {
            return this.parent.producesFileType(outputExtension);
        }
        return true;
    }

    private List getOutputsList() {
        ArrayList<String> answer = new ArrayList<String>();
        if (this.outputExtensions != null) {
            String[] exts = this.outputExtensions.split(DEFAULT_SEPARATOR);
            answer.addAll(Arrays.asList(exts));
        }
        return answer;
    }

    public ITool getTool() {
        return this.parent;
    }

    public String getToolCommand() {
        if (this.command == null) {
            if (this.parent != null) {
                return this.parent.getToolCommand();
            }
            return new String();
        }
        return this.command;
    }

    public String getToolFlags() throws BuildException {
        StringBuffer buf = new StringBuffer();
        IOption[] opts = this.getOptions();
        int index = 0;
        while (index < opts.length) {
            IOption option = opts[index];
            switch (option.getValueType()) {
                case 0: {
                    String boolCmd = option.getBooleanValue() ? option.getCommand() : option.getCommandFalse();
                    if (boolCmd == null || boolCmd.length() <= 0) break;
                    buf.append(String.valueOf(boolCmd) + " ");
                    break;
                }
                case 1: {
                    String string = option.getEnumCommand(option.getSelectedEnum());
                    if (string.length() <= 0) break;
                    buf.append(String.valueOf(string) + " ");
                    break;
                }
                case 2: {
                    String strCmd = option.getCommand();
                    String val = option.getStringValue();
                    if (val.length() <= 0) break;
                    if (strCmd != null) {
                        buf.append(strCmd);
                    }
                    buf.append(String.valueOf(val) + " ");
                    break;
                }
                case 3: {
                    String cmd = option.getCommand();
                    String[] list = option.getStringListValue();
                    int j = 0;
                    while (j < list.length) {
                        String temp = list[j];
                        if (cmd != null) {
                            buf.append(cmd);
                        }
                        buf.append(String.valueOf(temp) + " ");
                        ++j;
                    }
                    break;
                }
                case 4: {
                    String incCmd = option.getCommand();
                    String[] paths = option.getIncludePaths();
                    int j = 0;
                    while (j < paths.length) {
                        String temp = paths[j];
                        buf.append(String.valueOf(incCmd) + temp + " ");
                        ++j;
                    }
                    break;
                }
                case 5: {
                    String defCmd = option.getCommand();
                    String[] symbols = option.getDefinedSymbols();
                    int j = 0;
                    while (j < symbols.length) {
                        String temp = symbols[j];
                        buf.append(String.valueOf(defCmd) + temp + " ");
                        ++j;
                    }
                    break;
                }
            }
            ++index;
        }
        return buf.toString().trim();
    }

    public IOptionCategory getTopOptionCategory() {
        try {
            return this.parent.getTopOptionCategory();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    private OptionReference getOptionReference(IOption option) {
        ListIterator iter = this.getAllOptionRefs().listIterator();
        while (iter.hasNext()) {
            OptionReference optionRef = (OptionReference)iter.next();
            if (!optionRef.references(option)) continue;
            return optionRef;
        }
        return null;
    }

    private OptionReference getOptionReference(String id) {
        Iterator it = this.getOptionReferenceList().iterator();
        while (it.hasNext()) {
            OptionReference current = (OptionReference)it.next();
            if (!current.getId().equals(id)) continue;
            return current;
        }
        return null;
    }

    public List getOptionReferenceList() {
        if (this.optionReferences == null) {
            this.optionReferences = new ArrayList();
        }
        return this.optionReferences;
    }

    public IOption[] getOptions() {
        IOption[] options = this.parent.getOptions();
        int i = 0;
        while (i < options.length) {
            OptionReference ref = this.getOptionReference(options[i]);
            if (ref != null) {
                options[i] = ref;
            }
            ++i;
        }
        return options;
    }

    public String[] getOutputExtensions() {
        if (this.outputExtensions == null) {
            if (this.parent != null) {
                return this.parent.getOutputExtensions();
            }
            return new String[0];
        }
        return this.outputExtensions.split(DEFAULT_SEPARATOR);
    }

    public String getOutputExtension(String inputExtension) {
        if (this.parent == null) {
            return new String();
        }
        return this.parent.getOutputExtension(inputExtension);
    }

    public String getOutputFlag() {
        if (this.outputFlag == null) {
            if (this.parent != null) {
                return this.parent.getOutputFlag();
            }
            return new String();
        }
        return this.outputFlag;
    }

    public String getOutputPrefix() {
        if (this.outputPrefix == null) {
            if (this.parent != null) {
                return this.parent.getOutputPrefix();
            }
            return new String();
        }
        return this.outputPrefix;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isHeaderFile(String ext) {
        if (this.parent == null) {
            return false;
        }
        return this.parent.isHeaderFile(ext);
    }

    public boolean ownedByConfiguration(IConfigurationV2 config) {
        if (this.owner instanceof ConfigurationV2) {
            return ((IConfigurationV2)this.owner).equals(config);
        }
        return false;
    }

    public void serialize(Document doc, Element element) {
        if (this.parent == null) {
            return;
        }
        element.setAttribute("id", this.parent.getId());
        if (this.command != null) {
            element.setAttribute("command", this.getToolCommand());
        }
        if (this.outputPrefix != null) {
            element.setAttribute("outputPrefix", this.getOutputPrefix());
        }
        if (this.outputFlag != null) {
            element.setAttribute("outputFlag", this.getOutputFlag());
        }
        if (this.outputExtensions != null) {
            element.setAttribute("outputs", this.outputExtensions);
        }
        ListIterator iter = this.getOptionReferenceList().listIterator();
        while (iter.hasNext()) {
            OptionReference optionRef = (OptionReference)iter.next();
            Element optionRefElement = doc.createElement("optionReference");
            element.appendChild(optionRefElement);
            optionRef.serialize(doc, optionRefElement);
        }
        this.isDirty = false;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public boolean setToolCommand(String cmd) {
        if (cmd != null && !cmd.equals(this.command)) {
            this.command = cmd;
            this.isDirty = true;
            return true;
        }
        return false;
    }

    public void setOutputFlag(String flag) {
        if (flag == null) {
            return;
        }
        if (this.outputFlag == null || !flag.equals(this.outputFlag)) {
            this.outputFlag = flag;
            this.isDirty = true;
        }
    }

    public void setOutputPrefix(String prefix) {
        if (prefix == null) {
            return;
        }
        if (this.outputPrefix == null || !prefix.equals(this.outputPrefix)) {
            this.outputPrefix = prefix;
            this.isDirty = true;
        }
    }

    public void setOutputExtensions(String ext) {
        if (ext == null) {
            return;
        }
        if (this.outputExtensions == null || !ext.equals(this.outputExtensions)) {
            this.outputExtensions = ext;
            this.isDirty = true;
        }
    }

    public String toString() {
        String answer = new String();
        if (this.parent != null) {
            answer = String.valueOf(answer) + "Reference to " + this.parent.getName();
        }
        if (answer.length() > 0) {
            return answer;
        }
        return super.toString();
    }

    public ITool getSuperClass() {
        return null;
    }

    public boolean isAbstract() {
        return false;
    }

    public String getUnusedChildren() {
        return null;
    }

    public String[] getErrorParserList() {
        return null;
    }

    public String getErrorParserIds() {
        return null;
    }

    public void setErrorParserIds(String ids) {
    }

    public List getInterfaceExtensions() {
        return null;
    }

    public boolean isExtensionElement() {
        return false;
    }

    public String getRawOutputExtensions() {
        return this.outputExtensions;
    }

    public String getRawOutputFlag() {
        return this.outputFlag;
    }

    public String getRawOutputPrefix() {
        return this.outputPrefix;
    }

    public String getRawToolCommand() {
        return this.command;
    }

    public IOption createOption(IOption superClass, String Id, String name, boolean b) {
        return null;
    }

    public void removeOption(IOption o) {
    }

    public IOptionCategory[] getChildCategories() {
        return null;
    }

    public void setToolParent(IBuildObject newParent) {
        if (this.parent == null) {
            return;
        }
        ((Tool)this.parent).setToolParent(newParent);
    }

    public void setIsAbstract(boolean b) {
    }

    public IBuildObject getParent() {
        return this.owner;
    }

    public String getCommandLinePattern() {
        if (this.parent == null) {
            return new String();
        }
        return this.parent.getCommandLinePattern();
    }

    public void setCommandLinePattern(String pattern) {
    }

    public IManagedCommandLineGenerator getCommandLineGenerator() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getCommandLineGenerator();
    }

    public IConfigurationElement getCommandLineGeneratorElement() {
        return null;
    }

    public void setCommandLineGeneratorElement(IConfigurationElement element) {
    }

    public IManagedDependencyGenerator getDependencyGenerator() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getDependencyGenerator();
    }

    public IConfigurationElement getDependencyGeneratorElement() {
        return null;
    }

    public void setDependencyGeneratorElement(IConfigurationElement element) {
    }

    public String[] getCommandFlags() throws BuildException {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getCommandFlags();
    }
}

