/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.sourcelookup;

import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.core.sourcelookup.SourceLookupFactory;
import org.eclipse.cdt.debug.internal.ui.CDebugImageDescriptorRegistry;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.dialogfields.SelectionButtonDialogField;
import org.eclipse.cdt.debug.internal.ui.editors.FileNotFoundElement;
import org.eclipse.cdt.debug.internal.ui.editors.NoSymbolOrSourceElement;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.sourcelookup.SourceLookupMessages;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultSourceLocator
implements IPersistableSourceLocator,
IAdaptable {
    public static final String ID_DEFAULT_SOURCE_LOCATOR = String.valueOf(CDebugUIPlugin.getUniqueIdentifier()) + ".DefaultSourceLocator";
    public static final String ID_OLD_DEFAULT_SOURCE_LOCATOR = "org.eclipse.cdt.launch.DefaultSourceLocator";
    private static final String ELEMENT_NAME = "PromptingSourceLocator";
    private static final String ATTR_PROJECT = "project";
    private static final String ATTR_MEMENTO = "memento";
    private ICSourceLocator fSourceLocator;
    private HashMap fFramesToSource = null;
    private HashMap fNamesToSource = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public String getMemento() throws CoreException {
        if (this.getCSourceLocator() != null) {
            Document document = null;
            Exception ex = null;
            try {
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                Element element = document.createElement(ELEMENT_NAME);
                document.appendChild(element);
                element.setAttribute(ATTR_PROJECT, this.getCSourceLocator().getProject().getName());
                IPersistableSourceLocator psl = this.getPersistableSourceLocator();
                if (psl != null) {
                    element.setAttribute(ATTR_MEMENTO, psl.getMemento());
                }
                return CDebugUtils.serializeDocument((Document)document);
            }
            catch (ParserConfigurationException e) {
                ex = e;
            }
            catch (IOException e) {
                ex = e;
            }
            catch (TransformerException e) {
                ex = e;
            }
            this.abort(SourceLookupMessages.getString("DefaultSourceLocator.1"), ex);
        }
        return null;
    }

    public void initializeFromMemento(String memento) throws CoreException {
        Exception ex = null;
        try {
            IPersistableSourceLocator psl;
            Element root = null;
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            StringReader reader = new StringReader(memento);
            InputSource source = new InputSource(reader);
            root = parser.parse(source).getDocumentElement();
            if (!root.getNodeName().equalsIgnoreCase(ELEMENT_NAME)) {
                this.abort(SourceLookupMessages.getString("DefaultSourceLocator.2"), null);
            }
            String projectName = root.getAttribute(ATTR_PROJECT);
            String data = root.getAttribute(ATTR_MEMENTO);
            if (this.isEmpty(projectName)) {
                this.abort(SourceLookupMessages.getString("DefaultSourceLocator.3"), null);
            }
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (this.getCSourceLocator() == null) {
                this.setCSourceLocator(SourceLookupFactory.createSourceLocator((IProject)project));
            }
            if (this.getCSourceLocator().getProject() != null && !this.getCSourceLocator().getProject().equals((Object)project)) {
                return;
            }
            if (project == null || !project.exists() || !project.isOpen()) {
                this.abort(MessageFormat.format(SourceLookupMessages.getString("DefaultSourceLocator.4"), projectName), null);
            }
            if ((psl = this.getPersistableSourceLocator()) != null) {
                psl.initializeFromMemento(data);
            } else {
                this.abort(SourceLookupMessages.getString("DefaultSourceLocator.5"), null);
            }
            return;
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        catch (SAXException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        this.abort(SourceLookupMessages.getString("DefaultSourceLocator.6"), ex);
    }

    public void initializeDefaults(ILaunchConfiguration configuration) throws CoreException {
        this.setCSourceLocator(SourceLookupFactory.createSourceLocator((IProject)this.getProject(configuration)));
        String memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, "");
        if (!this.isEmpty(memento)) {
            this.initializeFromMemento(memento);
        }
    }

    public Object getAdapter(Class adapter) {
        if (this.getCSourceLocator() instanceof IAdaptable) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter.equals(clazz)) {
                return ((IAdaptable)this.getCSourceLocator()).getAdapter(adapter);
            }
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResourceChangeListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter.equals(clazz2)) {
                return ((IAdaptable)this.getCSourceLocator()).getAdapter(adapter);
            }
        }
        return null;
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        Object res = this.cacheLookup(stackFrame);
        if (res == null && (res = this.getCSourceLocator().getSourceElement(stackFrame)) instanceof List) {
            List list = (List)res;
            if (list.size() != 0) {
                SourceSelectionDialog dialog = this.createSourceSelectionDialog(list);
                dialog.open();
                Object[] objs = dialog.getResult();
                Object object = res = objs != null && objs.length > 0 ? objs[0] : null;
                if (res != null) {
                    this.cacheSourceElement(stackFrame, res, dialog.alwaysMapToSelection());
                }
            } else {
                res = null;
            }
        }
        if (res == null) {
            res = stackFrame instanceof ICStackFrame && !this.isEmpty(((ICStackFrame)stackFrame).getFile()) ? new FileNotFoundElement(stackFrame) : new NoSymbolOrSourceElement(stackFrame);
        }
        return res;
    }

    protected void saveChanges(ILaunchConfiguration configuration, IPersistableSourceLocator locator) {
        try {
            ILaunchConfigurationWorkingCopy copy = configuration.copy(configuration.getName());
            copy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, locator.getMemento());
            copy.doSave();
        }
        catch (CoreException e) {
            CDebugUIPlugin.errorDialog(e.getMessage(), null);
        }
    }

    private SourceSelectionDialog createSourceSelectionDialog(List list) {
        SourceSelectionDialog dialog = new SourceSelectionDialog(CDebugUIPlugin.getActiveWorkbenchShell());
        dialog.setInput(list.toArray());
        dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dialog.setLabelProvider((ILabelProvider)new SourceElementLabelProvider());
        dialog.setTitle(SourceLookupMessages.getString("DefaultSourceLocator.7"));
        dialog.setMessage(SourceLookupMessages.getString("DefaultSourceLocator.8"));
        dialog.setInitialSelections(new Object[]{list.get(0)});
        return dialog;
    }

    private void cacheSourceElement(IStackFrame frame, Object sourceElement, boolean alwaysMapToSelection) {
        if (alwaysMapToSelection) {
            String name = this.getFileName(frame);
            if (name != null) {
                if (this.fNamesToSource == null) {
                    this.fNamesToSource = new HashMap();
                }
                this.fNamesToSource.put(name, sourceElement);
            }
        } else {
            if (this.fFramesToSource == null) {
                this.fFramesToSource = new HashMap();
            }
            this.fFramesToSource.put(frame, sourceElement);
        }
    }

    private Object cacheLookup(IStackFrame frame) {
        Object result;
        String name = this.getFileName(frame);
        if (name != null && this.fNamesToSource != null && (result = this.fNamesToSource.get(name)) != null) {
            return result;
        }
        return this.fFramesToSource != null ? this.fFramesToSource.get(frame) : null;
    }

    private String getFileName(IStackFrame frame) {
        String name;
        if (frame instanceof ICStackFrame && !this.isEmpty(name = ((ICStackFrame)frame).getFile())) {
            return name.trim();
        }
        return null;
    }

    private ICSourceLocator getCSourceLocator() {
        return this.fSourceLocator;
    }

    private void setCSourceLocator(ICSourceLocator locator) {
        this.fSourceLocator = locator;
    }

    private IPersistableSourceLocator getPersistableSourceLocator() {
        ICSourceLocator sl = this.getCSourceLocator();
        return sl instanceof IPersistableSourceLocator ? (IPersistableSourceLocator)sl : null;
    }

    private void abort(String message, Throwable e) throws CoreException {
        Status s = new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 0, message, e);
        throw new CoreException((IStatus)s);
    }

    private boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    private IProject getProject(ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        String projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
        if (!this.isEmpty(projectName) && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)).exists()) {
            return project;
        }
        this.abort(MessageFormat.format(SourceLookupMessages.getString("DefaultSourceLocator.9"), projectName), null);
        return null;
    }

    public class SourceSelectionDialog
    extends ListDialog {
        private SelectionButtonDialogField fAlwaysUseThisFileButton = new SelectionButtonDialogField(32);

        public SourceSelectionDialog(Shell parent) {
            super(parent);
        }

        protected Control createDialogArea(Composite parent) {
            Composite comp = ControlFactory.createComposite((Composite)parent, (int)1);
            super.createDialogArea(comp);
            Composite comp1 = ControlFactory.createComposite((Composite)comp, (int)1);
            this.fAlwaysUseThisFileButton.setLabelText(SourceLookupMessages.getString("DefaultSourceLocator.0"));
            this.fAlwaysUseThisFileButton.doFillIntoGrid(comp1, 1);
            return comp;
        }

        public boolean alwaysMapToSelection() {
            return this.fAlwaysUseThisFileButton.isSelected();
        }
    }

    public class SourceElementLabelProvider
    extends LabelProvider {
        protected CDebugImageDescriptorRegistry fDebugImageRegistry = CDebugUIPlugin.getImageDescriptorRegistry();

        public String getText(Object element) {
            if (element instanceof IFile) {
                return ((IFile)element).getFullPath().toString();
            }
            if (element instanceof FileStorage) {
                return ((FileStorage)element).getFullPath().toOSString();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof IFile) {
                return this.fDebugImageRegistry.get(CDebugImages.DESC_OBJS_WORKSPACE_SOURCE_FILE);
            }
            if (element instanceof FileStorage) {
                return this.fDebugImageRegistry.get(CDebugImages.DESC_OBJS_EXTERNAL_SOURCE_FILE);
            }
            return super.getImage(element);
        }
    }
}

