/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Observable;
import org.eclipse.cdt.debug.mi.core.CommandQueue;
import org.eclipse.cdt.debug.mi.core.EventThread;
import org.eclipse.cdt.debug.mi.core.IMITTY;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIInferior;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.MIProcess;
import org.eclipse.cdt.debug.mi.core.Queue;
import org.eclipse.cdt.debug.mi.core.RxThread;
import org.eclipse.cdt.debug.mi.core.SessionProcess;
import org.eclipse.cdt.debug.mi.core.TxThread;
import org.eclipse.cdt.debug.mi.core.command.Command;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIExecInterrupt;
import org.eclipse.cdt.debug.mi.core.command.MIGDBExit;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSet;
import org.eclipse.cdt.debug.mi.core.command.MIGDBShowPrompt;
import org.eclipse.cdt.debug.mi.core.command.MIInterpreterExecConsole;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIGDBExitEvent;
import org.eclipse.cdt.debug.mi.core.output.MIGDBShowInfo;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIParser;

public class MISession
extends Observable {
    public static final int PROGRAM = 0;
    public static final int ATTACH = 1;
    public static final int CORE = 2;
    boolean terminated;
    boolean useInterpreterExecConsole;
    int sessionType;
    Process sessionProcess;
    MIProcess gdbProcess;
    InputStream inChannel;
    OutputStream outChannel;
    TxThread txThread;
    RxThread rxThread;
    EventThread eventThread;
    CommandQueue txQueue;
    CommandQueue rxQueue;
    Queue eventQueue;
    PipedInputStream miInConsolePipe;
    PipedOutputStream miOutConsolePipe;
    PipedInputStream miInLogPipe;
    PipedOutputStream miOutLogPipe;
    CommandFactory factory;
    MIParser parser;
    long cmdTimeout;
    MIInferior inferior;

    public MISession(MIProcess process, IMITTY tty, int timeout, int type, int launchTimeout) throws MIException {
        this.gdbProcess = process;
        this.inChannel = process.getInputStream();
        this.outChannel = process.getOutputStream();
        this.cmdTimeout = timeout;
        this.sessionType = type;
        this.factory = new CommandFactory();
        this.parser = new MIParser();
        this.inferior = new MIInferior(this, tty);
        this.txQueue = new CommandQueue();
        this.rxQueue = new CommandQueue();
        this.eventQueue = new Queue();
        try {
            process.exitValue();
            InputStream err = process.getErrorStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(err));
            String line = null;
            try {
                line = reader.readLine();
                reader.close();
            }
            catch (Exception exception) {}
            if (line == null) {
                line = MIPlugin.getResourceString("src.MISession.Process_Terminated");
            }
            throw new MIException(line);
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            this.txThread = new TxThread(this);
            this.rxThread = new RxThread(this);
            this.eventThread = new EventThread(this);
            this.txThread.start();
            this.rxThread.start();
            this.eventThread.start();
            try {
                MIGDBSet confirm = new MIGDBSet(new String[]{"confirm", "off"});
                this.postCommand(confirm, launchTimeout);
                confirm.getMIInfo();
                MIGDBSet width = new MIGDBSet(new String[]{"width", "0"});
                this.postCommand(width, launchTimeout);
                width.getMIInfo();
                MIGDBSet height = new MIGDBSet(new String[]{"height", "0"});
                this.postCommand(height, launchTimeout);
                height.getMIInfo();
                try {
                    MIInterpreterExecConsole echo = new MIInterpreterExecConsole("echo");
                    this.postCommand(echo, launchTimeout);
                    echo.getMIInfo();
                    this.useInterpreterExecConsole = true;
                }
                catch (MIException mIException) {}
                MIGDBShowPrompt prompt = new MIGDBShowPrompt();
                this.postCommand(prompt);
                MIGDBShowInfo infoPrompt = prompt.getMIGDBShowInfo();
                String value = infoPrompt.getValue();
                if (value != null && value.length() > 0) {
                    this.parser.cliPrompt = value.trim();
                }
            }
            catch (MIException exc) {
                if (this.txThread.isAlive()) {
                    this.txThread.interrupt();
                }
                if (this.rxThread.isAlive()) {
                    this.rxThread.interrupt();
                }
                if (this.eventThread.isAlive()) {
                    this.eventThread.interrupt();
                }
                throw exc;
            }
            return;
        }
    }

    public InputStream getMIConsoleStream() {
        if (this.miInConsolePipe == null) {
            try {
                this.miOutConsolePipe = new PipedOutputStream();
                this.miInConsolePipe = new PipedInputStream(this.miOutConsolePipe);
            }
            catch (IOException iOException) {}
        }
        return this.miInConsolePipe;
    }

    public InputStream getMILogStream() {
        if (this.miInLogPipe == null) {
            try {
                this.miOutLogPipe = new PipedOutputStream();
                this.miInLogPipe = new PipedInputStream(this.miOutLogPipe);
            }
            catch (IOException iOException) {}
        }
        return this.miInLogPipe;
    }

    public CommandFactory getCommandFactory() {
        return this.factory;
    }

    public void setCommandFactory(CommandFactory f) {
        this.factory = f;
    }

    public MIParser getMIParser() {
        return this.parser;
    }

    public void setMIParser(MIParser p) {
        this.parser = p;
    }

    public int getSessionType() {
        return this.sessionType;
    }

    public void setSessionType(int type) {
        this.sessionType = type;
    }

    public boolean useExecConsole() {
        return this.useInterpreterExecConsole;
    }

    public boolean inPrimaryPrompt() {
        return this.rxThread.inPrimaryPrompt();
    }

    public boolean inSecondaryPrompt() {
        return this.rxThread.inSecondaryPrompt();
    }

    public boolean isProgramSession() {
        return this.sessionType == 0;
    }

    public boolean isAttachSession() {
        return this.sessionType == 1;
    }

    public boolean isCoreSession() {
        return this.sessionType == 2;
    }

    public void setCommandTimeout(long timeout) {
        this.cmdTimeout = timeout;
    }

    public long getCommandTimeout() {
        return this.cmdTimeout;
    }

    public void postCommand(Command cmd) throws MIException {
        this.postCommand(cmd, this.cmdTimeout);
    }

    public void postCommand(Command cmd, long timeout) throws MIException {
        if (!this.txThread.isAlive() || !this.rxThread.isAlive()) {
            throw new MIException(MIPlugin.getResourceString("src.MISession.Thread_Terminated"));
        }
        if (this.inferior.isRunning() && !(cmd instanceof MIExecInterrupt)) {
            throw new MIException(MIPlugin.getResourceString("src.MISession.Target_not_suspended"));
        }
        if (this.isTerminated()) {
            throw new MIException(MIPlugin.getResourceString("src.MISession.Session_terminated"));
        }
        this.postCommand0(cmd, timeout);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void postCommand0(Command cmd, long timeout) throws MIException {
        MIPlugin.getDefault().debugLog(cmd.toString());
        this.txQueue.addCommand(cmd);
        if (timeout < 0L) {
            return;
        }
        Command command = cmd;
        synchronized (command) {
            while (true) {
                if (cmd.getMIOutput() != null) {
                    return;
                }
                try {
                    cmd.wait(timeout);
                    if (cmd.getMIOutput() != null) continue;
                    throw new MIException(MIPlugin.getResourceString("src.MISession.Target_not_responding"));
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public MIInferior getMIInferior() {
        return this.inferior;
    }

    public MIProcess getGDBProcess() {
        return this.gdbProcess;
    }

    public Process getSessionProcess() {
        if (this.sessionProcess == null) {
            this.sessionProcess = new SessionProcess(this);
        }
        return this.sessionProcess;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void terminate() {
        if (this.isTerminated()) {
            return;
        }
        this.terminated = true;
        this.inferior.destroy();
        InputStream inGDB = this.inChannel;
        this.inChannel = null;
        OutputStream outGDB = this.outChannel;
        this.outChannel = null;
        MIGDBExit exit = this.factory.createMIGDBExit();
        try {
            this.postCommand0(exit, 2000L);
        }
        catch (MIException mIException) {}
        if (this.gdbProcess != null) {
            this.gdbProcess.destroy();
        }
        try {
            if (inGDB != null) {
                inGDB.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (outGDB != null) {
                outGDB.close();
            }
        }
        catch (IOException iOException) {}
        try {
            this.miInConsolePipe = null;
            if (this.miOutConsolePipe != null) {
                this.miOutConsolePipe.close();
            }
        }
        catch (IOException iOException) {}
        try {
            this.miInLogPipe = null;
            if (this.miOutLogPipe != null) {
                this.miOutLogPipe.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (this.txThread.isAlive()) {
                this.txThread.interrupt();
                this.txThread.join(this.cmdTimeout);
            }
        }
        catch (InterruptedException interruptedException) {}
        try {
            if (this.rxThread.isAlive()) {
                this.rxThread.interrupt();
                this.rxThread.join(this.cmdTimeout);
            }
        }
        catch (InterruptedException interruptedException) {}
        if (!this.eventThread.equals(Thread.currentThread())) {
            try {
                if (this.eventThread.isAlive()) {
                    this.eventThread.interrupt();
                    this.eventThread.join(this.cmdTimeout);
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        this.notifyObservers(new MIGDBExitEvent(this, 0));
        this.deleteObservers();
    }

    public void notifyObservers(Object arg) {
        this.setChanged();
        super.notifyObservers(arg);
    }

    OutputStream getConsolePipe() {
        return this.miOutConsolePipe;
    }

    OutputStream getLogPipe() {
        return this.miOutLogPipe;
    }

    CommandQueue getTxQueue() {
        return this.txQueue;
    }

    CommandQueue getRxQueue() {
        return this.rxQueue;
    }

    Queue getEventQueue() {
        return this.eventQueue;
    }

    RxThread getRxThread() {
        return this.rxThread;
    }

    InputStream getChannelInputStream() {
        return this.inChannel;
    }

    OutputStream getChannelOutputStream() {
        return this.outChannel;
    }

    MIOutput parse(String buffer) {
        return this.parser.parse(buffer);
    }

    public void fireEvents(MIEvent[] events) {
        if (events != null && events.length > 0) {
            int i = 0;
            while (i < events.length) {
                this.fireEvent(events[i]);
                ++i;
            }
        }
    }

    public void fireEvent(MIEvent event) {
        if (event != null) {
            this.getEventQueue().addItem(event);
        }
    }
}

