/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.Enumeration;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IOpenable;
import org.eclipse.cdt.internal.core.model.Buffer;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.core.util.LRUCache;
import org.eclipse.cdt.internal.core.util.OverflowingLRUCache;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class BufferManager
implements IBufferFactory {
    protected static BufferManager DEFAULT_BUFFER_MANAGER;
    protected OverflowingLRUCache openBuffers = new BufferCache(60);

    protected void addBuffer(IBuffer buffer) {
        this.openBuffers.put(buffer.getOwner(), buffer);
    }

    public IBuffer createBuffer(IOpenable owner) {
        ICElement element = (ICElement)((Object)owner);
        IResource resource = element.getResource();
        return new Buffer(resource instanceof IFile ? (IFile)resource : null, owner, element.isReadOnly());
    }

    public IBuffer getBuffer(IOpenable owner) {
        return (IBuffer)this.openBuffers.get(owner);
    }

    public IBufferFactory getDefaultBufferFactory() {
        return this;
    }

    public static synchronized BufferManager getDefaultBufferManager() {
        if (DEFAULT_BUFFER_MANAGER == null) {
            DEFAULT_BUFFER_MANAGER = new BufferManager();
        }
        return DEFAULT_BUFFER_MANAGER;
    }

    public Enumeration getOpenBuffers() {
        OverflowingLRUCache overflowingLRUCache = this.openBuffers;
        synchronized (overflowingLRUCache) {
            this.openBuffers.shrink();
            return this.openBuffers.elements();
        }
    }

    protected void removeBuffer(IBuffer buffer) {
        this.openBuffers.remove(buffer.getOwner());
    }

    public class BufferCache
    extends OverflowingLRUCache {
        public BufferCache(int size) {
            super(size);
        }

        public BufferCache(int size, int overflow) {
            super(size, overflow);
        }

        protected boolean close(LRUCache.LRUCacheEntry entry) {
            IBuffer buffer = (IBuffer)entry._fValue;
            if (buffer.hasUnsavedChanges()) {
                return false;
            }
            buffer.close();
            return true;
        }

        protected LRUCache newInstance(int size, int overflow) {
            return new BufferCache(size, overflow);
        }
    }
}

