/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CDescriptorEvent;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICDescriptorListener;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.ILibraryEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.resources.IPathEntryStore;
import org.eclipse.cdt.core.resources.IPathEntryStoreListener;
import org.eclipse.cdt.core.resources.PathEntryStoreChangedEvent;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.model.APathEntry;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.PathEntry;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultPathEntryStore
implements IPathEntryStore,
ICDescriptorListener {
    static String PATH_ENTRY = "pathentry";
    static String PATH_ENTRY_ID = "org.eclipse.cdt.core.pathentry";
    static String ATTRIBUTE_KIND = "kind";
    static String ATTRIBUTE_PATH = "path";
    static String ATTRIBUTE_BASE_PATH = "base-path";
    static String ATTRIBUTE_BASE_REF = "base-ref";
    static String ATTRIBUTE_EXPORTED = "exported";
    static String ATTRIBUTE_SOURCEPATH = "sourcepath";
    static String ATTRIBUTE_ROOTPATH = "roopath";
    static String ATTRIBUTE_PREFIXMAPPING = "prefixmapping";
    static String ATTRIBUTE_EXCLUDING = "excluding";
    static String ATTRIBUTE_INCLUDE = "include";
    static String ATTRIBUTE_LIBRARY = "library";
    static String ATTRIBUTE_SYSTEM = "system";
    static String ATTRIBUTE_NAME = "name";
    static String ATTRIBUTE_VALUE = "value";
    static String VALUE_TRUE = "true";
    static final IPathEntry[] NO_PATHENTRIES = new IPathEntry[0];
    List listeners;
    IProject fProject;

    public DefaultPathEntryStore(IProject project) {
        this.fProject = project;
        this.listeners = Collections.synchronizedList(new ArrayList());
        CCorePlugin.getDefault().getCDescriptorManager().addDescriptorListener(this);
    }

    public IPathEntry[] getRawPathEntries() throws CoreException {
        ICDescriptor cdesc = CCorePlugin.getDefault().getCProjectDescription(this.fProject, false);
        if (cdesc != null) {
            ArrayList<IPathEntry> pathEntries = new ArrayList<IPathEntry>();
            Element element = cdesc.getProjectData(PATH_ENTRY_ID);
            NodeList list = element.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node childNode = list.item(i);
                if (childNode.getNodeType() == 1 && childNode.getNodeName().equals(PATH_ENTRY)) {
                    pathEntries.add(DefaultPathEntryStore.decodePathEntry(this.fProject, (Element)childNode));
                }
                ++i;
            }
            IPathEntry[] entries = new IPathEntry[pathEntries.size()];
            pathEntries.toArray(entries);
            return entries;
        }
        return NO_PATHENTRIES;
    }

    public void setRawPathEntries(IPathEntry[] newRawEntries) throws CoreException {
        if (Arrays.equals(newRawEntries, this.getRawPathEntries())) {
            return;
        }
        ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(this.fProject, true);
        Element rootElement = descriptor.getProjectData(PATH_ENTRY_ID);
        Node child = rootElement.getFirstChild();
        while (child != null) {
            rootElement.removeChild(child);
            child = rootElement.getFirstChild();
        }
        if (newRawEntries != null && newRawEntries.length > 0) {
            Document doc = rootElement.getOwnerDocument();
            DefaultPathEntryStore.encodePathEntries(this.fProject.getFullPath(), doc, rootElement, newRawEntries);
        }
        descriptor.saveProjectData();
    }

    static IPathEntry decodePathEntry(IProject project, Element element) throws CModelException {
        char[][] patterns;
        int patternCount;
        Path path;
        IPath projectPath = project.getFullPath();
        String kindAttr = element.getAttribute(ATTRIBUTE_KIND);
        int kind = PathEntry.kindFromString(kindAttr);
        boolean isExported = false;
        if (element.hasAttribute(ATTRIBUTE_EXPORTED)) {
            isExported = element.getAttribute(ATTRIBUTE_EXPORTED).equals(VALUE_TRUE);
        }
        if (!(path = element.hasAttribute(ATTRIBUTE_PATH) ? new Path(element.getAttribute(ATTRIBUTE_PATH)) : new Path("")).isAbsolute()) {
            path = projectPath.append((IPath)path);
        }
        Path basePath = new Path(element.getAttribute(ATTRIBUTE_BASE_PATH));
        Path baseRef = new Path(element.getAttribute(ATTRIBUTE_BASE_REF));
        String exclusion = element.getAttribute(ATTRIBUTE_EXCLUDING);
        IPath[] exclusionPatterns = APathEntry.NO_EXCLUSION_PATTERNS;
        if (exclusion != null && exclusion.length() > 0 && (patternCount = (patterns = CharOperation.splitOn('|', exclusion.toCharArray())).length) > 0) {
            exclusionPatterns = new IPath[patternCount];
            int j = 0;
            while (j < patterns.length) {
                exclusionPatterns[j] = new Path(new String(patterns[j]));
                ++j;
            }
        }
        switch (kind) {
            case 2: {
                return CoreModel.newProjectEntry((IPath)path, isExported);
            }
            case 1: {
                Path sourceAttachmentPrefixMapping;
                Path libraryPath = new Path(element.getAttribute(ATTRIBUTE_LIBRARY));
                Path sourceAttachmentPath = element.hasAttribute(ATTRIBUTE_SOURCEPATH) ? new Path(element.getAttribute(ATTRIBUTE_SOURCEPATH)) : null;
                Path sourceAttachmentRootPath = element.hasAttribute(ATTRIBUTE_ROOTPATH) ? new Path(element.getAttribute(ATTRIBUTE_ROOTPATH)) : null;
                Path path2 = sourceAttachmentPrefixMapping = element.hasAttribute(ATTRIBUTE_PREFIXMAPPING) ? new Path(element.getAttribute(ATTRIBUTE_PREFIXMAPPING)) : null;
                if (baseRef != null && !baseRef.isEmpty()) {
                    return CoreModel.newLibraryRefEntry((IPath)path, (IPath)baseRef, (IPath)libraryPath);
                }
                return CoreModel.newLibraryEntry((IPath)path, (IPath)basePath, (IPath)libraryPath, (IPath)sourceAttachmentPath, (IPath)sourceAttachmentRootPath, (IPath)sourceAttachmentPrefixMapping, isExported);
            }
            case 3: {
                String projSegment = path.segment(0);
                if (projSegment != null && projSegment.equals(project.getName())) {
                    return CoreModel.newSourceEntry((IPath)path, exclusionPatterns);
                }
                return CoreModel.newProjectEntry((IPath)path, isExported);
            }
            case 7: {
                return CoreModel.newOutputEntry((IPath)path, exclusionPatterns);
            }
            case 4: {
                Path includePath = new Path(element.getAttribute(ATTRIBUTE_INCLUDE));
                boolean isSystemInclude = false;
                if (element.hasAttribute(ATTRIBUTE_SYSTEM)) {
                    isSystemInclude = element.getAttribute(ATTRIBUTE_SYSTEM).equals(VALUE_TRUE);
                }
                if (baseRef != null && !baseRef.isEmpty()) {
                    return CoreModel.newIncludeRefEntry((IPath)path, (IPath)baseRef, (IPath)includePath);
                }
                return CoreModel.newIncludeEntry((IPath)path, (IPath)basePath, (IPath)includePath, isSystemInclude, exclusionPatterns, isExported);
            }
            case 6: {
                String macroName = element.getAttribute(ATTRIBUTE_NAME);
                String macroValue = element.getAttribute(ATTRIBUTE_VALUE);
                if (baseRef != null && !baseRef.isEmpty()) {
                    return CoreModel.newMacroRefEntry((IPath)path, (IPath)baseRef, macroName);
                }
                return CoreModel.newMacroEntry((IPath)path, macroName, macroValue, exclusionPatterns, isExported);
            }
            case 5: {
                Path id = new Path(element.getAttribute(ATTRIBUTE_PATH));
                return CoreModel.newContainerEntry((IPath)id, isExported);
            }
        }
        CModelStatus status = new CModelStatus(4, "PathEntry: unknown kind (" + kindAttr + ")");
        throw new CModelException(status);
    }

    static void encodePathEntries(IPath projectPath, Document doc, Element configRootElement, IPathEntry[] entries) {
        int i = 0;
        while (i < entries.length) {
            Element element = doc.createElement(PATH_ENTRY);
            configRootElement.appendChild(element);
            int kind = entries[i].getEntryKind();
            element.setAttribute(ATTRIBUTE_KIND, PathEntry.kindToString(kind));
            IPath xmlPath = entries[i].getPath();
            if (xmlPath == null) {
                xmlPath = new Path("");
            }
            if (kind != 5 && xmlPath.isAbsolute() && projectPath != null && projectPath.isPrefixOf(xmlPath)) {
                if (xmlPath.segment(0).equals(projectPath.segment(0))) {
                    xmlPath = xmlPath.removeFirstSegments(1);
                    xmlPath = xmlPath.makeRelative();
                } else {
                    xmlPath = xmlPath.makeAbsolute();
                }
            }
            element.setAttribute(ATTRIBUTE_PATH, xmlPath.toString());
            switch (kind) {
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    break;
                }
                case 1: {
                    ILibraryEntry lib = (ILibraryEntry)entries[i];
                    IPath libraryPath = lib.getLibraryPath();
                    element.setAttribute(ATTRIBUTE_LIBRARY, libraryPath.toString());
                    IPath sourcePath = lib.getSourceAttachmentPath();
                    if (sourcePath != null) {
                        if (projectPath != null && projectPath.isPrefixOf(sourcePath) && sourcePath.segment(0).equals(projectPath.segment(0))) {
                            sourcePath = sourcePath.removeFirstSegments(1);
                            sourcePath = sourcePath.makeRelative();
                        }
                        element.setAttribute(ATTRIBUTE_SOURCEPATH, sourcePath.toString());
                    }
                    if (lib.getSourceAttachmentRootPath() != null) {
                        element.setAttribute(ATTRIBUTE_ROOTPATH, lib.getSourceAttachmentRootPath().toString());
                    }
                    if (lib.getSourceAttachmentPrefixMapping() == null) break;
                    element.setAttribute(ATTRIBUTE_PREFIXMAPPING, lib.getSourceAttachmentPrefixMapping().toString());
                    break;
                }
                case 4: {
                    IIncludeEntry include = (IIncludeEntry)entries[i];
                    IPath includePath = include.getIncludePath();
                    element.setAttribute(ATTRIBUTE_INCLUDE, includePath.toString());
                    if (!include.isSystemInclude()) break;
                    element.setAttribute(ATTRIBUTE_SYSTEM, VALUE_TRUE);
                    break;
                }
                case 6: {
                    IMacroEntry macro = (IMacroEntry)entries[i];
                    element.setAttribute(ATTRIBUTE_NAME, macro.getMacroName());
                    element.setAttribute(ATTRIBUTE_VALUE, macro.getMacroValue());
                }
            }
            if (entries[i] instanceof APathEntry) {
                APathEntry entry = (APathEntry)entries[i];
                IPath basePath = entry.getBasePath();
                IPath baseRef = entry.getBaseReference();
                if (basePath != null && !basePath.isEmpty()) {
                    element.setAttribute(ATTRIBUTE_BASE_PATH, basePath.toString());
                } else if (baseRef != null && !baseRef.isEmpty()) {
                    element.setAttribute(ATTRIBUTE_BASE_REF, baseRef.toString());
                }
                IPath[] exclusionPatterns = entry.getExclusionPatterns();
                if (exclusionPatterns.length > 0) {
                    StringBuffer excludeRule = new StringBuffer(10);
                    int j = 0;
                    int max = exclusionPatterns.length;
                    while (j < max) {
                        if (j > 0) {
                            excludeRule.append('|');
                        }
                        excludeRule.append(exclusionPatterns[j]);
                        ++j;
                    }
                    element.setAttribute(ATTRIBUTE_EXCLUDING, excludeRule.toString());
                }
            }
            if (entries[i].isExported()) {
                element.setAttribute(ATTRIBUTE_EXPORTED, VALUE_TRUE);
            }
            ++i;
        }
    }

    public void descriptorChanged(CDescriptorEvent event) {
        ICDescriptor cdesc;
        if (event.getType() == 1 && (cdesc = event.getDescriptor()) != null && cdesc.getProject() == this.fProject) {
            this.fireContentChangedEvent(this.fProject);
        }
    }

    public void addPathEntryStoreListener(IPathEntryStoreListener listener) {
        this.listeners.add(listener);
    }

    public void removePathEntryStoreListener(IPathEntryStoreListener listener) {
        this.listeners.remove(listener);
    }

    private void fireContentChangedEvent(IProject project) {
        PathEntryStoreChangedEvent evt = new PathEntryStoreChangedEvent(this, project, 1);
        IPathEntryStoreListener[] observers = new IPathEntryStoreListener[this.listeners.size()];
        this.listeners.toArray(observers);
        int i = 0;
        while (i < observers.length) {
            observers[i].pathEntryStoreChanged(evt);
            ++i;
        }
    }

    public void close() {
        PathEntryStoreChangedEvent evt = new PathEntryStoreChangedEvent(this, this.fProject, 2);
        IPathEntryStoreListener[] observers = new IPathEntryStoreListener[this.listeners.size()];
        this.listeners.toArray(observers);
        int i = 0;
        while (i < observers.length) {
            observers[i].pathEntryStoreChanged(evt);
            ++i;
        }
        CCorePlugin.getDefault().getCDescriptorManager().removeDescriptorListener(this);
    }

    public IProject getProject() {
        return this.fProject;
    }

    public ICExtensionReference getExtensionReference() {
        return null;
    }
}

