/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OptionCategory
extends BuildObject
implements IOptionCategory {
    private static final IOptionCategory[] emtpyCategories = new IOptionCategory[0];
    private Tool tool;
    private List children;
    private IOptionCategory owner;
    private String ownerId;
    private boolean isExtensionOptionCategory = false;
    private boolean isDirty = false;
    private boolean resolved = true;

    public OptionCategory(IOptionCategory owner) {
        this.owner = owner;
    }

    public OptionCategory(Tool parent, IManagedConfigElement element) {
        this.tool = parent;
        this.isExtensionOptionCategory = true;
        this.resolved = false;
        this.loadFromManifest(element);
        ManagedBuildManager.addExtensionOptionCategory(this);
        this.tool.addOptionCategory(this);
    }

    public OptionCategory(Tool parent, Element element) {
        this.tool = parent;
        this.isExtensionOptionCategory = false;
        this.loadFromProject(element);
        this.tool.addOptionCategory(this);
    }

    public void loadFromManifest(IManagedConfigElement element) {
        ManagedBuildManager.putConfigElement(this, element);
        this.setId(element.getAttribute("id"));
        this.setName(element.getAttribute("name"));
        this.ownerId = element.getAttribute("owner");
    }

    protected void loadFromProject(Element element) {
        this.setId(element.getAttribute("id"));
        if (element.hasAttribute("name")) {
            this.setName(element.getAttribute("name"));
        }
        if (element.hasAttribute("owner")) {
            this.ownerId = element.getAttribute("owner");
        }
        this.owner = this.ownerId != null ? this.tool.getOptionCategory(this.ownerId) : this.tool;
        if (this.owner instanceof Tool) {
            ((Tool)this.owner).addChildCategory(this);
        } else {
            ((OptionCategory)this.owner).addChildCategory(this);
        }
    }

    public void serialize(Document doc, Element element) {
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.owner != null) {
            element.setAttribute("owner", this.owner.getId());
        }
        this.isDirty = false;
    }

    public IOptionCategory[] getChildCategories() {
        if (this.children != null) {
            return this.children.toArray(new IOptionCategory[this.children.size()]);
        }
        return emtpyCategories;
    }

    public void addChildCategory(OptionCategory category) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(category);
    }

    public Object[][] getOptions(IConfiguration configuration) {
        ITool[] tools = null;
        if (configuration != null) {
            tools = configuration.getTools();
        }
        return this.getOptions(tools, 2);
    }

    public Object[][] getOptions(IResourceConfiguration resConfig) {
        ITool[] tools = null;
        if (resConfig != null) {
            tools = resConfig.getTools();
        }
        return this.getOptions(tools, 1);
    }

    private Object[][] getOptions(ITool[] tools, int filterValue) {
        ITool catTool = this.getTool();
        ITool tool = null;
        if (tools != null) {
            int i = 0;
            while (i < tools.length) {
                ITool current = tools[i];
                do {
                    if (catTool != current) continue;
                    tool = tools[i];
                    break;
                } while ((current = current.getSuperClass()) != null);
                if (tool != null) break;
                ++i;
            }
        }
        if (tool == null) {
            tool = catTool;
        }
        IOption[] allOptions = tool.getOptions();
        Object[][] myOptions = new Object[allOptions.length][2];
        int index = 0;
        int i = 0;
        while (i < allOptions.length) {
            IOption option = allOptions[i];
            if (option.getCategory().equals(this) && (option.getResourceFilter() == 0 || option.getResourceFilter() == filterValue)) {
                myOptions[index] = new Object[2];
                myOptions[index][0] = tool;
                myOptions[index][1] = option;
                ++index;
            }
            ++i;
        }
        return myOptions;
    }

    public IOptionCategory getOwner() {
        return this.owner;
    }

    public ITool getTool() {
        return this.owner.getTool();
    }

    public boolean isExtensionElement() {
        return this.isExtensionOptionCategory;
    }

    public boolean isDirty() {
        if (this.isExtensionOptionCategory) {
            return false;
        }
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            if (this.ownerId != null) {
                this.owner = this.tool.getOptionCategory(this.ownerId);
                if (this.owner == null) {
                    ManagedBuildManager.OutputResolveError("owner", this.ownerId, "optionCategory", this.getId());
                }
            }
            if (this.owner == null) {
                this.owner = this.tool;
            }
            if (this.owner instanceof Tool) {
                ((Tool)this.owner).addChildCategory(this);
            } else {
                ((OptionCategory)this.owner).addChildCategory(this);
            }
        }
    }
}

